/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.parser;

import com.ibm.bpws.model.BPWSProcess;
import com.ibm.bpws.model.Container;
import com.ibm.bpws.model.Containers;
import com.ibm.bpws.model.Definition;
import com.ibm.bpws.model.Flow;
import com.ibm.bpws.model.From;
import com.ibm.bpws.model.Partner;
import com.ibm.bpws.model.Partners;
import com.ibm.bpws.model.Sequence;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class ParserUtils {
    public static Container getContainer(BPWSProcess process, String containerName) {
        Containers containers = process.getContainers();
        if (containers == null) {
            return null;
        }
        Iterator i = containers.getContainers().iterator();
        while (i.hasNext()) {
            Container p = (Container)i.next();
            if (!containerName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static Partner getPartner(BPWSProcess process, String partnerName) {
        Partners partners = process.getPartners();
        if (partners == null) {
            return null;
        }
        Iterator i = partners.getPartners().iterator();
        while (i.hasNext()) {
            Partner p = (Partner)i.next();
            if (!partnerName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static List getPropertyQNameList(Node startNode, String props) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(props);
        ArrayList<QName> l = new ArrayList<QName>();
        while (st.hasMoreTokens()) {
            String prop = st.nextToken();
            QName qn = ParserUtils.getQNameFromString(startNode, prop);
            l.add(qn);
        }
        return l;
    }

    public static QName getQNameFromString(Node startNode, String value) throws IllegalArgumentException {
        int index = value.indexOf(58);
        String valuePrefix = index != -1 ? value.substring(0, index) : null;
        String valueLocalPart = value.substring(index + 1);
        String valueNamespaceURI = DOMUtils.getNamespaceURIFromPrefix((Node)startNode, (String)valuePrefix);
        if (valueNamespaceURI != null) {
            return new QName(valueNamespaceURI, valueLocalPart);
        }
        throw new IllegalArgumentException("Unable to determine namespace of '" + (valuePrefix != null ? String.valueOf(valuePrefix) + ":" : "") + valueLocalPart + "'.");
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isParentFlowOrSequence(Object parent) {
        return parent instanceof Sequence || parent instanceof Flow;
    }

    public static void setLiteralValue(From from, NodeIterator ni) {
        Element e;
        Node n = ni.nextNode();
        Element element = e = n instanceof Element ? (Element)n : null;
        if (e != null) {
            from.setLiteralValue(e);
        }
    }

    public static void setTransformInlinedDefinition(Definition def, NodeIterator ni) {
        Element e;
        Node n = ni.nextNode();
        Element element = e = n instanceof Element ? (Element)n : null;
        if (e != null) {
            def.setInlinedDefinition(e);
        }
    }
}

