/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.util.xpath.XPathFunctions;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class Condition
implements Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    ActivityRT activity;
    String xpathExp;

    public Condition(ActivityRT activity, String xpathExp) {
        this.activity = activity;
        this.xpathExp = xpathExp;
    }

    public boolean evaluate() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("about to eval condition " + this.xpathExp));
        if (this.activity == null) {
            throw new BPWSRuntimeException("Activity in a condition may not  be null");
        }
        try {
            return XPathFunctions.evalToBoolean(this.activity, this.xpathExp);
        }
        catch (Exception e) {
            runtimeLogger.error((Object)"Evaluation failed", (Throwable)e);
            throw new BPWSRuntimeException("Could not evaluate xpath expression in condition " + this.xpathExp, e);
        }
    }

    public String toString() {
        return "[condition: " + this.xpathExp;
    }
}

