/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.ContainerRT;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.wsif.WSIFMessage;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class ReplyRT
extends ActivityRT
implements Serializable {
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    String replyContainerName;
    WSIFMessage correlationSet;
    String partnerName;
    QName portTypeName;
    String operationName;
    private BPWSProcessRT bpwsProcessRT;

    public ReplyRT(String name, ScopeRT scope, ActivityRT parentActivity, BPWSProcessRT bpwsProcessRT, String partnerName, QName portTypeName, String operationName) {
        super(name, scope, parentActivity);
        this.partnerName = partnerName;
        this.portTypeName = portTypeName;
        this.operationName = operationName;
        this.bpwsProcessRT = bpwsProcessRT;
    }

    public int getType() {
        return 10;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Reply " + this.name + " is running"));
        ContainerRT replyContainer = this.getContainer(this.replyContainerName);
        this.bpwsProcessRT.registerCorrelationInformation(this.activityModel, replyContainer.getMessage(), false);
        this.bpwsProcessRT.reply(this, this.partnerName, this.portTypeName, this.operationName, replyContainer.getMessage(), null);
    }

    public void replyCompleted(boolean deliveredSuccesfully) throws BPWSRuntimeException {
        if (this.status == 1) {
            return;
        }
        if (!deliveredSuccesfully) {
            throw new BPWSRuntimeException("Reply could not complete.. This should prolly get thrown to the scope and handled by default handler?");
        }
        this.complete();
    }

    public void setContainerName(String containerName) {
        this.replyContainerName = containerName;
    }
}

