/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.bpws.model.OnMessage;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.CompoundActivityRT;
import com.ibm.cs.bpws.runtime.Constants;
import com.ibm.cs.bpws.runtime.ContainerRT;
import com.ibm.cs.bpws.runtime.HandlerInfo;
import com.ibm.cs.bpws.runtime.events.CompensationHandledEvent;
import com.ibm.cs.bpws.runtime.events.EventChannel;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.runtime.events.FaultListener;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveListener;
import com.ibm.wsif.WSIFMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class ScopeRT
extends CompoundActivityRT
implements FaultListener,
ReceiveListener,
Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    protected BPWSProcessRT bpwsProcessRT;
    protected HashMap containers = new HashMap();
    protected ActivityRT activity;
    protected EventChannel eventChannel = new EventChannel();
    protected Hashtable messageHandlers = new Hashtable();
    protected LinkedList myReceiveEventTemplates = new LinkedList();
    protected LinkedList runningMessageHandlers = new LinkedList();
    protected int numMessageHandlersCompleted = 0;
    protected boolean allDoneExceptMessageHandlers = false;
    protected LinkedList receiveEventQueue = new LinkedList();
    protected Hashtable faultHandlers = new Hashtable();
    protected ActivityRT faultChild;
    protected ActivityRT finallyBlockHandler;
    protected ActivityRT catchAllFaultHandler;
    protected boolean exiting = false;
    public boolean isFaultHandlerShield = false;
    public boolean isCompensationHandlerShield = false;
    protected HandlerInfo compensationHandler;

    public ScopeRT(String name, ScopeRT scope, ActivityRT parentActivity, BPWSProcessRT bpwsProcessRT) {
        super(name, scope, parentActivity);
        FaultEvent event = new FaultEvent(null, null, null);
        this.bpwsProcessRT = bpwsProcessRT;
        try {
            this.eventChannel.addListener(this, event);
        }
        catch (BPWSRuntimeException bPWSRuntimeException) {}
    }

    public void activityCompleted(LifecycleEvent event) throws BPWSRuntimeException {
        if (this.status == 1) {
            return;
        }
        runtimeLogger.debug((Object)("scope " + this.name + " heard of end of " + event.getSource()));
        ActivityRT enabledAct = event.getSource();
        if (enabledAct == this.activity) {
            if (this.messageHandlers.size() > 0) {
                if (this.bpwsProcessRT != null) {
                    this.bpwsProcessRT.getEventChannel().removeReceiveListener(this);
                } else {
                    this.eventChannel.removeReceiveListener(this);
                }
            }
            this.allDoneExceptMessageHandlers = true;
            this.tryToComplete();
        } else if (this.runningMessageHandlers.contains(enabledAct)) {
            ++this.numMessageHandlersCompleted;
            this.checkQueueForHandlerAndRun();
            this.tryToComplete();
        } else if (enabledAct.equals(this.finallyBlockHandler)) {
            this.allDoneExceptMessageHandlers = true;
            this.completeAfterFault();
        } else if (enabledAct.equals(this.faultChild)) {
            runtimeLogger.debug((Object)("scope " + this.name + " heard of end of faultchild"));
            if (this.finallyBlockHandler == null) {
                this.allDoneExceptMessageHandlers = true;
                this.completeAfterFault();
            } else {
                this.finallyBlockHandler.activate();
            }
        } else if (this.status == 5 && enabledAct.equals(this.compensationHandler.activity)) {
            if (this.compensationHandler.containerBackups.size() > 0) {
                this.restoreContainersOnHandler();
                this.runCompensationHandler();
            } else {
                this.deliverCompensationHandledEvent(new CompensationHandledEvent(this, this.name, true));
            }
        }
    }

    public void activityEnabled(LifecycleEvent event) throws BPWSRuntimeException {
        ActivityRT enabledAct = event.getSource();
        if (this.status == 1) {
            return;
        }
        if (enabledAct.equals(this.activity) || this.runningMessageHandlers.contains(enabledAct) || enabledAct.equals(this.faultChild) || enabledAct.equals(this.finallyBlockHandler) || this.status == 5 && enabledAct.equals(this.compensationHandler.activity)) {
            enabledAct.go();
        }
    }

    public void addContainer(ContainerRT container) {
        this.containers.put(container.getName(), container);
    }

    public void addFaultHandler(QName faultName, ScopeRT activity, String faultContainerName) {
        HandlerInfo handler = new HandlerInfo(activity, faultContainerName);
        activity.addLifecycleListener(this);
        this.faultHandlers.put(faultName, handler);
        this.children.add(activity);
    }

    protected void addMessageHandler(String partnerName, QName portType, String operationName, OnMessage onMessage, ActivityRT activity, String messageContainerName) {
        HandlerInfo handler = new HandlerInfo(activity, messageContainerName);
        handler.setOnMessage(onMessage);
        String hashKey = String.valueOf(partnerName) + portType.toString() + operationName;
        this.messageHandlers.put(hashKey, handler);
        this.myReceiveEventTemplates.add(new ReceiveEvent(null, null, null, partnerName, portType, operationName));
        activity.addLifecycleListener(this);
        this.children.add(activity);
    }

    private void checkQueueForHandlerAndRun() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)"checking handler event queue");
        Iterator eventQIter = this.receiveEventQueue.iterator();
        while (eventQIter.hasNext()) {
            ReceiveEvent event = (ReceiveEvent)eventQIter.next();
            String key = String.valueOf(event.getPartnerName()) + event.getPortTypeName().toString() + event.getOperationName();
            HandlerInfo handler = (HandlerInfo)this.messageHandlers.get(key);
            if (handler == null || handler.activity.getStatus() != 5) continue;
            runtimeLogger.debug((Object)("status of handler activity is " + handler.activity.getStatus()));
            eventQIter.remove();
            this.runMessageHandler(event, handler);
        }
    }

    public void completeAfterFault() throws BPWSRuntimeException {
        if (this.status != 4) {
            throw new BPWSRuntimeException("trying to complete an activity that is not running");
        }
        if (this.compensationHandler != null) {
            this.dumpContainers();
        }
        this.resetState();
        this.fireLifecycleEvent(5);
        this.fireLinks(true);
    }

    public void deliverCompensationHandledEvent(CompensationHandledEvent event) {
        this.bpwsProcessRT.deliverCompensationHandledEvent(event);
    }

    public void disable() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("disabling scope " + this));
        if (this.compensationHandler != null) {
            Iterator iter = this.compensationHandler.containerBackups.iterator();
            while (iter.hasNext()) {
                String fileName = (String)iter.next();
                File file = new File(fileName);
                file.delete();
            }
            this.compensationHandler.containerBackups.clear();
        }
        this.exiting = true;
        super.disable();
    }

    private void dumpContainers() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)"about to save containers of scope");
        try {
            File tempFile = File.createTempFile("scope_", "bkp", Constants.TEMP_DIR);
            tempFile.deleteOnExit();
            FileOutputStream ostream = new FileOutputStream(tempFile);
            ObjectOutputStream oos = new ObjectOutputStream(ostream);
            String fileName = tempFile.getName();
            if (this.bpwsProcessRT != null) {
                oos.writeObject(this.bpwsProcessRT.containers);
            } else {
                oos.writeObject(this.containers);
            }
            oos.flush();
            ostream.close();
            runtimeLogger.debug((Object)("compensation handler is " + this.compensationHandler + " containerBackups is " + this.compensationHandler.containerBackups + " file name is " + fileName));
            this.compensationHandler.containerBackups.add(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPWSRuntimeException("Could not save containers to memory", e);
        }
    }

    public void faultThrown(FaultEvent event) throws BPWSRuntimeException {
        if (this.status != 3 && this.status != 4) {
            return;
        }
        if (this.exiting) {
            throw new BPWSRuntimeException("Scope " + this.name + " got a secondary fault while handling. Get out." + event);
        }
        this.exiting = true;
        QName faultName = event.getName();
        HandlerInfo handler = (HandlerInfo)this.faultHandlers.get(faultName);
        if (handler != null) {
            ContainerRT faultContainer = this.getContainer(handler.containerName);
            if (faultContainer != null) {
                faultContainer.setMessage(event.getMessage());
            }
            this.faultChild = handler.activity;
            runtimeLogger.debug((Object)("Found fault handller " + this.faultChild));
        } else {
            this.faultChild = this.catchAllFaultHandler;
        }
        if (this.faultChild != null) {
            Iterator childIterator = this.children.iterator();
            while (childIterator.hasNext()) {
                ActivityRT activity = (ActivityRT)childIterator.next();
                if (activity.equals(this.faultChild) || activity.equals(this.finallyBlockHandler) || activity.getType() != 11 || ((ScopeRT)activity).isCompensationHandlerShield || activity.getStatus() == 5 || activity.getStatus() == 1) continue;
                runtimeLogger.debug((Object)("uncompleted child being disabled " + activity));
                activity.disable();
            }
            if (this.status != 1) {
                this.faultChild.activate();
            }
        } else if (this.isFaultHandlerShield || this.isCompensationHandlerShield) {
            this.scope.fireFaultEvent(event);
        } else {
            this.fireFaultEvent(event);
        }
    }

    public void fireConflictingReceiveFault() throws BPWSRuntimeException {
        FaultEvent event = new FaultEvent(this, Constants.CONFLICTING_RECEIVE_FAULT_QNAME, null);
        this.fireFaultEvent(event);
    }

    public void fireConflictingRequestFault() throws BPWSRuntimeException {
        FaultEvent event = new FaultEvent(this, Constants.CONFLICTING_REQUEST_FAULT_QNAME, null);
        this.fireFaultEvent(event);
    }

    public ContainerRT getContainer(String containerName) {
        ContainerRT theContainer = (ContainerRT)this.containers.get(containerName);
        if (theContainer == null && this.scope != null) {
            return this.scope.getContainer(containerName);
        }
        return theContainer;
    }

    public EventChannel getEventChannel() {
        return this.eventChannel;
    }

    public int getType() {
        return 11;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Scope " + this.name + " is running"));
        Iterator receiveTemplates = this.myReceiveEventTemplates.iterator();
        ReceiveEvent currTemplate = null;
        while (receiveTemplates.hasNext()) {
            currTemplate = (ReceiveEvent)receiveTemplates.next();
            if (this.bpwsProcessRT != null) {
                this.bpwsProcessRT.getEventChannel().addListener(this, currTemplate);
                continue;
            }
            this.eventChannel.addListener(this, currTemplate);
        }
        if (this.activity != null) {
            this.activity.activate();
        } else {
            this.complete();
        }
    }

    public boolean isExiting() {
        return this.exiting;
    }

    public void messageReceived(ReceiveEvent event) throws BPWSRuntimeException {
        if (this.status != 3 && this.status != 4 || this.allDoneExceptMessageHandlers) {
            return;
        }
        HandlerInfo handler = (HandlerInfo)this.messageHandlers.get(String.valueOf(event.getPartnerName()) + event.getPortTypeName() + event.getOperationName());
        if (handler != null) {
            ActivityRT messageActivity = handler.activity;
            if (messageActivity.getStatus() != 4 && messageActivity.getStatus() != 2) {
                this.registerCorrelationInformation(handler.getOnMessage(), event.getMessage(), true);
                this.runMessageHandler(event, handler);
            } else {
                this.receiveEventQueue.addLast(event);
            }
        }
    }

    protected void registerCorrelationInformation(Object onMessage, WSIFMessage wsifmsg, boolean incoming) throws BPWSRuntimeException {
        this.bpwsProcessRT.registerCorrelationInformation(onMessage, wsifmsg, incoming);
    }

    protected void resetReceiveEventQueue() {
        Iterator iter = this.receiveEventQueue.iterator();
        this.bpwsProcessRT.requestsAborted(iter);
        this.receiveEventQueue.clear();
    }

    public void resetState() {
        super.resetState();
        this.runningMessageHandlers.clear();
        this.faultChild = null;
        this.numMessageHandlersCompleted = 0;
        this.allDoneExceptMessageHandlers = false;
        this.exiting = false;
        this.resetReceiveEventQueue();
    }

    private void restoreContainersOnHandler() throws BPWSRuntimeException {
        String fileName = (String)this.compensationHandler.containerBackups.removeLast();
        try {
            runtimeLogger.debug((Object)("restoring containers from " + fileName));
            File fileToRestoreFrom = new File(fileName);
            FileInputStream istream = new FileInputStream(fileToRestoreFrom);
            ObjectInputStream ois = new ObjectInputStream(istream);
            HashMap restoredContainers = (HashMap)ois.readObject();
            istream.close();
            ((ScopeRT)this.compensationHandler.activity).containers = restoredContainers;
            fileToRestoreFrom.delete();
        }
        catch (Exception e) {
            throw new BPWSRuntimeException("Could not read containers from memory", e);
        }
    }

    public void runCompensationHandler() throws BPWSRuntimeException {
        if (this.status == 5) {
            if (this.compensationHandler != null) {
                this.restoreContainersOnHandler();
                this.compensationHandler.activity.activate();
            } else {
                throw new BPWSRuntimeException("Attempting to run compensation handler of Scope " + this + " that has no compensation handler defined.");
            }
        }
    }

    protected void runMessageHandler(ReceiveEvent event, HandlerInfo handler) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("scope " + this.name + " about to run message handler"));
        if (handler != null) {
            ActivityRT messageActivity;
            ContainerRT msgContainer = this.getContainer(handler.containerName);
            if (msgContainer != null) {
                msgContainer.setMessage(event.getMessage());
            }
            if ((messageActivity = handler.activity).getStatus() == 5) {
                messageActivity.revive();
            }
            this.runningMessageHandlers.addLast(messageActivity);
            messageActivity.activate();
        }
    }

    public void setActivity(ActivityRT activity) {
        this.activity = activity;
        activity.addLifecycleListener(this);
        this.children.add(activity);
    }

    public void setCatchAllFaultHandler(ScopeRT activity) {
        this.catchAllFaultHandler = activity;
        this.catchAllFaultHandler.addLifecycleListener(this);
        this.children.add(this.catchAllFaultHandler);
    }

    public void setCompensationHandler(ScopeRT activity) {
        runtimeLogger.debug((Object)("setting compensation handler on scope " + this.name));
        this.compensationHandler = new HandlerInfo(activity, null);
        this.compensationHandler.containerBackups = new LinkedList();
        activity.addLifecycleListener(this);
        this.children.add(activity);
    }

    public void setFinallyBlockHandler(ScopeRT activity) {
        this.finallyBlockHandler = activity;
        this.finallyBlockHandler.addLifecycleListener(this);
        this.children.add(this.finallyBlockHandler);
    }

    public void tryToComplete() throws BPWSRuntimeException {
        if (this.numMessageHandlersCompleted == this.runningMessageHandlers.size() && this.receiveEventQueue.size() == 0 && (this.allDoneExceptMessageHandlers || this.activity == null)) {
            if (this.compensationHandler != null) {
                this.dumpContainers();
            }
            this.complete();
        }
    }
}

