/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime.container;

import com.ibm.bpws.model.From;
import com.ibm.bpws.model.To;
import com.ibm.cs.bpws.runtime.AssignRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.Debug;
import com.ibm.cs.bpws.runtime.bus.AssignValueHandler;
import com.ibm.cs.bpws.runtime.bus.BPWSBus;
import com.ibm.cs.bpws.runtime.bus.InvocationCompletionHandler;
import com.ibm.cs.bpws.runtime.bus.ServiceReference;
import com.ibm.cs.bpws.runtime.container.BPWSContainerProcessService;
import com.ibm.cs.bpws.util.alarm.AlarmHandler;
import com.ibm.cs.bpws.util.alarm.AlarmScheduler;
import com.ibm.jrom.JROMDurationValue;
import com.ibm.jrom.JROMTimeValue;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.ConvertorUtils;
import com.ibm.wsgw.WSGateway;
import com.ibm.wsif.WSIFMessage;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class BPWSManager
implements AlarmHandler {
    static Logger managerLogger = Logger.getLogger((String)"bpws.runtime.manager");
    BPWSBus serviceBus;
    WSGateway gateway;
    HashMap replyMessageTable = new HashMap();
    HashMap flowInstanceServiceCorrelation = new HashMap();
    AlarmScheduler alarmScheduler = new AlarmScheduler(this);
    HashMap alarmMap = new HashMap();
    JROMFactory jromFactory;

    public BPWSManager() {
        this(null);
        managerLogger.warn((Object)"No gateway was passed in to the BPWSManager; invocations done by the flow will fail");
    }

    public BPWSManager(WSGateway gateway) {
        this.serviceBus = new BPWSBus(1);
        this.serviceBus.setGateway(gateway);
        this.alarmScheduler.setVerbose(Debug.DEBUG_ON);
        try {
            this.jromFactory = JROMFactory.newInstance();
        }
        catch (Exception exception) {}
    }

    public void alarmRinging(Object correlationInfo) {
        List alarmRequests = (List)this.alarmMap.remove(correlationInfo);
        Iterator iter = alarmRequests.iterator();
        while (iter.hasNext()) {
            AlarmRequestDataStruct br = (AlarmRequestDataStruct)iter.next();
            iter.remove();
            br.callback.alarmRinging(br.clientData);
        }
    }

    public void bpwsProcessRTExited(BPWSProcessRT cg, QName faultName, WSIFMessage faultMessage, Exception exception) {
        BPWSContainerProcessService service = (BPWSContainerProcessService)this.flowInstanceServiceCorrelation.get(cg);
        service.removeFlowInstance(cg);
    }

    public void deregisterFlowInstance(BPWSProcessRT cg) {
        this.flowInstanceServiceCorrelation.remove(cg);
    }

    public void destroy() {
        this.serviceBus.destroy();
    }

    public void getValueToAssign(From assignSrc, To assignDest, AssignRT activity, AssignValueHandler callback, Object clientData) {
        this.serviceBus.getValueToAssign(assignSrc, assignDest, activity, callback, clientData);
    }

    public void invoke(ServiceReference serviceRef, QName portType, String operation, WSIFMessage input, InvocationCompletionHandler callback, Object clientData) {
        this.serviceBus.invoke(serviceRef, portType, operation, input, callback, clientData);
    }

    public void registerCorrelationInformation(BPWSProcessRT cg, Object modelObject, WSIFMessage wsifMsg, boolean in) throws BPWSRuntimeException {
        BPWSContainerProcessService service = (BPWSContainerProcessService)this.flowInstanceServiceCorrelation.get(cg);
        service.initializeCorrelationSets(cg, modelObject, wsifMsg, in);
    }

    public void registerFlowInstance(BPWSProcessRT cg, BPWSContainerProcessService service) {
        this.flowInstanceServiceCorrelation.put(cg, service);
    }

    public void reply(Object receiveClientData, WSIFMessage replyMsg, WSIFMessage correlationSet) {
        boolean isFault = false;
        managerLogger.debug((Object)"Queueing a response");
        HashMap hashMap = this.replyMessageTable;
        synchronized (hashMap) {
            this.replyMessageTable.put(receiveClientData, new ReplyDataStruct(isFault, replyMsg, correlationSet));
            this.replyMessageTable.notifyAll();
            managerLogger.debug((Object)"Notified listeners about a possible response");
        }
    }

    public void requestAborted(Object correlID) {
        HashMap hashMap = this.replyMessageTable;
        synchronized (hashMap) {
            this.replyMessageTable.put(correlID, new ReplyDataStruct(true, null, null));
            this.replyMessageTable.notifyAll();
        }
    }

    public void requestNotHandled(Object correlID) {
        HashMap hashMap = this.replyMessageTable;
        synchronized (hashMap) {
            this.replyMessageTable.put(correlID, new ReplyDataStruct(true, null, null));
            this.replyMessageTable.notifyAll();
        }
    }

    public ServiceReference resolvePartnerServiceReference(BPWSProcessRT cg, String partnerName) {
        BPWSContainerProcessService service = (BPWSContainerProcessService)this.flowInstanceServiceCorrelation.get(cg);
        QName serviceid = service.findPartner(partnerName);
        return new ServiceReference(null, serviceid, null);
    }

    public void setAlarm(String durationString, AlarmHandler callback, Object clientData) {
        JROMDurationValue durationVal = this.jromFactory.newJROMDurationValue();
        durationVal.setValue(ConvertorUtils.stringToDuration((String)durationString));
        JROMTimeValue timeJROM = this.jromFactory.newJROMTimeValue();
        timeJROM.setValue(new Date());
        durationVal.addDurationToDateTime(timeJROM);
        Date date = timeJROM.getValue();
        AlarmRequestDataStruct br = new AlarmRequestDataStruct(date, callback, clientData);
        if (this.alarmMap.containsKey(date)) {
            List alarmRequests = (List)this.alarmMap.get(date);
            alarmRequests.add(br);
        } else {
            LinkedList<AlarmRequestDataStruct> alarmRequests = new LinkedList<AlarmRequestDataStruct>();
            alarmRequests.add(br);
            this.alarmMap.put(date, alarmRequests);
        }
        this.alarmScheduler.scheduleAlarm(date);
    }

    public ReplyDataStruct waitForMessageFromProcess(Object correlID) {
        ReplyDataStruct rds = null;
        managerLogger.debug((Object)"Waiting for response");
        while (rds == null) {
            managerLogger.debug((Object)"Checking for a response");
            rds = (ReplyDataStruct)this.replyMessageTable.get(correlID);
            if (rds != null) continue;
            HashMap hashMap = this.replyMessageTable;
            synchronized (hashMap) {
                try {
                    this.replyMessageTable.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        managerLogger.debug((Object)"Done waiting for a response");
        return rds;
    }

    public class AlarmRequestDataStruct {
        public Date date;
        public AlarmHandler callback;
        public Object clientData;

        public AlarmRequestDataStruct(Date date, AlarmHandler callback, Object clientData) {
            this.date = date;
            this.clientData = clientData;
            this.callback = callback;
        }

        public String toString() {
            return "[BPWSManager.AlarmRequestDataStruc date=" + this.date + " clientData " + this.clientData + " callback = " + this.callback;
        }
    }

    public class ReplyDataStruct {
        public boolean isFault;
        public WSIFMessage replyMsg;
        public WSIFMessage contextMsg;

        public ReplyDataStruct(boolean isFault, WSIFMessage replyMsg, WSIFMessage contextMsg) {
            this.isFault = isFault;
            this.replyMsg = replyMsg;
            this.contextMsg = contextMsg;
        }
    }
}

