/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.util.alarm;

import com.ibm.cs.bpws.util.alarm.AlarmHandler;
import java.util.Date;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class AlarmScheduler
implements Runnable {
    private static Logger alarmLogger = Logger.getLogger((String)"bpws.runtime.alarm");
    private TreeSet alarmSet = new TreeSet();
    private Thread serviceThread;
    private Date date;
    private boolean done = false;
    private boolean verbose = false;
    AlarmHandler handler;

    public AlarmScheduler(AlarmHandler handler) {
        this.handler = handler;
        this.serviceThread = new Thread(this);
        this.serviceThread.start();
    }

    public void run() {
        Date event = null;
        long timeDiff = 0L;
        while (!this.done) {
            AlarmScheduler alarmScheduler = this;
            synchronized (alarmScheduler) {
                if (this.alarmSet.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.alarmSet.size() > 0) {
                    event = (Date)this.alarmSet.first();
                    this.date = new Date();
                    timeDiff = event.getTime() - this.date.getTime();
                    if (timeDiff < 0L) {
                        timeDiff = 0L;
                    }
                } else {
                    timeDiff = 0L;
                }
            }
            try {
                if (timeDiff > 0L && this.verbose) {
                    alarmLogger.debug((Object)("AlarmScheduler: alarm thread sleeping " + timeDiff));
                }
                Thread.sleep(timeDiff);
            }
            catch (InterruptedException interruptedException) {
                if (this.verbose) {
                    alarmLogger.debug((Object)("AlarmScheduler:alarm thread interrupted w/ date=" + event));
                }
                event = null;
            }
            alarmScheduler = this;
            synchronized (alarmScheduler) {
                if (this.alarmSet.size() > 0 && event != null) {
                    if (this.verbose) {
                        alarmLogger.debug((Object)("AlarmScheduler: alarm went off " + event));
                    }
                    this.alarmSet.remove(event);
                    this.handler.alarmRinging(event);
                    event = null;
                    timeDiff = 0L;
                }
            }
        }
    }

    public void scheduleAlarm(Date date) {
        AlarmScheduler alarmScheduler = this;
        synchronized (alarmScheduler) {
            Date firstDate = null;
            if (this.alarmSet.size() > 0) {
                firstDate = (Date)this.alarmSet.first();
            }
            this.alarmSet.add(date);
            if (date.compareTo(new Date()) < 0) {
                this.handler.alarmRinging(date);
            } else if (firstDate != null && date.compareTo(firstDate) < 0) {
                if (this.verbose) {
                    alarmLogger.debug((Object)("AlarmScheduler: about to interrupt alarm thread coz new date " + date + " is smaller than sleeping date " + firstDate));
                }
                this.serviceThread.interrupt();
            }
            this.notifyAll();
        }
    }

    public void setVerbose(boolean displayinfo) {
        this.verbose = this.verbose;
    }

    public void stop() {
        this.done = true;
    }
}

