/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.util.xpath;

import com.ibm.cs.bpws.util.xpath.MapBasedPrefixResolver;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.ExtensionHandlerJavaClass;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class XPathUtils {
    private static Document doc = null;
    private static XPathContext xpathContext = null;
    private static MapBasedPrefixResolver prefixResolver = null;

    static {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
            xpathContext = new XPathContext();
            ExtensionsTable eTable = xpathContext.getExtensionsTable();
            String prefix = "bpws";
            String uri = "http://schemas.xmlsoap.org/ws/2002/07/business-process/";
            ExtensionHandlerJavaClass fh = new ExtensionHandlerJavaClass(uri, "javaclass", "com.ibm.cs.bpws.util.xpath.Extensions");
            eTable.addExtensionNamespace(uri, (ExtensionHandler)fh);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(prefix, uri);
            prefixResolver = new MapBasedPrefixResolver(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized XObject eval(Node contextNode, String xpathExpr) throws TransformerException {
        if (contextNode == null) {
            contextNode = doc;
        }
        XPath xpath = new XPath(xpathExpr, null, (PrefixResolver)prefixResolver, 0);
        return xpath.execute(xpathContext, contextNode, (PrefixResolver)prefixResolver);
    }

    public static boolean evalToBoolean(Node contextNode, String xpathExpr) throws TransformerException, IllegalArgumentException {
        XObject xobject = XPathUtils.eval(contextNode, xpathExpr);
        int type = xobject.getType();
        if (type == 1) {
            return xobject.bool();
        }
        throw new IllegalArgumentException("Expression '" + xpathExpr + "' does not " + "evaluate to a boolean.");
    }

    public static String evalToString(Node contextNode, String xpathExpr) throws TransformerException, IllegalArgumentException {
        XObject xobject = XPathUtils.eval(contextNode, xpathExpr);
        int type = xobject.getType();
        if (type == 3) {
            return xobject.str();
        }
        throw new IllegalArgumentException("Expression '" + xpathExpr + "' does not " + "evaluate to a String.");
    }

    public static MapBasedPrefixResolver getMapBasedPrefixResolver() {
        return prefixResolver;
    }

    public static void main(String[] argv) throws TransformerException {
        if (argv.length == 1) {
            XObject xobject = XPathUtils.eval(null, argv[0]);
            XPathUtils.printXObject(xobject);
        } else if (argv.length == 2) {
            Document doc = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(argv[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            XObject xobject = XPathUtils.eval(doc, argv[1]);
            XPathUtils.printXObject(xobject);
        } else {
            System.err.println("Usage:");
            System.err.println("  java XPathUtils [xml-file] XPathExpr");
            System.exit(1);
        }
    }

    public static void printXObject(XObject xobject) throws TransformerException {
        int type = xobject.getType();
        if (type == 4) {
            NodeIterator nl = xobject.nodeset();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer serializer = transformerFactory.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            Node node = nl.nextNode();
            while (node != null) {
                serializer.transform(new DOMSource(node), new StreamResult(System.out));
                System.out.println();
                node = nl.nextNode();
            }
        } else if (type == 2) {
            System.out.println(xobject.num());
        } else if (type == 1) {
            System.out.println(xobject.bool());
        } else if (type == 3) {
            System.out.println(xobject.str());
        } else {
            System.err.println("Returned an XObject-wrapped object of type '" + xobject.object().getClass().getName() + "': " + xobject);
        }
    }
}

