/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.util.xslt;

import com.ibm.bpws.model.Container;
import com.ibm.bpws.model.Definition;
import com.ibm.bpws.model.From;
import com.ibm.bpws.model.Input;
import com.ibm.bpws.model.Result;
import com.ibm.bpws.model.To;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.util.xpath.XPathFunctions;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMValue;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsif.WSIFJROMPart;
import com.ibm.wsif.WSIFMessage;
import com.ibm.wsif.WSIFPart;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import samples.apachesoap.JROMDOMConvertor;

public class XSLTUtils {
    public static Document applyTransformation(Document inputDoc, Definition xsltDefinition) throws IllegalArgumentException {
        TransformerFactory factory = TransformerFactory.newInstance();
        String stylesheetURI = xsltDefinition.getLocation();
        Element stylesheetEl = xsltDefinition.getInlinedDefinition();
        Source stylesheetSource = null;
        if (stylesheetURI != null) {
            stylesheetSource = new StreamSource(stylesheetURI);
        } else if (stylesheetEl != null) {
            stylesheetSource = new DOMSource(stylesheetEl.getOwnerDocument());
        } else {
            throw new IllegalArgumentException("Definition must specify either an inlinedDefinition or a stylesheet location.");
        }
        DOMResult domResult = new DOMResult();
        try {
            Transformer transformer = factory.newTransformer(stylesheetSource);
            transformer.transform(new DOMSource(inputDoc), domResult);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return (Document)domResult.getNode();
    }

    public static Document getInputDocument(ActivityRT activity, Input input) throws IllegalArgumentException, TransformerException {
        int selectionCounter = 0;
        int expressionCounter = 0;
        JROMDOMConvertor convertor = null;
        try {
            convertor = new JROMDOMConvertor();
        }
        catch (JROMException e) {
            throw new IllegalArgumentException(e.toString());
        }
        String uri = "http://schemas.xmlsoap.org/ws/2002/07/business-process/";
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Element docElement = doc.createElementNS(uri, "bpws:transform-input");
        doc.appendChild(docElement);
        List froms = input.getFroms();
        int i = 0;
        while (i < froms.size()) {
            Element sourceEl;
            block14: {
                From from = (From)froms.get(i);
                String elName = null;
                if (from.getExpression() != null) {
                    elName = "expression" + expressionCounter++;
                } else {
                    Container container = from.getContainer();
                    String partName = from.getPart();
                    elName = "container-" + container.getName();
                    if (partName != null) {
                        elName = String.valueOf(elName) + "-" + partName;
                        if (from.getQuery() != null) {
                            elName = String.valueOf(elName) + "-selection" + selectionCounter++;
                        }
                    }
                }
                sourceEl = doc.createElementNS(uri, elName);
                Object dataObj = XPathFunctions.getDataToCopy(activity, from, null);
                try {
                    if (dataObj instanceof JROMValue) {
                        Element dataEl = convertor.JROM2DOM((JROMValue)dataObj);
                        Element dataElClone = (Element)doc.importNode(dataEl, true);
                        sourceEl.appendChild(doc.createTextNode("\n\r"));
                        sourceEl.appendChild(dataElClone);
                        sourceEl.appendChild(doc.createTextNode("\n\r"));
                        break block14;
                    }
                    if (dataObj instanceof WSIFMessage) {
                        Iterator parts = ((WSIFMessage)dataObj).getParts();
                        while (parts.hasNext()) {
                            WSIFPart part = (WSIFPart)parts.next();
                            JROMValue partValue = (JROMValue)part.getJavaValue();
                            Element partEl = convertor.JROM2DOM(partValue);
                            Element partElClone = (Element)doc.importNode(partEl, true);
                            sourceEl.appendChild(doc.createTextNode("\n\r"));
                            sourceEl.appendChild(partElClone);
                            sourceEl.appendChild(doc.createTextNode("\n\r"));
                        }
                        break block14;
                    }
                    throw new IllegalArgumentException("Got back something other than a JROMValue or a WSIFMessage: " + dataObj);
                }
                catch (JROMException e) {
                    throw new IllegalArgumentException(e.toString());
                }
            }
            docElement.appendChild(doc.createTextNode("\n\r"));
            docElement.appendChild(sourceEl);
            docElement.appendChild(doc.createTextNode("\n\r"));
            ++i;
        }
        return doc;
    }

    public static void mapResults(ActivityRT activity, Result result, Document resultDoc) throws IllegalArgumentException, TransformerException {
        JROMDOMConvertor convertor = null;
        try {
            convertor = new JROMDOMConvertor();
        }
        catch (JROMException e) {
            throw new IllegalArgumentException(e.toString());
        }
        Element tempEl = resultDoc.getDocumentElement();
        String uri = "http://schemas.xmlsoap.org/ws/2002/07/business-process/";
        QName outputQName = new QName(uri, "transform-output");
        if (XSLTUtils.matches(outputQName, tempEl)) {
            List tos = result.getTos();
            int tosCount = tos.size();
            int i = 0;
            tempEl = DOMUtils.getFirstChildElement((Element)tempEl);
            while (tempEl != null) {
                if (i + 1 > tosCount) {
                    throw new IllegalArgumentException("There are " + tosCount + " To's, but more than " + tosCount + " child elements " + "in the XSLT result document.");
                }
                To to = (To)tos.get(i);
                Element childEl = DOMUtils.getFirstChildElement((Element)tempEl);
                if (childEl == null) {
                    throw new IllegalArgumentException("Wrapper element '" + tempEl.getTagName() + "' contains no child " + "element.");
                }
                JROMValue fromValue = convertor.DOM2JROM(childEl);
                Container toContainer = to.getContainer();
                String toContainerName = toContainer.getName();
                String toPartName = to.getPart();
                WSIFMessage toMessage = XPathFunctions.getWSIFMessage("mapResults", new String[]{toContainerName, toPartName}, activity, toContainerName, toPartName);
                JROMValue dataToCopy = null;
                if (to.getQuery() == null) {
                    JROMValue toPartValue = XPathFunctions.getPartValue("mapResults", new String[]{toContainerName, toPartName}, toPartName, toMessage);
                    dataToCopy = XPathFunctions.cloneJROMValue(fromValue, toPartValue);
                } else {
                    dataToCopy = XPathFunctions.getDataToCopy(activity, fromValue, to);
                }
                WSIFJROMPart toPart = new WSIFJROMPart(dataToCopy);
                toMessage.setPart(toPartName, (WSIFPart)toPart);
                tempEl = DOMUtils.getNextSiblingElement((Element)tempEl);
                ++i;
            }
            if (tosCount > i) {
                throw new IllegalArgumentException("There are " + tosCount + " To's, but only " + i + " child elements " + "in the XSLT result document.");
            }
        } else {
            throw new IllegalArgumentException("Encountered '" + tempEl.getNamespaceURI() + ":" + tempEl.getLocalName() + "', instead of '" + outputQName + "'.");
        }
    }

    private static boolean matches(QName qname, Node node) {
        return node != null && qname.equals(XSLTUtils.newQName(node));
    }

    private static QName newQName(Node node) {
        if (node != null) {
            return new QName(node.getNamespaceURI(), node.getLocalName());
        }
        return new QName(null, null);
    }
}

