/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpws.factory;

import com.ibm.bpws.BPWSException;
import com.ibm.bpws.model.BPWSProcess;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public abstract class BPWSFactory {
    private static final String PROPERTY_NAME = "com.ibm.bpws.factory.BPWSFactory";
    private static final String PROPERTY_FILE_NAME = "bpws.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "com.ibm.cs.bpws.factory.BPWSFactoryImpl";
    private static String fullPropertyFileName = null;

    private static String findFactoryImplName() {
        block6: {
            String factoryImplName = null;
            try {
                factoryImplName = System.getProperty(PROPERTY_NAME);
                if (factoryImplName != null) {
                    return factoryImplName;
                }
            }
            catch (SecurityException securityException) {}
            String propFileName = BPWSFactory.getFullPropertyFileName();
            if (propFileName == null) break block6;
            try {
                Properties properties = new Properties();
                File propFile = new File(propFileName);
                FileInputStream fis = new FileInputStream(propFile);
                properties.load(fis);
                fis.close();
                factoryImplName = properties.getProperty(PROPERTY_NAME);
                if (factoryImplName != null) {
                    return factoryImplName;
                }
            }
            catch (IOException iOException) {}
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        block2: {
            if (fullPropertyFileName != null) break block2;
            try {
                String javaHome = System.getProperty("java.home");
                fullPropertyFileName = String.valueOf(javaHome) + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {}
        }
        return fullPropertyFileName;
    }

    public abstract BPWSProcess newBPWSProcess();

    public static BPWSFactory newInstance() throws BPWSException {
        String factoryImplName = BPWSFactory.findFactoryImplName();
        return BPWSFactory.newInstance(factoryImplName);
    }

    public static BPWSFactory newInstance(String factoryImplName) throws BPWSException {
        if (factoryImplName != null) {
            try {
                Class<?> cl = Class.forName(factoryImplName);
                return (BPWSFactory)cl.newInstance();
            }
            catch (Exception e) {
                throw new BPWSException("CONFIGURATION_ERROR", "Problem instantiating factory implementation.", e);
            }
        }
        throw new BPWSException("CONFIGURATION_ERROR", "Unable to find name of factory implementation.");
    }
}

