/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.parser;

import com.ibm.bpws.model.Activity;
import com.ibm.bpws.model.Assign;
import com.ibm.bpws.model.BPWSProcess;
import com.ibm.bpws.model.CaseClause;
import com.ibm.bpws.model.CatchAll;
import com.ibm.bpws.model.CatchFault;
import com.ibm.bpws.model.CompensationHandler;
import com.ibm.bpws.model.Copy;
import com.ibm.bpws.model.Correlation;
import com.ibm.bpws.model.CorrelationSet;
import com.ibm.bpws.model.CorrelationSets;
import com.ibm.bpws.model.Correlations;
import com.ibm.bpws.model.FaultHandlers;
import com.ibm.bpws.model.Flow;
import com.ibm.bpws.model.From;
import com.ibm.bpws.model.Invoke;
import com.ibm.bpws.model.Link;
import com.ibm.bpws.model.OnAlarm;
import com.ibm.bpws.model.OnMessage;
import com.ibm.bpws.model.Partner;
import com.ibm.bpws.model.Partners;
import com.ibm.bpws.model.Pick;
import com.ibm.bpws.model.Receive;
import com.ibm.bpws.model.Reply;
import com.ibm.bpws.model.Scope;
import com.ibm.bpws.model.Sequence;
import com.ibm.bpws.model.Source;
import com.ibm.bpws.model.SwitchBlock;
import com.ibm.bpws.model.Target;
import com.ibm.bpws.model.Throw;
import com.ibm.bpws.model.To;
import com.ibm.bpws.model.Variable;
import com.ibm.bpws.model.Variables;
import com.ibm.bpws.model.Wait;
import com.ibm.bpws.model.While;
import com.ibm.cs.bpws.parser.BPWSParser;
import com.ibm.cs.bpws.util.ParentChildPair;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class Validator {
    private static Map validationErrors;
    private static BPWSProcess process;
    static /* synthetic */ Class class$com$ibm$bpws$model$Scope;
    static /* synthetic */ Class class$com$ibm$cs$bpws$parser$Validator;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static boolean isCorrelationSetDefined(String setName, ParentChildPair pcPair) {
        CorrelationSets sets = null;
        ParentChildPair parentP = pcPair.parentPair;
        boolean result = false;
        parentP = pcPair.parentPair;
        while (parentP != null) {
            if (parentP.child != null && (class$com$ibm$bpws$model$Scope != null ? class$com$ibm$bpws$model$Scope : Validator.class$("com.ibm.bpws.model.Scope")).isAssignableFrom(parentP.child.getClass()) && Validator.isCorrelationSetInSets(sets = ((Scope)parentP.child).getCorrelationSets(), setName)) {
                return true;
            }
            parentP = parentP.parentPair;
        }
        return Validator.isCorrelationSetInSets(process.getCorrelationSets(), setName);
    }

    private static boolean isCorrelationSetInSets(CorrelationSets sets, String setName) {
        if (sets != null && sets.getCorrelationSets() != null) {
            Iterator setList = sets.getCorrelationSets().iterator();
            while (setList.hasNext()) {
                CorrelationSet set = (CorrelationSet)setList.next();
                if (!set.getName().equals(setName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isLinkDefined(Link link, Activity activity) {
        return true;
    }

    private static boolean isOperationValid(String operation) {
        return operation != null && operation.length() > 0;
    }

    private static boolean isPartnerDefined(Partner partner) {
        List partnerList;
        Partners partners;
        if (partner != null && (partners = process.getPartners()) != null && (partnerList = partners.getPartners()) != null) {
            Iterator partnerIterator = partnerList.iterator();
            while (partnerIterator.hasNext()) {
                Partner current = (Partner)partnerIterator.next();
                if (!current.equals(partner)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPortTypeValid(QName portType) {
        return portType != null;
    }

    private static boolean isVariableDefined(Variable variable, ParentChildPair pcPair) {
        if (variable != null) {
            Variables variables = process.getVariables();
            ParentChildPair parentP = pcPair.parentPair;
            parentP = pcPair.parentPair;
            while (parentP != null) {
                if (parentP.child != null && (class$com$ibm$bpws$model$Scope != null ? class$com$ibm$bpws$model$Scope : Validator.class$("com.ibm.bpws.model.Scope")).isAssignableFrom(parentP.child.getClass()) && Validator.isVariableInVariables(variables = ((Scope)parentP.child).getVariables(), variable)) {
                    return true;
                }
                parentP = parentP.parentPair;
            }
            return Validator.isVariableInVariables(process.getVariables(), variable);
        }
        return false;
    }

    private static boolean isVariableInVariables(Variables variables, Variable variable) {
        List variableList;
        if (variables != null && (variableList = variables.getVariables()) != null) {
            Iterator variableIterator = variableList.iterator();
            while (variableIterator.hasNext()) {
                Variable current = (Variable)variableIterator.next();
                if (!current.equals(variable)) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: " + (class$com$ibm$cs$bpws$parser$Validator != null ? class$com$ibm$cs$bpws$parser$Validator : (class$com$ibm$cs$bpws$parser$Validator = Validator.class$("com.ibm.cs.bpws.parser.Validator"))).getName() + " filename");
            System.exit(1);
        }
        URL url = null;
        try {
            url = new URL("file", null, args[0]);
            BPWSProcess proc = BPWSParser.readBPWS(null, url);
            Map errorMap = Validator.validateBPWS(proc);
            int numErrors = 0;
            if (errorMap.values() == null || errorMap.values().size() == 0) {
                System.out.println("Validation complete, no errors found");
            } else {
                Iterator errors = errorMap.values().iterator();
                while (errors.hasNext()) {
                    List errorList = (List)errors.next();
                    Iterator errorListIt = errorList.iterator();
                    while (errorListIt.hasNext()) {
                        System.out.println(errorListIt.next());
                        ++numErrors;
                    }
                }
                System.out.println("Validation complete, " + numErrors + " error(s) found");
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Unable to parse URL " + url + ", received the following exception:");
            e.printStackTrace();
        }
    }

    private static void validateActivity(Activity activity, ParentChildPair parentPair) {
        List targets;
        ParentChildPair currPCPair = new ParentChildPair(parentPair, activity);
        String name = "";
        if (activity.getName() != null) {
            name = activity.getName();
        }
        LinkedList<String> errors = new LinkedList<String>();
        List sources = activity.getSources();
        if (sources != null) {
            Iterator sourceList = sources.iterator();
            while (sourceList.hasNext()) {
                Source source = (Source)sourceList.next();
                if (source.getLink() == null || source.getLink().getName() == null || source.getLink().getName().length() == 0) {
                    errors.add(new String("Activity " + name + " is a source of an unspecified link"));
                }
                if (source.getLink() == null || Validator.isLinkDefined(source.getLink(), activity)) continue;
                String linkName = "";
                if (source.getLink().getName() != null) {
                    linkName = source.getLink().getName();
                }
                errors.add(new String("Source link " + linkName + " in activity " + name + "is undefined"));
            }
        }
        if ((targets = activity.getTargets()) != null) {
            Iterator targetList = targets.iterator();
            while (targetList.hasNext()) {
                Target target = (Target)targetList.next();
                if (target.getLink() == null || target.getLink().getName() == null || target.getLink().getName().length() == 0) {
                    errors.add(new String("Activity " + name + " is a target of an unspecified link"));
                }
                if (target.getLink() == null || Validator.isLinkDefined(target.getLink(), activity)) continue;
                String linkName = "";
                if (target.getLink().getName() != null) {
                    linkName = target.getLink().getName();
                }
                errors.add(new String("Target link " + linkName + " in activity " + name + "is undefined"));
            }
        }
        if (activity instanceof Receive) {
            Validator.validateReceive((Receive)activity, errors, name, currPCPair);
        } else if (activity instanceof Invoke) {
            Validator.validateInvoke((Invoke)activity, errors, name, currPCPair);
        } else if (activity instanceof Reply) {
            Validator.validateReply((Reply)activity, errors, name, currPCPair);
        } else if (activity instanceof Assign) {
            Validator.validateAssign((Assign)activity, errors, name, currPCPair);
        } else if (activity instanceof Wait) {
            Validator.validateWait((Wait)activity, errors, name);
        } else if (activity instanceof SwitchBlock) {
            Validator.validateSwitch((SwitchBlock)activity, errors, name, currPCPair);
        } else if (activity instanceof Pick) {
            Validator.validatePick((Pick)activity, errors, name, currPCPair);
        } else if (activity instanceof Scope) {
            Validator.validateScope((Scope)activity, errors, name, currPCPair);
        } else if (activity instanceof Sequence) {
            Validator.validateSequence((Sequence)activity, errors, name, currPCPair);
        } else if (activity instanceof Flow) {
            Validator.validateFlow((Flow)activity, errors, name, currPCPair);
        } else if (activity instanceof While) {
            Validator.validateWhile((While)activity, errors, name, currPCPair);
        } else if (activity instanceof Throw) {
            Validator.validateThrow((Throw)activity, errors, name, currPCPair);
        }
    }

    private static void validateAssign(Assign assign, List errors, String name, ParentChildPair pcPair) {
        List copies = assign.getCopies();
        if (copies.size() == 0) {
            errors.add(new String("Assign activity " + name + " must have at least one copy clause"));
        }
        Iterator copyList = copies.iterator();
        while (copyList.hasNext()) {
            Copy copy = (Copy)copyList.next();
            From from = copy.getFrom();
            if (from == null) {
                errors.add(new String("Copy clause in assign activity " + name + " does not " + "specify source (the required 'from' element is absent)"));
            } else if (from.getVariable() != null) {
                if (!Validator.isVariableDefined(from.getVariable(), pcPair)) {
                    errors.add(new String("Variable " + from.getVariable().getName() + " specified in copy clause of assign activity " + name + " is not defined"));
                }
            } else if (from.getPartner() != null) {
                if (!Validator.isPartnerDefined(from.getPartner())) {
                    errors.add(new String("Partner " + from.getPartner().getName() + " specified in copy clause of assign activity " + name + " is not defined"));
                }
                if (from.getServiceReference() == null) {
                    errors.add(new String("Must have service reference specified with partner in definition of from element of assign activity " + name));
                } else if (!from.getServiceReference().equals("myRole") && !from.getServiceReference().equals("partnerRole")) {
                    errors.add("Invalid service reference specified in definition of from element of assign activity " + name);
                }
            }
            To to = copy.getTo();
            if (to == null) {
                errors.add(new String("Copy clause of assign activity " + name + " does not specify destination (the required 'to' " + "element is absent)"));
                continue;
            }
            if (to.getVariable() != null) {
                if (Validator.isVariableDefined(to.getVariable(), pcPair)) continue;
                errors.add(new String("Variable " + to.getVariable().getName() + " specified in copy clause of assign activity " + name + " is not defined"));
                continue;
            }
            if (to.getPartner() == null || Validator.isPartnerDefined(to.getPartner())) continue;
            errors.add(new String("Partner " + to.getPartner().getName() + " specified in copy clause of assign activity " + name + " is not defined"));
        }
        if (errors.size() > 0) {
            validationErrors.put(assign, errors);
        }
    }

    public static synchronized Map validateBPWS(BPWSProcess process) {
        validationErrors = new HashMap();
        Validator.process = process;
        Validator.validateProcess();
        return validationErrors;
    }

    private static void validateCatchAll(CatchAll catchAll, ParentChildPair pcPair) {
        if (catchAll.getActivity() == null) {
            LinkedList<String> errors = new LinkedList<String>();
            errors.add("Catch all must contain an activity");
            if (errors.size() > 0) {
                validationErrors.put(catchAll, errors);
            }
        } else {
            Validator.validateActivity(catchAll.getActivity(), pcPair);
        }
    }

    private static void validateCatchFault(CatchFault catchFault, ParentChildPair pcPair) {
        if (catchFault.getActivity() == null) {
            LinkedList<String> errors = new LinkedList<String>();
            errors.add("Catch must contain an activity");
            if (errors.size() > 0) {
                validationErrors.put(catchFault, errors);
            }
        } else {
            Validator.validateActivity(catchFault.getActivity(), pcPair);
        }
    }

    private static void validateCompensationHandler(CompensationHandler compensationHandler, ParentChildPair pcPair) {
        if (compensationHandler.getActivity() == null) {
            LinkedList<String> errors = new LinkedList<String>();
            errors.add("Compensation handler must contain an activity");
            if (errors.size() > 0) {
                validationErrors.put(compensationHandler, errors);
            }
        } else {
            Validator.validateActivity(compensationHandler.getActivity(), pcPair);
        }
    }

    private static void validateCorrelation(Correlation correlation, ParentChildPair pcPair) {
        LinkedList<String> errors = new LinkedList<String>();
        if (correlation.getSet() == null || correlation.getSet().length() == 0) {
            errors.add("Correlation must belong to a set");
        } else if (!Validator.isCorrelationSetDefined(correlation.getSet(), pcPair)) {
            errors.add("Correlation set " + correlation.getSet() + " is undefined");
        }
        if (errors.size() > 0) {
            validationErrors.put(correlation, errors);
        }
    }

    private static void validateCorrelationSet(CorrelationSet correlationSet) {
        LinkedList<String> errors = new LinkedList<String>();
        if (correlationSet.getName() == null || correlationSet.getName().length() == 0) {
            errors.add("Correlation set must be named");
        }
        if (correlationSet.getProperties() == null || correlationSet.getProperties().size() == 0) {
            errors.add("Correlation set must contain at least one property");
        }
        if (errors.size() > 0) {
            validationErrors.put(correlationSet, errors);
        }
    }

    private static void validateFlow(Flow flow, List errors, String name, ParentChildPair pcPair) {
        if (flow.getActivities() != null && flow.getActivities().size() != 0) {
            Iterator activities = flow.getActivities().iterator();
            while (activities.hasNext()) {
                Activity activity = (Activity)activities.next();
                Validator.validateActivity(activity, new ParentChildPair(pcPair, flow));
            }
        } else {
            errors.add(new String("Flow activity " + name + " does not contain any activities"));
        }
        if (flow.getLinks() != null && flow.getLinks().getLinks() != null) {
            Iterator links = flow.getLinks().getLinks().iterator();
            while (links.hasNext()) {
                Link link = (Link)links.next();
                if (link.getName() != null && link.getName().length() != 0) continue;
                errors.add(new String("Flow activity " + name + " has an unnamed link"));
            }
        }
        if (errors.size() > 0) {
            validationErrors.put(flow, errors);
        }
    }

    private static void validateInvoke(Invoke invoke, List errors, String name, ParentChildPair pcPair) {
        CompensationHandler compensationHandler;
        List catchFaultList;
        Correlations correlations;
        if (!Validator.isPartnerDefined(invoke.getPartner())) {
            errors.add(new String("Invoke activity " + name + " does not specify a valid partner"));
        }
        if (!Validator.isPortTypeValid(invoke.getPortType())) {
            errors.add(new String("Invoke activity " + name + " does not specify a valid port type"));
        }
        if (!Validator.isOperationValid(invoke.getOperation())) {
            errors.add(new String("Invoke activity " + name + " does not specify a valid  operation"));
        }
        if (!Validator.isVariableDefined(invoke.getInputVariable(), pcPair)) {
            errors.add(new String("Invoke activity " + name + " does not specify a valid input variable"));
        }
        if ((correlations = invoke.getCorrelations()) != null && correlations.getCorrelations() != null) {
            if (correlations.getCorrelations().size() == 0) {
                errors.add("Invoke activity " + name + " has correlations tag " + "with no correlation defined");
            } else {
                Iterator correlationList = correlations.getCorrelations().iterator();
                while (correlationList.hasNext()) {
                    Correlation correlation = (Correlation)correlationList.next();
                    Validator.validateCorrelation(correlation, pcPair);
                }
            }
        }
        if ((catchFaultList = invoke.getCatchFaults()) != null) {
            Iterator catchFaultIterator = catchFaultList.iterator();
            while (catchFaultIterator.hasNext()) {
                CatchFault catchFault = (CatchFault)catchFaultIterator.next();
                Validator.validateCatchFault(catchFault, pcPair);
            }
        }
        if ((compensationHandler = invoke.getCompensationHandler()) != null) {
            Validator.validateCompensationHandler(compensationHandler, pcPair);
        }
        if (errors.size() > 0) {
            validationErrors.put(invoke, errors);
        }
    }

    private static void validatePartner(Partner partner) {
        LinkedList<String> errors = new LinkedList<String>();
        if (partner.getName() == null || partner.getName().length() == 0) {
            errors.add("Process defines an unnamed partner");
        }
        if (partner.getServiceLinkType() == null) {
            if (partner.getName() != null) {
                errors.add("Partner " + partner.getName() + "  has no a service link type");
            } else {
                errors.add("Process defines a partner without a service link type");
            }
        }
        if (errors.size() > 0) {
            validationErrors.put(partner, errors);
        }
    }

    private static void validatePick(Pick pick, List errors, String name, ParentChildPair pcPair) {
        if (pick.getOnMessages() == null || pick.getOnMessages().size() == 0) {
            errors.add("Pick activity " + name + " must contain at least one 'onMessage' clause");
        } else {
            Iterator onMessages = pick.getOnMessages().iterator();
            while (onMessages.hasNext()) {
                Correlations correlations;
                OnMessage onMessage = (OnMessage)onMessages.next();
                if (!Validator.isPartnerDefined(onMessage.getPartner())) {
                    errors.add(new String("OnMessage clause in pick activity " + name + " does not specify a valid partner"));
                }
                if (!Validator.isPortTypeValid(onMessage.getPortType())) {
                    errors.add(new String("OnMessage clause in pick activity " + name + " does not specify a valid port type"));
                }
                if (!Validator.isOperationValid(onMessage.getOperation())) {
                    errors.add(new String("OnMessage clause in pick activity " + name + " does not specify a valid operation"));
                }
                if (!Validator.isVariableDefined(onMessage.getVariable(), pcPair)) {
                    errors.add(new String("OnMessage clause in pick activity " + name + " does not specify a valid variable"));
                }
                if ((correlations = onMessage.getCorrelations()) != null && correlations.getCorrelations() != null) {
                    if (correlations.getCorrelations().size() == 0) {
                        errors.add("OnMessage clause in pick activity " + name + " has correlations tag with no correlation defined");
                    } else {
                        Iterator correlationList = correlations.getCorrelations().iterator();
                        while (correlationList.hasNext()) {
                            Correlation correlation = (Correlation)correlationList.next();
                            Validator.validateCorrelation(correlation, pcPair);
                        }
                    }
                }
                if (onMessage.getActivity() == null) {
                    errors.add("OnMessage clause in pick activity " + name + " does not have any activity");
                    continue;
                }
                Validator.validateActivity(onMessage.getActivity(), new ParentChildPair(pcPair, pick));
            }
            if (pick.getOnAlarms() != null) {
                Iterator onAlarms = pick.getOnAlarms().iterator();
                while (onAlarms.hasNext()) {
                    OnAlarm onAlarm = (OnAlarm)onAlarms.next();
                    if (!(onAlarm.getForExpr() != null && onAlarm.getForExpr().length() != 0 || onAlarm.getUntil() != null && onAlarm.getUntil().length() != 0)) {
                        errors.add(new String("OnAlarm clause in pick activity " + name + " must specify a " + "for expression or an until expression"));
                    }
                    if (onAlarm.getActivity() == null) {
                        errors.add("OnAlarm clause in pick activity " + name + " does not have any activity");
                        continue;
                    }
                    Validator.validateActivity(onAlarm.getActivity(), new ParentChildPair(pcPair, pick));
                }
            }
        }
        if (errors.size() > 0) {
            validationErrors.put(pick, errors);
        }
    }

    private static void validateProcess() {
        List correlationSetList;
        CorrelationSets correlationSets;
        FaultHandlers faultHandlers;
        List variableList;
        Variables variables;
        List partnerList;
        Partners partners;
        LinkedList<String> errors = new LinkedList<String>();
        if (process.getTargetNamespace() == null || process.getTargetNamespace().length() == 0) {
            errors.add(new String("Process must have a declared target namespace"));
        }
        if (process.getName() == null || process.getName().length() == 0) {
            errors.add(new String("Process must have a name"));
        }
        if ((partners = process.getPartners()) != null && (partnerList = partners.getPartners()) != null) {
            Iterator partnerIterator = partnerList.iterator();
            while (partnerIterator.hasNext()) {
                Partner partner = (Partner)partnerIterator.next();
                Validator.validatePartner(partner);
            }
        }
        if ((variables = process.getVariables()) != null && (variableList = variables.getVariables()) != null) {
            Iterator variableIterator = variableList.iterator();
            while (variableIterator.hasNext()) {
                Variable variable = (Variable)variableIterator.next();
                Validator.validateVariable(variable);
            }
        }
        if ((faultHandlers = process.getFaultHandlers()) != null) {
            CatchAll catchAll;
            List catchFaultList;
            if ((faultHandlers.getCatchFaults() == null || faultHandlers.getCatchFaults().size() == 0) && faultHandlers.getCatchAll() == null) {
                errors.add("Process must have at least one fault handler or default handler defined");
            }
            if ((catchFaultList = faultHandlers.getCatchFaults()) != null) {
                Iterator catchFaultIterator = catchFaultList.iterator();
                while (catchFaultIterator.hasNext()) {
                    CatchFault catchFault = (CatchFault)catchFaultIterator.next();
                    Validator.validateCatchFault(catchFault, null);
                }
            }
            if ((catchAll = faultHandlers.getCatchAll()) != null) {
                Validator.validateCatchAll(catchAll, null);
            }
        }
        if (process.getCompensationHandler() != null) {
            Validator.validateCompensationHandler(process.getCompensationHandler(), null);
        }
        if ((correlationSets = process.getCorrelationSets()) != null && (correlationSetList = correlationSets.getCorrelationSets()) != null) {
            Iterator correlationSetIterator = correlationSetList.iterator();
            while (correlationSetIterator.hasNext()) {
                CorrelationSet correlationSet = (CorrelationSet)correlationSetIterator.next();
                Validator.validateCorrelationSet(correlationSet);
            }
        }
        if (process.getActivity() == null) {
            errors.add("Process must contain an activity");
        } else {
            Validator.validateActivity(process.getActivity(), null);
        }
        if (errors.size() > 0) {
            validationErrors.put(process, errors);
        }
    }

    private static void validateReceive(Receive receive, List errors, String name, ParentChildPair pcPair) {
        Correlations correlations;
        if (!Validator.isPartnerDefined(receive.getPartner())) {
            errors.add(new String("Receive activity " + name + " does not specify a valid partner"));
        }
        if (!Validator.isPortTypeValid(receive.getPortType())) {
            errors.add(new String("Receive activity " + name + " does not specify a valid port type"));
        }
        if (!Validator.isOperationValid(receive.getOperation())) {
            errors.add(new String("Receive activity " + name + " does not specify a valid operation"));
        }
        if (!Validator.isVariableDefined(receive.getVariable(), pcPair)) {
            errors.add(new String("Receive activity " + name + " does not specify a valid variable"));
        }
        if ((correlations = receive.getCorrelations()) != null && correlations.getCorrelations() != null) {
            if (correlations.getCorrelations().size() == 0) {
                errors.add("Receive activity " + name + " has correlations tag " + "with no correlation defined");
            } else {
                Iterator correlationList = correlations.getCorrelations().iterator();
                while (correlationList.hasNext()) {
                    Correlation correlation = (Correlation)correlationList.next();
                    Validator.validateCorrelation(correlation, pcPair);
                }
            }
        }
        if (errors.size() > 0) {
            validationErrors.put(receive, errors);
        }
    }

    private static void validateReply(Reply reply, List errors, String name, ParentChildPair pcPair) {
        Correlations correlations;
        if (!Validator.isPartnerDefined(reply.getPartner())) {
            errors.add(new String("Reply activity " + name + " does not specify a valid partner"));
        }
        if (!Validator.isPortTypeValid(reply.getPortType())) {
            errors.add(new String("Reply activity " + name + " does not specify a valid port type"));
        }
        if (!Validator.isOperationValid(reply.getOperation())) {
            errors.add(new String("Reply activity " + name + " does not specify a valid operation"));
        }
        if (!Validator.isVariableDefined(reply.getVariable(), pcPair)) {
            errors.add(new String("Reply activity " + name + " does not specify a valid variable"));
        }
        if ((correlations = reply.getCorrelations()) != null && correlations.getCorrelations() != null) {
            if (correlations.getCorrelations().size() == 0) {
                errors.add("Reply activity " + name + " has correlations tag " + "with no correlation defined");
            } else {
                Iterator correlationList = correlations.getCorrelations().iterator();
                while (correlationList.hasNext()) {
                    Correlation correlation = (Correlation)correlationList.next();
                    Validator.validateCorrelation(correlation, pcPair);
                }
            }
        }
        if (errors.size() > 0) {
            validationErrors.put(reply, errors);
        }
    }

    private static void validateScope(Scope scope, List errors, String name, ParentChildPair pcPair) {
        FaultHandlers faultHandlers;
        List variableList;
        Variables variables;
        List correlationSetList;
        CorrelationSets correlationSets;
        if (scope.getActivity() != null) {
            Validator.validateActivity(scope.getActivity(), new ParentChildPair(pcPair, scope));
        } else {
            errors.add(new String("Scope activity " + name + "does not contain any activity"));
        }
        if (scope.getVariableAccessSerializable() == null) {
            errors.add(new String("Scope activity " + name + " does not specify variable access serialzable"));
        }
        if ((correlationSets = scope.getCorrelationSets()) != null && (correlationSetList = correlationSets.getCorrelationSets()) != null) {
            Iterator correlationSetIterator = correlationSetList.iterator();
            while (correlationSetIterator.hasNext()) {
                CorrelationSet correlationSet = (CorrelationSet)correlationSetIterator.next();
                Validator.validateCorrelationSet(correlationSet);
            }
        }
        if ((variables = scope.getVariables()) != null && (variableList = variables.getVariables()) != null) {
            Iterator variableIterator = variableList.iterator();
            while (variableIterator.hasNext()) {
                Variable variable = (Variable)variableIterator.next();
                Validator.validateVariable(variable);
            }
        }
        if ((faultHandlers = scope.getFaultHandlers()) != null) {
            CatchAll catchAll;
            List catchFaultList;
            if ((faultHandlers.getCatchFaults() == null || faultHandlers.getCatchFaults().size() == 0) && faultHandlers.getCatchAll() == null) {
                errors.add("Scope must have at least one fault handler or default handler defined");
            }
            if ((catchFaultList = faultHandlers.getCatchFaults()) != null) {
                Iterator catchFaultIterator = catchFaultList.iterator();
                while (catchFaultIterator.hasNext()) {
                    CatchFault catchFault = (CatchFault)catchFaultIterator.next();
                    Validator.validateCatchFault(catchFault, pcPair);
                }
            }
            if ((catchAll = faultHandlers.getCatchAll()) != null) {
                Validator.validateCatchAll(catchAll, pcPair);
            }
        }
        if (scope.getCompensationHandler() != null) {
            Validator.validateCompensationHandler(scope.getCompensationHandler(), pcPair);
        }
        if (errors.size() > 0) {
            validationErrors.put(scope, errors);
        }
    }

    private static void validateSequence(Sequence sequence, List errors, String name, ParentChildPair pcPair) {
        if (sequence.getActivities() == null || sequence.getActivities().size() == 0) {
            errors.add("Sequence activity " + name + " must contain at least one activity");
        } else {
            Iterator activities = sequence.getActivities().iterator();
            while (activities.hasNext()) {
                Activity activity = (Activity)activities.next();
                Validator.validateActivity(activity, new ParentChildPair(pcPair, sequence));
            }
        }
        if (errors.size() > 0) {
            validationErrors.put(sequence, errors);
        }
    }

    private static void validateSwitch(SwitchBlock switchBlock, List errors, String name, ParentChildPair pcPair) {
        if (switchBlock.getCaseClauses() == null || switchBlock.getCaseClauses().size() == 0) {
            errors.add("Switch activity " + name + " must contain at least one case clause");
        } else {
            Iterator caseClauses = switchBlock.getCaseClauses().iterator();
            while (caseClauses.hasNext()) {
                CaseClause caseClause = (CaseClause)caseClauses.next();
                if (caseClause.getCondition() == null || caseClause.getCondition().length() == 0) {
                    errors.add("Case clause of switch " + name + " is does not have a condition");
                }
                if (caseClause.getActivity() == null) {
                    errors.add("Case clause of switch " + name + " is does not have an activity");
                    continue;
                }
                Validator.validateActivity(caseClause.getActivity(), new ParentChildPair(pcPair, switchBlock));
            }
        }
        if (switchBlock.getOtherwise() != null) {
            if (switchBlock.getOtherwise().getActivity() == null) {
                errors.add("Otherwise clause of switch " + name + " is does not have an activity");
            } else {
                Validator.validateActivity(switchBlock.getOtherwise().getActivity(), new ParentChildPair(pcPair, switchBlock));
            }
        }
        if (errors.size() > 0) {
            validationErrors.put(switchBlock, errors);
        }
    }

    private static void validateThrow(Throw thro, List errors, String name, ParentChildPair pcPair) {
        if (thro.getFaultName() == null) {
            errors.add(new String("Throw activity " + name + " does not have a fault name specified"));
        }
        if (errors.size() > 0) {
            validationErrors.put(thro, errors);
        }
    }

    private static void validateVariable(Variable variable) {
        if (variable.getName() == null || variable.getName().length() == 0) {
            LinkedList<String> errors = new LinkedList<String>();
            errors.add("Process defined an unnamed variable");
            if (errors.size() > 0) {
                validationErrors.put(variable, errors);
            }
        }
    }

    private static void validateWait(Wait wait, List errors, String name) {
        if (!(wait.getForExpr() != null && wait.getForExpr().length() != 0 || wait.getUntil() != null && wait.getUntil().length() != 0)) {
            errors.add(new String("Wait activity " + name + " must specify a " + "for expression or an until expression"));
        }
        if (errors.size() > 0) {
            validationErrors.put(wait, errors);
        }
    }

    private static void validateWhile(While whil, List errors, String name, ParentChildPair pcPair) {
        if (whil.getActivity() != null) {
            Validator.validateActivity(whil.getActivity(), new ParentChildPair(pcPair, whil));
        } else {
            errors.add(new String("While activity " + name + " does not contain any activity"));
        }
        if (whil.getCondition() == null || whil.getCondition().length() == 0) {
            errors.add(new String("While activity " + name + " does not specify a condition"));
        }
        if (errors.size() > 0) {
            validationErrors.put(whil, errors);
        }
    }
}

