/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.bpws.model.Activity;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.Condition;
import com.ibm.cs.bpws.runtime.Constants;
import com.ibm.cs.bpws.runtime.Monitor;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.VariableRT;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import com.ibm.cs.bpws.runtime.events.LifecycleListener;
import com.ibm.cs.bpws.runtime.events.LinkEvent;
import com.ibm.cs.bpws.runtime.events.LinkListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ActivityRT
implements LinkListener,
Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    public static final int TYPE_ASSIGN = 1;
    public static final int TYPE_BPWSPROCESS = 2;
    public static final int TYPE_COMPENSATE = 3;
    public static final int TYPE_EMPTY = 4;
    public static final int TYPE_FLOW = 5;
    public static final int TYPE_INVOKE = 6;
    public static final int TYPE_PICK = 7;
    public static final int TYPE_THROW = 8;
    public static final int TYPE_RECEIVE = 9;
    public static final int TYPE_REPLY = 10;
    public static final int TYPE_SCOPE = 11;
    public static final int TYPE_SEQUENCE = 12;
    public static final int TYPE_SWITCH = 13;
    public static final int TYPE_TERMINATE = 14;
    public static final int TYPE_WAIT = 15;
    public static final int TYPE_WHILE = 16;
    public static final int STATUS_DEFAULT = 0;
    public static final int STATUS_DISABLED = 1;
    public static final int STATUS_ACTIVATED = 2;
    public static final int STATUS_ENABLED = 3;
    public static final int STATUS_RUNNING = 4;
    public static final int STATUS_COMPLETED = 5;
    public static final Integer LINK_DEFAULT = new Integer(0);
    public static final Integer LINK_TRUE = new Integer(1);
    public static final Integer LINK_FALSE = new Integer(2);
    protected String name;
    protected ScopeRT scope;
    protected ActivityRT parentActivity;
    protected Activity activityModel;
    protected List lifecycleListeners = new LinkedList();
    private Condition joinCondition;
    private Map incomingLinkTable = new HashMap();
    private Map outgoingLinkTable = new HashMap();
    private int receivedLinkCount = 0;
    protected int status;
    protected boolean joinSatisfied = true;

    public ActivityRT(String name, ScopeRT scope, ActivityRT parentActivity) {
        this.scope = scope;
        this.name = name;
        this.parentActivity = parentActivity;
        this.status = 0;
    }

    public void activate() throws BPWSRuntimeException {
        if (this.status == 0) {
            this.fireLifecycleEvent(2);
            if (this.incomingLinkTable.size() == 0) {
                this.enable();
            } else if (this.receivedLinkCount == this.incomingLinkTable.size() && !this.scope.isExiting()) {
                this.checkIfLinksSatisfied();
            }
        } else {
            throw new BPWSRuntimeException("trying to activate an activity that is not in the default status");
        }
    }

    public void addAsSourceForLink(String linkName, Condition transitionCondition) {
        this.outgoingLinkTable.put(linkName, transitionCondition);
    }

    public void addAsTargetToLink(String linkName, ActivityRT source) throws BPWSRuntimeException {
        this.joinSatisfied = false;
        this.incomingLinkTable.put(linkName, LINK_DEFAULT);
        LinkEvent linkEventTemplate = new LinkEvent(linkName, false, null, source);
        if (source.getScope() == null) {
            ((ScopeRT)source).getEventChannel().addListener(this, linkEventTemplate);
        } else {
            source.getScope().getEventChannel().addListener(this, linkEventTemplate);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void addMonitor(Monitor monitor) {
        this.lifecycleListeners.add(0, monitor);
    }

    private void checkIfLinksSatisfied() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("about to check links: incoming = " + this.receivedLinkCount + " and name is " + this.name));
        if (this.joinCondition != null) {
            this.joinSatisfied = this.joinCondition.evaluate();
        } else {
            this.joinSatisfied = false;
            Iterator linkNames = this.incomingLinkTable.keySet().iterator();
            while (linkNames.hasNext()) {
                String linkName = (String)linkNames.next();
                if (this.incomingLinkTable.get(linkName) != null && !this.incomingLinkTable.get(linkName).equals(LINK_TRUE)) continue;
                this.joinSatisfied = true;
            }
        }
        if (this.joinSatisfied) {
            this.enable();
        } else {
            runtimeLogger.debug((Object)(String.valueOf(this.name) + " about to fire join fault"));
            FaultEvent faultEvent = new FaultEvent(this, Constants.JOIN_FAULT_QNAME, null);
            this.fireFaultEvent(faultEvent);
        }
    }

    protected void complete() throws BPWSRuntimeException {
        if (this.status != 4) {
            throw new BPWSRuntimeException("trying to complete an activity that is not running");
        }
        this.resetState();
        this.fireLifecycleEvent(5);
        this.fireLinks(true);
    }

    public void disable() throws BPWSRuntimeException {
        this.resetState();
        this.fireLifecycleEvent(1);
        this.fireLinks(false);
    }

    protected void enable() throws BPWSRuntimeException {
        if (this.status != 2) {
            throw new BPWSRuntimeException("trying to enable an activity that is not activated");
        }
        this.fireLifecycleEvent(3);
    }

    protected void fireFaultEvent(FaultEvent event) throws BPWSRuntimeException {
        if (this.status == 1) {
            return;
        }
        this.disable();
        if (this.scope == null) {
            throw new BPWSRuntimeException("No registered handler for fault " + event.getName() + " carried as event " + event);
        }
        this.scope.getEventChannel().processEvent(event);
    }

    protected void fireLifecycleEvent(int status) throws BPWSRuntimeException {
        this.status = status;
        LifecycleEvent lifecycleEvent = new LifecycleEvent(this, status);
        Iterator listeners = this.lifecycleListeners.iterator();
        while (listeners.hasNext()) {
            LifecycleListener listener = (LifecycleListener)listeners.next();
            switch (status) {
                case 1: {
                    listener.activityDisabled(lifecycleEvent);
                    break;
                }
                case 3: {
                    listener.activityEnabled(lifecycleEvent);
                    break;
                }
                case 2: {
                    listener.activityActivated(lifecycleEvent);
                    break;
                }
                case 4: {
                    listener.activityRunning(lifecycleEvent);
                    break;
                }
                case 5: {
                    listener.activityCompleted(lifecycleEvent);
                    break;
                }
                case 0: {
                    listener.activityRevived(lifecycleEvent);
                    break;
                }
            }
        }
    }

    protected void fireLinkEvent(LinkEvent event) throws BPWSRuntimeException {
        runtimeLogger.assertLog(this.scope != null, "Activity with null scope tried to fire a link event");
        this.scope.getEventChannel().processEvent(event);
    }

    protected void fireLinks(boolean normalCompletion) throws BPWSRuntimeException {
        if (this.outgoingLinkTable.size() != 0) {
            runtimeLogger.debug((Object)("about to fire links of activity " + this.name));
        }
        Iterator outgoingLinkList = this.outgoingLinkTable.keySet().iterator();
        while (outgoingLinkList.hasNext()) {
            String linkName = (String)outgoingLinkList.next();
            LinkEvent linkEvent = null;
            if (normalCompletion) {
                runtimeLogger.debug((Object)("evaluating condition for link " + linkName));
                Condition transitionCondition = (Condition)this.outgoingLinkTable.get(linkName);
                linkEvent = new LinkEvent(linkName, transitionCondition.evaluate(), null, this);
            } else {
                linkEvent = new LinkEvent(linkName, false, null, this);
            }
            runtimeLogger.debug((Object)("about to fire link event " + linkEvent.getLinkName() + linkEvent.linkWasActivated()));
            this.fireLinkEvent(linkEvent);
        }
    }

    public Integer getIncomingLinkStatus(String linkName) {
        runtimeLogger.debug((Object)("Getting status of the link " + linkName + " found: " + (Integer)this.incomingLinkTable.get(linkName)));
        return (Integer)this.incomingLinkTable.get(linkName);
    }

    public Condition getJoinCondition() {
        return this.joinCondition;
    }

    public String getName() {
        return this.name;
    }

    public ScopeRT getScope() {
        return this.scope;
    }

    public int getStatus() {
        return this.status;
    }

    public abstract int getType();

    public VariableRT getVariable(String variableName) {
        return this.scope.getVariable(variableName);
    }

    protected void go() throws BPWSRuntimeException {
        if (this.status != 3) {
            throw new BPWSRuntimeException("Cannot run an activity that is not yet enabled");
        }
        this.fireLifecycleEvent(4);
    }

    public void linkActivated(LinkEvent event) throws BPWSRuntimeException {
        if (this.scope == null) {
            throw new BPWSRuntimeException("trying to activate a link on the choreo");
        }
        if (this.status == 1 || this.status == 5 || this.scope.isExiting()) {
            return;
        }
        String linkName = event.getLinkName();
        Integer linkState = (Integer)this.incomingLinkTable.get(linkName);
        runtimeLogger.debug((Object)("activity " + this.name + "link activated " + linkName));
        runtimeLogger.assertLog(linkState != null, "Activity " + this.name + " was informed of a link activated event for link " + linkName + " which it doesn't care about");
        this.incomingLinkTable.put(linkName, LINK_TRUE);
        ++this.receivedLinkCount;
        if (this.receivedLinkCount == this.incomingLinkTable.size() && this.status == 2) {
            this.checkIfLinksSatisfied();
        }
    }

    public void linkDeactivated(LinkEvent event) throws BPWSRuntimeException {
        if (this.scope == null) {
            throw new BPWSRuntimeException("trying to deactivate a link on the choreo");
        }
        if (this.status == 1 || this.status == 5 || this.scope.isExiting()) {
            return;
        }
        String linkName = event.getLinkName();
        Integer linkState = (Integer)this.incomingLinkTable.get(linkName);
        runtimeLogger.debug((Object)("link deactivated " + linkName));
        runtimeLogger.assertLog(linkState != null, "Activity " + this.name + " was informed of a link deactivated event for " + "link " + linkName + " which it doesn't care about");
        this.incomingLinkTable.put(linkName, LINK_FALSE);
        ++this.receivedLinkCount;
        if (this.receivedLinkCount == this.incomingLinkTable.size() && this.status == 2) {
            this.checkIfLinksSatisfied();
        }
    }

    public void resetState() {
        if (this.incomingLinkTable.size() > 0) {
            this.joinSatisfied = false;
            Iterator linkNames = this.incomingLinkTable.keySet().iterator();
            while (linkNames.hasNext()) {
                String key = (String)linkNames.next();
                this.incomingLinkTable.put(key, LINK_DEFAULT);
            }
        }
        this.receivedLinkCount = 0;
    }

    public void revive() throws BPWSRuntimeException {
        this.fireLifecycleEvent(0);
    }

    public void setActivityModel(Activity model) {
        this.activityModel = model;
    }

    public void setJoinCondition(Condition joinCondition) {
        this.joinCondition = joinCondition;
    }

    public void setJoinSatisfied(boolean state) {
        this.joinSatisfied = state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Activity ").append(this.name);
        if (this.parentActivity == null) {
            sb.append(" with no parent");
        } else {
            sb.append(" with parent named ").append(this.parentActivity.getName());
        }
        if (this.scope == null) {
            sb.append(" and no enclosing scope");
        } else {
            sb.append(" and enclosing scope named ").append(this.scope.getName());
        }
        return sb.toString();
    }
}

