/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.bpws.model.Activity;
import com.ibm.bpws.model.Assign;
import com.ibm.bpws.model.Copy;
import com.ibm.bpws.model.From;
import com.ibm.bpws.model.To;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.VariableRT;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.jrom.JROMValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;

public class AssignRT
extends ActivityRT
implements Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    BPWSProcessRT bpwsProcessRT;
    List copies;
    int numCopiesProcessed = 0;
    int numIterations = 0;
    Map copyValueTable = new HashMap();

    public AssignRT(String name, ScopeRT scope, ActivityRT parent, BPWSProcessRT bpwsProcessRT) {
        super(name, scope, parent);
        this.bpwsProcessRT = bpwsProcessRT;
    }

    public void complete() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("assign " + this.name + " completing and setting all values"));
        Iterator copiesIter = this.copies.iterator();
        while (copiesIter.hasNext()) {
            AssignInfo info = (AssignInfo)this.copyValueTable.get(copiesIter.next());
            To to = info.copy.getTo();
            Object value = info.value;
            VariableRT toVariable = this.getVariable(to.getVariable().getName());
            if (value instanceof JROMValue) {
                JROMValue val = (JROMValue)value;
                val.setNameLocalPart(to.getPart());
                WSIFMessage variableMessage = toVariable.getMessage();
                try {
                    variableMessage.setObjectPart(to.getPart(), (Object)val);
                }
                catch (WSIFException exception) {
                    runtimeLogger.error((Object)"Exception while setting message part ", (Throwable)exception);
                }
                continue;
            }
            if (!(value instanceof WSIFMessage)) continue;
            toVariable.setMessage((WSIFMessage)value);
        }
        runtimeLogger.debug((Object)("assign " + this.name + " completing"));
        super.complete();
    }

    public int getType() {
        return 1;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Assign " + this.name + " is running"));
        ++this.numIterations;
        Iterator copiesIter = this.copies.iterator();
        while (copiesIter.hasNext()) {
            Copy copy = (Copy)copiesIter.next();
            From from = copy.getFrom();
            To to = copy.getTo();
            this.bpwsProcessRT.getValueToAssign(new AssignInfo(copy, this.numIterations), from, to, this);
        }
    }

    public void resetState() {
        super.resetState();
        this.numCopiesProcessed = 0;
        this.numIterations = 0;
        this.copyValueTable.clear();
    }

    public void setActivityModel(Activity model) {
        super.setActivityModel(model);
        this.copies = ((Assign)model).getCopies();
    }

    public void setCopies(List copies) {
        this.copies = copies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object clientData, Object value) throws BPWSRuntimeException {
        AssignInfo info = (AssignInfo)clientData;
        if (this.status != 4 || info.numIterations != this.numIterations) {
            return;
        }
        if (value instanceof Exception) {
            if (!(value instanceof BPWSRuntimeException)) throw new BPWSRuntimeException("Assignment could not be completed ", (Exception)value);
            BPWSRuntimeException exc = (BPWSRuntimeException)value;
            this.fireFaultEvent(new FaultEvent(this, exc.getFaultQName(), null));
            return;
        } else {
            info.value = value;
            this.copyValueTable.put(info.copy, info);
            ++this.numCopiesProcessed;
            if (this.numCopiesProcessed != this.copies.size()) return;
            this.complete();
        }
    }

    public class AssignInfo {
        Copy copy;
        Object value;
        int numIterations;

        public AssignInfo(Copy copy, int numIterations) {
            this.copy = copy;
            this.numIterations = numIterations;
        }
    }
}

