/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.bpws.model.BPWSProcess;
import com.ibm.bpws.model.From;
import com.ibm.bpws.model.To;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.AssignRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.InvokeRT;
import com.ibm.cs.bpws.runtime.PartnerRT;
import com.ibm.cs.bpws.runtime.PickRT;
import com.ibm.cs.bpws.runtime.ReplyRT;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.WaitRT;
import com.ibm.cs.bpws.runtime.bus.AssignValueHandler;
import com.ibm.cs.bpws.runtime.bus.InvocationCompletionHandler;
import com.ibm.cs.bpws.runtime.container.BPWSManager;
import com.ibm.cs.bpws.runtime.events.AlarmEvent;
import com.ibm.cs.bpws.runtime.events.AssignmentValueReadyEvent;
import com.ibm.cs.bpws.runtime.events.BPWSEvent;
import com.ibm.cs.bpws.runtime.events.CompensationHandledEvent;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.runtime.events.InvocationCompletedEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveEvent;
import com.ibm.cs.bpws.util.alarm.AlarmHandler;
import com.ibm.cs.bpws.util.xpath.XPathFunctions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.wsif.WSIFMessage;

public class BPWSProcessRT
extends ScopeRT
implements Runnable,
InvocationCompletionHandler,
AssignValueHandler,
AlarmHandler,
Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    String targetNamespace;
    Map partnerMap = new HashMap();
    Map pendingInvokes = new HashMap();
    Map pendingAssigns = new HashMap();
    Map pendingAlarms = new HashMap();
    Map scopeMap = new HashMap();
    LinkedList eventQueue = new LinkedList();
    boolean done = false;
    transient Thread serviceThread;
    transient BPWSManager flowMgr;
    QName faultQName = null;
    WSIFMessage faultMessage = null;
    BPWSProcess bpwsProcessModel;

    public BPWSProcessRT(String targetNamespace, String name) {
        super(name, null, null, null);
        this.targetNamespace = targetNamespace;
    }

    public void addPartner(PartnerRT partner) {
        this.partnerMap.put(partner.getName(), partner);
    }

    public void addScopeToMap(ScopeRT scopeToBeCompensated) throws BPWSRuntimeException {
        if (scopeToBeCompensated.name == null) {
            throw new BPWSRuntimeException(" Scopes that have a compensation handler must be named");
        }
        this.scopeMap.put(scopeToBeCompensated.name, scopeToBeCompensated);
    }

    public void alarmRinging(Object clientData) {
        this.deliverEvent(new AlarmEvent(clientData));
    }

    public void assignmentValueReady(Object clientData, Object value) {
        this.deliverEvent(new AssignmentValueReadyEvent(clientData, value));
    }

    public void cancelAlarm(Object clientData) {
        this.pendingAlarms.remove(clientData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compensateScope(String scopeName) throws BPWSRuntimeException {
        if (scopeName != this.name) {
            ScopeRT scopeToComp = (ScopeRT)this.scopeMap.get(scopeName);
            if (scopeToComp == null) throw new BPWSRuntimeException("No scope of name " + scopeName + " found to be compensated");
            scopeToComp.runCompensationHandler();
            return;
        } else {
            this.runCompensationHandler();
        }
    }

    protected void complete() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Process " + this.name + " completing"));
        super.complete();
        this.requestsNotHandled(this.eventChannel.getPendingReceiveEvents());
        this.requestsNotHandled(this.eventChannel.getConsumedReceiveEvents());
        this.done = true;
        BPWSProcessRT bPWSProcessRT = this;
        synchronized (bPWSProcessRT) {
            this.notifyAll();
        }
    }

    public void completeAfterFault() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Process " + this.name + " completing"));
        super.completeAfterFault();
        this.requestsNotHandled(this.eventChannel.getPendingReceiveEvents());
        this.requestsNotHandled(this.eventChannel.getConsumedReceiveEvents());
        this.done = true;
        BPWSProcessRT bPWSProcessRT = this;
        synchronized (bPWSProcessRT) {
            this.notifyAll();
        }
    }

    public void deliverCompensationHandledEvent(CompensationHandledEvent event) {
        this.deliverEvent(event);
    }

    public void deliverEvent(BPWSEvent event) {
        BPWSProcessRT bPWSProcessRT = this;
        synchronized (bPWSProcessRT) {
            this.eventQueue.addLast(event);
            this.notifyAll();
        }
    }

    public void deregisterCorrelationInformation(Object modelObj) throws BPWSRuntimeException {
        this.flowMgr.deregisterCorrelationInformation(this, modelObj);
    }

    public void disable() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("disabling Process " + this.name));
        super.disable();
        this.requestsAborted(this.eventChannel.getPendingReceiveEvents());
        this.requestsNotHandled(this.eventChannel.getConsumedReceiveEvents());
        this.done = true;
        BPWSProcessRT bPWSProcessRT = this;
        synchronized (bPWSProcessRT) {
            this.notifyAll();
        }
    }

    protected void fireFaultEvent(FaultEvent event) throws BPWSRuntimeException {
        this.disable();
        this.faultMessage = event.getMessage();
        this.faultQName = event.getName();
        this.done = true;
        BPWSProcessRT bPWSProcessRT = this;
        synchronized (bPWSProcessRT) {
            this.notifyAll();
        }
    }

    public PartnerRT getPartner(String partnerName) {
        return (PartnerRT)this.partnerMap.get(partnerName);
    }

    public int getType() {
        return 2;
    }

    public void getValueToAssign(Object clientData, From from, To to, AssignRT assignAct) {
        this.pendingAssigns.put(clientData, assignAct);
        this.flowMgr.getValueToAssign(from, to, assignAct, this, clientData);
    }

    public void invocationCompleted(Object clientData, WSIFMessage message, boolean isFault) {
        this.deliverEvent(new InvocationCompletedEvent(clientData, message, isFault));
    }

    public void invoke(Object clientData, InvokeRT invocationSource, String partnerName, QName portType, String operationName, WSIFMessage inputMessage) {
        runtimeLogger.debug((Object)("Process " + this.name + " received an invocation request"));
        PartnerRT partner = (PartnerRT)this.partnerMap.get(partnerName);
        if (partner.serviceRef == null) {
            partner.serviceRef = this.flowMgr.resolvePartnerServiceReference(this, partnerName);
        }
        this.flowMgr.invoke(partner.serviceRef, portType, operationName, inputMessage, this, clientData);
        this.pendingInvokes.put(clientData, invocationSource);
    }

    private void processAlarmEvent(AlarmEvent ev) throws BPWSRuntimeException {
        ActivityRT activity = (ActivityRT)this.pendingAlarms.remove(ev.clientData);
        runtimeLogger.debug((Object)("Processing alarm event meant for " + activity));
        if (activity != null) {
            if (activity.getType() == 7) {
                ((PickRT)activity).alarmReceived(ev.clientData);
            } else if (activity.getType() == 11 || activity.getType() == 2) {
                ((ScopeRT)activity).alarmReceived(ev.clientData);
            } else if (activity.getType() == 15) {
                ((WaitRT)activity).alarmReceived(ev.clientData);
            }
        } else {
            runtimeLogger.warn((Object)"alarm has been cancelled");
        }
    }

    private void processAssignmentValueReadyEvent(AssignmentValueReadyEvent ev) throws BPWSRuntimeException {
        AssignRT assign = (AssignRT)this.pendingAssigns.remove(ev.clientData);
        if (assign == null) {
            throw new BPWSRuntimeException("BPWSProcessRT:no pending assign ");
        }
        assign.setValue(ev.clientData, ev.value);
    }

    private void processInvocationCompletedEvent(InvocationCompletedEvent ev) throws BPWSRuntimeException {
        InvokeRT invokeToReplyTo = (InvokeRT)this.pendingInvokes.remove(ev.clientData);
        if (invokeToReplyTo == null) {
            throw new BPWSRuntimeException("BPWSProcessRT: invocationReturned: BPWSProcess does not have a pending invoke corresponding to this event: " + ev);
        }
        invokeToReplyTo.invocationReturned(ev.message, ev.isFault, ev.clientData);
    }

    public void registerCorrelationInformation(Object modelObj, WSIFMessage wsifmsg, boolean incoming) throws BPWSRuntimeException {
        this.flowMgr.registerCorrelationInformation(this, modelObj, wsifmsg, incoming);
    }

    public void reply(ReplyRT source, String partnerName, QName portTypeName, String operationName, QName faultName, WSIFMessage replyMsg, WSIFMessage correlationSet) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Process " + this.name + " received a reply request" + replyMsg));
        ReceiveEvent matchingReceive = this.eventChannel.getWaitingReceive(partnerName, portTypeName, operationName);
        if (matchingReceive == null) {
            runtimeLogger.warn((Object)"Reply called, but no matching receive found");
            throw new BPWSRuntimeException("BPWSProcessRT:reply: no matching receive found");
        }
        runtimeLogger.debug((Object)"found matching receive");
        Object receiveClientData = matchingReceive.getReceiveClientData();
        this.flowMgr.reply(receiveClientData, replyMsg, faultName, correlationSet);
        source.replyCompleted(true);
    }

    public void requestsAborted(Iterator abortedReceiveEvents) {
        while (abortedReceiveEvents.hasNext()) {
            ReceiveEvent event = (ReceiveEvent)abortedReceiveEvents.next();
            this.flowMgr.requestAborted(event.getReceiveClientData());
        }
    }

    public void requestsNotHandled(Iterator unhandledReceiveEvents) {
        while (unhandledReceiveEvents.hasNext()) {
            ReceiveEvent event = (ReceiveEvent)unhandledReceiveEvents.next();
            this.flowMgr.requestNotHandled(event.getReceiveClientData());
        }
    }

    protected void resetReceiveEventQueue() {
        Iterator iter = this.receiveEventQueue.iterator();
        this.requestsAborted(iter);
        this.receiveEventQueue.clear();
    }

    public void run() {
        try {
            this.activate();
            this.go();
            while (!this.done && this.status != 1) {
                runtimeLogger.debug((Object)("Process " + this.name + " running; waiting for event"));
                BPWSEvent event = null;
                BPWSProcessRT bPWSProcessRT = this;
                synchronized (bPWSProcessRT) {
                    if (this.eventQueue.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    event = (BPWSEvent)this.eventQueue.removeFirst();
                }
                runtimeLogger.debug((Object)("Processing event: " + event));
                if (event instanceof InvocationCompletedEvent) {
                    this.processInvocationCompletedEvent((InvocationCompletedEvent)event);
                    continue;
                }
                if (event instanceof AssignmentValueReadyEvent) {
                    this.processAssignmentValueReadyEvent((AssignmentValueReadyEvent)event);
                    continue;
                }
                if (event instanceof AlarmEvent) {
                    this.processAlarmEvent((AlarmEvent)event);
                    continue;
                }
                this.eventChannel.processEvent(event);
            }
        }
        catch (Exception e) {
            runtimeLogger.error((Object)("BPWSProcess " + this.name + " exiting due to exception"), (Throwable)e);
            this.flowMgr.bpwsProcessRTExited(this, null, null, e);
            return;
        }
        this.flowMgr.bpwsProcessRTExited(this, this.faultQName, this.faultMessage, null);
        if (this.faultQName == null) {
            runtimeLogger.debug((Object)("Process " + this.name + " exiting"));
        } else {
            runtimeLogger.debug((Object)("Process " + this.name + " exiting with fault " + this.faultQName));
        }
    }

    public void setAlarm(Object clientData, ActivityRT alarmSource, String forExp) throws BPWSRuntimeException {
        String durationString;
        this.pendingAlarms.put(clientData, alarmSource);
        try {
            durationString = XPathFunctions.evalToString(alarmSource, forExp);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BPWSRuntimeException("xpath failed to get duration string", e);
        }
        runtimeLogger.debug((Object)("process setting alarm to " + durationString));
        this.flowMgr.setAlarm(durationString, this, clientData);
    }

    public void setBPWSManager(BPWSManager flowMgr) {
        this.flowMgr = flowMgr;
    }

    public void setBPWSProcessModel(BPWSProcess bpwsProcess) {
        this.bpwsProcessModel = bpwsProcess;
    }

    public void start() {
        this.serviceThread = new Thread(this);
        this.serviceThread.start();
    }

    public void terminate() {
        runtimeLogger.debug((Object)("Process " + this.name + " exiting"));
        this.requestsAborted(this.eventChannel.getPendingReceiveEvents());
        this.requestsNotHandled(this.eventChannel.getConsumedReceiveEvents());
        this.done = true;
        BPWSProcessRT bPWSProcessRT = this;
        synchronized (bPWSProcessRT) {
            this.notifyAll();
        }
    }
}

