/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.CompoundActivityRT;
import com.ibm.cs.bpws.runtime.Debug;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.events.BPWSEvent;
import com.ibm.cs.bpws.runtime.events.BPWSEventListener;
import com.ibm.cs.bpws.runtime.events.EventChannel;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.runtime.events.FaultListener;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import com.ibm.cs.bpws.runtime.events.LifecycleListener;
import com.ibm.cs.bpws.runtime.events.LinkEvent;
import com.ibm.cs.bpws.runtime.events.LinkListener;
import com.ibm.cs.bpws.runtime.events.ReplyEvent;
import com.ibm.cs.bpws.runtime.events.ReplyListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Monitor
implements LifecycleListener,
ReplyListener,
FaultListener,
LinkListener,
Runnable,
Serializable {
    private BPWSProcessRT choreography;
    private EventChannel eventChannel = new EventChannel();
    private boolean choreographyDone = false;
    private transient Thread monitorThread;
    public List eventQueue = new LinkedList();

    public Monitor(BPWSProcessRT choreography) {
        this.choreography = choreography;
        this.listenToActivity(choreography);
        this.monitorThread = new Thread(this);
        this.monitorThread.start();
    }

    public void activityActivated(LifecycleEvent event) {
        this.publishEvent(event);
    }

    public void activityCompleted(LifecycleEvent event) throws BPWSRuntimeException {
        if (event.getSource().equals(this.choreography)) {
            this.choreographyDone = true;
        }
        this.publishEvent(event);
    }

    public void activityDisabled(LifecycleEvent event) {
        this.publishEvent(event);
    }

    public void activityEnabled(LifecycleEvent event) throws BPWSRuntimeException {
        this.publishEvent(event);
    }

    public void activityRevived(LifecycleEvent event) throws BPWSRuntimeException {
    }

    public void activityRunning(LifecycleEvent event) {
        this.publishEvent(event);
    }

    public void addListener(BPWSEventListener listener) throws BPWSRuntimeException {
        this.eventChannel.addListener(listener);
    }

    public void addListener(BPWSEventListener listener, BPWSEvent eventTemplate) throws BPWSRuntimeException {
        this.eventChannel.addListener(listener, eventTemplate);
    }

    public void faultThrown(FaultEvent event) throws BPWSRuntimeException {
        this.publishEvent(event);
    }

    public void linkActivated(LinkEvent event) {
        this.publishEvent(event);
    }

    public void linkDeactivated(LinkEvent event) {
        this.publishEvent(event);
    }

    public void listenToActivity(ActivityRT activity) {
        activity.addMonitor(this);
        if (activity instanceof ScopeRT) {
            ((ScopeRT)activity).getEventChannel().addMonitor(this);
        }
        if (activity instanceof CompoundActivityRT) {
            List children = ((CompoundActivityRT)activity).getChildren();
            Iterator childrenIt = children.iterator();
            while (childrenIt.hasNext()) {
                ActivityRT child = (ActivityRT)childrenIt.next();
                this.listenToActivity(child);
            }
        }
    }

    private void publishEvent(BPWSEvent event) {
        Debug.info("Monitoring>> " + event + "\n", 1);
        Monitor monitor = this;
        synchronized (monitor) {
            Debug.info("Monitor adding event " + event + " to queue");
            this.eventQueue.add(event);
            this.notifyAll();
        }
    }

    public void replyRequested(ReplyEvent event) {
        this.publishEvent(event);
    }

    public void run() {
        while (!this.choreographyDone || this.eventQueue.size() > 0) {
            BPWSEvent event = null;
            Monitor monitor = this;
            synchronized (monitor) {
                if (this.eventQueue.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                event = (BPWSEvent)this.eventQueue.get(0);
                this.eventQueue.remove(event);
            }
            try {
                if (event == null) continue;
                this.eventChannel.processEvent(event);
            }
            catch (BPWSRuntimeException exception) {
                Debug.error(exception.toString(), 10);
                exception.printStackTrace();
            }
        }
    }
}

