/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.bpws.model.OnMessage;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.CompoundActivityRT;
import com.ibm.cs.bpws.runtime.Constants;
import com.ibm.cs.bpws.runtime.HandlerInfo;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.VariableRT;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveListener;
import com.ibm.cs.bpws.util.IntTuple;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class PickRT
extends CompoundActivityRT
implements ReceiveListener,
Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    protected Hashtable messageHandlers = new Hashtable();
    protected ActivityRT alarmHandler;
    protected String alarmForOrUntil;
    protected LinkedList myEventTemplates = new LinkedList();
    protected ActivityRT runningChild;
    protected BPWSProcessRT bpwsProcess;
    private int myID = -1;
    private int numIterations = 0;
    private IntTuple alarmCorrelationInfo = new IntTuple(0, 0);

    public PickRT(String name, ScopeRT scope, ActivityRT parentActivity, BPWSProcessRT bpwsProcess) {
        super(name, scope, parentActivity);
        this.bpwsProcess = bpwsProcess;
    }

    public void activityCompleted(LifecycleEvent event) throws BPWSRuntimeException {
        if (event.getSource() == this.runningChild) {
            this.complete();
        }
    }

    public void activityEnabled(LifecycleEvent event) throws BPWSRuntimeException {
        if (event.getSource() == this.runningChild) {
            this.runningChild.go();
        }
    }

    public void addAlarmHandler(String forOrUntil, ActivityRT activity) throws BPWSRuntimeException {
        this.alarmForOrUntil = forOrUntil;
        this.alarmHandler = activity;
        activity.addLifecycleListener(this);
        this.children.add(activity);
    }

    public void addMessageHandler(String partnerName, QName portType, String operationName, OnMessage onMessage, ActivityRT activity, String messageVariableName) {
        HandlerInfo handler = new HandlerInfo(activity, messageVariableName);
        handler.setOnMessage(onMessage);
        String hashKey = String.valueOf(partnerName) + portType.toString() + operationName;
        this.messageHandlers.put(hashKey, handler);
        this.myEventTemplates.add(new ReceiveEvent(null, null, null, partnerName, portType, operationName));
        activity.addLifecycleListener(this);
        this.children.add(activity);
    }

    public void alarmReceived(Object clientData) throws BPWSRuntimeException {
        if (this.status != 4 || this.runningChild != null || !this.alarmCorrelationInfo.equals(clientData)) {
            return;
        }
        this.bpwsProcess.getEventChannel().removeReceiveListener(this);
        this.runningChild = this.alarmHandler;
        this.runningChild.activate();
    }

    public void fireConflictingReceiveFault() throws BPWSRuntimeException {
        FaultEvent event = new FaultEvent(this, Constants.CONFLICTING_RECEIVE_FAULT_QNAME, null);
        this.fireFaultEvent(event);
    }

    public void fireConflictingRequestFault() throws BPWSRuntimeException {
        FaultEvent event = new FaultEvent(this, Constants.CONFLICTING_REQUEST_FAULT_QNAME, null);
        this.fireFaultEvent(event);
    }

    public int getID() {
        if (this.myID == -1) {
            this.myID = this.hashCode();
        }
        return this.myID;
    }

    public int getType() {
        return 7;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Pick " + this.name + " is running"));
        ++this.numIterations;
        if (this.alarmHandler != null) {
            this.alarmCorrelationInfo.id1 = this.getID();
            this.alarmCorrelationInfo.id2 = this.numIterations;
            this.bpwsProcess.setAlarm(this.alarmCorrelationInfo, this, this.alarmForOrUntil);
        }
        Iterator receiveTemplates = this.myEventTemplates.iterator();
        ReceiveEvent currTemplate = null;
        while (receiveTemplates.hasNext()) {
            currTemplate = (ReceiveEvent)receiveTemplates.next();
            this.bpwsProcess.getEventChannel().addListener(this, currTemplate);
        }
    }

    public void messageReceived(ReceiveEvent event) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("pick " + this.name + " received message"));
        if (this.status != 3 && this.status != 4 || this.runningChild != null) {
            return;
        }
        this.bpwsProcess.cancelAlarm(this.alarmCorrelationInfo);
        this.bpwsProcess.getEventChannel().removeReceiveListener(this);
        HandlerInfo handler = (HandlerInfo)this.messageHandlers.get(String.valueOf(event.getPartnerName()) + event.getPortTypeName() + event.getOperationName());
        if (handler != null) {
            ActivityRT messageActivity;
            this.bpwsProcess.registerCorrelationInformation(handler.getOnMessage(), event.getMessage(), true);
            VariableRT msgVariable = this.getVariable(handler.variableName);
            if (msgVariable != null) {
                msgVariable.setMessage(event.getMessage());
            }
            this.runningChild = messageActivity = handler.activity;
            this.runningChild.activate();
        }
    }

    public void resetState() {
        if (this.alarmHandler != null && this.runningChild != this.alarmHandler) {
            this.bpwsProcess.cancelAlarm(this.alarmCorrelationInfo);
        }
        this.runningChild = null;
    }
}

