/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSProcessRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.Constants;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.events.FaultEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveEvent;
import com.ibm.cs.bpws.runtime.events.ReceiveListener;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.wsif.WSIFMessage;

public class ReceiveRT
extends ActivityRT
implements ReceiveListener,
Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    String variableName;
    String partnerName;
    QName portTypeName;
    String operationName;
    transient Object clientData;
    private BPWSProcessRT bpwsProcessRT;
    private ReceiveEvent myEventTemplate;
    WSIFMessage savedMsg = null;

    public ReceiveRT(String name, ScopeRT scope, ActivityRT parentActivity, BPWSProcessRT bpwsProcessRT, String partnerName, QName portTypeName, String operationName) {
        super(name, scope, parentActivity);
        this.partnerName = partnerName;
        this.portTypeName = portTypeName;
        this.operationName = operationName;
        this.bpwsProcessRT = bpwsProcessRT;
        this.myEventTemplate = new ReceiveEvent(null, null, null, partnerName, portTypeName, operationName);
    }

    public void disable() throws BPWSRuntimeException {
        if (this.status != 5 || this.status != 1) {
            this.bpwsProcessRT.getEventChannel().removeReceiveListener(this);
        }
        super.disable();
    }

    public void fireConflictingReceiveFault() throws BPWSRuntimeException {
        FaultEvent event = new FaultEvent(this, Constants.CONFLICTING_RECEIVE_FAULT_QNAME, null);
        this.fireFaultEvent(event);
    }

    public void fireConflictingRequestFault() throws BPWSRuntimeException {
        FaultEvent event = new FaultEvent(this, Constants.CONFLICTING_REQUEST_FAULT_QNAME, null);
        this.fireFaultEvent(event);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public Object getReceiveClientData() {
        return this.clientData;
    }

    public int getType() {
        return 9;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Receive " + this.name + " is running"));
        this.bpwsProcessRT.getEventChannel().addListener(this, this.myEventTemplate);
    }

    public void messageReceived(ReceiveEvent event) throws BPWSRuntimeException {
        if (this.status == 1) {
            return;
        }
        runtimeLogger.debug((Object)("<receive> " + this.name + " got a message"));
        this.bpwsProcessRT.getEventChannel().removeReceiveListener(this);
        this.bpwsProcessRT.registerCorrelationInformation(this.activityModel, event.getMessage(), true);
        this.getVariable(this.variableName).setMessage(event.getMessage());
        this.clientData = event.getReceiveClientData();
        runtimeLogger.debug((Object)("Receive " + this.name + " completing"));
        this.complete();
    }

    public void resetClientData() {
        this.clientData = null;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }
}

