/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.CompoundActivityRT;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class SequenceRT
extends CompoundActivityRT
implements Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    private int currChildIdx = -1;

    public SequenceRT(String name, ScopeRT scope, ActivityRT parentActivity) {
        super(name, scope, parentActivity);
    }

    public void activate() throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("Starting sequence " + this.name + " Activity "));
        super.activate();
    }

    public void activityCompleted(LifecycleEvent e) throws BPWSRuntimeException {
        if (this.status == 1) {
            return;
        }
        runtimeLogger.debug((Object)("sequence " + this.name + " heard of end of " + e.getSource().name));
        ActivityRT currActivity = (ActivityRT)this.children.get(this.currChildIdx);
        if (currActivity == e.getSource()) {
            if (this.currChildIdx == this.children.size() - 1) {
                this.complete();
                runtimeLogger.debug((Object)("sequence " + this.name + " done"));
            } else {
                runtimeLogger.debug((Object)("sequence " + this.name + " activity next act starting"));
                ++this.currChildIdx;
                ((ActivityRT)this.children.get(this.currChildIdx)).activate();
            }
        }
    }

    public void activityEnabled(LifecycleEvent e) throws BPWSRuntimeException {
        if (this.status == 1) {
            return;
        }
        runtimeLogger.debug((Object)("Sequence " + this.name + " about to run " + e.getSource().name));
        ActivityRT currActivity = (ActivityRT)this.children.get(this.currChildIdx);
        if (currActivity == e.getSource()) {
            currActivity.go();
        }
    }

    public void addActivity(ActivityRT activity) {
        this.children.add(activity);
        activity.addLifecycleListener(this);
    }

    public int getType() {
        return 12;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Sequence " + this.name + " is running"));
        if (this.currChildIdx != -1) {
            runtimeLogger.warn((Object)("help!! someone tryin to restart the seq " + this.name + " in midflow"));
        } else {
            ++this.currChildIdx;
            ((ActivityRT)this.children.get(this.currChildIdx)).activate();
        }
    }

    public void resetState() {
        super.resetState();
        this.currChildIdx = -1;
    }
}

