/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.CompoundActivityRT;
import com.ibm.cs.bpws.runtime.Condition;
import com.ibm.cs.bpws.runtime.ScopeRT;
import com.ibm.cs.bpws.runtime.events.LifecycleEvent;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class SwitchRT
extends CompoundActivityRT
implements Serializable {
    static Logger runtimeLogger = Logger.getLogger((String)"bpws.runtime.flow");
    static Logger baseLogger = Logger.getLogger((String)"bpws.runtime.flow.base");
    LinkedList conditions = new LinkedList();
    ActivityRT runningChild = null;

    public SwitchRT(String name, ScopeRT scope, ActivityRT parentActivity) {
        super(name, scope, parentActivity);
    }

    public void activityCompleted(LifecycleEvent e) throws BPWSRuntimeException {
        runtimeLogger.debug((Object)("switch " + this.name + " completing"));
        if (e.getSource() == this.runningChild && this.status != 1) {
            this.complete();
        }
    }

    public void activityEnabled(LifecycleEvent e) throws BPWSRuntimeException {
        if (e.getSource() == this.runningChild && this.status != 1) {
            this.runningChild.go();
        }
    }

    public void addConditionAndActivity(Condition cond, ActivityRT act) {
        this.conditions.addLast(cond);
        this.children.addLast(act);
        act.addLifecycleListener(this);
    }

    public void addOtherwiseActivity(ActivityRT otherwiseAct) {
        this.children.addFirst(otherwiseAct);
        otherwiseAct.addLifecycleListener(this);
    }

    public int getType() {
        return 13;
    }

    public void go() throws BPWSRuntimeException {
        super.go();
        baseLogger.debug((Object)("Switch " + this.name + " is running"));
        this.fireLifecycleEvent(4);
        int j = 0;
        int i = 0;
        ActivityRT otherwiseAct = null;
        ActivityRT act = null;
        if (this.conditions.size() < this.children.size()) {
            otherwiseAct = (ActivityRT)this.children.get(0);
        }
        i = 0;
        while (i < this.conditions.size()) {
            Condition condition = (Condition)this.conditions.get(i);
            if (condition.evaluate()) {
                act = otherwiseAct == null ? (ActivityRT)this.children.get(i) : (ActivityRT)this.children.get(i + 1);
                runtimeLogger.debug((Object)("switch " + this.name + " activating child " + act.name));
                this.runningChild = act;
                act.activate();
                return;
            }
            ++i;
        }
        if (i >= this.conditions.size() && otherwiseAct != null) {
            runtimeLogger.debug((Object)("switch " + this.name + " about to run otherwise" + otherwiseAct.getType()));
            this.runningChild = otherwiseAct;
            this.runningChild.activate();
            return;
        }
        this.complete();
    }

    public void resetState() {
        super.resetState();
        this.runningChild = null;
    }
}

