/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime.bus;

import com.ibm.bpws.model.From;
import com.ibm.bpws.model.To;
import com.ibm.cs.bpws.runtime.AssignRT;
import com.ibm.cs.bpws.runtime.bus.AssignValueHandler;
import com.ibm.cs.bpws.runtime.bus.BusRequest;
import com.ibm.cs.bpws.runtime.bus.BusRequestAssign;
import com.ibm.cs.bpws.runtime.bus.BusRequestInvoke;
import com.ibm.cs.bpws.runtime.bus.InvocationCompletionHandler;
import com.ibm.cs.bpws.runtime.bus.ServiceReference;
import com.ibm.cs.bpws.util.xpath.XPathFunctions;
import com.ibm.wsgw.WSGWException;
import com.ibm.wsgw.WSGWUtils;
import com.ibm.wsgw.WSGateway;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFRequest;
import org.apache.wsif.WSIFResponse;
import org.apache.wsif.base.WSIFDefaultMessage;

public class BPWSBus
implements Runnable {
    static Logger busLogger = Logger.getLogger((String)"bpws.runtime.bus");
    LinkedList requestQueue = new LinkedList();
    Thread[] workers;
    boolean completed = false;
    WSGateway gateway;
    static /* synthetic */ Class class$com$ibm$cs$bpws$util$xpath$XPathFunctions;

    public BPWSBus(int nThreads) {
        this.workers = new Thread[nThreads];
        int i = 0;
        while (i < nThreads) {
            this.workers[i] = new Thread(this);
            this.workers[i].start();
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void destroy() {
        this.completed = true;
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.notifyAll();
        }
    }

    public void getValueToAssign(From assignSrc, To assignDest, AssignRT activity, AssignValueHandler callback, Object clientData) {
        BusRequestAssign br = new BusRequestAssign(assignSrc, assignDest, activity, callback, clientData);
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.addLast(br);
            this.requestQueue.notifyAll();
        }
    }

    public void invoke(ServiceReference serviceRef, QName portType, String operation, WSIFMessage input, InvocationCompletionHandler callback, Object clientData) {
        BusRequestInvoke br = new BusRequestInvoke(serviceRef, portType, operation, input, callback, clientData);
        LinkedList linkedList = this.requestQueue;
        synchronized (linkedList) {
            this.requestQueue.addLast(br);
            this.requestQueue.notifyAll();
        }
    }

    private void processGetValueToAssignRequest(BusRequestAssign br) {
        Object value = null;
        try {
            Class clazz = class$com$ibm$cs$bpws$util$xpath$XPathFunctions != null ? class$com$ibm$cs$bpws$util$xpath$XPathFunctions : (class$com$ibm$cs$bpws$util$xpath$XPathFunctions = BPWSBus.class$("com.ibm.cs.bpws.util.xpath.XPathFunctions"));
            synchronized (clazz) {
                XPathFunctions.setActivity(br.activity);
                value = XPathFunctions.getDataToCopy(br.assignSrc, br.assignDest);
            }
            br.callback.assignmentValueReady(br.clientData, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            br.callback.assignmentValueReady(br.clientData, e);
        }
    }

    private void processInvokeRequest(BusRequestInvoke br) {
        boolean faulted;
        WSGWException wce;
        WSIFRequest req = new WSIFRequest(br.serviceRef.serviceQName);
        req.setOperationName(br.operation);
        req.setContextMessage(null);
        WSIFMessage inmsg = br.input;
        boolean usingJROM = this.gateway.getJROMPreference(br.serviceRef.serviceQName);
        WSIFResponse res = null;
        try {
            if (!usingJROM) {
                Map typeMappings = this.gateway.getService(br.serviceRef.serviceQName).getTypeMappings();
                inmsg = WSGWUtils.changePartRepresentation((WSIFMessage)inmsg, (boolean)false, (Map)typeMappings);
            }
            req.setIncomingMessage(inmsg);
            res = new WSIFResponse(br.serviceRef.serviceQName);
            res.setOperationName(br.operation);
            busLogger.debug((Object)("Invoking external service with " + req));
            wce = null;
            faulted = false;
            this.gateway.process(req, res);
            busLogger.debug((Object)("Response for external invoke is " + res));
            if (res.getIsFault()) {
                faulted = true;
            }
        }
        catch (WSGWException e) {
            busLogger.error((Object)"Exception during external invocation", (Throwable)e);
            wce = e;
            faulted = true;
        }
        WSIFMessage outputMessage = null;
        if (faulted) {
            if (wce == null) {
                outputMessage = res.getFaultMessage();
                outputMessage.setName(new QName(br.serviceRef.serviceQName.getNamespaceURI(), outputMessage.getName()).toString());
            } else {
                outputMessage = new WSIFDefaultMessage();
                outputMessage.setName("Fault Message");
            }
        } else {
            outputMessage = res.getOutgoingMessage();
            if (!usingJROM) {
                try {
                    Map typeMappings = this.gateway.getService(br.serviceRef.serviceQName).getTypeMappings();
                    outputMessage = WSGWUtils.changePartRepresentation((WSIFMessage)outputMessage, (boolean)true, (Map)typeMappings);
                }
                catch (WSGWException e) {
                    busLogger.error((Object)"Exception during part transformation", (Throwable)e);
                    outputMessage = new WSIFDefaultMessage();
                    outputMessage.setName("Fault Message");
                }
            }
        }
        br.callback.invocationCompleted(br.clientData, outputMessage, faulted);
    }

    private void processRequest(BusRequest br) {
        if (br instanceof BusRequestInvoke) {
            this.processInvokeRequest((BusRequestInvoke)br);
        } else if (br instanceof BusRequestAssign) {
            this.processGetValueToAssignRequest((BusRequestAssign)br);
        } else {
            throw new IllegalArgumentException("BPWSBus.processRequest: Unexpected request: " + br);
        }
    }

    public void run() {
        while (!this.completed) {
            busLogger.debug((Object)"Waiting for request");
            BusRequest br = null;
            LinkedList linkedList = this.requestQueue;
            synchronized (linkedList) {
                if (this.requestQueue.size() == 0) {
                    try {
                        this.requestQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.requestQueue.size() != 0) {
                    br = (BusRequest)this.requestQueue.removeFirst();
                }
            }
            if (br == null) continue;
            busLogger.debug((Object)("Processing request: " + br));
            this.processRequest(br);
        }
        busLogger.debug((Object)"Done");
    }

    public void setGateway(WSGateway gateway) {
        this.gateway = gateway;
    }
}

