/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.runtime.events;

import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.events.BPWSEvent;
import com.ibm.cs.bpws.runtime.events.BPWSEventType;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFMessage;

public class ReceiveEvent
extends BPWSEvent
implements Serializable {
    private WSIFMessage message;
    private WSIFMessage correlationSet;
    private String partnerName;
    private QName portTypeName;
    private String operationName;
    private Object clientData;

    public ReceiveEvent(Object clientData, WSIFMessage message, WSIFMessage correlationSet, String partnerName, QName portTypeName, String operationName) {
        this.clientData = clientData;
        this.message = message;
        this.correlationSet = correlationSet;
        this.partnerName = partnerName;
        this.portTypeName = portTypeName;
        this.operationName = operationName;
    }

    public WSIFMessage getCorrelationSet() {
        return this.correlationSet;
    }

    public WSIFMessage getMessage() {
        return this.message;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public QName getPortTypeName() {
        return this.portTypeName;
    }

    public Object getReceiveClientData() {
        return this.clientData;
    }

    public ActivityRT getSource() {
        return null;
    }

    public BPWSEventType getType() {
        return BPWSEventType.RECEIVE_EVENT_TYPE;
    }

    public boolean matchesTemplate(BPWSEvent eventTemplate) {
        if (!super.matchesTemplate(eventTemplate)) {
            return false;
        }
        ReceiveEvent receiveEventTemplate = (ReceiveEvent)eventTemplate;
        if (receiveEventTemplate.getPartnerName() != null && !receiveEventTemplate.getPartnerName().equals(this.partnerName)) {
            return false;
        }
        if (receiveEventTemplate.getPortTypeName() != null && !receiveEventTemplate.getPortTypeName().equals(this.portTypeName)) {
            return false;
        }
        if (receiveEventTemplate.getOperationName() != null && !receiveEventTemplate.getOperationName().equals(this.operationName)) {
            return false;
        }
        if (receiveEventTemplate.getMessage() != null && !receiveEventTemplate.getMessage().equals(this.message)) {
            return false;
        }
        return receiveEventTemplate.getCorrelationSet() == null || receiveEventTemplate.getCorrelationSet().equals(this.correlationSet);
    }

    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    public String toString() {
        return "Receive event with message " + this.message + ", correlation set " + this.correlationSet + ", partnerName " + this.partnerName + ", port type name " + this.portTypeName + " and operation name " + this.operationName;
    }
}

