/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.util.xpath;

import com.ibm.bpws.model.From;
import com.ibm.bpws.model.To;
import com.ibm.cs.bpws.runtime.ActivityRT;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.cs.bpws.runtime.Constants;
import com.ibm.cs.bpws.runtime.VariableRT;
import com.ibm.cs.bpws.util.xpath.XPathUtils;
import com.ibm.jrom.JROMException;
import com.ibm.jrom.JROMType;
import com.ibm.jrom.JROMValue;
import com.ibm.jrom.factory.JROMFactory;
import com.ibm.jrom.util.ConvertorUtils;
import java.rmi.RemoteException;
import javax.xml.transform.TransformerException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.dtm.DTMManager;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XBooleanStatic;
import org.apache.xpath.objects.XNodeSetForDOM;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import samples.apachesoap.JROMDOMConvertor;

public class XPathFunctions {
    private static ActivityRT activity = null;

    public static JROMValue cloneJROMValue(JROMValue fromValue, JROMValue toVal) throws IllegalArgumentException {
        try {
            JROMFactory factory = JROMFactory.newInstance();
            JROMValue fromValCopy = factory.copyJROMInstance(fromValue);
            fromValCopy.setNameNamespace(toVal.getNameNamespace());
            fromValCopy.setNameLocalPart(toVal.getNameLocalPart());
            JROMType jromFromType = fromValCopy.getJROMType();
            JROMType jromToType = toVal.getJROMType();
            if (jromFromType == JROMType.JROM_DOUBLE_VALUE && jromToType != JROMType.JROM_DOUBLE_VALUE) {
                Double fromValDouble = (Double)ConvertorUtils.getSimpleJROMObject((JROMValue)fromValCopy);
                Number fromValObj = null;
                if (jromToType == JROMType.JROM_INTEGER_VALUE) {
                    fromValObj = new Integer(fromValDouble.intValue());
                } else if (jromToType == JROMType.JROM_FLOAT_VALUE) {
                    fromValObj = new Float(fromValDouble.floatValue());
                } else if (jromToType == JROMType.JROM_SHORT_VALUE) {
                    fromValObj = new Short(fromValDouble.shortValue());
                } else if (jromToType == JROMType.JROM_LONG_VALUE) {
                    fromValObj = new Long(fromValDouble.longValue());
                }
                if (fromValObj != null) {
                    fromValCopy = ConvertorUtils.createSimpleJrom((JROMFactory)factory, (JROMType)jromToType, (Object)fromValObj, (String)fromValCopy.getNameNamespace(), (String)fromValCopy.getNameLocalPart());
                }
            }
            return fromValCopy;
        }
        catch (JROMException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static synchronized boolean evalToBoolean(ActivityRT activity, String xpathExpr) throws TransformerException, IllegalArgumentException, BPWSRuntimeException {
        ActivityRT oldActivity = XPathFunctions.activity;
        XPathFunctions.activity = activity;
        boolean ret = XPathUtils.evalToBoolean(null, xpathExpr);
        XPathFunctions.activity = oldActivity;
        return ret;
    }

    public static synchronized String evalToString(ActivityRT activity, String xpathExpr) throws TransformerException, IllegalArgumentException, BPWSRuntimeException {
        ActivityRT oldActivity = XPathFunctions.activity;
        XPathFunctions.activity = activity;
        String ret = XPathUtils.evalToString(null, xpathExpr);
        XPathFunctions.activity = oldActivity;
        return ret;
    }

    public static JROMValue evaluateQuery(JROMValue jromValue, String xpathExpr, JROMDOMConvertor convertor) throws IllegalArgumentException, TransformerException {
        Element el = XPathFunctions.evaluateQueryToElement(null, jromValue, xpathExpr, convertor);
        return convertor.DOM2JROM(el);
    }

    private static Element evaluateQueryToElement(Element el, JROMValue jromValue, String xpathExpr, JROMDOMConvertor convertor) throws IllegalArgumentException, TransformerException {
        try {
            NodeIterator nl;
            Node node;
            if (el == null) {
                el = convertor.JROM2DOM(jromValue);
            }
            XObject xobject = XPathUtils.eval(el, xpathExpr);
            int type = xobject.getType();
            Element ret = null;
            if (type == 4 && (node = (nl = xobject.nodeset()).nextNode()) != null && node.getNodeType() == 1) {
                ret = (Element)node;
            }
            if (ret != null) {
                return ret;
            }
            throw new IllegalArgumentException("XPath expression '" + xpathExpr + "' does not evaluate " + "to an element.");
        }
        catch (JROMException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static ActivityRT getActivity() {
        return activity;
    }

    public static Object getDataToCopy(From from, To to) throws IllegalArgumentException, TransformerException {
        String expression = from.getExpression();
        Element literal = from.getLiteralValue();
        JROMValue ret = null;
        JROMDOMConvertor convertor = null;
        try {
            convertor = new JROMDOMConvertor();
        }
        catch (JROMException e) {
            throw new IllegalArgumentException(e.toString());
        }
        if (literal != null) {
            ret = convertor.DOM2JROM(literal);
        } else if (expression == null) {
            String variableName = from.getVariable().getName();
            String partName = from.getPart();
            String query = from.getQuery();
            VariableRT variable = activity.getVariable(variableName);
            WSIFMessage message = variable.getMessage();
            if (partName != null) {
                JROMValue partValue = null;
                try {
                    partValue = (JROMValue)message.getObjectPart(partName);
                }
                catch (WSIFException e) {
                    throw new IllegalArgumentException("Got exception '" + ((RemoteException)((Object)e)).getMessage() + "' when I tried to access part " + partName);
                }
                ret = query != null ? XPathFunctions.evaluateQuery(partValue, query, convertor) : partValue;
            } else {
                ret = message;
            }
        } else {
            int xtype;
            XObject xobject = XPathUtils.eval(null, expression);
            Object result = xobject.object();
            if (result instanceof XBooleanStatic) {
                result = new Boolean(xobject.bool());
            }
            if ((xtype = xobject.getType()) == 4) {
                NodeIterator nl = xobject.nodeset();
                Node node = nl.nextNode();
                if (node != null && node.getNodeType() == 1) {
                    ret = convertor.DOM2JROM((Element)node);
                }
            } else {
                JROMType type = ConvertorUtils.getJROMType(result.getClass());
                try {
                    JROMFactory factory = JROMFactory.newInstance();
                    ret = ConvertorUtils.createSimpleJrom((JROMFactory)factory, (JROMType)type, (Object)result, null, (String)"expr");
                }
                catch (JROMException e) {
                    throw new IllegalArgumentException(e.toString());
                }
            }
        }
        if (to != null && ret instanceof JROMValue) {
            ret = XPathFunctions.getDataToCopy(ret, to);
        }
        return ret;
    }

    public static JROMValue getDataToCopy(JROMValue fromValue, To to) throws IllegalArgumentException, TransformerException {
        JROMValue ret = null;
        JROMDOMConvertor convertor = null;
        try {
            convertor = new JROMDOMConvertor();
        }
        catch (JROMException e) {
            throw new IllegalArgumentException(e.toString());
        }
        String toQuery = to.getQuery();
        if (toQuery != null) {
            JROMValue toPartValue = XPathFunctions.getToPartValue(activity, to);
            JROMValue toVal = XPathFunctions.evaluateQuery(toPartValue, toQuery, convertor);
            try {
                JROMValue fromValCopy = XPathFunctions.cloneJROMValue(fromValue, toVal);
                Element fromResultEl = convertor.JROM2DOM(fromValCopy);
                Element toEl = convertor.JROM2DOM(toPartValue);
                Element toResultEl = XPathFunctions.evaluateQueryToElement(toEl, null, toQuery, convertor);
                Document toDoc = toResultEl.getOwnerDocument();
                Element fromResultClone = (Element)toDoc.importNode(fromResultEl, true);
                Node parentNode = toResultEl.getParentNode();
                if (parentNode != toDoc) {
                    parentNode.replaceChild(fromResultClone, toResultEl);
                } else {
                    toEl = fromResultClone;
                }
                ret = convertor.DOM2JROM(toEl);
            }
            catch (JROMException e) {
                throw new IllegalArgumentException(e.toString());
            }
        } else {
            ret = fromValue;
        }
        return ret;
    }

    public static XObject getLinkStatus(String linkName) throws IllegalArgumentException {
        if (activity == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation("getLinkStatus", new String[]{linkName}) + ", activity must not be null.");
        }
        if (linkName == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation("getLinkStatus", new String[]{linkName}) + ", linkName must not be null.");
        }
        return new XBoolean(activity.getIncomingLinkStatus(linkName) == ActivityRT.LINK_TRUE);
    }

    public static JROMValue getPartValue(String methodName, String[] methodArgs, ActivityRT activity, String variableName, String partName) throws IllegalArgumentException {
        WSIFMessage message = XPathFunctions.getWSIFMessage(methodName, methodArgs, activity, variableName, partName);
        return XPathFunctions.getPartValue(methodName, methodArgs, partName, message);
    }

    public static JROMValue getPartValue(String methodName, String[] methodArgs, String partName, WSIFMessage message) throws IllegalArgumentException {
        Object partObjValue = null;
        try {
            partObjValue = message.getObjectPart(partName);
        }
        catch (WSIFException e) {
            throw new IllegalArgumentException("Got exception '" + ((RemoteException)((Object)e)).getMessage() + "' when I tried to access part " + partName);
        }
        if (partObjValue == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation(methodName, methodArgs) + ", part '" + partName + "' was not found.");
        }
        if (!(partObjValue instanceof JROMValue)) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation(methodName, methodArgs) + ", part '" + partName + "' does not contain a JROMValue.");
        }
        return (JROMValue)partObjValue;
    }

    public static JROMValue getToPartValue(ActivityRT activity, To to) throws IllegalArgumentException {
        String toVariableName = to.getVariable().getName();
        String toPartName = to.getPart();
        VariableRT toVariable = activity.getVariable(toVariableName);
        WSIFMessage toMessage = toVariable.getMessage();
        JROMValue toPartValue = null;
        try {
            toPartValue = (JROMValue)toMessage.getObjectPart(toPartName);
        }
        catch (WSIFException e) {
            throw new IllegalArgumentException("Got exception '" + ((RemoteException)((Object)e)).getMessage() + "' when I tried to access part " + toPartName);
        }
        return toPartValue;
    }

    public static XObject getVariableData(ExpressionContext exprContext, String variableName, String partName, String locationPath) throws IllegalArgumentException, TransformerException, BPWSRuntimeException {
        JROMValue partValue = XPathFunctions.getPartValue("getVariableData", new String[]{variableName, partName, locationPath}, activity, variableName, partName);
        Object ret = null;
        try {
            JROMDOMConvertor convertor = new JROMDOMConvertor();
            Element el = convertor.JROM2DOM(partValue);
            Node node = null;
            XObject xobject = null;
            if (locationPath == null) {
                node = el;
            } else {
                NodeIterator nl;
                xobject = XPathUtils.eval(el, locationPath);
                int type = xobject.getType();
                if (type == 4 && ((node = (nl = xobject.nodeset()).nextNode()) == null || nl.nextNode() != null)) {
                    String msg = "In " + XPathFunctions.printMethodInvocation("getVariableData", new String[]{variableName, partName, locationPath}) + ", locationPath '" + locationPath + "' selected a nodeSet of size other than one.";
                    BPWSRuntimeException e = new BPWSRuntimeException(msg);
                    e.setFaultQName(Constants.SELECTION_FAILURE_FAULT_QNAME);
                    throw e;
                }
            }
            if (node != null && node.getNodeType() == 1) {
                JROMValue val = convertor.DOM2JROM(node);
                try {
                    Object obj = ConvertorUtils.getSimpleJROMObject((JROMValue)val);
                    ret = obj instanceof Number ? new XNumber((Number)obj) : (obj instanceof String ? new XString((String)obj) : (obj instanceof Boolean ? new XBoolean((Boolean)obj) : new XObject(obj)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (ret == null) {
                if (xobject != null) {
                    ret = xobject;
                } else {
                    XPathContext xctxt = null;
                    if (exprContext instanceof XPathContext.XPathExpressionContext) {
                        XPathContext.XPathExpressionContext xpathExprContext = (XPathContext.XPathExpressionContext)exprContext;
                        xctxt = xpathExprContext.getXPathContext();
                    } else {
                        xctxt = new XPathContext();
                    }
                    ret = new XNodeSetForDOM((Node)el, (DTMManager)xctxt);
                }
            }
        }
        catch (JROMException e) {
            throw new IllegalArgumentException(e.toString());
        }
        return ret;
    }

    public static WSIFMessage getWSIFMessage(String methodName, String[] methodArgs, ActivityRT activity, String variableName, String partName) throws IllegalArgumentException {
        if (activity == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation(methodName, methodArgs) + ", activity must not be null.");
        }
        if (variableName == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation(methodName, methodArgs) + ", variableName must not be null.");
        }
        if (partName == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation(methodName, methodArgs) + ", partName must not be null.");
        }
        VariableRT variable = activity.getVariable(variableName);
        if (variable == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation(methodName, methodArgs) + ", variable '" + variableName + "' was not found.");
        }
        WSIFMessage message = variable.getMessage();
        if (message == null) {
            throw new IllegalArgumentException("In " + XPathFunctions.printMethodInvocation(methodName, methodArgs) + ", variable '" + variableName + "' has no message.");
        }
        return message;
    }

    private static String printMethodInvocation(String methodName, String[] methodArgs) {
        StringBuffer strBuf = new StringBuffer(String.valueOf(methodName) + '(');
        int i = 0;
        while (i < methodArgs.length) {
            String arg = methodArgs[i];
            strBuf.append(String.valueOf(i > 0 ? ", " : "") + (arg != null ? String.valueOf('\"') + arg + '\"' : null));
            ++i;
        }
        return strBuf.append(')').toString();
    }

    public static void setActivity(ActivityRT activity) {
        XPathFunctions.activity = activity;
    }
}

