/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.extra.JPFErrorException;
import gov.nasa.arc.ase.ltl.Automaton;
import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.Node;
import gov.nasa.arc.ase.ltl.ParseErrorException;
import gov.nasa.arc.ase.ltl.State;
import gov.nasa.arc.ase.util.graph.Graph;

public class Translator {
    public static final int LTL2AUT = 0;
    public static final int LTL2BUCHI = 1;
    private static int algorithm = 1;

    public static int get_algorithm() {
        return algorithm;
    }

    public static boolean set_algorithm(int n) {
        if (n == 0 || n == 1) {
            algorithm = n;
            return true;
        }
        return false;
    }

    public static Graph translate(String string) {
        try {
            Formula formula = Formula.parse(string);
            Node node = Node.createInitial(formula);
            State[] stateArray = node.expand(new Automaton()).structForRuntAnalysis();
            return Automaton.SMoutput(stateArray);
        }
        catch (ParseErrorException parseErrorException) {
            throw new JPFErrorException("parse error: " + parseErrorException.getMessage());
        }
    }
}

