/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class Cache {
    private Hashtable ht = new Hashtable();
    private Index lowest = new Index(0);
    private Index highest = new Index(0);
    private int count = 0;
    private int size;
    private Listener listener;

    public Cache(int n) {
        this.size = n;
        this.listener = null;
    }

    public Cache(int n, Listener listener) {
        this.size = n;
        this.listener = listener;
    }

    public boolean put(Object object) {
        if (this.ht.containsKey(object)) {
            Index index = (Index)this.ht.get(object);
            if (index.cnt != this.highest.cnt - 1) {
                int n = index.cnt;
                index.cnt = this.highest.cnt;
                if (n == this.lowest.cnt) {
                    this.lowest.cnt = this.lowestValue();
                }
                this.next();
            }
            return false;
        }
        if (this.count == this.size) {
            this.removeLowest();
        } else {
            ++this.count;
        }
        this.ht.put(object, new Index(this.highest.cnt));
        this.next();
        return true;
    }

    public String toString() {
        return this.ht.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void setSize(int var1_1) {
        block1: {
            if (var1_1 <= this.count) ** GOTO lbl6
            this.size = var1_1;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.removeLowest();
                --this.count;
lbl6:
                // 2 sources

                ** while (this.count > var1_1)
            }
lbl7:
            // 1 sources

            this.size = var1_1;
        }
    }

    private void next() {
        ++this.highest.cnt;
        if (this.highest.cnt < 0) {
            ArrayList arrayList = new ArrayList(this.ht.entrySet());
            Collections.sort(arrayList, new EntryComparator());
            int n = 0;
            this.ht = new Hashtable();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.ht.put(entry.getKey(), new Index(n));
                ++n;
            }
            this.lowest.cnt = 0;
            this.highest.cnt = arrayList.size();
        }
    }

    private Index getValue(Index index) {
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.ht.get(k);
            if (!v.equals(index)) continue;
            return (Index)v;
        }
        return null;
    }

    private Object getKey(Index index) {
        Enumeration enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.ht.get(k);
            if (!v.equals(index)) continue;
            return k;
        }
        return null;
    }

    private int lowestValue() {
        int n = 0;
        boolean bl = false;
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            Index index = (Index)enumeration.nextElement();
            if (bl && index.cnt >= n) continue;
            bl = true;
            n = index.cnt;
        }
        return n;
    }

    private void removeLowest() {
        Object object = this.getKey(this.lowest);
        this.ht.remove(object);
        this.lowest.cnt = this.lowestValue();
        if (this.count == 1) {
            this.highest.cnt = 0;
        }
        if (this.listener != null) {
            this.listener.elementRemoved(object);
        }
    }

    private class Index {
        int cnt;

        public Index() {
            this.cnt = 0;
        }

        public Index(int n) {
            this.cnt = n;
        }

        public Object clone() {
            return new Index(this.cnt);
        }

        public boolean equals(Object object) {
            return ((Index)object).cnt == this.cnt;
        }

        public String toString() {
            return new Integer(this.cnt).toString();
        }
    }

    private class EntryComparator
    implements Comparator {
        private EntryComparator() {
        }

        public int compare(Object object, Object object2) {
            Map.Entry entry = (Map.Entry)object;
            Map.Entry entry2 = (Map.Entry)object2;
            Index index = (Index)entry.getValue();
            Index index2 = (Index)entry2.getValue();
            return index.cnt - index2.cnt;
        }
    }

    public static interface Listener {
        public void elementRemoved(Object var1);
    }
}

