/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

public class Debug {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int MESSAGE = 2;
    public static final int DEBUG = 3;
    private static final int LAST_LEVEL = 4;
    public static final int DEFAULT = 0;
    public static final int RACE = 1;
    public static final int LOCK_ORDER = 2;
    public static final int DEPEND = 3;
    public static final int DISTRIBUTED = 4;
    public static final int SEARCH = 5;
    public static final int TRACE = 6;
    private static final int LAST_KIND = 7;
    private static int[] enabled = new int[7];
    private static String[] levels = new String[]{"error", "warning", "message", "debug"};
    private static String[] kinds = new String[]{"default", "race", "lock-order", "depend", "distributed", "search", "trace"};

    public static int mapLevel(String string) {
        int n = 0;
        while (n < 4) {
            if (string.equals(levels[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int mapKind(String string) {
        int n = 0;
        while (n < 7) {
            if (string.equals(kinds[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void setDebugLevel(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("0 <= level < 4");
        }
        Debug.enabled[0] = n;
    }

    public static void setDebugLevel(String string) {
        int n = Debug.mapLevel(string);
        if (n == -1) {
            throw new IllegalArgumentException(string + " is not a valid level");
        }
        Debug.enabled[0] = n;
    }

    public static void setDebugLevel(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("0 <= level < 4");
        }
        if (n2 < 0 || n2 >= 7) {
            throw new IllegalArgumentException("0 <= kind < 7");
        }
        Debug.enabled[n2] = n;
    }

    public static void setDebugLevel(int n, String string) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("0 <= level < 4");
        }
        int n2 = Debug.mapKind(string);
        if (n2 == -1) {
            throw new IllegalArgumentException(string + " is not a valid kind");
        }
        Debug.enabled[n2] = n;
    }

    public static void setDebugLevel(String string, int n) {
        if (n < 0 || n >= 7) {
            throw new IllegalArgumentException("0 <= kind < 7");
        }
        int n2 = Debug.mapLevel(string);
        if (n2 == -1) {
            throw new IllegalArgumentException(string + " is not a valid level");
        }
        Debug.enabled[n] = n2;
    }

    public static void setDebugLevel(String string, String string2) {
        int n = Debug.mapLevel(string);
        if (n == -1) {
            throw new IllegalArgumentException(string + " is not a valid level");
        }
        int n2 = Debug.mapKind(string2);
        if (n2 == -1) {
            throw new IllegalArgumentException(string2 + " is not a valid kind");
        }
        Debug.enabled[n2] = n;
    }

    public static int getDebugLevel() {
        return enabled[0];
    }

    public static int getDebugLevel(int n) {
        return enabled[n];
    }

    public static int getDebugLevel(String string) {
        int n = Debug.mapKind(string);
        if (n == -1) {
            throw new IllegalArgumentException(string + " is not a valid kind");
        }
        return enabled[n];
    }

    public static void print(int n, Object object) {
        if (n <= enabled[0]) {
            System.err.print(object);
        }
    }

    public static void print(int n, String string) {
        if (n <= enabled[0]) {
            System.err.print(string);
        }
    }

    public static void println(int n) {
        if (n <= enabled[0]) {
            System.err.println();
        }
    }

    public static void println(int n, Object object) {
        if (n <= enabled[0]) {
            System.err.println(object);
        }
    }

    public static void println(int n, String string) {
        if (n <= enabled[0]) {
            System.err.println(string);
        }
    }

    public static void print(int n, int n2, Object object) {
        if (n <= enabled[n2]) {
            System.err.print(object);
        }
    }

    public static void print(int n, int n2, String string) {
        if (n <= enabled[n2]) {
            System.err.print(string);
        }
    }

    public static void println(int n, int n2) {
        if (n <= enabled[n2]) {
            System.err.println();
        }
    }

    public static void println(int n, int n2, Object object) {
        if (n <= enabled[n2]) {
            System.err.println(object);
        }
    }

    public static void println(int n, int n2, String string) {
        if (n <= enabled[n2]) {
            System.err.println(string);
        }
    }

    public static String status() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n < 7) {
            int n2 = enabled[n];
            if (n2 != 0) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(kinds[n]);
                stringBuffer.append("=");
                stringBuffer.append(levels[n2]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

