/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xerces.util.SecuritySupport;

public class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;
    static /* synthetic */ Class class$org$apache$xerces$util$ObjectFactory;

    public static Object createObject(String string, String string2) throws ConfigurationError {
        return ObjectFactory.createObject(string, null, string2);
    }

    public static Object createObject(String string, String string2, String string3) throws ConfigurationError {
        Object object;
        String string4;
        ObjectFactory.debugPrintln("debug is on");
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        try {
            string4 = securitySupport.getSystemProperty(string);
            if (string4 != null) {
                ObjectFactory.debugPrintln("found system property, value=" + string4);
                return ObjectFactory.newInstance(string4, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string4 = null;
        if (string2 == null) {
            object = securitySupport.getSystemProperty("java.home");
            string2 = (String)object + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
            File file = new File(string2);
            boolean bl = securitySupport.getFileExists(file);
            Class clazz = class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory;
            synchronized (clazz) {
                boolean bl2 = false;
                if (fLastModified >= 0L) {
                    if (bl && fLastModified < (fLastModified = securitySupport.getLastModified(file))) {
                        bl2 = true;
                    } else if (!bl) {
                        fLastModified = -1L;
                        fXercesProperties = null;
                    }
                } else if (bl) {
                    bl2 = true;
                    fLastModified = securitySupport.getLastModified(file);
                }
                if (bl2) {
                    try {
                        fXercesProperties = new Properties();
                        FileInputStream fileInputStream = securitySupport.getFileInputStream(file);
                        fXercesProperties.load(fileInputStream);
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        fXercesProperties = null;
                        fLastModified = -1L;
                    }
                }
            }
            if (fXercesProperties != null) {
                string4 = fXercesProperties.getProperty(string);
            }
        } else {
            try {
                object = securitySupport.getFileInputStream(new File(string2));
                Properties properties = new Properties();
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
                string4 = properties.getProperty(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string4 != null) {
            ObjectFactory.debugPrintln("found in " + string2 + ", value=" + string4);
            return ObjectFactory.newInstance(string4, classLoader, true);
        }
        object = ObjectFactory.findJarServiceProvider(string);
        if (object != null) {
            return object;
        }
        if (string3 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        ObjectFactory.debugPrintln("using fallback, value=" + string3);
        return ObjectFactory.newInstance(string3, classLoader, true);
    }

    private static void debugPrintln(String string) {
    }

    public static ClassLoader findClassLoader() throws ConfigurationError {
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
        }
        return classLoader;
    }

    public static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl);
            Object t = clazz.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    public static Class findProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        Class<?> clazz;
        if (classLoader == null) {
            clazz = Class.forName(string);
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
                    clazz = classLoader.loadClass(string);
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }

    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        BufferedReader bufferedReader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = securitySupport.getContextClassLoader();
        if (classLoader != null) {
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            if (inputStream == null) {
                classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
                inputStream = securitySupport.getResourceAsStream(classLoader, string2);
            }
        } else {
            classLoader = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
            inputStream = securitySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        String string3 = null;
        try {
            string3 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string3 != null && !"".equals(string3)) {
            ObjectFactory.debugPrintln("found in resource, value=" + string3);
            return ObjectFactory.newInstance(string3, classLoader, false);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ConfigurationError
    extends Error {
        private Exception exception;

        public ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

