/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.EventClient;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSEvent;
import ic.doc.ltsa.lts.LTSOutput;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AlphabetWindow
extends JSplitPane
implements LTSOutput,
EventClient {
    public static boolean fontFlag = false;
    JTextArea output;
    JList list;
    JScrollPane left;
    JScrollPane right;
    EventManager eman;
    int Nmach;
    int selectedMachine = 0;
    Alphabet current = null;
    int expandLevel = 0;
    CompactState[] sm;
    Font f1 = new Font("Monospaced", 0, 12);
    Font f2 = new Font("Monospaced", 1, 18);
    Font f3 = new Font("SansSerif", 0, 12);
    Font f4 = new Font("SansSerif", 1, 18);
    AlphabetWindow thisWindow;
    private static final int MAXPRINT = 400;

    public AlphabetWindow(CompositeState cs, EventManager eman) {
        this.eman = eman;
        this.thisWindow = this;
        this.output = new JTextArea(23, 50);
        this.output.setEditable(false);
        this.right = new JScrollPane(this.output, 20, 30);
        this.output.setBackground(Color.white);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new PrintAction());
        this.left = new JScrollPane(this.list, 20, 30);
        JPanel fortools = new JPanel(new BorderLayout());
        fortools.add("Center", this.right);
        JToolBar tools = new JToolBar();
        tools.setOrientation(1);
        fortools.add("West", tools);
        tools.add(this.createTool("icon/expanded.gif", "Expand Most", new ExpandMostAction()));
        tools.add(this.createTool("icon/expand.gif", "Expand", new ExpandMoreAction()));
        tools.add(this.createTool("icon/collapse.gif", "Collapse", new ExpandLessAction()));
        tools.add(this.createTool("icon/collapsed.gif", "Most Concise", new ExpandLeastAction()));
        if (eman != null) {
            eman.addClient(this);
        }
        this.new_machines(cs);
        this.setLeftComponent(this.left);
        this.setRightComponent(fortools);
        this.setDividerLocation(150);
        this.setBigFont(fontFlag);
        this.validate();
    }

    public void ltsAction(LTSEvent e) {
        switch (e.kind) {
            case 0: {
                break;
            }
            case 1: {
                this.new_machines((CompositeState)e.info);
                break;
            }
        }
    }

    public void out(String str) {
        this.output.append(str);
    }

    public void outln(String str) {
        this.output.append(String.valueOf(str) + "\n");
    }

    public void clearOutput() {
        this.output.setText("");
    }

    private void new_machines(CompositeState cs) {
        int i;
        int hasC;
        int n = hasC = cs != null && cs.composition != null ? 1 : 0;
        if (cs != null && cs.machines != null && cs.machines.size() > 0) {
            this.sm = new CompactState[cs.machines.size() + hasC];
            Enumeration e = cs.machines.elements();
            i = 0;
            while (e.hasMoreElements()) {
                this.sm[i] = (CompactState)e.nextElement();
                ++i;
            }
            this.Nmach = this.sm.length;
            if (hasC == 1) {
                this.sm[this.Nmach - 1] = cs.composition;
            }
        } else {
            this.Nmach = 0;
        }
        DefaultListModel<String> lm = new DefaultListModel<String>();
        i = 0;
        while (i < this.Nmach) {
            if (hasC == 1 && i == this.Nmach - 1) {
                lm.addElement("||" + this.sm[i].name);
            } else {
                lm.addElement(this.sm[i].name);
            }
            ++i;
        }
        this.list.setModel(lm);
        if (this.selectedMachine >= this.Nmach) {
            this.selectedMachine = 0;
        }
        this.current = null;
        this.clearOutput();
    }

    protected JButton createTool(String icon, String tip, ActionListener act) {
        JButton b = new JButton((Icon)new ImageIcon(this.getClass().getResource(icon))){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setToolTipText(tip);
        b.addActionListener(act);
        return b;
    }

    public void setBigFont(boolean b) {
        fontFlag = b;
        if (fontFlag) {
            this.output.setFont(this.f2);
            this.list.setFont(this.f4);
        } else {
            this.output.setFont(this.f1);
            this.list.setFont(this.f3);
        }
    }

    public void removeClient() {
        if (this.eman != null) {
            this.eman.removeClient(this);
        }
    }

    public void copy() {
        this.output.copy();
    }

    public void saveFile() {
        FileDialog fd = new FileDialog((Frame)this.getTopLevelAncestor(), "Save text in:", 1);
        if (this.Nmach > 0) {
            String fname = this.sm[this.selectedMachine].name;
            int colon = fname.indexOf(58, 0);
            if (colon > 0) {
                fname = fname.substring(0, colon);
            }
            fd.setFile(String.valueOf(fname) + ".txt");
        }
        fd.show();
        String file = fd.getFile();
        if (file != null) {
            try {
                int i = file.indexOf(46, 0);
                file = String.valueOf(file.substring(0, i)) + "." + "txt";
                FileOutputStream fout = new FileOutputStream(String.valueOf(fd.getDirectory()) + file);
                PrintStream myOutput = new PrintStream(fout);
                String text = this.output.getText();
                myOutput.print(text);
                myOutput.close();
                fout.close();
            }
            catch (IOException e) {
                this.outln("Error saving file: " + e);
            }
        }
    }

    class ExpandMoreAction
    implements ActionListener {
        ExpandMoreAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            if (AlphabetWindow.this.expandLevel < AlphabetWindow.this.current.maxLevel) {
                ++AlphabetWindow.this.expandLevel;
            }
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class ExpandLessAction
    implements ActionListener {
        ExpandLessAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            if (AlphabetWindow.this.expandLevel > 0) {
                --AlphabetWindow.this.expandLevel;
            }
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class ExpandMostAction
    implements ActionListener {
        ExpandMostAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            AlphabetWindow.this.expandLevel = AlphabetWindow.this.current.maxLevel;
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class ExpandLeastAction
    implements ActionListener {
        ExpandLeastAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AlphabetWindow.this.current == null) {
                return;
            }
            AlphabetWindow.this.expandLevel = 0;
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }

    class PrintAction
    implements ListSelectionListener {
        PrintAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int machine = AlphabetWindow.this.list.getSelectedIndex();
            if (machine < 0 || machine >= AlphabetWindow.this.Nmach) {
                return;
            }
            AlphabetWindow.this.selectedMachine = machine;
            AlphabetWindow.this.clearOutput();
            AlphabetWindow.this.current = new Alphabet(AlphabetWindow.this.sm[machine]);
            if (AlphabetWindow.this.expandLevel > AlphabetWindow.this.current.maxLevel) {
                AlphabetWindow.this.expandLevel = AlphabetWindow.this.current.maxLevel;
            }
            AlphabetWindow.this.current.print(AlphabetWindow.this.thisWindow, AlphabetWindow.this.expandLevel);
        }
    }
}

