/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import ic.doc.extension.Animator;
import ic.doc.ltsa.lts.RunMenu;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class AnimWindow
extends JFrame {
    public static boolean fontFlag = false;
    JTextArea output;
    Animator animator;
    JCheckBox[] choices;
    Font f1;
    BitSet actions;
    Color priority;
    BitSet pactions;
    String[] modelAlphabet;
    JButton step;
    JButton run;
    public boolean autoRun = false;
    private static final int STEPLIMIT = 64;
    protected boolean traceMode = false;

    public AnimWindow(Animator animator, RunMenu r, boolean auto, boolean traceM) {
        this.autoRun = auto;
        this.traceMode = traceM;
        this.f1 = fontFlag ? new Font("SansSerif", 1, 16) : new Font("SansSerif", 1, 12);
        this.animator = animator;
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.white);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.output = new JTextArea("", 15, 15);
        this.output.setEditable(false);
        this.output.setFont(this.f1);
        this.output.setBackground(Color.white);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        JScrollPane outp = new JScrollPane(this.output, 22, 30);
        this.getContentPane().add(outp);
        this.actions = r == null ? animator.initialise(null) : animator.initialise(r.alphabet);
        if (this.traceMode) {
            this.setTitle("Replay Animator");
        } else {
            this.setTitle("Animator");
        }
        this.step = new JButton("Step");
        this.step.setFont(this.f1);
        this.step.addActionListener(new AnimAction(this.traceMode ? -3 : -1));
        this.run = new JButton("Run");
        this.run.addActionListener(new AnimAction(this.traceMode ? -4 : -2));
        this.run.setFont(this.f1);
        Box buttons = Box.createHorizontalBox();
        buttons.add(this.run);
        buttons.add(this.step);
        String[] alphabet = animator.getMenuNames();
        this.modelAlphabet = animator.getAllNames();
        this.priority = animator.getPriority() ? Color.cyan : Color.pink;
        this.pactions = animator.getPriorityActions();
        this.choices = new JCheckBox[alphabet.length];
        Box p = Box.createVerticalBox();
        int i = 1;
        while (i < alphabet.length) {
            this.choices[i] = new JCheckBox(alphabet[i], null, this.actions.get(i));
            p.add(this.choices[i]);
            this.choices[i].setFont(this.f1);
            this.choices[i].addActionListener(new AnimAction(i));
            if (this.traceMode) {
                this.choices[i].setEnabled(false);
            }
            if (this.pactions != null && this.pactions.get(i)) {
                this.choices[i].setBackground(this.priority);
            }
            ++i;
        }
        p.add(Box.createHorizontalStrut(10));
        boolean enable = animator.nonMenuChoice() || this.traceMode;
        this.step.setEnabled(enable);
        this.run.setEnabled(enable);
        if (this.empty(this.actions) && !enable) {
            this.outln("STOP");
        }
        JScrollPane boxes = new JScrollPane(p, 20, 31);
        boxes.setBorder(new EmptyBorder(0, 0, 0, 0));
        Box side = Box.createVerticalBox();
        side.add(buttons);
        side.add(boxes);
        this.getContentPane().add(side);
        p.setBackground(Color.white);
        this.validate();
        if (this.autoRun) {
            this.dostep(-2);
        }
    }

    private void dostep(int choice) {
        boolean enable;
        if (this.animator.isError()) {
            return;
        }
        if (choice == -1) {
            this.actions = this.animator.singleStep();
            this.outAction();
        } else if (choice == -2) {
            this.actions = this.multiStep(null);
        } else if (choice == -3) {
            this.actions = this.animator.traceStep();
            this.outAction();
        } else if (choice == -4) {
            this.actions = this.multiTraceStep(null);
        } else if (!this.choices[choice].isSelected()) {
            this.actions = this.animator.menuStep(choice);
            this.outAction();
        }
        if (this.actions == null) {
            return;
        }
        if (this.autoRun && !this.traceMode) {
            this.actions = this.multiStep(this.actions);
        }
        int j = 1;
        while (j < this.choices.length) {
            this.choices[j].setSelected(this.actions.get(j));
            ++j;
        }
        if (!this.traceMode) {
            enable = this.animator.nonMenuChoice();
            this.step.setEnabled(enable);
            this.run.setEnabled(enable);
            if (this.empty(this.actions) && !enable && !this.animator.isError()) {
                if (this.animator.isEnd()) {
                    this.outln("END");
                } else {
                    this.outln("STOP");
                }
            }
        } else {
            enable = this.animator.traceChoice();
            this.step.setEnabled(enable);
            this.run.setEnabled(enable);
            if (!enable && !this.animator.isError()) {
                if (this.empty(this.actions)) {
                    if (this.animator.isEnd()) {
                        this.outln("END");
                    } else {
                        this.outln("STOP");
                    }
                } else {
                    this.outln("DIVERGED FROM TRACE");
                }
            }
        }
        this.repaint();
    }

    private BitSet multiStep(BitSet b) {
        int step = 0;
        while (this.animator.nonMenuChoice()) {
            b = this.animator.singleStep();
            this.outAction();
            if (++step <= 64) continue;
            this.outln("LOOP");
            return b;
        }
        return b;
    }

    private BitSet multiTraceStep(BitSet b) {
        while (this.animator.traceChoice()) {
            b = this.animator.traceStep();
            this.outAction();
        }
        return b;
    }

    public void out(String str) {
        this.output.append(str);
    }

    public void outln(String str) {
        this.output.append(String.valueOf(str) + "\n");
    }

    public void clearOutput() {
        this.output.setText("");
    }

    private boolean empty(BitSet b) {
        int i = 0;
        while (i < b.size()) {
            if (b.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void outAction() {
        this.outln(" " + this.modelAlphabet[this.animator.actionChosen()]);
        if (this.animator.isError()) {
            this.outln("ERROR");
        }
    }

    class AnimAction
    implements ActionListener {
        int choice;

        AnimAction(int id) {
            this.choice = id;
        }

        public void actionPerformed(ActionEvent e) {
            AnimWindow.this.dostep(this.choice);
        }
    }
}

