/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import gov.nasa.arc.ase.util.graph.Graph;
import ic.doc.extension.Animator;
import ic.doc.extension.Exportable;
import ic.doc.extension.ILTSAPlugin;
import ic.doc.extension.Initialisable;
import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.Relation;
import ic.doc.ltsa.AlphabetWindow;
import ic.doc.ltsa.AnimWindow;
import ic.doc.ltsa.AppletButton;
import ic.doc.ltsa.Examples;
import ic.doc.ltsa.LTSABlanker;
import ic.doc.ltsa.LTSASplash;
import ic.doc.ltsa.LTSDrawWindow;
import ic.doc.ltsa.OutputBuffer;
import ic.doc.ltsa.PrintWindow;
import ic.doc.ltsa.dclap.Gr2PICT;
import ic.doc.ltsa.editor.ColoredEditorKit;
import ic.doc.ltsa.lts.Analyser;
import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventClient;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSCanvas;
import ic.doc.ltsa.lts.LTSCompiler;
import ic.doc.ltsa.lts.LTSEvent;
import ic.doc.ltsa.lts.LTSException;
import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MenuDefinition;
import ic.doc.ltsa.lts.PrintTransitions;
import ic.doc.ltsa.lts.ProgressCheck;
import ic.doc.ltsa.lts.RunMenu;
import ic.doc.ltsa.lts.SuperTrace;
import ic.doc.ltsa.lts.SymbolTable;
import ic.doc.ltsa.lts.ltl.AssertDefinition;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class HPWindow
extends JFrame
implements LTSA,
LTSInput,
LTSOutput,
Runnable {
    private static final String VERSION = " j1.2 v14-10-99, animation support";
    private static final String DEFAULT = "DEFAULT";
    private boolean force_recompile = false;
    private static HPWindow o_hpwindow;
    JTextArea output;
    JEditorPane input;
    JEditorPane manual;
    JEditorPane internal;
    JScrollPane hidden;
    AlphabetWindow alphabet;
    PrintWindow prints;
    LTSDrawWindow draws;
    JTabbedPane textIO;
    JToolBar tools;
    Map o_plugin_buttons;
    Map o_menus;
    JComboBox targetChoice;
    JPanel p;
    EventManager eman = new EventManager();
    Collection o_event_listeners;
    JFrame animator = null;
    CompositeState current = null;
    String run_menu = "DEFAULT";
    String asserted = null;
    StringBuffer o_internal;
    Initialisable o_scenebeans_init = null;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    JMenu file;
    JMenu edit;
    JMenu check;
    JMenu build;
    JMenu window;
    JMenu help;
    JMenu option;
    JMenuItem file_new;
    JMenuItem file_open;
    JMenuItem file_save;
    JMenuItem file_saveAs;
    JMenuItem file_export;
    JMenuItem file_exit;
    JMenuItem edit_cut;
    JMenuItem edit_copy;
    JMenuItem edit_paste;
    JMenuItem edit_undo;
    JMenuItem edit_redo;
    JMenuItem check_safe;
    JMenuItem check_progress;
    JMenuItem check_reachable;
    JMenuItem check_stop;
    JMenuItem build_parse;
    JMenuItem build_compile;
    JMenuItem build_compose;
    JMenuItem build_minimise;
    JMenuItem help_about;
    JMenuItem supertrace_options;
    JMenu check_run;
    JMenu file_example;
    JMenu check_liveness;
    JMenuItem default_run;
    JMenuItem[] run_items;
    JMenuItem[] assert_items;
    String[] run_names;
    String[] assert_names;
    boolean[] run_enabled;
    JCheckBoxMenuItem setWarnings;
    JCheckBoxMenuItem setWarningsAreErrors;
    JCheckBoxMenuItem setFair;
    JCheckBoxMenuItem setPartialOrder;
    JCheckBoxMenuItem setObsEquiv;
    JCheckBoxMenuItem setReduction;
    JCheckBoxMenuItem setBigFont;
    JCheckBoxMenuItem setDisplayName;
    JCheckBoxMenuItem setNewLabelFormat;
    JCheckBoxMenuItem setAutoRun;
    JCheckBoxMenuItem setMultipleLTS;
    JCheckBoxMenuItem help_manual;
    JCheckBoxMenuItem window_alpha;
    JCheckBoxMenuItem window_print;
    JCheckBoxMenuItem window_draw;
    JCheckBoxMenuItem window_hidden;
    JCheckBoxMenuItem setProbabilistic;
    JMenuBar mb;
    Map o_plugins;
    List o_current_plugins;
    JButton stopTool;
    JButton parseTool;
    JButton safetyTool;
    JButton progressTool;
    JButton copyTool;
    JButton cutTool;
    JButton pasteTool;
    JButton newFileTool;
    JButton openFileTool;
    JButton saveFileTool;
    JButton compileTool;
    JButton composeTool;
    JButton minimizeTool;
    JButton undoTool;
    JButton redoTool;
    int fPos = -1;
    String fSrc = "\n";
    Font fixed = new Font("Monospaced", 0, 12);
    Font big = new Font("Monospaced", 1, 18);
    private int o_states_explored;
    private int o_transitions_taken;
    private AppletButton isApplet = null;
    private static final int DO_safety = 1;
    private static final int DO_execute = 3;
    private static final int DO_reachable = 4;
    private static final int DO_compile = 5;
    private static final int DO_doComposition = 6;
    private static final int DO_minimiseComposition = 7;
    private static final int DO_progress = 8;
    private static final int DO_liveness = 9;
    private static final int DO_parse = 10;
    private int theAction = 0;
    private Thread executer;
    private static final String fileType = "*.lts";
    private String openFile = "*.lts";
    String currentDirectory;
    private String savedText = "";
    private int tabindex = 0;
    private CompositeState _copy = null;

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
        o_hpwindow = new HPWindow(null);
    }

    public HPWindow(AppletButton isap) {
        this.o_plugins = new HashMap();
        this.o_current_plugins = new ArrayList();
        this.o_event_listeners = new ArrayList();
        this.isApplet = isap;
        SymbolTable.init();
        this.getContentPane().setLayout(new BorderLayout());
        this.o_menus = new HashMap();
        this.textIO = new JTabbedPane();
        this.input = new JEditorPane();
        this.input.setEditorKit(new ColoredEditorKit());
        this.input.setFont(this.fixed);
        this.input.setBackground(Color.white);
        this.input.getDocument().addUndoableEditListener(this.undoHandler);
        this.undo.setLimit(10);
        this.input.setBorder(new EmptyBorder(0, 5, 0, 0));
        JScrollPane inp = new JScrollPane(this.input, 22, 30);
        this.internal = new JEditorPane();
        this.internal.setEditorKit(new ColoredEditorKit());
        this.internal.setFont(this.fixed);
        this.internal.setBackground(Color.white);
        this.internal.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.hidden = new JScrollPane(this.internal, 22, 30);
        this.textIO.addTab("Edit", inp);
        this.textIO.setBackgroundAt(0, Color.green);
        this.output = new JTextArea("", 30, 100);
        this.output.setEditable(false);
        this.output.setFont(this.fixed);
        this.output.setBackground(Color.white);
        this.output.setLineWrap(true);
        this.output.setWrapStyleWord(true);
        this.output.setBorder(new EmptyBorder(0, 5, 0, 0));
        JScrollPane outp = new JScrollPane(this.output, 22, 31);
        this.textIO.addTab("Output", outp);
        this.textIO.setBackgroundAt(1, Color.lightGray);
        this.textIO.addChangeListener(new TabChange());
        this.textIO.setRequestFocusEnabled(false);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        this.textIO.setPreferredSize(new Dimension((int)(screen.getWidth() * 0.8), (int)(screen.getHeight() * 0.8)));
        this.getContentPane().add("Center", this.textIO);
        this.o_plugin_buttons = new HashMap();
        this.window = new JMenu("Window");
        this.mb = new JMenuBar();
        this.setJMenuBar(this.mb);
        this.file = new JMenu("File");
        this.mb.add(this.file);
        this.o_menus.put("File", this.file);
        this.file_new = new JMenuItem("New");
        this.file_new.addActionListener(new NewFileAction());
        this.file.add(this.file_new);
        this.file_open = new JMenuItem("Open...");
        this.file_open.addActionListener(new OpenFileAction());
        this.file.add(this.file_open);
        this.file_save = new JMenuItem("Save");
        this.file_save.addActionListener(new SaveFileAction());
        this.file.add(this.file_save);
        this.file_saveAs = new JMenuItem("Save as...");
        this.file_saveAs.addActionListener(new SaveAsFileAction());
        this.file.add(this.file_saveAs);
        this.file_export = new JMenuItem("Export...");
        this.file_export.addActionListener(new ExportFileAction());
        this.file.add(this.file_export);
        this.file_example = new JMenu("Examples");
        new Examples(this.file_example, this).getExamples();
        this.file.add(this.file_example);
        this.file_exit = new JMenuItem("Quit");
        this.file_exit.addActionListener(new ExitFileAction());
        this.file.add(this.file_exit);
        this.edit = new JMenu("Edit");
        this.mb.add(this.edit);
        this.o_menus.put("Edit", this.edit);
        this.edit_cut = new JMenuItem("Cut");
        this.edit_cut.addActionListener(new EditCutAction());
        this.edit.add(this.edit_cut);
        this.edit_copy = new JMenuItem("Copy");
        this.edit_copy.addActionListener(new EditCopyAction());
        this.edit.add(this.edit_copy);
        this.edit_paste = new JMenuItem("Paste");
        this.edit_paste.addActionListener(new EditPasteAction());
        this.edit.add(this.edit_paste);
        this.edit.addSeparator();
        this.edit_undo = new JMenuItem("Undo");
        this.edit_undo.addActionListener(new UndoAction());
        this.edit.add(this.edit_undo);
        this.edit_redo = new JMenuItem("Redo");
        this.edit_redo.addActionListener(new RedoAction());
        this.edit.add(this.edit_redo);
        this.check = new JMenu("Check");
        this.mb.add(this.check);
        this.o_menus.put("Check", this.check);
        this.check_safe = new JMenuItem("Safety");
        this.check_safe.addActionListener(new DoAction(1));
        this.check.add(this.check_safe);
        this.check_progress = new JMenuItem("Progress");
        this.check_progress.addActionListener(new DoAction(8));
        this.check.add(this.check_progress);
        this.check_liveness = new JMenu("LTL property");
        if (this.hasLTL2BuchiJar()) {
            this.check.add(this.check_liveness);
        }
        this.check_run = new JMenu("Run");
        this.check.add(this.check_run);
        this.default_run = new JMenuItem(DEFAULT);
        this.default_run.addActionListener(new ExecuteAction(DEFAULT));
        this.check_run.add(this.default_run);
        this.check_reachable = new JMenuItem("Supertrace");
        this.check_reachable.addActionListener(new DoAction(4));
        this.check.add(this.check_reachable);
        this.check_stop = new JMenuItem("Stop");
        this.check_stop.addActionListener(new StopAction());
        this.check_stop.setEnabled(false);
        this.check.add(this.check_stop);
        this.build = new JMenu("Build");
        this.mb.add(this.build);
        this.o_menus.put("Build", this.build);
        this.build_parse = new JMenuItem("Parse");
        this.build_parse.addActionListener(new DoAction(10));
        this.build.add(this.build_parse);
        this.build_compile = new JMenuItem("Compile");
        this.build_compile.addActionListener(new DoAction(5));
        this.build.add(this.build_compile);
        this.build_compose = new JMenuItem("Compose");
        this.build_compose.addActionListener(new DoAction(6));
        this.build.add(this.build_compose);
        this.build_minimise = new JMenuItem("Minimise");
        this.build_minimise.addActionListener(new DoAction(7));
        this.build.add(this.build_minimise);
        this.mb.add(this.window);
        this.o_menus.put("Window", this.window);
        this.window_alpha = new JCheckBoxMenuItem("Alphabet");
        this.window_alpha.setSelected(false);
        this.window_alpha.addActionListener(new WinAlphabetAction());
        this.window.add(this.window_alpha);
        this.window_print = new JCheckBoxMenuItem("Transitions");
        this.window_print.setSelected(false);
        this.window_print.addActionListener(new WinPrintAction());
        this.window.add(this.window_print);
        this.window_draw = new JCheckBoxMenuItem("Draw");
        this.window_draw.setSelected(true);
        this.window_draw.addActionListener(new WinDrawAction());
        this.window.add(this.window_draw);
        this.window_hidden = new JCheckBoxMenuItem("Compile Buffer");
        this.window_hidden.setSelected(false);
        this.window_hidden.addActionListener(new WinHiddenAction());
        this.window.add(this.window_hidden);
        this.help = new JMenu("Help");
        this.mb.add(this.help);
        this.o_menus.put("Help", this.help);
        this.help_about = new JMenuItem("About");
        this.help_about.addActionListener(new HelpAboutAction());
        this.help.add(this.help_about);
        this.help_manual = new JCheckBoxMenuItem("Manual");
        this.help_manual.setSelected(false);
        this.help_manual.addActionListener(new HelpManualAction());
        this.help.add(this.help_manual);
        OptionAction opt = new OptionAction();
        this.option = new JMenu("Options");
        this.mb.add(this.option);
        this.o_menus.put("Options", this.option);
        this.setWarnings = new JCheckBoxMenuItem("Display warning messages");
        this.setWarnings.addActionListener(opt);
        this.option.add(this.setWarnings);
        this.setWarnings.setSelected(true);
        this.setWarningsAreErrors = new JCheckBoxMenuItem("Treat warnings as errors");
        this.setWarningsAreErrors.addActionListener(opt);
        this.option.add(this.setWarningsAreErrors);
        this.setWarningsAreErrors.setSelected(false);
        this.setFair = new JCheckBoxMenuItem("Fair Choice for LTL check");
        this.setFair.addActionListener(opt);
        this.option.add(this.setFair);
        this.setFair.setSelected(true);
        this.setPartialOrder = new JCheckBoxMenuItem("Partial Order Reduction");
        this.setPartialOrder.addActionListener(opt);
        this.option.add(this.setPartialOrder);
        this.setPartialOrder.setSelected(false);
        this.setObsEquiv = new JCheckBoxMenuItem("Preserve OE for POR composition");
        this.setObsEquiv.addActionListener(opt);
        this.option.add(this.setObsEquiv);
        this.setObsEquiv.setSelected(true);
        this.setReduction = new JCheckBoxMenuItem("Enable Tau Reduction");
        this.setReduction.addActionListener(opt);
        this.option.add(this.setReduction);
        this.setReduction.setSelected(true);
        this.supertrace_options = new JMenuItem("Set Supertrace parameters");
        this.supertrace_options.addActionListener(new SuperTraceOptionListener());
        this.option.add(this.supertrace_options);
        this.option.addSeparator();
        this.setBigFont = new JCheckBoxMenuItem("Use big font");
        this.setBigFont.addActionListener(opt);
        this.option.add(this.setBigFont);
        this.setBigFont.setSelected(false);
        this.setDisplayName = new JCheckBoxMenuItem("Display name when drawing LTS");
        this.setDisplayName.addActionListener(opt);
        this.option.add(this.setDisplayName);
        this.setDisplayName.setSelected(true);
        this.setNewLabelFormat = new JCheckBoxMenuItem("Use V2.0 label format when drawing LTS");
        this.setNewLabelFormat.addActionListener(opt);
        this.option.add(this.setNewLabelFormat);
        this.setNewLabelFormat.setSelected(false);
        this.setMultipleLTS = new JCheckBoxMenuItem("Multiple LTS in Draw window");
        this.setMultipleLTS.addActionListener(opt);
        this.option.add(this.setMultipleLTS);
        this.setMultipleLTS.setSelected(false);
        this.option.addSeparator();
        this.setAutoRun = new JCheckBoxMenuItem("Auto run actions in Animator");
        this.setAutoRun.addActionListener(opt);
        this.option.add(this.setAutoRun);
        this.setAutoRun.setSelected(false);
        this.option.addSeparator();
        this.setProbabilistic = new JCheckBoxMenuItem("Compile probabilistic syntax");
        this.setProbabilistic.addActionListener(opt);
        this.setProbabilistic.setSelected(false);
        this.option.add(this.setProbabilistic);
        this.tools = new JToolBar();
        this.tools.setFloatable(false);
        this.newFileTool = this.createTool("/ic/doc/ltsa/icon/new.gif", "New file", new NewFileAction());
        this.tools.add(this.newFileTool);
        this.openFileTool = this.createTool("/ic/doc/ltsa/icon/open.gif", "Open file", new OpenFileAction());
        this.tools.add(this.openFileTool);
        this.saveFileTool = this.createTool("/ic/doc/ltsa/icon/save.gif", "Save File", new SaveFileAction());
        this.tools.add(this.saveFileTool);
        this.tools.addSeparator();
        this.cutTool = this.createTool("/ic/doc/ltsa/icon/cut.gif", "Cut", new EditCutAction());
        this.tools.add(this.cutTool);
        this.copyTool = this.createTool("/ic/doc/ltsa/icon/copy.gif", "Copy", new EditCopyAction());
        this.tools.add(this.copyTool);
        this.pasteTool = this.createTool("/ic/doc/ltsa/icon/paste.gif", "Paste", new EditPasteAction());
        this.tools.add(this.pasteTool);
        this.undoTool = this.createTool("/ic/doc/ltsa/icon/undo.gif", "Undo", new UndoAction());
        this.tools.add(this.undoTool);
        this.redoTool = this.createTool("/ic/doc/ltsa/icon/redo.gif", "Redo", new RedoAction());
        this.tools.add(this.redoTool);
        this.tools.addSeparator();
        this.parseTool = this.createTool("/ic/doc/ltsa/icon/parse.gif", "Parse", new DoAction(10));
        this.tools.add(this.parseTool);
        this.compileTool = this.createTool("/ic/doc/ltsa/icon/compile.gif", "Compile", new DoAction(5));
        this.tools.add(this.compileTool);
        this.composeTool = this.createTool("/ic/doc/ltsa/icon/compose.gif", "Compose", new DoAction(6));
        this.tools.add(this.composeTool);
        this.minimizeTool = this.createTool("/ic/doc/ltsa/icon/minimize.gif", "Minimize", new DoAction(7));
        this.tools.add(this.minimizeTool);
        this.targetChoice = new JComboBox();
        this.targetChoice.setEditable(false);
        this.targetChoice.addItem(DEFAULT);
        this.targetChoice.setToolTipText("Target Composition");
        this.targetChoice.setRequestFocusEnabled(false);
        this.targetChoice.addActionListener(new TargetAction());
        this.tools.addSeparator();
        this.tools.add(this.targetChoice);
        this.tools.addSeparator();
        this.safetyTool = this.createTool("/ic/doc/ltsa/icon/safety.gif", "Check safety", new DoAction(1));
        this.tools.add(this.safetyTool);
        this.progressTool = this.createTool("/ic/doc/ltsa/icon/progress.gif", "Check Progress", new DoAction(8));
        this.tools.add(this.progressTool);
        this.stopTool = this.createTool("/ic/doc/ltsa/icon/stop.gif", "Stop", new StopAction());
        this.tools.add(this.stopTool);
        this.stopTool.setEnabled(false);
        this.tools.addSeparator();
        this.tools.add(this.createTool("/ic/doc/ltsa/icon/alphabet.gif", "Run DEFAULT Animation", new ExecuteAction(DEFAULT)));
        this.tools.add(this.createTool("/ic/doc/ltsa/icon/blanker.gif", "Blank Screen", new BlankAction()));
        this.getContentPane().add("North", this.tools);
        this.menuEnable(true);
        this.file_save.setEnabled(this.isApplet == null);
        this.file_saveAs.setEnabled(this.isApplet == null);
        this.file_export.setEnabled(this.isApplet == null);
        this.saveFileTool.setEnabled(this.isApplet == null);
        this.updateDoState();
        LTSCanvas.displayName = this.setDisplayName.isSelected();
        LTSCanvas.newLabelFormat = this.setNewLabelFormat.isSelected();
        LTSDrawWindow.singleMode = !this.setMultipleLTS.isSelected();
        this.newDrawWindow(this.window_draw.isSelected());
        this.swapto(0);
        this.setEditControls(0);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseWindow());
        this.o_internal = new StringBuffer();
    }

    static void centre(Component c) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        Dimension ltsa = c.getSize();
        double x = (screen.getWidth() - ltsa.getWidth()) / 2.0;
        double y = (screen.getHeight() - ltsa.getHeight()) / 2.0;
        c.setLocation((int)x, (int)y);
    }

    void left(Component c) {
        Point ltsa = this.getLocationOnScreen();
        ltsa.translate(10, 100);
        c.setLocation(ltsa);
    }

    protected JButton createTool(String icon, String tip, ActionListener act) {
        JButton b = new JButton((Icon)new ImageIcon(this.getClass().getResource(icon))){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setToolTipText(tip);
        b.addActionListener(act);
        return b;
    }

    void menuEnable(boolean flag) {
        this.tabindex = this.textIO.getSelectedIndex();
        String pp = this.textIO.getTitleAt(this.tabindex);
        boolean b = this.tabindex == 0;
        ILTSAPlugin x_plugin = (ILTSAPlugin)this.o_plugins.get(pp);
        boolean bl = this.isApplet == null;
        this.file_new.setEnabled(flag && (b || x_plugin != null && x_plugin.providesNewFile()));
        this.file_example.setEnabled(flag && b);
        this.file_open.setEnabled(flag && (b || x_plugin != null && x_plugin.providesOpenFile()));
        this.file_exit.setEnabled(flag);
        this.check_safe.setEnabled(flag);
        this.check_progress.setEnabled(flag);
        this.check_run.setEnabled(flag);
        this.check_reachable.setEnabled(flag);
        this.build_parse.setEnabled(flag);
        this.build_compile.setEnabled(flag);
        this.build_compose.setEnabled(flag);
        this.build_minimise.setEnabled(flag);
        this.parseTool.setEnabled(flag);
        this.safetyTool.setEnabled(flag);
        this.progressTool.setEnabled(flag);
        this.compileTool.setEnabled(flag);
        this.composeTool.setEnabled(flag);
        this.minimizeTool.setEnabled(flag);
        Iterator i = this.o_plugin_buttons.keySet().iterator();
        while (i.hasNext()) {
            LTSAButton x_lb = (LTSAButton)i.next();
            ILTSAPlugin x_pl = (ILTSAPlugin)this.o_plugin_buttons.get(x_lb);
            if (x_pl != null && x_pl.addAsTab()) {
                x_lb.setEnabled(x_plugin == x_pl);
                continue;
            }
            x_lb.setEnabled(true);
        }
    }

    private void do_action(int action) {
        this.menuEnable(false);
        this.check_stop.setEnabled(true);
        this.stopTool.setEnabled(true);
        this.theAction = action;
        this.executer = new Thread(this);
        this.executer.setPriority(4);
        this.executer.start();
    }

    public void run() {
        try {
            switch (this.theAction) {
                case 1: {
                    this.showOutput();
                    this.safety();
                    break;
                }
                case 3: {
                    this.execute();
                    break;
                }
                case 4: {
                    this.showOutput();
                    this.reachable();
                    break;
                }
                case 5: {
                    this.showOutput();
                    this.compile();
                    break;
                }
                case 6: {
                    this.showOutput();
                    this.doComposition();
                    break;
                }
                case 7: {
                    this.showOutput();
                    this.minimiseComposition();
                    break;
                }
                case 8: {
                    this.showOutput();
                    this.progress();
                    break;
                }
                case 9: {
                    this.showOutput();
                    this.liveness();
                    break;
                }
                case 10: {
                    this.parse();
                }
            }
        }
        catch (Throwable e) {
            this.showOutput();
            this.outln("**** Runtime Exception: " + e);
            e.printStackTrace();
        }
        this.menuEnable(true);
        this.check_stop.setEnabled(false);
        this.stopTool.setEnabled(false);
    }

    public void invalidateState() {
        this.current = null;
        this.targetChoice.removeAllItems();
        this.targetChoice.addItem(DEFAULT);
        this.check_run.removeAll();
        this.check_run.add(this.default_run);
        this.run_items = null;
        this.assert_items = null;
        this.run_names = null;
        this.check_liveness.removeAll();
        this.validate();
        this.eman.post(new LTSEvent(1, null));
        if (this.animator != null) {
            this.animator.dispose();
            this.animator = null;
        }
    }

    public void postState(CompositeState m) {
        if (this.animator != null) {
            this.animator.dispose();
            this.animator = null;
        }
        this.eman.post(new LTSEvent(1, m));
    }

    private void newFile() {
        if (this.checkSave()) {
            this.setTitle("LTS Analyser");
            this.savedText = "";
            this.openFile = fileType;
            this.input.setText("");
            this.swapto(0);
            this.output.setText("");
            this.invalidateState();
        }
        this.repaint();
    }

    public void newExample(String dir, String ex) {
        this.undo.discardAllEdits();
        this.input.getDocument().removeUndoableEditListener(this.undoHandler);
        if (this.checkSave()) {
            this.invalidateState();
            this.clearOutput();
            this.doOpenFile(dir, ex, true);
        }
        this.input.getDocument().addUndoableEditListener(this.undoHandler);
        this.updateDoState();
        this.repaint();
    }

    private void openAFile() {
        if (this.checkSave()) {
            String x_tab;
            ILTSAPlugin x_plugin;
            this.invalidateState();
            this.clearOutput();
            FileDialog fd = new FileDialog((Frame)this, "Select source file:");
            if (this.currentDirectory != null) {
                fd.setDirectory(this.currentDirectory);
            }
            if ((x_plugin = (ILTSAPlugin)this.o_plugins.get(x_tab = this.textIO.getTitleAt(this.textIO.getSelectedIndex()))) != null && x_plugin.getFileExtension() != null) {
                fd.setFile("*." + x_plugin.getFileExtension());
            } else {
                fd.setFile(fileType);
            }
            fd.show();
            this.currentDirectory = fd.getDirectory();
            this.doOpenFile(this.currentDirectory, fd.getFile(), false);
        }
        this.repaint();
    }

    private void doOpenFile(String dir, String f, boolean resource) {
        if (f != null) {
            try {
                InputStream fin;
                this.openFile = f;
                this.setTitle("LTSA - " + this.openFile);
                if (!resource) {
                    String x_tab = this.textIO.getTitleAt(this.textIO.getSelectedIndex());
                    ILTSAPlugin x_plugin = (ILTSAPlugin)this.o_plugins.get(x_tab);
                    if (x_plugin != null && x_plugin.providesOpenFile()) {
                        x_plugin.openFile(new File(String.valueOf(dir) + this.openFile));
                        return;
                    }
                    fin = new FileInputStream(String.valueOf(dir) + this.openFile);
                } else {
                    fin = this.getClass().getResourceAsStream(String.valueOf(dir) + this.openFile);
                }
                try {
                    BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
                    try {
                        String thisLine;
                        StringBuffer buff = new StringBuffer();
                        while ((thisLine = myInput.readLine()) != null) {
                            buff.append(String.valueOf(thisLine) + "\n");
                        }
                        this.savedText = buff.toString();
                        this.input.setText(this.savedText);
                        this.parse();
                    }
                    catch (Exception e) {
                        this.outln("Error reading file: " + e);
                    }
                }
                catch (Exception e) {
                    this.outln("Error creating InputStream: " + e);
                }
            }
            catch (Exception e) {
                this.outln("Error creating FileInputStream: " + e);
            }
        }
    }

    private void saveAsFile() {
        ILTSAPlugin x_plugin;
        String x_tab = this.textIO.getTitleAt(this.textIO.getSelectedIndex());
        if (x_tab.equals("Draw")) {
            this.draws.saveFile();
            return;
        }
        FileDialog fd = new FileDialog((Frame)this, "Save file in:", 1);
        if (this.currentDirectory != null) {
            fd.setDirectory(this.currentDirectory);
        }
        if ((x_plugin = (ILTSAPlugin)this.o_plugins.get(x_tab)) != null && x_plugin.getFileExtension() != null) {
            fd.setFile("*." + x_plugin.getFileExtension());
        } else {
            fd.setFile(this.openFile);
        }
        fd.show();
        String tmp = fd.getFile();
        if (tmp != null) {
            if (x_plugin != null && x_plugin.providesSaveFile()) {
                try {
                    x_plugin.saveFile(new FileOutputStream(String.valueOf(fd.getDirectory()) + fd.getFile()));
                }
                catch (IOException iOException) {
                    this.outln("File not found : " + fd.getDirectory() + fd.getFile());
                }
                return;
            }
            this.currentDirectory = fd.getDirectory();
            this.openFile = tmp;
            this.setTitle("LTSA - " + this.openFile);
            this.saveFile();
        }
    }

    private void saveFile() {
        String x_tab = this.textIO.getTitleAt(this.textIO.getSelectedIndex());
        ILTSAPlugin x_plugin = (ILTSAPlugin)this.o_plugins.get(x_tab);
        if (x_plugin != null && x_plugin.providesSaveFile()) {
            this.saveAsFile();
        } else if (this.openFile != null && this.openFile.equals(fileType)) {
            this.saveAsFile();
        } else if (this.openFile != null) {
            try {
                int i = this.openFile.indexOf(46, 0);
                this.openFile = i > 0 ? String.valueOf(this.openFile.substring(0, i)) + "." + "lts" : String.valueOf(this.openFile) + ".lts";
                String tempname = this.currentDirectory == null ? this.openFile : String.valueOf(this.currentDirectory) + this.openFile;
                FileOutputStream fout = new FileOutputStream(tempname);
                PrintStream myOutput = new PrintStream(fout);
                this.savedText = this.input.getText();
                myOutput.print(this.savedText);
                myOutput.close();
                fout.close();
                this.outln("Saved in: " + tempname);
            }
            catch (IOException e) {
                this.outln("Error saving file: " + e);
            }
        }
    }

    private void exportFile() {
        String message = "Export as Aldebaran format (.aut) to:";
        FileDialog fd = new FileDialog((Frame)this, message, 1);
        if (this.current == null || this.current.composition == null) {
            JOptionPane.showMessageDialog(this, "No target composition to export");
            return;
        }
        String fname = this.current.composition.name;
        fd.setFile(String.valueOf(fname) + ".aut");
        fd.setDirectory(this.currentDirectory);
        fd.show();
        String sn = fd.getFile();
        if (sn != null) {
            try {
                int i = sn.indexOf(46, 0);
                sn = String.valueOf(sn.substring(0, i)) + ".aut";
                File file = new File(fd.getDirectory(), sn);
                FileOutputStream fout = new FileOutputStream(file);
                PrintStream myOutput = new PrintStream(fout);
                this.current.composition.printAUT(myOutput);
                myOutput.close();
                fout.close();
                this.outln("Exported to: " + fd.getDirectory() + file);
            }
            catch (IOException e) {
                this.outln("Error exporting file: " + e);
            }
        }
    }

    private boolean checkSave() {
        if (this.isApplet != null) {
            return true;
        }
        if (!this.savedText.equals(this.input.getText())) {
            int result = JOptionPane.showConfirmDialog(this, "Do you want to save the contents of " + this.openFile);
            if (result == 0) {
                this.saveFile();
                return true;
            }
            if (result == 1) {
                return true;
            }
            if (result == 2) {
                return false;
            }
        }
        return true;
    }

    private void doFont() {
        if (this.setBigFont.getState()) {
            this.input.setFont(this.big);
            this.output.setFont(this.big);
        } else {
            this.input.setFont(this.fixed);
            this.output.setFont(this.fixed);
        }
        this.pack();
        this.show();
    }

    private void quitAll() {
        if (this.isApplet != null) {
            this.dispose();
            this.isApplet.ended();
        } else if (this.checkSave()) {
            System.exit(0);
        }
    }

    public void updateDoState() {
        this.edit_undo.setEnabled(this.undo.canUndo());
        this.undoTool.setEnabled(this.undo.canUndo());
        this.edit_redo.setEnabled(this.undo.canRedo());
        this.redoTool.setEnabled(this.undo.canRedo());
    }

    private void swapto(int i) {
        if (i == this.tabindex) {
            return;
        }
        this.textIO.setBackgroundAt(i, Color.green);
        if (this.tabindex != i && this.tabindex < this.textIO.getTabCount()) {
            this.textIO.setBackgroundAt(this.tabindex, Color.lightGray);
        }
        this.tabindex = i;
        this.setEditControls(this.tabindex);
        this.textIO.setSelectedIndex(i);
    }

    public void swapto(String p_tabname) {
        this.swapto(this.textIO.indexOfTab(p_tabname));
    }

    private void setEditControls(int tabindex) {
        boolean app = this.isApplet == null;
        tabindex = this.textIO.getSelectedIndex();
        String pp = this.textIO.getTitleAt(tabindex);
        boolean b = tabindex == 0;
        ILTSAPlugin x_plugin = (ILTSAPlugin)this.o_plugins.get(pp);
        if (x_plugin != null) {
            x_plugin.selected();
        }
        this.edit_cut.setEnabled(b || x_plugin != null && x_plugin.providesCut());
        this.cutTool.setEnabled(b || x_plugin != null && x_plugin.providesCut());
        this.edit_paste.setEnabled(b || x_plugin != null && x_plugin.providesPaste());
        this.pasteTool.setEnabled(b || x_plugin != null && x_plugin.providesPaste());
        this.edit_copy.setEnabled(b || x_plugin != null && x_plugin.providesCopy());
        this.copyTool.setEnabled(b || x_plugin != null && x_plugin.providesCopy());
        this.file_new.setEnabled(b || x_plugin != null && x_plugin.providesNewFile());
        this.file_example.setEnabled(b);
        this.file_open.setEnabled(app && (b || x_plugin != null && x_plugin.providesOpenFile()));
        this.file_save.setEnabled(app && (b || x_plugin != null && x_plugin.providesSaveFile()));
        this.file_saveAs.setEnabled(app && (b || pp.equals("Draw") || x_plugin != null && x_plugin.providesSaveFile()));
        this.file_export.setEnabled(app && x_plugin == null);
        this.newFileTool.setEnabled(b || x_plugin != null && x_plugin.providesNewFile());
        this.openFileTool.setEnabled(app && (b || x_plugin != null && x_plugin.providesOpenFile()));
        this.saveFileTool.setEnabled(app && (b || pp.equals("Draw") || x_plugin != null && x_plugin.providesSaveFile()));
        this.edit_undo.setEnabled(b && this.undo.canUndo());
        this.undoTool.setEnabled(b && this.undo.canUndo());
        this.edit_redo.setEnabled(b && this.undo.canRedo());
        this.redoTool.setEnabled(b && this.undo.canRedo());
        if (b) {
            this.input.requestFocusInWindow();
        }
        Iterator i = this.o_plugin_buttons.keySet().iterator();
        while (i.hasNext()) {
            LTSAButton x_lb = (LTSAButton)i.next();
            ILTSAPlugin x_pl = (ILTSAPlugin)this.o_plugin_buttons.get(x_lb);
            if (x_pl != null && x_pl.addAsTab()) {
                x_lb.setEnabled(x_plugin == x_pl);
                continue;
            }
            x_lb.setEnabled(true);
        }
        if (b) {
            SwingUtilities.invokeLater(new RequestFocus());
        }
    }

    public void out(String str) {
        SwingUtilities.invokeLater(new OutputAppend(str));
    }

    public void outln(String str) {
        SwingUtilities.invokeLater(new OutputAppend(String.valueOf(str) + "\n"));
    }

    public void clearOutput() {
        SwingUtilities.invokeLater(new OutputClear());
    }

    public void showOutput() {
        SwingUtilities.invokeLater(new OutputShow());
    }

    public char nextChar() {
        ++this.fPos;
        if (this.fPos < this.fSrc.length()) {
            return this.fSrc.charAt(this.fPos);
        }
        return '\u0000';
    }

    public char backChar() {
        --this.fPos;
        if (this.fPos < 0) {
            this.fPos = 0;
            return '\u0000';
        }
        return this.fSrc.charAt(this.fPos);
    }

    public int getMarker() {
        return this.fPos;
    }

    private boolean compile() {
        this.force_recompile = false;
        this.clearOutput();
        if (!this.parse()) {
            return false;
        }
        this.current = this.docompile();
        if (this.current == null) {
            return false;
        }
        this.postState(this.current);
        return true;
    }

    private void displayError(LTSException x) {
        if (x.marker != null) {
            int i = (Integer)x.marker;
            int line = 1;
            int j = 0;
            while (j < i) {
                if (this.fSrc.charAt(j) == '\n') {
                    ++line;
                }
                ++j;
            }
            this.outln("ERROR line:" + line + " - " + x.getMessage());
            this.input.select(i, i + 1);
        } else {
            this.outln("ERROR - " + x.getMessage());
        }
    }

    private CompositeState docompile() {
        this.fPos = -1;
        this.fSrc = this.o_internal + "\n" + this.input.getText();
        this.internal.setText(this.fSrc);
        CompositeState cs = null;
        LTSCompiler comp = new LTSCompiler(this, this, this.currentDirectory);
        try {
            cs = comp.compile((String)this.targetChoice.getSelectedItem());
        }
        catch (LTSException x) {
            this.displayError(x);
        }
        return cs;
    }

    private Hashtable doparse() {
        this.fPos = -1;
        this.fSrc = String.valueOf(this.o_internal.toString()) + "\n" + this.input.getText();
        this.internal.setText(this.fSrc);
        LTSCompiler comp = new LTSCompiler(this, this, this.currentDirectory);
        Hashtable cs = new Hashtable();
        Hashtable ps = new Hashtable();
        try {
            comp.parse(cs, ps);
        }
        catch (LTSException x) {
            this.displayError(x);
            return null;
        }
        return cs;
    }

    private boolean compileIfChange() {
        String tmp = String.valueOf(this.o_internal.toString()) + "\n" + this.input.getText();
        if (this.force_recompile || this.current == null || !tmp.equals(this.fSrc) || !this.current.name.equals(this.targetChoice.getSelectedItem())) {
            return this.compile();
        }
        return true;
    }

    private void safety() {
        this.clearOutput();
        if (this.compileIfChange() && this.current != null) {
            this.current.analyse(this);
        }
    }

    private void progress() {
        this.clearOutput();
        if (this.compileIfChange() && this.current != null) {
            this.current.checkProgress(this);
        }
    }

    private void liveness() {
        this.clearOutput();
        if (!this.compileIfChange()) {
            return;
        }
        CompositeState ltl_property = AssertDefinition.compile(this, this.asserted);
        if (this.current != null && ltl_property != null) {
            this.current.checkLTL(this, ltl_property);
            this.postState(this.current);
        }
    }

    private void minimiseComposition() {
        this.clearOutput();
        if (this.compileIfChange() && this.current != null) {
            if (this.current.composition == null) {
                this.current.compose(this);
            }
            this.current.minimise(this);
            this.postState(this.current);
        }
    }

    private void doComposition() {
        this.clearOutput();
        if (this.compileIfChange() && this.current != null) {
            this.current.compose(this);
            this.postState(this.current);
        }
    }

    public void compileNoClear() {
        if (!this.parse()) {
            return;
        }
        this.current = this.docompile();
        if (this.current != null) {
            this.postState(this.current);
        }
    }

    private boolean checkReplay(Animator a) {
        if (a.hasErrorTrace()) {
            int result = JOptionPane.showConfirmDialog(this, "Do you want to replay the error trace?");
            if (result == 0) {
                return true;
            }
            if (result == 1) {
                return false;
            }
            if (result == 2) {
                return false;
            }
        }
        return false;
    }

    private void execute() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null) {
            Analyser a = new Analyser(this.current, this, this.eman);
            boolean replay = this.checkReplay(a);
            if (this.animator != null) {
                this.animator.dispose();
                this.animator = null;
            }
            RunMenu r = null;
            if (RunMenu.menus != null) {
                r = (RunMenu)RunMenu.menus.get(this.run_menu);
            }
            this.animator = r != null && r.isCustom() ? this.createCustom(a, r.params, r.actions, r.controls, replay) : new AnimWindow(a, r, this.setAutoRun.getState(), replay);
            if (this.animator != null) {
                this.animator.pack();
                this.left(this.animator);
                this.animator.setVisible(true);
            }
        }
    }

    private JFrame createCustom(Animator anim, String params, Relation actions, Relation controls, boolean replay) {
        ILTSAPlugin x_scenebeans = (ILTSAPlugin)this.o_plugins.get("SceneBeans");
        if (x_scenebeans != null) {
            try {
                this.o_scenebeans_init.initialise(new Object[]{anim, params, actions, controls, new Boolean(replay), this.currentDirectory});
                return (JFrame)x_scenebeans.getComponent();
            }
            catch (ClassCastException e) {
                this.outln("** Failed cast " + e + e.getMessage());
                e.printStackTrace();
            }
        }
        this.outln("** Failed to create instance of Scene Animator ");
        return null;
    }

    private void reachable() {
        this.clearOutput();
        this.compileIfChange();
        if (this.current != null && this.current.machines.size() > 0) {
            Analyser a = new Analyser(this.current, this, null);
            SuperTrace s = new SuperTrace(a, this);
            this.current.setErrorTrace(s.getErrorTrace());
        }
    }

    private void newDrawWindow(boolean disp) {
        if (disp && this.textIO.indexOfTab("Draw") < 0) {
            this.draws = new LTSDrawWindow(this.current, this.eman);
            this.textIO.addTab("Draw", this.draws);
            this.textIO.setBackgroundAt(this.textIO.indexOfTab("Draw"), Color.lightGray);
            this.swapto(this.textIO.indexOfTab("Draw"));
        } else if (!disp && this.textIO.indexOfTab("Draw") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Draw"));
            this.draws.removeClient();
            this.draws = null;
        }
    }

    private void newCompileBuf(boolean disp) {
        if (disp && this.textIO.indexOfTab("Compile Buffer") < 0) {
            this.textIO.addTab("Compile Buffer", this.hidden);
            this.swapto(this.textIO.indexOfTab("Compile Buffer"));
        } else if (!disp && this.textIO.indexOfTab("Compile Buffer") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Compile Buffer"));
        }
    }

    private void newMSCWindow(boolean disp) {
        if (disp && this.textIO.indexOfTab("MSC Editor") < 0) {
            this.swapto(this.textIO.indexOfTab("MSC Editor"));
        } else if (!disp && this.textIO.indexOfTab("MSC Editor") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("MSC Editor"));
        }
    }

    private void newPrintWindow(boolean disp) {
        if (disp && this.textIO.indexOfTab("Transitions") < 0) {
            this.prints = new PrintWindow(this.current, this.eman);
            this.textIO.addTab("Transitions", this.prints);
            this.swapto(this.textIO.indexOfTab("Transitions"));
        } else if (!disp && this.textIO.indexOfTab("Transitions") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Transitions"));
            this.prints.removeClient();
            this.prints = null;
        }
    }

    private void newAlphabetWindow(boolean disp) {
        if (disp && this.textIO.indexOfTab("Alphabet") < 0) {
            this.alphabet = new AlphabetWindow(this.current, this.eman);
            this.textIO.addTab("Alphabet", this.alphabet);
            this.swapto(this.textIO.indexOfTab("Alphabet"));
        } else if (!disp && this.textIO.indexOfTab("Alphabet") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Alphabet"));
            this.alphabet.removeClient();
            this.alphabet = null;
        }
    }

    private void aboutDialog() {
        LTSASplash d = new LTSASplash((Window)this);
        d.setVisible(true);
    }

    private void blankit() {
        LTSABlanker d = new LTSABlanker((Window)this);
        d.setVisible(true);
    }

    private void setSuperTraceOption() {
        try {
            String o = (String)JOptionPane.showInputDialog(this, "Enter Hashtable size (Kilobytes):", "Supertrace parameters", -1, null, null, "" + SuperTrace.getHashSize());
            if (o == null) {
                return;
            }
            SuperTrace.setHashSize(Integer.parseInt(o));
            o = (String)JOptionPane.showInputDialog(this, "Enter bound for search depth size:", "Supertrace parameters", -1, null, null, "" + SuperTrace.getDepthBound());
            if (o == null) {
                return;
            }
            SuperTrace.setDepthBound(Integer.parseInt(o));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public boolean parse() {
        String oldChoice = (String)this.targetChoice.getSelectedItem();
        Hashtable cs = this.doparse();
        if (cs == null) {
            return false;
        }
        this.targetChoice.removeAllItems();
        if (cs.size() == 0) {
            this.targetChoice.addItem(DEFAULT);
        } else {
            Enumeration e = cs.keys();
            ArrayList forSort = new ArrayList();
            while (e.hasMoreElements()) {
                forSort.add(e.nextElement());
            }
            Collections.sort(forSort);
            Iterator i = forSort.iterator();
            while (i.hasNext()) {
                this.targetChoice.addItem((String)i.next());
            }
        }
        if (oldChoice != null && !oldChoice.equals(DEFAULT) && cs.containsKey(oldChoice)) {
            this.targetChoice.setSelectedItem(oldChoice);
        }
        this.current = null;
        this.check_run.removeAll();
        this.run_names = MenuDefinition.names();
        this.run_enabled = MenuDefinition.enabled((String)this.targetChoice.getSelectedItem());
        this.check_run.add(this.default_run);
        if (this.run_names != null) {
            this.run_items = new JMenuItem[this.run_names.length];
            int i = 0;
            while (i < this.run_names.length) {
                this.run_items[i] = new JMenuItem(this.run_names[i]);
                this.run_items[i].setEnabled(this.run_enabled[i]);
                this.run_items[i].addActionListener(new ExecuteAction(this.run_names[i]));
                this.check_run.add(this.run_items[i]);
                ++i;
            }
        }
        this.check_liveness.removeAll();
        this.assert_names = AssertDefinition.names();
        if (this.assert_names != null) {
            this.assert_items = new JMenuItem[this.assert_names.length];
            int i = 0;
            while (i < this.assert_names.length) {
                this.assert_items[i] = new JMenuItem(this.assert_names[i]);
                this.assert_items[i].addActionListener(new LivenessAction(this.assert_names[i]));
                this.check_liveness.add(this.assert_items[i]);
                ++i;
            }
        }
        this.validate();
        return true;
    }

    private void displayManual(boolean dispman) {
        if (dispman && this.textIO.indexOfTab("Manual") < 0) {
            this.manual = new JEditorPane();
            this.manual.setEditable(false);
            this.manual.addHyperlinkListener(new Hyperactive());
            JScrollPane mm = new JScrollPane(this.manual, 22, 31);
            this.textIO.addTab("Manual", mm);
            this.swapto(this.textIO.indexOfTab("Manual"));
            URL man = this.getClass().getResource("doc/User-manual.html");
            try {
                this.manual.setPage(man);
            }
            catch (IOException e) {
                this.outln("" + e);
            }
        } else if (!dispman && this.textIO.indexOfTab("Manual") > 0) {
            this.swapto(0);
            this.textIO.removeTabAt(this.textIO.indexOfTab("Manual"));
            this.manual = null;
        }
    }

    public int getStatesExplored() {
        return this.o_states_explored;
    }

    public void setStatesExplored(int p_exp) {
        this.o_states_explored = p_exp;
    }

    public int getTransitionsTaken() {
        return this.o_transitions_taken;
    }

    public void setTransitionsTaken(int p_trans) {
        this.o_transitions_taken = p_trans;
    }

    public static HPWindow getInstance() {
        return o_hpwindow;
    }

    public static void main(String[] args) {
        HPWindow window = HPWindow.getInstance();
        window.setTitle("LTS Analyser");
        window.pack();
        HPWindow.centre(window);
        window.setVisible(true);
        if (args.length > 0) {
            SwingUtilities.invokeLater(new ScheduleOpenFile(window, args[0]));
        } else {
            window.currentDirectory = System.getProperty("user.dir");
        }
    }

    private boolean hasLTL2BuchiJar() {
        try {
            new Graph();
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public String getTransitions(String p_machine) {
        if (this.current.composition != null && this.current.composition.name.equals(p_machine)) {
            OutputBuffer x_ob = new OutputBuffer();
            new PrintTransitions(this.current.composition).print(x_ob);
            return x_ob.toString();
        }
        if (this.current != null && this.current.machines != null && this.current.machines.size() > 0) {
            Enumeration e = this.current.machines.elements();
            while (e.hasMoreElements()) {
                CompactState x_cs = (CompactState)e.nextElement();
                if (!x_cs.name.equals(p_machine)) continue;
                OutputBuffer x_ob = new OutputBuffer();
                new PrintTransitions(x_cs).print(x_ob);
                return x_ob.toString();
            }
        }
        return null;
    }

    public List getAlphabet(String p_machine) {
        ArrayList<String> x_alphabet = new ArrayList<String>();
        HashMap<String, CompactState> x_compact_states = new HashMap<String, CompactState>();
        if (this.current != null && this.current.machines != null && this.current.machines.size() > 0) {
            Enumeration e = this.current.machines.elements();
            while (e.hasMoreElements()) {
                CompactState x_cs = (CompactState)e.nextElement();
                x_compact_states.put(x_cs.name, x_cs);
            }
            if (this.current.composition != null) {
                x_compact_states.put(this.current.composition.name, this.current.composition);
            }
            if (x_compact_states.get(p_machine) != null) {
                String[] x_labels = ((Automata)x_compact_states.get(p_machine)).getAlphabet();
                int i = 0;
                while (i < x_labels.length) {
                    if (!x_labels[i].equals("tau")) {
                        x_alphabet.add(this.rewriteName(x_labels[i]));
                    }
                    ++i;
                }
            }
        }
        return x_alphabet;
    }

    private String rewriteName(String p_name) {
        StringBuffer x_buf = new StringBuffer(p_name);
        int i = 0;
        while (i < x_buf.length()) {
            if (x_buf.charAt(i) == '.' && Character.isDigit(x_buf.charAt(i + 1))) {
                x_buf.insert(i + 1, '[');
                x_buf.deleteCharAt(i);
                ++i;
                while (i < x_buf.length() && Character.isDigit(x_buf.charAt(i))) {
                    ++i;
                }
                x_buf = x_buf.insert(i, ']');
            }
            ++i;
        }
        return x_buf.toString();
    }

    public List getLTSNames() {
        ArrayList x_list = new ArrayList();
        Hashtable x_parse_result = this.doparse();
        if (x_parse_result != null) {
            Iterator i = x_parse_result.keySet().iterator();
            while (i.hasNext()) {
                x_list.add(i.next());
            }
        }
        return x_list;
    }

    public List getAllProcessNames() {
        ArrayList x_list = new ArrayList();
        this.fPos = -1;
        this.fSrc = String.valueOf(this.o_internal.toString()) + "\n" + this.input.getText();
        this.internal.setText(this.fSrc);
        LTSCompiler comp = new LTSCompiler(this, this, this.currentDirectory);
        Hashtable cs = new Hashtable();
        Hashtable ps = new Hashtable();
        try {
            comp.parse(cs, ps);
            x_list.addAll(ps.keySet());
        }
        catch (LTSException x) {
            this.displayError(x);
        }
        return x_list;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String p_directory) {
        this.currentDirectory = p_directory;
    }

    public UndoManager getUndoManager() {
        return this.undo;
    }

    public JEditorPane getInputPane() {
        return this.input;
    }

    public void setTargetChoice(String p_choice) {
        this.targetChoice.setSelectedItem(p_choice);
    }

    public boolean isCurrentStateNull() {
        return this.current == null;
    }

    public boolean isCurrentStateComposed() {
        return this.current.composition != null;
    }

    public void composeCurrentState() {
        this.current.compose(this);
    }

    public void analyseCurrentState() {
        this.current.analyse(this);
    }

    public void analyseCurrentStateNoDeadlockCheck() {
        this.current.analyse(this, false);
    }

    public Vector getCurrentStateErrorTrace() {
        Vector x_list = this.current.getErrorTrace();
        Vector<String> x_return = new Vector<String>();
        if (x_list == null) {
            return null;
        }
        Iterator i = x_list.iterator();
        while (i.hasNext()) {
            x_return.add(this.rewriteName((String)i.next()));
        }
        return x_return;
    }

    public void postCurrentState() {
        this.postState(this.current);
    }

    public void exportGraphic(Exportable p_exp) {
        FileDialog x_fd = new FileDialog((Frame)this, "Save file in:", 1);
        x_fd.show();
        String x_file = x_fd.getFile();
        if (this.file != null) {
            try {
                int i = x_file.indexOf(46, 0);
                x_file = String.valueOf(x_file.substring(0, i)) + "." + "pct";
                FileOutputStream x_fout = new FileOutputStream(String.valueOf(x_fd.getDirectory()) + x_file);
                ByteArrayOutputStream x_baos = new ByteArrayOutputStream(10000);
                Rectangle r = new Rectangle(0, 0, this.input.getSize().width, this.input.getSize().height);
                Gr2PICT x_pict = new Gr2PICT((OutputStream)x_baos, this.input.getGraphics(), r);
                p_exp.fileDraw(x_pict);
                x_pict.finalize();
                x_fout.write(x_baos.toByteArray());
                x_fout.flush();
                x_fout.close();
            }
            catch (IOException e) {
                System.out.println("Error saving file: " + e);
            }
        }
    }

    public Animator getAnimator() {
        return new Analyser(this.current, this, this.eman);
    }

    public void clearInternalBuffer() {
        this.o_internal = new StringBuffer();
        this.internal.setText("");
    }

    public void appendInternalBuffer(String p_str) {
        this.o_internal.append(p_str);
        this.internal.setText(this.o_internal.toString());
    }

    public Set getAllFluentDefinitions() {
        if (PredicateDefinition.getAll() == null) {
            return new HashSet();
        }
        return new HashSet(PredicateDefinition.getAll());
    }

    public void pluginAdded(ILTSAPlugin p_plugin) {
        System.out.println("adding " + p_plugin.getName() + " " + p_plugin);
        p_plugin.setLTSA(this);
        p_plugin.initialise();
        this.o_plugins.put(p_plugin.getName(), p_plugin);
        this.o_current_plugins.add(p_plugin);
        if (p_plugin.addAsTab()) {
            String x_name = p_plugin.getName();
            this.textIO.addTab(x_name, p_plugin.getComponent());
            this.textIO.setBackgroundAt(this.textIO.indexOfTab(x_name), Color.lightGray);
            JCheckBoxMenuItem x_menuitem = new JCheckBoxMenuItem(x_name);
            x_menuitem.addActionListener(new ToggleWindowAction(x_name));
            x_menuitem.setSelected(true);
            this.window.add(x_menuitem);
        }
        if (p_plugin.addToolbarButtons()) {
            this.tools.addSeparator();
            List x_buttons = p_plugin.getToolbarButtons();
            Iterator j = x_buttons.iterator();
            while (j.hasNext()) {
                LTSAButton x_lb = (LTSAButton)j.next();
                this.tools.add(x_lb);
                this.o_plugin_buttons.put(x_lb, p_plugin);
            }
        }
        if (p_plugin.addMenuItems()) {
            Map x_menu_items = p_plugin.getMenuItems();
            HashMap x_temp_menus = new HashMap();
            Iterator j = x_menu_items.keySet().iterator();
            while (j.hasNext()) {
                Object x_item = j.next();
                Object x_name = x_menu_items.get(x_item);
                if (x_temp_menus.get(x_name) == null) {
                    x_temp_menus.put(x_name, new ArrayList());
                }
                List x_list = (List)x_temp_menus.get(x_name);
                x_list.add(x_item);
            }
            j = x_temp_menus.keySet().iterator();
            while (j.hasNext()) {
                JMenu x_menu;
                String x_name = (String)j.next();
                List x_list = (List)x_temp_menus.get(x_name);
                if (this.o_menus.get(x_name) == null) {
                    x_menu = new JMenu(x_name);
                    this.o_menus.put(x_name, x_menu);
                    this.mb.add(x_menu);
                } else {
                    x_menu = (JMenu)this.o_menus.get(x_name);
                    x_menu.addSeparator();
                }
                Iterator k = x_list.iterator();
                while (k.hasNext()) {
                    x_menu.add((JMenuItem)k.next());
                }
            }
        }
        this.pack();
    }

    public void pluginAdded(EventClient p_ec) {
        this.o_event_listeners.add(p_ec);
        this.eman.addClient(p_ec);
    }

    public void pluginAdded(Initialisable p_init) {
        this.o_scenebeans_init = p_init;
    }

    class CloseWindow
    extends WindowAdapter {
        CloseWindow() {
        }

        public void windowClosing(WindowEvent e) {
            HPWindow.this.quitAll();
        }

        public void windowActivated(WindowEvent e) {
            if (HPWindow.this.animator != null) {
                HPWindow.this.animator.toFront();
            }
        }
    }

    class NewFileAction
    implements ActionListener {
        NewFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String x_tab = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            ILTSAPlugin x_plugin = (ILTSAPlugin)HPWindow.this.o_plugins.get(x_tab);
            if (x_plugin != null && x_plugin.providesNewFile()) {
                x_plugin.newFile();
                return;
            }
            HPWindow.this.undo.discardAllEdits();
            HPWindow.this.input.getDocument().removeUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.newFile();
            HPWindow.this.input.getDocument().addUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.updateDoState();
        }
    }

    class OpenFileAction
    implements ActionListener {
        OpenFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.undo.discardAllEdits();
            HPWindow.this.input.getDocument().removeUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.openAFile();
            HPWindow.this.input.getDocument().addUndoableEditListener(HPWindow.this.undoHandler);
            HPWindow.this.updateDoState();
        }
    }

    class SaveFileAction
    implements ActionListener {
        SaveFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String x_tab = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            if (x_tab.equals("Edit") || x_tab.equals("Output")) {
                HPWindow.this.saveFile();
            } else if (x_tab.equals("Alphabet")) {
                HPWindow.this.alphabet.saveFile();
            } else if (x_tab.equals("Transitions")) {
                HPWindow.this.prints.saveFile(HPWindow.this.currentDirectory, ".txt");
            } else if (x_tab.equals("Draw")) {
                HPWindow.this.draws.saveFile();
            } else {
                HPWindow.this.saveFile();
            }
        }
    }

    class SaveAsFileAction
    implements ActionListener {
        SaveAsFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.saveAsFile();
        }
    }

    class ExportFileAction
    implements ActionListener {
        ExportFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String pp = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            if (pp.equals("Edit")) {
                HPWindow.this.exportFile();
            } else if (pp.equals("Transitions")) {
                HPWindow.this.prints.saveAsPrism(HPWindow.this.currentDirectory, ".pm");
            }
        }
    }

    class ExitFileAction
    implements ActionListener {
        ExitFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.quitAll();
        }
    }

    class DoAction
    implements ActionListener {
        int actionCode;

        DoAction(int a) {
            this.actionCode = a;
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.do_action(this.actionCode);
        }
    }

    class OptionAction
    implements ActionListener {
        OptionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == HPWindow.this.setWarnings) {
                Diagnostics.warningFlag = HPWindow.this.setWarnings.isSelected();
            } else if (source == HPWindow.this.setWarningsAreErrors) {
                Diagnostics.warningsAreErrors = HPWindow.this.setWarningsAreErrors.isSelected();
            } else if (source == HPWindow.this.setFair) {
                ProgressCheck.strongFairFlag = HPWindow.this.setFair.isSelected();
            } else if (source == HPWindow.this.setPartialOrder) {
                Analyser.partialOrderReduction = HPWindow.this.setPartialOrder.isSelected();
            } else if (source == HPWindow.this.setObsEquiv) {
                Analyser.preserveObsEquiv = HPWindow.this.setObsEquiv.isSelected();
            } else if (source == HPWindow.this.setReduction) {
                CompositeState.reduceFlag = HPWindow.this.setReduction.isSelected();
            } else if (source == HPWindow.this.setBigFont) {
                AnimWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                AlphabetWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                if (HPWindow.this.alphabet != null) {
                    HPWindow.this.alphabet.setBigFont(HPWindow.this.setBigFont.isSelected());
                }
                PrintWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                if (HPWindow.this.prints != null) {
                    HPWindow.this.prints.setBigFont(HPWindow.this.setBigFont.isSelected());
                }
                LTSDrawWindow.fontFlag = HPWindow.this.setBigFont.isSelected();
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setBigFont(HPWindow.this.setBigFont.isSelected());
                }
                LTSCanvas.fontFlag = HPWindow.this.setBigFont.isSelected();
                Iterator i = HPWindow.this.o_plugins.values().iterator();
                while (i.hasNext()) {
                    ((ILTSAPlugin)i.next()).setBigFont(HPWindow.this.setBigFont.isSelected());
                }
                HPWindow.this.doFont();
            } else if (source == HPWindow.this.setDisplayName) {
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setDrawName(HPWindow.this.setDisplayName.isSelected());
                }
                LTSCanvas.displayName = HPWindow.this.setDisplayName.isSelected();
            } else if (source == HPWindow.this.setMultipleLTS) {
                boolean bl = LTSDrawWindow.singleMode = !HPWindow.this.setMultipleLTS.isSelected();
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setMode(LTSDrawWindow.singleMode);
                }
            } else if (source == HPWindow.this.setNewLabelFormat) {
                if (HPWindow.this.draws != null) {
                    HPWindow.this.draws.setNewLabelFormat(HPWindow.this.setNewLabelFormat.isSelected());
                }
                LTSCanvas.newLabelFormat = HPWindow.this.setNewLabelFormat.isSelected();
            } else if (source == HPWindow.this.setProbabilistic) {
                HPWindow.this.force_recompile = true;
            }
        }
    }

    class SuperTraceOptionListener
    implements ActionListener {
        SuperTraceOptionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.setSuperTraceOption();
        }
    }

    class WinAlphabetAction
    implements ActionListener {
        WinAlphabetAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.newAlphabetWindow(HPWindow.this.window_alpha.isSelected());
        }
    }

    class WinPrintAction
    implements ActionListener {
        WinPrintAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.newPrintWindow(HPWindow.this.window_print.isSelected());
        }
    }

    class WinDrawAction
    implements ActionListener {
        WinDrawAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.newDrawWindow(HPWindow.this.window_draw.isSelected());
        }
    }

    class WinHiddenAction
    implements ActionListener {
        WinHiddenAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.newCompileBuf(HPWindow.this.window_hidden.isSelected());
        }
    }

    class HelpAboutAction
    implements ActionListener {
        HelpAboutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.aboutDialog();
        }
    }

    class BlankAction
    implements ActionListener {
        BlankAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.blankit();
        }
    }

    class HelpManualAction
    implements ActionListener {
        HelpManualAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.displayManual(HPWindow.this.help_manual.isSelected());
        }
    }

    class StopAction
    implements ActionListener {
        StopAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (HPWindow.this.executer != null) {
                HPWindow.this.executer.stop();
                HPWindow.this.menuEnable(true);
                HPWindow.this.check_stop.setEnabled(false);
                HPWindow.this.stopTool.setEnabled(false);
                HPWindow.this.outln("\n\t-- stopped");
                HPWindow.this.executer = null;
            }
        }
    }

    class ExecuteAction
    implements ActionListener {
        String runtarget;

        ExecuteAction(String s) {
            this.runtarget = s;
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.run_menu = this.runtarget;
            HPWindow.this.do_action(3);
        }
    }

    class LivenessAction
    implements ActionListener {
        String asserttarget;

        LivenessAction(String s) {
            this.asserttarget = s;
        }

        public void actionPerformed(ActionEvent e) {
            HPWindow.this.asserted = this.asserttarget;
            HPWindow.this.do_action(9);
        }
    }

    class EditCutAction
    implements ActionListener {
        EditCutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String x_tab = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            ILTSAPlugin x_plugin = (ILTSAPlugin)HPWindow.this.o_plugins.get(x_tab);
            if (x_plugin != null && x_plugin.providesCut()) {
                x_plugin.cut();
            } else {
                HPWindow.this.input.cut();
            }
        }
    }

    class EditCopyAction
    implements ActionListener {
        EditCopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String x_tab = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            ILTSAPlugin x_plugin = (ILTSAPlugin)HPWindow.this.o_plugins.get(x_tab);
            if (x_plugin != null && x_plugin.providesCopy()) {
                x_plugin.copy();
            } else if (x_tab.equals("Edit")) {
                HPWindow.this.input.copy();
            } else if (x_tab.equals("Output")) {
                HPWindow.this.output.copy();
            } else if (x_tab.equals("Manual")) {
                HPWindow.this.manual.copy();
            } else if (x_tab.equals("Alphabet")) {
                HPWindow.this.alphabet.copy();
            } else if (x_tab.equals("Transitions")) {
                HPWindow.this.prints.copy();
            }
        }
    }

    class EditPasteAction
    implements ActionListener {
        EditPasteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String x_tab = HPWindow.this.textIO.getTitleAt(HPWindow.this.textIO.getSelectedIndex());
            ILTSAPlugin x_plugin = (ILTSAPlugin)HPWindow.this.o_plugins.get(x_tab);
            if (x_plugin != null && x_plugin.providesPaste()) {
                x_plugin.paste();
            } else {
                HPWindow.this.input.paste();
            }
        }
    }

    class TargetAction
    implements ActionListener {
        TargetAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String choice = (String)HPWindow.this.targetChoice.getSelectedItem();
            if (choice == null) {
                return;
            }
            HPWindow.this.run_enabled = MenuDefinition.enabled(choice);
            if (HPWindow.this.run_items != null && HPWindow.this.run_enabled != null && HPWindow.this.run_items.length == HPWindow.this.run_enabled.length) {
                int i = 0;
                while (i < HPWindow.this.run_items.length) {
                    HPWindow.this.run_items[i].setEnabled(HPWindow.this.run_enabled[i]);
                    ++i;
                }
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            HPWindow.this.undo.addEdit(e.getEdit());
            HPWindow.this.updateDoState();
        }
    }

    class UndoAction
    implements ActionListener {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                HPWindow.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {}
            HPWindow.this.updateDoState();
        }
    }

    class RedoAction
    implements ActionListener {
        RedoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                HPWindow.this.undo.redo();
            }
            catch (CannotUndoException cannotUndoException) {}
            HPWindow.this.updateDoState();
        }
    }

    class TabChange
    implements ChangeListener {
        TabChange() {
        }

        public void stateChanged(ChangeEvent e) {
            int i = HPWindow.this.textIO.getSelectedIndex();
            if (i == HPWindow.this.tabindex) {
                return;
            }
            HPWindow.this.textIO.setBackgroundAt(i, Color.green);
            HPWindow.this.textIO.setBackgroundAt(HPWindow.this.tabindex, Color.lightGray);
            HPWindow.this.tabindex = i;
            HPWindow.this.setEditControls(HPWindow.this.tabindex);
        }
    }

    class RequestFocus
    implements Runnable {
        RequestFocus() {
        }

        public void run() {
            HPWindow.this.input.requestFocusInWindow();
        }
    }

    class OutputAppend
    implements Runnable {
        String text;

        OutputAppend(String text) {
            this.text = text;
        }

        public void run() {
            HPWindow.this.output.append(this.text);
        }
    }

    class OutputClear
    implements Runnable {
        OutputClear() {
        }

        public void run() {
            HPWindow.this.output.setText("");
        }
    }

    class OutputShow
    implements Runnable {
        OutputShow() {
        }

        public void run() {
            HPWindow.this.swapto(1);
        }
    }

    class ToggleWindowAction
    implements ActionListener {
        private String o_name;

        ToggleWindowAction(String p_name) {
            this.o_name = p_name;
        }

        public void actionPerformed(ActionEvent p_ae) {
            JCheckBoxMenuItem x_mi = (JCheckBoxMenuItem)p_ae.getSource();
            if (!x_mi.isSelected()) {
                HPWindow.this.textIO.remove(HPWindow.this.textIO.indexOfTab(this.o_name));
            } else {
                HPWindow.this.textIO.add(this.o_name, ((ILTSAPlugin)HPWindow.this.o_plugins.get(this.o_name)).getComponent());
            }
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                try {
                    URL u = e.getURL();
                    pane.setPage(u);
                }
                catch (Throwable throwable) {
                    HPWindow.this.outln("" + e);
                }
            }
        }
    }

    static class ScheduleOpenFile
    implements Runnable {
        HPWindow window;
        String arg;

        ScheduleOpenFile(HPWindow window, String arg) {
            this.window = window;
            this.arg = arg;
        }

        public void run() {
            this.window.doOpenFile("", this.arg, false);
        }
    }
}

