/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.custom;

import ic.doc.ltsa.custom.AnimationAction;
import ic.doc.ltsa.custom.AnimationMessage;
import ic.doc.ltsa.custom.Relation;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OutputActionRegistry {
    Hashtable outputs = new Hashtable();
    Relation actionMap;
    AnimationMessage msg;

    public OutputActionRegistry(Relation actionMap, AnimationMessage msg) {
        this.actionMap = actionMap;
        this.msg = msg;
    }

    public void register(String name, AnimationAction action) {
        Vector<AnimationAction> a = (Vector<AnimationAction>)this.outputs.get(name);
        if (a != null) {
            a.addElement(action);
        } else {
            a = new Vector<AnimationAction>();
            a.addElement(action);
            this.outputs.put(name, a);
        }
    }

    public void doAction(String name) {
        this.msg.traceMsg(name);
        Object o = this.actionMap.get(name);
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            this.execute((String)o);
        } else {
            Vector a = (Vector)o;
            Enumeration e = a.elements();
            while (e.hasMoreElements()) {
                this.execute((String)e.nextElement());
            }
        }
    }

    private void execute(String name) {
        this.msg.debugMsg("-action -" + name);
        Vector a = (Vector)this.outputs.get(name);
        if (a == null) {
            return;
        }
        Enumeration e = a.elements();
        while (e.hasMoreElements()) {
            AnimationAction action = (AnimationAction)e.nextElement();
            action.action();
        }
    }
}

