/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.eclipse.fsp;

import ic.doc.ltsa.eclipse.fsp.IFSPSyntax;
import ic.doc.ltsa.eclipse.utils.WordPartDetector;
import java.util.Iterator;
import java.util.Vector;
import ltsaeclipse.ltsaeclipsePlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class FSPCompletionProcessor
implements IContentAssistProcessor,
IFSPSyntax {
    protected Vector proposalList = new Vector();
    protected IContextInformationValidator fValidator = new Validator();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        WordPartDetector wordPart = new WordPartDetector(viewer, documentOffset);
        int i = 0;
        while (i < allWords.length) {
            String[] list = (String[])allWords[i];
            int y = 0;
            while (y < list.length) {
                if (list[y].startsWith(wordPart.getString().toUpperCase())) {
                    this.proposalList.add(list[y]);
                }
                ++y;
            }
            ++i;
        }
        return this.turnProposalVectorIntoAdaptedArray(wordPart);
    }

    private void showMessage(String message) {
        MessageDialog.openInformation(null, (String)"Sample View", (String)message);
    }

    protected ICompletionProposal[] turnProposalVectorIntoAdaptedArray(WordPartDetector word) {
        ICompletionProposal[] result = new ICompletionProposal[this.proposalList.size()];
        int index = 0;
        Iterator i = this.proposalList.iterator();
        while (i.hasNext()) {
            String keyWord = (String)i.next();
            ContextInformation info = new ContextInformation(keyWord, this.getContentInfoString(keyWord));
            result[index] = new CompletionProposal(keyWord, word.getOffset(), word.getString().length(), keyWord.length(), null, keyWord, (IContextInformation)info, this.getContentInfoString(keyWord));
            ++index;
        }
        this.proposalList.removeAllElements();
        return result;
    }

    private String getContentInfoString(String keyWord) {
        String resourceKey = "ContextString." + keyWord;
        ltsaeclipsePlugin.getDefault();
        String resourceString = ltsaeclipsePlugin.getResourceString(resourceKey);
        if (resourceString == keyWord) {
            resourceString = "No Context Info String";
        }
        return resourceString;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        new WordPartDetector(viewer, documentOffset);
        IContextInformation[] result = new IContextInformation[]{new ContextInformation("contextDisplayString", "informationDisplayString"), new ContextInformation("contextDisplayString2", "informationDisplayString2")};
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

