/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Animator;
import ic.doc.ltsa.HPWindow;
import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.Automata;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSEvent;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MyHashQueue;
import ic.doc.ltsa.lts.MyHashQueueEntry;
import ic.doc.ltsa.lts.MyHashStack;
import ic.doc.ltsa.lts.MyList;
import ic.doc.ltsa.lts.PartialOrder;
import ic.doc.ltsa.lts.StackCheck;
import ic.doc.ltsa.lts.StackChecker;
import ic.doc.ltsa.lts.StateCodec;
import ic.doc.ltsa.lts.ltl.FluentTrace;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class Analyser
implements Animator,
Automata {
    private CompositeState cs;
    private CompactState[] sm;
    private LTSOutput output;
    private Hashtable alphabet = new Hashtable();
    private Hashtable actionMap = new Hashtable();
    private int[] actionCount;
    private String[] actionName;
    private int Nmach;
    private int[] Mbase;
    private MyHashStack analysed;
    private int stateNo = 0;
    private int stateCount = 0;
    private boolean[] violated;
    private boolean deadlockDetected = false;
    private static final int SUCCESS = 0;
    private static final int DEADLOCK = 1;
    private static final int ERROR = 2;
    private static final int FOUND = 3;
    private EventManager eman;
    private boolean lowpriority = true;
    private Vector priorLabels = null;
    private BitSet highAction = null;
    private int acceptEvent = -1;
    private int asteriskEvent = -1;
    private BitSet visible;
    private StateCodec coder;
    private boolean canTerminate = false;
    public static boolean partialOrderReduction = false;
    public static boolean preserveObsEquiv = true;
    private PartialOrder partial = null;
    private MyList compTrans;
    private int endSequence = -99999;
    LinkedList trace;
    int errorMachine;
    PartialOrder savedPartial = null;
    private String[] menuAlpha;
    private Hashtable actionToIndex;
    private Hashtable indexToAction;
    private int[] currentA;
    private volatile List choices;
    private boolean errorState = false;
    private Enumeration _replay = null;
    private String _replayAction = null;
    int theChoice = 0;
    Random rand = new Random();

    public Analyser(CompositeState cs, LTSOutput output, EventManager eman) {
        this(cs, output, eman, false);
    }

    public Analyser(CompositeState cs, LTSOutput output, EventManager eman, boolean ia) {
        this.cs = cs;
        this.output = output;
        this.eman = eman;
        if (cs.priorityLabels != null) {
            this.lowpriority = cs.priorityIsLow;
            this.priorLabels = cs.priorityLabels;
            this.highAction = new BitSet();
        }
        this.sm = new CompactState[cs.machines.size()];
        this.violated = new boolean[cs.machines.size()];
        Enumeration<Object> e = cs.machines.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.sm[i] = ((CompactState)e.nextElement()).myclone();
            ++i;
        }
        this.Nmach = this.sm.length;
        output.outln("Composition:");
        output.out(String.valueOf(cs.name) + " = ");
        i = 0;
        while (i < this.sm.length) {
            output.out(this.sm[i].name);
            if (i < this.sm.length - 1) {
                output.out(" || ");
            }
            ++i;
        }
        output.outln("");
        if (this.priorLabels != null) {
            if (this.lowpriority) {
                output.out("\t>> ");
            } else {
                output.out("\t<< ");
            }
            output.outln(new Alphabet(cs.priorityLabels).toString());
        }
        this.Mbase = new int[this.Nmach];
        output.outln("State Space:");
        i = 0;
        while (i < this.sm.length) {
            output.out(" " + this.sm[i].maxStates + " ");
            if (i < this.sm.length - 1) {
                output.out("*");
            }
            this.Mbase[i] = this.sm[i].maxStates;
            ++i;
        }
        this.coder = new StateCodec(this.Mbase);
        output.outln("= 2 ** " + this.coder.bits());
        HashSet<String> terminating = new HashSet<String>();
        HashSet<String> nonterminating = new HashSet<String>();
        Counter newLabel = new Counter(0);
        int i2 = 0;
        while (i2 < this.sm.length) {
            int j = 0;
            while (j < this.sm[i2].alphabet.length) {
                if (this.sm[i2].endseq > 0) {
                    terminating.add(this.sm[i2].alphabet[j]);
                } else {
                    nonterminating.add(this.sm[i2].alphabet[j]);
                }
                BitSet b = (BitSet)this.alphabet.get(this.sm[i2].alphabet[j]);
                if (b == null) {
                    b = new BitSet();
                    b.set(i2);
                    String s = this.sm[i2].alphabet[j];
                    this.alphabet.put(s, b);
                    this.actionMap.put(s, newLabel.label());
                } else {
                    b.set(i2);
                }
                ++j;
            }
            ++i2;
        }
        this.canTerminate = terminating.containsAll(nonterminating);
        this.actionName = new String[this.alphabet.size()];
        this.actionCount = new int[this.alphabet.size()];
        e = this.alphabet.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            BitSet b = (BitSet)this.alphabet.get(s);
            int index = (Integer)this.actionMap.get(s);
            this.actionName[index] = s;
            this.actionCount[index] = this.countSet(b);
            if (s.charAt(0) == '@') {
                this.acceptEvent = index;
            } else if (s.equals("*") && !ia) {
                this.asteriskEvent = index;
            }
            if (this.highAction == null) continue;
            if (!this.lowpriority) {
                if (!CompactState.contains(s, this.priorLabels)) continue;
                this.highAction.set(index);
                continue;
            }
            if (CompactState.contains(s, this.priorLabels)) continue;
            this.highAction.set(index);
        }
        if (this.highAction != null) {
            if (this.lowpriority) {
                this.highAction.set(0);
            } else {
                this.highAction.clear(0);
            }
            if (this.acceptEvent > 0) {
                this.highAction.clear(this.acceptEvent);
            }
        }
        this.actionCount[0] = 0;
        i = 0;
        while (i < this.sm.length) {
            int j = 0;
            while (j < this.sm[i].maxStates) {
                EventState p = this.sm[i].states[j];
                while (p != null) {
                    EventState tr = p;
                    tr.machine = i;
                    tr.event = (Integer)this.actionMap.get(this.sm[i].alphabet[tr.event]);
                    while (tr.nondet != null) {
                        tr.nondet.event = tr.event;
                        tr.nondet.machine = tr.machine;
                        tr = tr.nondet;
                    }
                    p = p.list;
                }
                ++j;
            }
            ++i;
        }
        this.visible = new BitSet(this.actionName.length);
        i = 1;
        while (i < this.actionName.length) {
            if (cs.hidden == null) {
                this.visible.set(i);
            } else if (cs.exposeNotHide) {
                if (CompactState.contains(this.actionName[i], cs.hidden)) {
                    this.visible.set(i);
                }
            } else if (!CompactState.contains(this.actionName[i], cs.hidden)) {
                this.visible.set(i);
            }
            ++i;
        }
    }

    public CompactState compose() {
        return this.private_compose(true);
    }

    public CompactState composeNoHide() {
        return this.private_compose(false);
    }

    private CompactState private_compose(boolean dohiding) {
        this.output.outln("Composing...");
        long start = System.currentTimeMillis();
        this.newState_compose();
        CompactState c = new CompactState(this.stateCount, this.cs.name, this.analysed, this.compTrans, this.actionName, this.endSequence);
        if (dohiding && this.cs.hidden != null) {
            if (!this.cs.exposeNotHide) {
                c.conceal(this.cs.hidden);
            } else {
                c.expose(this.cs.hidden);
            }
        }
        long finish = System.currentTimeMillis();
        this.outStatistics(this.stateCount, this.compTrans.size());
        this.output.outln("Composed in " + (finish - start) + "ms");
        this.analysed = null;
        this.compTrans = null;
        return c;
    }

    public void analyse(FluentTrace tracer) {
        this.output.outln("Analysing...");
        System.gc();
        long start = System.currentTimeMillis();
        int ret = this.newState_analyse(this.coder.zero(), null);
        long finish = System.currentTimeMillis();
        if (ret == 1) {
            this.output.outln("Trace to DEADLOCK:");
            tracer.print(this.output, this.trace, true);
        } else if (ret == 2) {
            this.output.outln("Trace to property violation in " + this.sm[this.errorMachine].name + ":");
            tracer.print(this.output, this.trace, true);
        } else {
            this.output.outln("No deadlocks/errors");
        }
        this.output.outln("Analysed in: " + (finish - start) + "ms");
    }

    public void analyse() {
        this.output.outln("Analysing...");
        System.gc();
        long start = System.currentTimeMillis();
        int ret = this.newState_analyse(this.coder.zero(), null);
        long finish = System.currentTimeMillis();
        if (ret == 1) {
            this.output.outln("Trace to DEADLOCK:");
            this.printPath(this.trace);
        } else if (ret == 2) {
            this.output.outln("Trace to property violation in " + this.sm[this.errorMachine].name + ":");
            this.printPath(this.trace);
        } else {
            this.output.outln("No deadlocks/errors");
        }
        this.output.outln("Analysed in: " + (finish - start) + "ms");
    }

    public List getErrorTrace() {
        return this.trace;
    }

    private int countSet(BitSet b) {
        int count = 0;
        int i = 0;
        while (i < b.size()) {
            if (b.get(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean isEND(int[] state) {
        if (!this.canTerminate) {
            return false;
        }
        int i = 0;
        while (i < this.Nmach) {
            if (this.sm[i].endseq >= 0 && this.sm[i].endseq != state[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void printState(int[] state) {
        this.output.out("[");
        int i = 0;
        while (i < state.length) {
            this.output.out("" + state[i]);
            if (i < state.length - 1) {
                this.output.out(",");
            }
            ++i;
        }
        this.output.out("]");
    }

    private int[] myclone(int[] x) {
        int[] tmp = new int[x.length];
        int i = 0;
        while (i < x.length) {
            tmp[i] = x[i];
            ++i;
        }
        return tmp;
    }

    List eligibleTransitions(int[] state) {
        EventState tr;
        List parTrans;
        ArrayList<int[]> asteriskTransitions = null;
        if (!(this.partial == null || this.asteriskEvent > 0 && EventState.hasEvent(this.sm[this.Nmach - 1].states[state[this.Nmach - 1]], this.asteriskEvent) || (parTrans = this.partial.transitions(state)) == null)) {
            return parTrans;
        }
        int[] ac = this.myclone(this.actionCount);
        EventState[] trs = new EventState[this.actionCount.length];
        int nsucc = 0;
        int highs = 0;
        int i = 0;
        while (i < this.Nmach) {
            EventState p = this.sm[i].states[state[i]];
            while (p != null) {
                tr = p;
                tr.path = trs[tr.event];
                trs[tr.event] = tr;
                int n = tr.event;
                ac[n] = ac[n] - 1;
                if (tr.event != 0 && ac[tr.event] == 0) {
                    ++nsucc;
                    if (this.highAction != null && this.highAction.get(tr.event) && tr.event != this.asteriskEvent) {
                        ++highs;
                    }
                }
                p = p.list;
            }
            ++i;
        }
        if (nsucc == 0 && trs[0] == null) {
            return null;
        }
        int actionNo = 1;
        ArrayList<int[]> transitions = new ArrayList<int[]>(8);
        if (trs[0] != null) {
            boolean highTau;
            boolean bl = highTau = this.highAction != null && this.highAction.get(0);
            if (highTau || highs == 0) {
                this.computeTauTransitions(trs[0], state, transitions);
            }
            if (highTau) {
                ++highs;
            }
        }
        while (nsucc > 0) {
            --nsucc;
            while (ac[actionNo] > 0) {
                ++actionNo;
            }
            if (highs <= 0 || this.highAction.get(actionNo) || actionNo == this.acceptEvent) {
                tr = trs[actionNo];
                boolean nonDeterministic = false;
                while (tr != null) {
                    if (tr.nondet != null) {
                        nonDeterministic = true;
                        break;
                    }
                    tr = tr.path;
                }
                tr = trs[actionNo];
                if (!nonDeterministic) {
                    int[] next = this.myclone(state);
                    next[this.Nmach] = actionNo;
                    while (tr != null) {
                        next[tr.machine] = tr.next;
                        tr = tr.path;
                    }
                    if (actionNo != this.asteriskEvent) {
                        transitions.add(next);
                    } else {
                        asteriskTransitions = new ArrayList(1);
                        asteriskTransitions.add(next);
                    }
                } else if (actionNo != this.asteriskEvent) {
                    this.computeNonDetTransitions(tr, state, transitions);
                } else {
                    asteriskTransitions = new ArrayList<int[]>(4);
                    this.computeNonDetTransitions(tr, state, asteriskTransitions);
                }
            }
            int n = actionNo;
            ac[n] = ac[n] + 1;
        }
        if (this.asteriskEvent < 0) {
            return transitions;
        }
        return this.mergeAsterisk(transitions, asteriskTransitions);
    }

    private void computeTauTransitions(EventState first, int[] state, List v) {
        EventState down = first;
        while (down != null) {
            EventState across = down;
            while (across != null) {
                int[] next = this.myclone(state);
                next[across.machine] = across.next;
                next[this.Nmach] = 0;
                v.add(next);
                across = across.nondet;
            }
            down = down.path;
        }
    }

    private void computeNonDetTransitions(EventState first, int[] state, List v) {
        EventState tr = first;
        while (tr != null) {
            int[] next = this.myclone(state);
            next[tr.machine] = tr.next;
            if (first.path != null) {
                this.computeNonDetTransitions(first.path, next, v);
            } else {
                next[this.Nmach] = first.event;
                v.add(next);
            }
            tr = tr.nondet;
        }
    }

    List mergeAsterisk(List transitions, List asteriskTransitions) {
        if (transitions == null || asteriskTransitions == null) {
            return transitions;
        }
        if (transitions.size() == 0) {
            return null;
        }
        if (asteriskTransitions.size() == 1) {
            int[] asteriskTransition = (int[])asteriskTransitions.get(0);
            Iterator e = transitions.iterator();
            while (e.hasNext()) {
                int[] next = (int[])e.next();
                if (this.visible.get(next[this.Nmach])) continue;
                next[this.Nmach - 1] = asteriskTransition[this.Nmach - 1];
            }
            return transitions;
        }
        Iterator a = asteriskTransitions.iterator();
        ArrayList<int[]> newTransitions = new ArrayList<int[]>();
        while (a.hasNext()) {
            int[] asteriskTransition = (int[])a.next();
            Iterator e = transitions.iterator();
            while (e.hasNext()) {
                int[] next = (int[])e.next();
                if (!this.visible.get(next[this.Nmach])) {
                    next[this.Nmach - 1] = asteriskTransition[this.Nmach - 1];
                }
                newTransitions.add(this.myclone(next));
            }
        }
        return newTransitions;
    }

    private void outStatistics(int states, int transitions) {
        Runtime r = Runtime.getRuntime();
        this.output.outln("-- States: " + states + " Transitions: " + transitions + " Memory used: " + (r.totalMemory() - r.freeMemory()) / 1000L + "K");
        HPWindow x_hp = HPWindow.getInstance();
        x_hp.setStatesExplored(states);
        x_hp.setTransitionsTaken(transitions);
    }

    private int newState_compose() {
        System.gc();
        this.analysed = new MyHashStack(100001);
        if (partialOrderReduction) {
            this.partial = new PartialOrder(this.alphabet, this.actionName, this.sm, new StackChecker(this.coder, this.analysed), this.cs.hidden, this.cs.exposeNotHide, preserveObsEquiv, this.highAction);
        }
        this.compTrans = new MyList();
        this.stateCount = 0;
        this.analysed.pushPut(this.coder.zero());
        while (!this.analysed.empty()) {
            List transitions;
            if (this.analysed.marked()) {
                this.analysed.pop();
                continue;
            }
            int[] state = this.coder.decode(this.analysed.peek());
            this.analysed.mark(this.stateCount++);
            if (this.stateCount % 10000 == 0) {
                this.output.out("Depth " + this.analysed.getDepth() + " ");
                this.outStatistics(this.stateCount, this.compTrans.size());
            }
            if ((transitions = this.eligibleTransitions(state)) == null) {
                if (!this.isEND(state)) {
                    if (!this.deadlockDetected) {
                        this.output.outln("  potential DEADLOCK");
                    }
                    this.deadlockDetected = true;
                    continue;
                }
                if (this.endSequence < 0) {
                    this.endSequence = this.stateCount - 1;
                    continue;
                }
                this.analysed.mark(this.endSequence);
                --this.stateCount;
                continue;
            }
            Iterator e = transitions.iterator();
            while (e.hasNext()) {
                int[] next = (int[])e.next();
                byte[] code = this.coder.encode(next);
                this.compTrans.add(this.stateCount - 1, code, next[this.Nmach]);
                if (code == null) {
                    int i = 0;
                    while (next[i] >= 0) {
                        ++i;
                    }
                    if (!this.violated[i]) {
                        this.output.outln("  property " + this.sm[i].name + " violation.");
                    }
                    this.violated[i] = true;
                    continue;
                }
                if (this.analysed.containsKey(code)) continue;
                this.analysed.pushPut(code);
            }
        }
        return 0;
    }

    private void printPath(LinkedList v) {
        Iterator t = v.iterator();
        while (t.hasNext()) {
            this.output.outln("\t" + (String)t.next());
        }
    }

    private int newState_analyse(byte[] fromState, byte[] target) {
        this.stateCount = 0;
        int nTrans = 0;
        MyHashQueue hh = new MyHashQueue(100001);
        if (partialOrderReduction) {
            this.partial = new PartialOrder(this.alphabet, this.actionName, this.sm, new StackChecker(this.coder, hh), this.cs.hidden, this.cs.exposeNotHide, false, this.highAction);
        }
        hh.addPut(fromState, 0, null);
        new Integer(-1);
        Runtime.getRuntime();
        MyHashQueueEntry qe = null;
        while (!hh.empty()) {
            qe = hh.peek();
            fromState = qe.key;
            int[] state = this.coder.decode(fromState);
            ++this.stateCount;
            if (this.stateCount % 10000 == 0) {
                this.output.out("Depth " + hh.depth(qe) + " ");
                this.outStatistics(this.stateCount, nTrans);
            }
            List transitions = this.eligibleTransitions(state);
            hh.pop();
            if (transitions == null) {
                if (this.isEND(state)) continue;
                this.output.out("Depth " + hh.depth(qe) + " ");
                this.outStatistics(this.stateCount, nTrans);
                this.trace = hh.getPath(qe, this.actionName);
                return 1;
            }
            Iterator e = transitions.iterator();
            while (e.hasNext()) {
                int[] next = (int[])e.next();
                byte[] code = this.coder.encode(next);
                ++nTrans;
                if (code == null || StateCodec.equals(code, target)) {
                    this.output.out("Depth " + hh.depth(qe) + " ");
                    this.outStatistics(this.stateCount, nTrans);
                    if (code == null) {
                        int i = 0;
                        while (next[i] >= 0) {
                            ++i;
                        }
                        this.errorMachine = i;
                    }
                    this.trace = hh.getPath(qe, this.actionName);
                    this.trace.add(this.actionName[next[this.Nmach]]);
                    if (code == null) {
                        return 2;
                    }
                    return 3;
                }
                if (hh.containsKey(code)) continue;
                hh.addPut(code, next[this.Nmach], qe);
            }
        }
        this.output.out("Depth " + hh.depth(qe) + " ");
        this.outStatistics(this.stateCount, nTrans);
        return 0;
    }

    public String[] getAlphabet() {
        return this.actionName;
    }

    public MyList getTransitions(byte[] state) {
        List ex = this.eligibleTransitions(this.coder.decode(state));
        MyList trs = new MyList();
        if (ex == null) {
            return trs;
        }
        Iterator e = ex.iterator();
        while (e.hasNext()) {
            int[] next = (int[])e.next();
            byte[] code = this.coder.encode(next);
            if (code == null) {
                int i = 0;
                while (next[i] >= 0) {
                    ++i;
                }
                this.errorMachine = i;
            }
            trs.add(0, code, next[this.Nmach]);
        }
        return trs;
    }

    public boolean isAccepting(byte[] state) {
        if (this.acceptEvent < 0) {
            return false;
        }
        int[] ds = this.coder.decode(state);
        return EventState.hasEvent(this.sm[this.Nmach - 1].states[ds[this.Nmach - 1]], this.acceptEvent);
    }

    public String getViolatedProperty() {
        return this.sm[this.errorMachine].name;
    }

    public Vector getTraceToState(byte[] from, byte[] to) {
        if (StateCodec.equals(from, to)) {
            return new Vector();
        }
        int ret = this.newState_analyse(from, to);
        if (ret == 3) {
            Vector v = new Vector();
            v.addAll(this.trace);
            return v;
        }
        return null;
    }

    public boolean END(byte[] state) {
        return this.isEND(this.coder.decode(state));
    }

    public byte[] START() {
        return this.coder.zero();
    }

    public void setStackChecker(StackCheck s) {
        if (partialOrderReduction) {
            this.partial = new PartialOrder(this.alphabet, this.actionName, this.sm, new StackChecker(this.coder, s), this.cs.hidden, this.cs.exposeNotHide, false, this.highAction);
        }
    }

    public boolean isPartialOrder() {
        return partialOrderReduction;
    }

    public void disablePartialOrder() {
        this.savedPartial = this.partial;
        this.partial = null;
    }

    public void enablePartialOrder() {
        this.partial = this.savedPartial;
    }

    private void getMenuHash() {
        this.actionToIndex = new Hashtable();
        this.indexToAction = new Hashtable();
        int i = 1;
        while (i < this.menuAlpha.length) {
            Integer index = new Integer(i);
            Integer actionNo = (Integer)this.actionMap.get(this.menuAlpha[i]);
            this.actionToIndex.put(actionNo, index);
            this.indexToAction.put(index, actionNo);
            ++i;
        }
    }

    private void getMenu(Vector a) {
        if (a != null) {
            Vector<String> validAction = new Vector<String>();
            Enumeration e = a.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (!this.alphabet.containsKey(s)) continue;
                validAction.addElement(s);
            }
            this.menuAlpha = new String[validAction.size() + 1];
            this.menuAlpha[0] = "tau";
            int i = 1;
            while (i < this.menuAlpha.length) {
                this.menuAlpha[i] = (String)validAction.elementAt(i - 1);
                ++i;
            }
        } else {
            this.menuAlpha = this.actionName;
        }
        this.getMenuHash();
    }

    private BitSet menuActions() {
        BitSet b = new BitSet(this.menuAlpha.length);
        if (this.choices != null) {
            Iterator e = this.choices.iterator();
            while (e.hasNext()) {
                int[] next = (int[])e.next();
                Integer actionNo = new Integer(next[this.Nmach]);
                Integer index = (Integer)this.actionToIndex.get(actionNo);
                if (index == null) continue;
                b.set(index);
            }
        }
        return b;
    }

    private BitSet allActions() {
        BitSet b = new BitSet(this.actionCount.length);
        if (this.choices != null) {
            Iterator e = this.choices.iterator();
            while (e.hasNext()) {
                int[] next = (int[])e.next();
                b.set(next[this.Nmach]);
            }
        }
        return b;
    }

    public BitSet initialise(Vector menu) {
        this.currentA = this.coder.decode(this.coder.zero());
        this.choices = this.eligibleTransitions(this.currentA);
        if (this.eman != null) {
            this.eman.post(new LTSEvent(0, this.currentA));
        }
        this.getMenu(menu);
        if (this.cs.getErrorTrace() != null) {
            this._replay = this.cs.getErrorTrace().elements();
            if (this._replay.hasMoreElements()) {
                this._replayAction = (String)this._replay.nextElement();
            }
        }
        return this.menuActions();
    }

    public BitSet singleStep() {
        if (this.errorState) {
            return null;
        }
        if (this.nonMenuChoice()) {
            this.currentA = this.step(this.randomNonMenuChoice());
            if (this.errorState) {
                return null;
            }
            this.choices = this.eligibleTransitions(this.currentA);
        }
        return this.menuActions();
    }

    public BitSet menuStep(int choice) {
        if (this.errorState) {
            return null;
        }
        this.theChoice = (Integer)this.indexToAction.get(new Integer(choice));
        this.currentA = this.step(this.theChoice);
        if (this.errorState) {
            return null;
        }
        this.choices = this.eligibleTransitions(this.currentA);
        return this.menuActions();
    }

    public int actionChosen() {
        return this.theChoice;
    }

    public String actionNameChosen() {
        return this.actionName[this.theChoice];
    }

    public boolean nonMenuChoice() {
        if (this.errorState) {
            return false;
        }
        BitSet b = this.allActions();
        int i = 0;
        while (i < b.size()) {
            if (b.get(i) && !this.actionToIndex.containsKey(new Integer(i))) {
                this.theChoice = i;
                return true;
            }
            ++i;
        }
        return false;
    }

    private int randomNonMenuChoice() {
        BitSet b = this.allActions();
        ArrayList<Integer> nmc = new ArrayList<Integer>(8);
        int i = 0;
        while (i < b.size()) {
            Integer II = new Integer(i);
            if (b.get(i) && !this.actionToIndex.containsKey(II)) {
                nmc.add(II);
            }
            ++i;
        }
        i = Math.abs(this.rand.nextInt()) % nmc.size();
        this.theChoice = (Integer)nmc.get(i);
        return this.theChoice;
    }

    public boolean traceChoice() {
        if (this.errorState) {
            return false;
        }
        if (this._replay == null) {
            return false;
        }
        if (this._replayAction != null) {
            int i = (Integer)this.actionMap.get(this._replayAction);
            BitSet b = this.allActions();
            if (b.get(i)) {
                this.theChoice = i;
                return true;
            }
        }
        return false;
    }

    public boolean hasErrorTrace() {
        return this.cs.getErrorTrace() != null;
    }

    public BitSet traceStep() {
        if (this.errorState) {
            return null;
        }
        if (this.traceChoice()) {
            this.currentA = this.step(this.theChoice);
            if (this.errorState) {
                return null;
            }
            this.choices = this.eligibleTransitions(this.currentA);
            this._replayAction = this._replay.hasMoreElements() ? (String)this._replay.nextElement() : null;
        }
        return this.menuActions();
    }

    public boolean isError() {
        return this.errorState;
    }

    public boolean isEnd() {
        return this.isEND(this.currentA);
    }

    private int[] thestep(int action) {
        if (this.errorState) {
            return this.currentA;
        }
        if (this.choices == null) {
            this.output.outln("DEADLOCK");
            this.errorState = true;
            return this.currentA;
        }
        Iterator e = this.choices.iterator();
        while (e.hasNext()) {
            int[] next = (int[])e.next();
            if (next[this.Nmach] != action) continue;
            boolean bl = this.errorState = this.coder.encode(next = this.nonDetSelect(next)) == null;
            if (this.errorState) {
                return next;
            }
            this.currentA = next;
            return next;
        }
        return this.currentA;
    }

    private int[] step(int action) {
        int[] tmp = this.thestep(action);
        if (this.eman != null) {
            this.eman.post(new LTSEvent(0, tmp, this.actionName[action]));
        }
        return tmp;
    }

    int[] nonDetSelect(int[] x) {
        int start = this.choices.indexOf(x);
        int last = start + 1;
        while (last < this.choices.size() && x[this.Nmach] == ((int[])this.choices.get(last))[this.Nmach]) {
            ++last;
        }
        if (start + 1 == last) {
            return x;
        }
        int i = start + Math.abs(this.rand.nextInt()) % (last - start);
        return (int[])this.choices.get(i);
    }

    public String[] getMenuNames() {
        return this.menuAlpha;
    }

    public String[] getAllNames() {
        return this.actionName;
    }

    public boolean getPriority() {
        return this.lowpriority;
    }

    public BitSet getPriorityActions() {
        if (this.priorLabels == null) {
            return null;
        }
        BitSet b = new BitSet();
        int i = 1;
        while (i < this.actionName.length) {
            Integer ix = (Integer)this.actionToIndex.get(new Integer(i));
            if (ix != null && (this.lowpriority && !this.highAction.get(i) || !this.lowpriority && this.highAction.get(i))) {
                b.set(ix);
            }
            ++i;
        }
        return b;
    }

    public void message(String msg) {
        this.output.outln(msg);
    }
}

