/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ActionExpr;
import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.ActionName;
import ic.doc.ltsa.lts.ActionRange;
import ic.doc.ltsa.lts.ActionSet;
import ic.doc.ltsa.lts.ActionSetExpr;
import ic.doc.ltsa.lts.ActionVarRange;
import ic.doc.ltsa.lts.ActionVarSet;
import ic.doc.ltsa.lts.AutCompactState;
import ic.doc.ltsa.lts.ChoiceElement;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeBody;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.CompositionExpression;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.Lex;
import ic.doc.ltsa.lts.MenuDefinition;
import ic.doc.ltsa.lts.ProcessRef;
import ic.doc.ltsa.lts.ProcessSpec;
import ic.doc.ltsa.lts.ProgressDefinition;
import ic.doc.ltsa.lts.Range;
import ic.doc.ltsa.lts.RelabelDefn;
import ic.doc.ltsa.lts.SeqProcessRef;
import ic.doc.ltsa.lts.StateDefn;
import ic.doc.ltsa.lts.StateExpr;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.AssertDefinition;
import ic.doc.ltsa.lts.ltl.FormulaSyntax;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class LTSCompiler {
    private Lex lex;
    private LTSOutput output;
    private String currentDirectory;
    private Symbol current;
    static Hashtable processes;
    static Hashtable compiled;
    static Hashtable composites;

    public LTSCompiler(LTSInput input, LTSOutput output, String currentDirectory) {
        this.lex = new Lex(input);
        this.output = output;
        this.currentDirectory = currentDirectory;
        Diagnostics.init(output);
        SeqProcessRef.output = output;
        StateMachine.output = output;
        Expression.constants = new Hashtable();
        Range.ranges = new Hashtable();
        LabelSet.constants = new Hashtable();
        ProgressDefinition.definitions = new Hashtable();
        MenuDefinition.definitions = new Hashtable();
        PredicateDefinition.init();
        AssertDefinition.init();
    }

    private Symbol next_symbol() {
        this.current = this.lex.next_symbol();
        return this.current;
    }

    private void push_symbol() {
        this.lex.push_symbol();
    }

    private void error(String errorMsg) {
        Diagnostics.fatal(errorMsg, this.current);
    }

    private void current_is(int kind, String errorMsg) {
        if (this.current.kind != kind) {
            this.error(errorMsg);
        }
    }

    public CompositeState compile(String name) {
        processes = new Hashtable();
        composites = new Hashtable();
        compiled = new Hashtable();
        this.doparse(composites, processes, compiled);
        ProgressDefinition.compile();
        MenuDefinition.compile();
        PredicateDefinition.compileAll();
        AssertDefinition.compileAll(this.output);
        CompositionExpression ce = (CompositionExpression)composites.get(name);
        if (ce == null && composites.size() > 0) {
            Enumeration e = composites.elements();
            ce = (CompositionExpression)e.nextElement();
        }
        if (ce != null) {
            return ce.compose(null);
        }
        this.compileProcesses(processes, compiled);
        return this.noCompositionExpression(compiled);
    }

    private void compileProcesses(Hashtable h, Hashtable compiled) {
        Enumeration e = h.elements();
        while (e.hasMoreElements()) {
            ProcessSpec p = (ProcessSpec)e.nextElement();
            if (!p.imported()) {
                StateMachine one = new StateMachine(p);
                CompactState c = one.makeCompactState();
                this.output.outln("Compiled: " + c.name);
                compiled.put(c.name, c);
                continue;
            }
            AutCompactState c = new AutCompactState(p.name, p.importFile);
            this.output.outln("Imported: " + c.name);
            compiled.put(c.name, c);
        }
        AssertDefinition.compileConstraints(this.output, compiled);
    }

    public void parse(Hashtable composites, Hashtable processes) {
        this.doparse(composites, processes, null);
    }

    private void doparse(Hashtable composites, Hashtable processes, Hashtable compiled) {
        this.next_symbol();
        while (this.current.kind != 99) {
            ProcessSpec p;
            if (this.current.kind == 1) {
                this.next_symbol();
                this.constantDefinition(Expression.constants);
            } else if (this.current.kind == 3) {
                this.next_symbol();
                this.rangeDefinition();
            } else if (this.current.kind == 9) {
                this.next_symbol();
                this.setDefinition();
            } else if (this.current.kind == 10) {
                this.next_symbol();
                this.progressDefinition();
            } else if (this.current.kind == 11) {
                this.next_symbol();
                this.menuDefinition();
            } else if (this.current.kind == 12) {
                this.next_symbol();
                this.animationDefinition();
            } else if (this.current.kind == 21) {
                this.next_symbol();
                this.assertDefinition(false);
            } else if (this.current.kind == 26) {
                this.next_symbol();
                this.assertDefinition(true);
            } else if (this.current.kind == 22) {
                this.next_symbol();
                this.predicateDefinition();
            } else if (this.current.kind == 19) {
                this.next_symbol();
                p = this.importDefinition();
                if (processes.put(p.name.toString(), p) != null) {
                    Diagnostics.fatal("duplicate process definition: " + p.name, p.name);
                }
            } else if (this.current.kind == 40 || this.current.kind == 15 || this.current.kind == 16 || this.current.kind == 2 || this.current.kind == 17) {
                boolean makeDet = false;
                boolean makeMin = false;
                boolean makeProp = false;
                boolean makeComp = false;
                if (this.current.kind == 15) {
                    makeDet = true;
                    this.next_symbol();
                }
                if (this.current.kind == 16) {
                    makeMin = true;
                    this.next_symbol();
                }
                if (this.current.kind == 17) {
                    makeComp = true;
                    this.next_symbol();
                }
                if (this.current.kind == 2) {
                    makeProp = true;
                    this.next_symbol();
                }
                if (this.current.kind != 40) {
                    ProcessSpec p2 = this.stateDefns();
                    if (processes.put(p2.name.toString(), p2) != null) {
                        Diagnostics.fatal("duplicate process definition: " + p2.name, p2.name);
                    }
                    p2.isProperty = makeProp;
                    p2.isMinimal = makeMin;
                    p2.isDeterministic = makeDet;
                } else if (this.current.kind == 40) {
                    CompositionExpression c = this.composition();
                    c.composites = composites;
                    c.processes = processes;
                    c.compiledProcesses = compiled;
                    c.output = this.output;
                    c.makeDeterministic = makeDet;
                    c.makeProperty = makeProp;
                    c.makeMinimal = makeMin;
                    c.makeCompose = makeComp;
                    if (composites.put(c.name.toString(), c) != null) {
                        Diagnostics.fatal("duplicate composite definition: " + c.name, c.name);
                    }
                }
            } else {
                p = this.stateDefns();
                if (processes.put(p.name.toString(), p) != null) {
                    Diagnostics.fatal("duplicate process definition: " + p.name, p.name);
                }
            }
            this.next_symbol();
        }
    }

    private CompositeState noCompositionExpression(Hashtable h) {
        Vector v = new Vector(16);
        Enumeration e = h.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return new CompositeState(v);
    }

    private CompositionExpression composition() {
        this.current_is(40, "|| expected");
        this.next_symbol();
        CompositionExpression c = new CompositionExpression();
        this.current_is(123, "process identifier expected");
        c.name = this.current;
        this.next_symbol();
        this.paramDefns(c.init_constants, c.parameters);
        this.current_is(64, "= expected");
        this.next_symbol();
        c.body = this.compositebody();
        c.priorityActions = this.priorityDefn(c);
        if (this.current.kind == 70 || this.current.kind == 68) {
            c.exposeNotHide = this.current.kind == 68;
            this.next_symbol();
            c.alphaHidden = this.labelSet();
        }
        this.current_is(66, "dot expected");
        return c;
    }

    private CompositeBody compositebody() {
        CompositeBody b = new CompositeBody();
        if (this.current.kind == 4) {
            this.next_symbol();
            b.boolexpr = new Stack();
            this.expression(b.boolexpr);
            this.current_is(5, "keyword then expected");
            this.next_symbol();
            b.thenpart = this.compositebody();
            if (this.current.kind == 6) {
                this.next_symbol();
                b.elsepart = this.compositebody();
            }
        } else if (this.current.kind == 7) {
            this.next_symbol();
            b.range = this.forallRanges();
            b.thenpart = this.compositebody();
        } else {
            if (this.isLabel()) {
                ActionLabels el = this.labelElement();
                if (this.current.kind == 71) {
                    b.accessSet = el;
                    this.next_symbol();
                    if (this.isLabel()) {
                        b.prefix = this.labelElement();
                        this.current_is(38, " : expected");
                        this.next_symbol();
                    }
                } else if (this.current.kind == 38) {
                    b.prefix = el;
                    this.next_symbol();
                } else {
                    this.error(" : or :: expected");
                }
            }
            if (this.current.kind == 53) {
                b.procRefs = this.processRefs();
                b.relabelDefns = this.relabelDefns();
            } else {
                b.singleton = this.processRef();
                b.relabelDefns = this.relabelDefns();
            }
        }
        return b;
    }

    private ActionLabels forallRanges() {
        ActionLabels head;
        this.current_is(62, "range expected");
        ActionLabels next = head = this.range();
        while (this.current.kind == 62) {
            ActionLabels t = this.range();
            next.addFollower(t);
            next = t;
        }
        return head;
    }

    private Vector processRefs() {
        Vector<CompositeBody> procRefs = new Vector<CompositeBody>();
        this.current_is(53, "( expected");
        this.next_symbol();
        if (this.current.kind != 54) {
            procRefs.addElement(this.compositebody());
            while (this.current.kind == 40) {
                this.next_symbol();
                procRefs.addElement(this.compositebody());
            }
            this.current_is(54, ") expected");
        }
        this.next_symbol();
        return procRefs;
    }

    private Vector relabelDefns() {
        if (this.current.kind != 33) {
            return null;
        }
        this.next_symbol();
        return this.relabelSet();
    }

    private LabelSet priorityDefn(CompositionExpression c) {
        if (this.current.kind != 51 && this.current.kind != 48) {
            return null;
        }
        if (this.current.kind == 48) {
            c.priorityIsLow = false;
        }
        this.next_symbol();
        return this.labelSet();
    }

    private Vector relabelSet() {
        this.current_is(60, "{ expected");
        this.next_symbol();
        Vector<RelabelDefn> v = new Vector<RelabelDefn>();
        v.addElement(this.relabelDefn());
        while (this.current.kind == 39) {
            this.next_symbol();
            v.addElement(this.relabelDefn());
        }
        this.current_is(61, "} expected");
        this.next_symbol();
        return v;
    }

    private RelabelDefn relabelDefn() {
        RelabelDefn r = new RelabelDefn();
        if (this.current.kind == 7) {
            this.next_symbol();
            r.range = this.forallRanges();
            r.defns = this.relabelSet();
        } else {
            r.newlabel = this.labelElement();
            this.current_is(33, "/ expected");
            this.next_symbol();
            r.oldlabel = this.labelElement();
        }
        return r;
    }

    private ProcessRef processRef() {
        ProcessRef p = new ProcessRef();
        this.current_is(123, "process identifier expected");
        p.name = this.current;
        this.next_symbol();
        p.actualParams = this.actualParameters();
        return p;
    }

    private Vector actualParameters() {
        if (this.current.kind != 53) {
            return null;
        }
        Vector v = new Vector();
        this.next_symbol();
        Stack stk = new Stack();
        this.expression(stk);
        v.addElement(stk);
        while (this.current.kind == 39) {
            this.next_symbol();
            stk = new Stack();
            this.expression(stk);
            v.addElement(stk);
        }
        this.current_is(54, ") - expected");
        this.next_symbol();
        return v;
    }

    private ProcessSpec stateDefns() {
        ProcessSpec p = new ProcessSpec();
        this.current_is(123, "process identifier expected");
        Symbol temp = this.current;
        this.next_symbol();
        this.paramDefns(p.init_constants, p.parameters);
        this.push_symbol();
        this.current = temp;
        p.stateDefns.addElement(this.stateDefn());
        while (this.current.kind == 39) {
            this.next_symbol();
            p.stateDefns.addElement(this.stateDefn());
        }
        if (this.current.kind == 30) {
            this.next_symbol();
            p.alphaAdditions = this.labelSet();
        }
        p.alphaRelabel = this.relabelDefns();
        if (this.current.kind == 70 || this.current.kind == 68) {
            p.exposeNotHide = this.current.kind == 68;
            this.next_symbol();
            p.alphaHidden = this.labelSet();
        }
        p.getname();
        this.current_is(66, "dot expected");
        return p;
    }

    private boolean isLabelSet() {
        if (this.current.kind == 60) {
            return true;
        }
        if (this.current.kind != 123) {
            return false;
        }
        return LabelSet.constants.containsKey(this.current.toString());
    }

    private boolean isLabel() {
        return this.isLabelSet() || this.current.kind == 124 || this.current.kind == 62;
    }

    private ProcessSpec importDefinition() {
        this.current_is(123, "imported process identifier expected");
        ProcessSpec p = new ProcessSpec();
        p.name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        this.current_is(127, " - imported file name expected");
        p.importFile = new File(this.currentDirectory, this.current.toString());
        return p;
    }

    private void animationDefinition() {
        this.current_is(123, "animation identifier expected");
        MenuDefinition m = new MenuDefinition();
        m.name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        this.current_is(127, " - XML file name expected");
        m.params = this.current;
        this.next_symbol();
        if (this.current.kind == 18) {
            this.next_symbol();
            this.current_is(123, " - target composition name expected");
            m.target = this.current;
            this.next_symbol();
        }
        if (this.current.kind == 17) {
            this.next_symbol();
            this.current_is(60, "{ expected");
            this.next_symbol();
            this.current_is(123, "animation name expected");
            Symbol name = this.current;
            this.next_symbol();
            m.addAnimationPart(name, this.relabelDefns());
            while (this.current.kind == 40) {
                this.next_symbol();
                this.current_is(123, "animation name expected");
                name = this.current;
                this.next_symbol();
                m.addAnimationPart(name, this.relabelDefns());
            }
            this.current_is(61, "} expected");
            this.next_symbol();
        }
        if (this.current.kind == 13) {
            this.next_symbol();
            m.actionMapDefn = this.relabelSet();
        }
        if (this.current.kind == 14) {
            this.next_symbol();
            m.controlMapDefn = this.relabelSet();
        }
        this.push_symbol();
        if (MenuDefinition.definitions.put(m.name.toString(), m) != null) {
            Diagnostics.fatal("duplicate menu/animation definition: " + m.name, m.name);
        }
    }

    private void menuDefinition() {
        this.current_is(123, "menu identifier expected");
        MenuDefinition m = new MenuDefinition();
        m.name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        m.actions = this.labelElement();
        this.push_symbol();
        if (MenuDefinition.definitions.put(m.name.toString(), m) != null) {
            Diagnostics.fatal("duplicate menu/animation definition: " + m.name, m.name);
        }
    }

    private void progressDefinition() {
        this.current_is(123, "progress test identifier expected");
        ProgressDefinition p = new ProgressDefinition();
        p.name = this.current;
        this.next_symbol();
        if (this.current.kind == 62) {
            p.range = this.forallRanges();
        }
        this.current_is(64, "= expected");
        this.next_symbol();
        if (this.current.kind == 4) {
            this.next_symbol();
            p.pactions = this.labelElement();
            this.current_is(5, "then expected");
            this.next_symbol();
            p.cactions = this.labelElement();
        } else {
            p.pactions = this.labelElement();
        }
        if (ProgressDefinition.definitions.put(p.name.toString(), p) != null) {
            Diagnostics.fatal("duplicate progress test: " + p.name, p.name);
        }
        this.push_symbol();
    }

    private void setDefinition() {
        this.current_is(123, "set identifier expected");
        Symbol temp = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        new LabelSet(temp, this.setValue());
        this.push_symbol();
    }

    private LabelSet labelSet() {
        if (this.current.kind == 60) {
            return new LabelSet(this.setValue());
        }
        if (this.current.kind == 123) {
            LabelSet ls = (LabelSet)LabelSet.constants.get(this.current.toString());
            if (ls == null) {
                this.error("set definition not found for: " + this.current);
            }
            this.next_symbol();
            return ls;
        }
        this.error("{ or set identifier expected");
        return null;
    }

    private Vector setValue() {
        this.current_is(60, "{ expected");
        this.next_symbol();
        Vector<ActionLabels> v = new Vector<ActionLabels>();
        v.addElement(this.labelElement());
        while (this.current.kind == 39) {
            this.next_symbol();
            v.addElement(this.labelElement());
        }
        this.current_is(61, "} expected");
        this.next_symbol();
        return v;
    }

    private ActionLabels labelElement() {
        if (this.current.kind != 124 && !this.isLabelSet() && this.current.kind != 62) {
            this.error("identifier, label set or range expected");
        }
        ActionLabels e = null;
        if (this.current.kind == 124) {
            if ("tau".equals(this.current.toString())) {
                this.error("'tau' cannot be used as an action label");
            }
            e = new ActionName(this.current);
            this.next_symbol();
        } else if (this.isLabelSet()) {
            LabelSet left = this.labelSet();
            if (this.current.kind == 70) {
                this.next_symbol();
                LabelSet right = this.labelSet();
                e = new ActionSetExpr(left, right);
            } else {
                e = new ActionSet(left);
            }
        } else if (this.current.kind == 62) {
            e = this.range();
        }
        if (this.current.kind == 66 || this.current.kind == 62) {
            if (this.current.kind == 66) {
                this.next_symbol();
            }
            if (e != null) {
                e.addFollower(this.labelElement());
            }
        }
        return e;
    }

    private void constantDefinition(Hashtable p) {
        this.current_is(123, "constant, upper case identifier expected");
        Symbol name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        Stack tmp = new Stack();
        this.simpleExpression(tmp);
        this.push_symbol();
        if (p.put(name.toString(), Expression.getValue(tmp, null, null)) != null) {
            Diagnostics.fatal("duplicate constant definition: " + name, name);
        }
    }

    private void paramDefns(Hashtable p, Vector parameters) {
        if (this.current.kind == 53) {
            this.next_symbol();
            this.parameterDefinition(p, parameters);
            while (this.current.kind == 39) {
                this.next_symbol();
                this.parameterDefinition(p, parameters);
            }
            this.current_is(54, ") expected");
            this.next_symbol();
        }
    }

    private void parameterDefinition(Hashtable p, Vector parameters) {
        this.current_is(123, "parameter, upper case identifier expected");
        Symbol name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        Stack tmp = new Stack();
        this.expression(tmp);
        this.push_symbol();
        if (p.put(name.toString(), Expression.getValue(tmp, null, null)) != null) {
            Diagnostics.fatal("duplicate parameter definition: " + name, name);
        }
        if (parameters != null) {
            parameters.addElement(name.toString());
            this.next_symbol();
        }
    }

    private StateDefn stateDefn() {
        StateDefn s = new StateDefn();
        this.current_is(123, "process identifier expected");
        s.name = this.current;
        this.next_symbol();
        if (this.current.kind == 68) {
            s.accept = true;
            this.next_symbol();
        }
        if (this.current.kind == 66 || this.current.kind == 62) {
            if (this.current.kind == 66) {
                this.next_symbol();
            }
            s.range = this.labelElement();
        }
        this.current_is(64, "= expected");
        this.next_symbol();
        s.stateExpr = this.stateExpr();
        return s;
    }

    private Stack getEvaluatedExpression() {
        Stack<Symbol> tmp = new Stack<Symbol>();
        this.simpleExpression(tmp);
        int v = Expression.evaluate(tmp, null, null);
        tmp = new Stack();
        tmp.push(new Symbol(125, v));
        return tmp;
    }

    private void rangeDefinition() {
        this.current_is(123, "range name, upper case identifier expected");
        Symbol name = this.current;
        this.next_symbol();
        this.current_is(64, "= expected");
        this.next_symbol();
        Range r = new Range();
        r.low = this.getEvaluatedExpression();
        this.current_is(67, "..  expected");
        this.next_symbol();
        r.high = this.getEvaluatedExpression();
        if (Range.ranges.put(name.toString(), r) != null) {
            Diagnostics.fatal("duplicate range definition: " + name, name);
        }
        this.push_symbol();
    }

    private ActionLabels range() {
        if (this.current.kind == 62) {
            ActionLabels r;
            this.next_symbol();
            Stack low = null;
            Stack high = null;
            if (this.current.kind != 124) {
                if (this.isLabelSet()) {
                    r = new ActionSet(this.labelSet());
                } else if (this.current.kind == 123 && Range.ranges.containsKey(this.current.toString())) {
                    r = new ActionRange((Range)Range.ranges.get(this.current.toString()));
                    this.next_symbol();
                } else {
                    low = new Stack();
                    this.expression(low);
                    r = new ActionExpr(low);
                }
                if (this.current.kind == 67) {
                    this.next_symbol();
                    high = new Stack();
                    this.expression(high);
                    r = new ActionRange(low, high);
                }
            } else {
                Symbol varname = this.current;
                this.next_symbol();
                if (this.current.kind == 38) {
                    this.next_symbol();
                    if (this.isLabelSet()) {
                        r = new ActionVarSet(varname, this.labelSet());
                    } else if (this.current.kind == 123 && Range.ranges.containsKey(this.current.toString())) {
                        r = new ActionVarRange(varname, (Range)Range.ranges.get(this.current.toString()));
                        this.next_symbol();
                    } else {
                        low = new Stack();
                        this.expression(low);
                        this.current_is(67, "..  expected");
                        this.next_symbol();
                        high = new Stack();
                        this.expression(high);
                        r = new ActionVarRange(varname, low, high);
                    }
                } else {
                    this.push_symbol();
                    this.current = varname;
                    low = new Stack();
                    this.expression(low);
                    if (this.current.kind == 67) {
                        this.next_symbol();
                        high = new Stack();
                        this.expression(high);
                        r = new ActionRange(low, high);
                    } else {
                        r = new ActionExpr(low);
                    }
                }
            }
            this.current_is(63, "] expected");
            this.next_symbol();
            return r;
        }
        return null;
    }

    private StateExpr stateExpr() {
        StateExpr s = new StateExpr();
        if (this.current.kind == 123) {
            this.stateRef(s);
        } else if (this.current.kind == 4) {
            this.next_symbol();
            s.boolexpr = new Stack();
            this.expression(s.boolexpr);
            this.current_is(5, "keyword then expected");
            this.next_symbol();
            s.thenpart = this.stateExpr();
            if (this.current.kind == 6) {
                this.next_symbol();
                s.elsepart = this.stateExpr();
            } else {
                Symbol stop = new Symbol(123, "STOP");
                StateExpr se = new StateExpr();
                se.name = stop;
                s.elsepart = se;
            }
        } else if (this.current.kind == 53) {
            this.next_symbol();
            this.choiceExpr(s);
            this.current_is(54, ") expected");
            this.next_symbol();
        } else {
            this.error(" (, if or process identifier expected");
        }
        return s;
    }

    private void stateRef(StateExpr s) {
        this.current_is(123, "process identifier expected");
        s.name = this.current;
        this.next_symbol();
        while (this.current.kind == 65 || this.current.kind == 53) {
            s.addSeqProcessRef(new SeqProcessRef(s.name, this.actualParameters()));
            this.next_symbol();
            this.current_is(123, "process identifier expected");
            s.name = this.current;
            this.next_symbol();
        }
        if (this.current.kind == 62) {
            s.expr = new Vector();
            while (this.current.kind == 62) {
                this.next_symbol();
                Stack x = new Stack();
                this.expression(x);
                s.expr.addElement(x);
                this.current_is(63, "] expected");
                this.next_symbol();
            }
        }
    }

    private void choiceExpr(StateExpr s) {
        s.choices = new Vector();
        s.choices.addElement(this.choiceElement());
        while (this.current.kind == 41) {
            this.next_symbol();
            s.choices.addElement(this.choiceElement());
        }
    }

    private ChoiceElement choiceElement() {
        ChoiceElement first = new ChoiceElement();
        if (this.current.kind == 8) {
            this.next_symbol();
            first.guard = new Stack();
            this.expression(first.guard);
        }
        first.action = this.labelElement();
        this.current_is(69, "-> expected");
        ChoiceElement next = first;
        ChoiceElement last = first;
        this.next_symbol();
        while (this.current.kind == 124 || this.current.kind == 62 || this.isLabelSet()) {
            StateExpr ex = new StateExpr();
            next = new ChoiceElement();
            next.action = this.labelElement();
            ex.choices = new Vector();
            ex.choices.addElement(next);
            last.stateExpr = ex;
            last = next;
            this.current_is(69, "-> expected");
            this.next_symbol();
        }
        next.stateExpr = this.stateExpr();
        return first;
    }

    private Symbol event() {
        this.current_is(124, "event identifier expected");
        Symbol e = this.current;
        this.next_symbol();
        return e;
    }

    private ActionLabels labelConstant() {
        this.next_symbol();
        ActionLabels el = this.labelElement();
        if (el != null) {
            return el;
        }
        this.error("label definition expected");
        return null;
    }

    private void set_select(Stack expr) {
        Symbol op = this.current;
        this.next_symbol();
        this.current_is(53, "( expected to start set index selection");
        Symbol temp = this.current;
        temp.setAny(this.labelConstant());
        temp.kind = 98;
        expr.push(temp);
        this.current_is(39, ", expected before set index expression");
        this.next_symbol();
        this.expression(expr);
        this.current_is(54, ") expected to end set index selection");
        this.next_symbol();
        expr.push(op);
    }

    private void unary(Stack expr) {
        Symbol unary_operator;
        switch (this.current.kind) {
            case 30: {
                unary_operator = this.current;
                unary_operator.kind = 29;
                this.next_symbol();
                break;
            }
            case 31: {
                unary_operator = this.current;
                unary_operator.kind = 28;
                this.next_symbol();
                break;
            }
            case 45: {
                unary_operator = this.current;
                this.next_symbol();
                break;
            }
            default: {
                unary_operator = null;
            }
        }
        switch (this.current.kind) {
            case 123: 
            case 124: 
            case 125: {
                expr.push(this.current);
                this.next_symbol();
                break;
            }
            case 53: {
                this.next_symbol();
                this.expression(expr);
                this.current_is(54, ") expected to end expression");
                this.next_symbol();
                break;
            }
            case 73: {
                unary_operator = new Symbol(this.current);
            }
            case 72: {
                Symbol temp = this.current;
                temp.setAny(this.labelConstant());
                temp.kind = 98;
                expr.push(temp);
                break;
            }
            case 68: {
                this.set_select(expr);
                break;
            }
            default: {
                this.error("syntax error in expression");
            }
        }
        if (unary_operator != null) {
            expr.push(unary_operator);
        }
    }

    private void multiplicative(Stack expr) {
        this.unary(expr);
        while (this.current.kind == 32 || this.current.kind == 33 || this.current.kind == 34) {
            Symbol op = this.current;
            this.next_symbol();
            this.unary(expr);
            expr.push(op);
        }
    }

    private void additive(Stack expr) {
        this.multiplicative(expr);
        while (this.current.kind == 30 || this.current.kind == 31) {
            Symbol op = this.current;
            this.next_symbol();
            this.multiplicative(expr);
            expr.push(op);
        }
    }

    private void shift(Stack expr) {
        this.additive(expr);
        while (this.current.kind == 48 || this.current.kind == 51) {
            Symbol op = this.current;
            this.next_symbol();
            this.additive(expr);
            expr.push(op);
        }
    }

    private void relational(Stack expr) {
        this.shift(expr);
        while (this.current.kind == 47 || this.current.kind == 46 || this.current.kind == 50 || this.current.kind == 49) {
            Symbol op = this.current;
            this.next_symbol();
            this.shift(expr);
            expr.push(op);
        }
    }

    private void equality(Stack expr) {
        this.relational(expr);
        while (this.current.kind == 52 || this.current.kind == 44) {
            Symbol op = this.current;
            this.next_symbol();
            this.relational(expr);
            expr.push(op);
        }
    }

    private void and(Stack expr) {
        this.equality(expr);
        while (this.current.kind == 43) {
            Symbol op = this.current;
            this.next_symbol();
            this.equality(expr);
            expr.push(op);
        }
    }

    private void exclusive_or(Stack expr) {
        this.and(expr);
        while (this.current.kind == 35) {
            Symbol op = this.current;
            this.next_symbol();
            this.and(expr);
            expr.push(op);
        }
    }

    private void inclusive_or(Stack expr) {
        this.exclusive_or(expr);
        while (this.current.kind == 41) {
            Symbol op = this.current;
            this.next_symbol();
            this.exclusive_or(expr);
            expr.push(op);
        }
    }

    private void logical_and(Stack expr) {
        this.inclusive_or(expr);
        while (this.current.kind == 42) {
            Symbol op = this.current;
            this.next_symbol();
            this.inclusive_or(expr);
            expr.push(op);
        }
    }

    private void logical_or(Stack expr) {
        this.logical_and(expr);
        while (this.current.kind == 40) {
            Symbol op = this.current;
            this.next_symbol();
            this.logical_and(expr);
            expr.push(op);
        }
    }

    private void expression(Stack expr) {
        this.logical_or(expr);
    }

    private void simpleExpression(Stack expr) {
        this.additive(expr);
    }

    private void assertDefinition(boolean isConstraint) {
        this.current_is(123, "LTL property identifier expected");
        Symbol name = this.current;
        LabelSet ls = null;
        this.next_symbol();
        Hashtable initparams = new Hashtable();
        Vector params = new Vector();
        this.paramDefns(initparams, params);
        this.current_is(64, "= expected");
        this.next_symbol_mod();
        FormulaSyntax f = this.ltl_unary();
        if (this.current.kind == 30) {
            this.next_symbol();
            ls = this.labelSet();
        }
        this.push_symbol();
        if (processes != null && processes.get(name.toString()) != null || composites != null && composites.get(name.toString()) != null) {
            Diagnostics.fatal("name already defined  " + name, name);
        }
        AssertDefinition.put(name, f, ls, initparams, params, isConstraint);
    }

    private Symbol modify(Symbol s) {
        if (s.kind != 123) {
            return s;
        }
        if (s.toString().equals("X")) {
            Symbol nx = new Symbol(s);
            nx.kind = 23;
            return nx;
        }
        if (s.toString().equals("U")) {
            Symbol ut = new Symbol(s);
            ut.kind = 20;
            return ut;
        }
        if (s.toString().equals("W")) {
            Symbol wut = new Symbol(s);
            wut.kind = 77;
            return wut;
        }
        return s;
    }

    private void next_symbol_mod() {
        this.next_symbol();
        this.current = this.modify(this.current);
    }

    private FormulaSyntax ltl_unary() {
        Symbol op = this.current;
        switch (this.current.kind) {
            case 23: 
            case 45: 
            case 74: 
            case 75: {
                this.next_symbol_mod();
                return FormulaSyntax.make(null, op, this.ltl_unary());
            }
            case 123: {
                this.next_symbol_mod();
                if (this.current.kind == 62) {
                    ActionLabels range = this.forallRanges();
                    this.current = this.modify(this.current);
                    return FormulaSyntax.make(op, range);
                }
                if (this.current.kind == 53) {
                    Vector actparams = this.actualParameters();
                    return FormulaSyntax.make(op, actparams);
                }
                return FormulaSyntax.make(op);
            }
            case 53: {
                this.next_symbol_mod();
                FormulaSyntax right = this.ltl_or();
                this.current_is(54, ") expected to end LTL expression");
                this.next_symbol_mod();
                return right;
            }
            case 60: 
            case 62: 
            case 124: {
                ActionLabels ts = this.labelElement();
                this.push_symbol();
                this.next_symbol_mod();
                return FormulaSyntax.make(ts);
            }
            case 24: {
                this.next_symbol_mod();
                ActionLabels ff = this.forallRanges();
                this.push_symbol();
                this.next_symbol_mod();
                return FormulaSyntax.make(new Symbol(40), ff, this.ltl_unary());
            }
            case 7: {
                this.next_symbol_mod();
                ActionLabels ff = this.forallRanges();
                this.push_symbol();
                this.next_symbol_mod();
                return FormulaSyntax.make(new Symbol(42), ff, this.ltl_unary());
            }
            case 25: {
                this.next_symbol_mod();
                Stack tmp = new Stack();
                this.simpleExpression(tmp);
                this.push_symbol();
                this.next_symbol_mod();
                return FormulaSyntax.makeE(op, tmp);
            }
        }
        Diagnostics.fatal("syntax error in LTL expression", this.current);
        return null;
    }

    private FormulaSyntax ltl_and() {
        FormulaSyntax left = this.ltl_unary();
        while (this.current.kind == 42) {
            Symbol op = this.current;
            this.next_symbol_mod();
            FormulaSyntax right = this.ltl_unary();
            left = FormulaSyntax.make(left, op, right);
        }
        return left;
    }

    private FormulaSyntax ltl_or() {
        FormulaSyntax left = this.ltl_binary();
        while (this.current.kind == 40) {
            Symbol op = this.current;
            this.next_symbol_mod();
            FormulaSyntax right = this.ltl_binary();
            left = FormulaSyntax.make(left, op, right);
        }
        return left;
    }

    private FormulaSyntax ltl_binary() {
        FormulaSyntax left = this.ltl_and();
        if (this.current.kind == 20 || this.current.kind == 77 || this.current.kind == 69 || this.current.kind == 76) {
            Symbol op = this.current;
            this.next_symbol_mod();
            FormulaSyntax right = this.ltl_and();
            left = FormulaSyntax.make(left, op, right);
        }
        return left;
    }

    private void predicateDefinition() {
        this.current_is(123, "predicate identifier expected");
        Symbol name = this.current;
        ActionLabels range = null;
        this.next_symbol();
        if (this.current.kind == 62) {
            range = this.forallRanges();
        }
        this.current_is(64, "= expected");
        this.next_symbol();
        this.current_is(47, "< expected");
        this.next_symbol();
        ActionLabels ts = this.labelElement();
        this.current_is(39, ", expected");
        this.next_symbol();
        ActionLabels fs = this.labelElement();
        this.current_is(50, "> expected");
        this.next_symbol();
        if (this.current.kind == 27) {
            this.next_symbol();
            Stack tmp = new Stack();
            this.simpleExpression(tmp);
            this.push_symbol();
            PredicateDefinition.put(name, range, ts, fs, tmp);
        } else {
            this.push_symbol();
            PredicateDefinition.put(name, range, ts, fs, null);
        }
    }
}

