/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.RelabelDefn;
import ic.doc.ltsa.lts.RunMenu;
import ic.doc.ltsa.lts.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MenuDefinition {
    Symbol name;
    ActionLabels actions;
    Symbol params;
    Symbol target;
    Vector actionMapDefn;
    Vector controlMapDefn;
    Vector animations;
    public static Hashtable definitions;

    public static void compile() {
        RunMenu.init();
        Enumeration e = definitions.elements();
        while (e.hasMoreElements()) {
            MenuDefinition m = (MenuDefinition)e.nextElement();
            RunMenu.add(m.makeRunMenu());
        }
    }

    public static String[] names() {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        String[] na = new String[n];
        Enumeration e = definitions.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            na[i++] = (String)e.nextElement();
        }
        return na;
    }

    public static boolean[] enabled(String targ) {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        boolean[] na = new boolean[n];
        Enumeration e = definitions.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            MenuDefinition m = (MenuDefinition)definitions.get((String)e.nextElement());
            boolean bl = na[i++] = m.target == null ? true : targ.equals(m.target.toString());
        }
        return na;
    }

    public RunMenu makeRunMenu() {
        String na = this.name.toString();
        if (this.params == null) {
            Vector a = null;
            a = this.actions.getActions(null, null);
            return new RunMenu(na, a);
        }
        Relation a = RelabelDefn.getRelabels(this.actionMapDefn);
        Relation c = RelabelDefn.getRelabels(this.controlMapDefn);
        a = a == null ? new Relation() : a.inverse();
        c = c == null ? new Relation() : c.inverse();
        this.includeParts(a, c);
        return new RunMenu(na, this.params == null ? null : this.params.toString(), a, c);
    }

    protected void includeParts(Relation actions, Relation controls) {
        if (this.animations == null) {
            return;
        }
        Enumeration e = this.animations.elements();
        while (e.hasMoreElements()) {
            AnimationPart ap = (AnimationPart)e.nextElement();
            ap.makePart();
            actions.union(ap.getActions());
            controls.union(ap.getControls());
        }
    }

    public void addAnimationPart(Symbol n, Vector r) {
        if (this.animations == null) {
            this.animations = new Vector();
        }
        this.animations.addElement(new AnimationPart(n, r));
    }

    class AnimationPart {
        Symbol name;
        Vector relabels;
        RunMenu compiled;

        AnimationPart(Symbol n, Vector r) {
            this.name = n;
            this.relabels = r;
        }

        void makePart() {
            MenuDefinition m = (MenuDefinition)definitions.get(this.name.toString());
            if (m == null) {
                Diagnostics.fatal("Animation not found: " + this.name, this.name);
                return;
            }
            if (m.params == null) {
                Diagnostics.fatal("Not an animation: " + this.name, this.name);
                return;
            }
            this.compiled = m.makeRunMenu();
            if (this.relabels != null) {
                Relation r = RelabelDefn.getRelabels(this.relabels);
                if (this.compiled.actions != null) {
                    this.compiled.actions.relabel(r);
                }
                if (this.compiled.controls != null) {
                    this.compiled.controls.relabel(r);
                }
            }
        }

        Relation getActions() {
            if (this.compiled != null) {
                return this.compiled.actions;
            }
            return null;
        }

        Relation getControls() {
            if (this.compiled != null) {
                return this.compiled.controls;
            }
            return null;
        }
    }
}

