/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Counter;
import ic.doc.ltsa.lts.Determinizer;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import java.util.BitSet;
import java.util.Hashtable;

public class Minimiser {
    static final int TAU = 0;
    BitSet[] E;
    BitSet[] A;
    EventState[] T;
    CompactState machine;
    LTSOutput output;

    public Minimiser(CompactState c, LTSOutput output) {
        this.machine = c;
        this.output = output;
    }

    private void initTau() {
        this.T = new EventState[this.machine.states.length];
        int i = 0;
        while (i < this.T.length) {
            this.T[i] = EventState.reachableTau(this.machine.states, i);
            ++i;
        }
    }

    private CompactState machTau(CompactState m) {
        int i = 0;
        while (i < m.states.length) {
            m.states[i] = EventState.tauAdd(m.states[i], this.T);
            ++i;
        }
        i = 0;
        while (i < m.states.length) {
            m.states[i] = EventState.union(m.states[i], this.T[i]);
            m.states[i] = EventState.actionAdd(m.states[i], m.states);
            ++i;
        }
        i = 0;
        while (i < m.states.length) {
            m.states[i] = EventState.add(m.states[i], new EventState(0, i));
            ++i;
        }
        this.output.out(".");
        return m;
    }

    private CompactState removeTau(CompactState m) {
        int i = 0;
        while (i < m.states.length) {
            m.states[i] = EventState.removeTau(m.states[i]);
            ++i;
        }
        return m;
    }

    private void initialise() {
        this.A = new BitSet[this.machine.maxStates];
        int i = 0;
        while (i < this.A.length) {
            this.A[i] = new BitSet(this.machine.alphabet.length);
            EventState.setActions(this.machine.states[i], this.A[i]);
            ++i;
        }
        this.E = new BitSet[this.machine.maxStates];
        i = 0;
        while (i < this.E.length) {
            this.E[i] = new BitSet(this.E.length);
            ++i;
        }
        i = 0;
        while (i < this.E.length) {
            this.E[i].set(i);
            int j = 0;
            while (j < i) {
                if (this.A[i].equals(this.A[j])) {
                    this.E[i].set(j);
                    this.E[j].set(i);
                }
                ++j;
            }
            ++i;
        }
        this.output.out(".");
    }

    private void dominimise() {
        boolean more = true;
        while (more) {
            this.output.out(".");
            more = false;
            int i = 0;
            while (i < this.E.length) {
                Thread.yield();
                int j = 0;
                while (j < i) {
                    if (this.E[i].get(j)) {
                        boolean b;
                        boolean bl = b = this.is_equivalent(i, j) && this.is_equivalent(j, i);
                        if (!b) {
                            more = true;
                            this.E[i].clear(j);
                            this.E[j].clear(i);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public CompactState minimise() {
        this.output.out(String.valueOf(this.machine.name) + " minimising");
        long start = System.currentTimeMillis();
        CompactState saved = this.machine.myclone();
        if (this.machine.endseq >= 0) {
            int es = this.machine.endseq;
            this.machine.states[es] = EventState.add(this.machine.states[es], new EventState(this.machine.alphabet.length, es));
        }
        if (this.machine.hasTau()) {
            this.initTau();
            this.machine = this.machTau(this.machine);
            this.T = null;
        }
        this.initialise();
        this.dominimise();
        this.machine = saved;
        CompactState c = this.makeNewMachine();
        long finish = System.currentTimeMillis();
        this.output.outln("");
        this.output.outln("Minimised States: " + c.maxStates + " in " + (finish - start) + "ms");
        return c;
    }

    public CompactState trace_minimise() {
        boolean must_minimize = false;
        if (this.machine.hasTau()) {
            must_minimize = true;
            this.output.out("Eliminating tau");
            this.initTau();
            this.machine = this.machTau(this.machine);
            this.machine = this.removeTau(this.machine);
            this.T = null;
        }
        if (must_minimize || this.machine.isNonDeterministic()) {
            must_minimize = true;
            Determinizer d = new Determinizer(this.machine, this.output);
            this.machine = d.determine();
        }
        if (must_minimize) {
            return this.minimise();
        }
        return this.machine;
    }

    private boolean is_equivalent(int i, int j) {
        EventState p = this.machine.states[i];
        while (p != null) {
            EventState tr = p;
            while (tr != null) {
                if (!this.findSuccessor(j, tr)) {
                    return false;
                }
                tr = tr.nondet;
            }
            p = p.list;
        }
        return true;
    }

    private boolean findSuccessor(int j, EventState tr) {
        EventState p = this.machine.states[j];
        while (p.event != tr.event) {
            p = p.list;
        }
        while (p != null) {
            if (tr.next < 0 ? p.next < 0 : p.next >= 0 && this.E[tr.next].get(p.next)) {
                return true;
            }
            p = p.nondet;
        }
        return false;
    }

    private CompactState makeNewMachine() {
        Hashtable<Integer, Integer> oldtonew = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> newtoold = new Hashtable<Integer, Integer>();
        Counter newSt = new Counter(0);
        int i = 0;
        while (i < this.E.length) {
            Integer oldIndex = new Integer(i);
            Integer newIndex = (Integer)oldtonew.get(oldIndex);
            if (newIndex == null) {
                newIndex = newSt.label();
                oldtonew.put(oldIndex, newIndex);
                newtoold.put(newIndex, oldIndex);
            }
            int j = 0;
            while (j < this.E.length) {
                if (this.E[i].get(j)) {
                    oldtonew.put(new Integer(j), newIndex);
                }
                ++j;
            }
            ++i;
        }
        CompactState m = new CompactState();
        m.name = this.machine.name;
        m.maxStates = newtoold.size();
        m.alphabet = this.machine.alphabet;
        m.states = new EventState[m.maxStates];
        if (this.machine.endseq < 0) {
            m.endseq = this.machine.endseq;
        } else {
            m.endseq = (Integer)oldtonew.get(new Integer(this.machine.endseq));
            m.states[m.endseq] = EventState.remove(m.states[m.endseq], new EventState(m.alphabet.length, m.endseq));
        }
        int i2 = 0;
        while (i2 < this.machine.maxStates) {
            int newi = (Integer)oldtonew.get(new Integer(i2));
            EventState tmp = EventState.renumberStates(this.machine.states[i2], oldtonew);
            m.states[newi] = EventState.union(m.states[newi], tmp);
            ++i2;
        }
        i2 = 0;
        while (i2 < m.maxStates) {
            m.states[i2] = EventState.remove(m.states[i2], new EventState(0, i2));
            ++i2;
        }
        return m;
    }

    public void print(LTSOutput output) {
        this.privPrint(output, this.E);
    }

    private void privPrint(LTSOutput output, BitSet[] E) {
        if (E.length > 20) {
            return;
        }
        char[] buf = new char[E.length * 2];
        int i = 0;
        while (i < E.length * 2) {
            buf[i] = 32;
            ++i;
        }
        output.outln("E:");
        output.out("       ");
        i = 0;
        while (i < E.length) {
            output.out(" " + i);
            ++i;
        }
        output.outln("");
        i = 0;
        while (i < E.length) {
            output.out("State " + i + " ");
            int j = 0;
            while (j < E.length) {
                buf[j * 2] = E[i].get(j) ? 49 : 32;
                ++j;
            }
            output.outln(new String(buf));
            ++i;
        }
    }
}

