/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.MyHashEntry;
import ic.doc.ltsa.lts.StackCheck;
import ic.doc.ltsa.lts.StateCodec;

public class MyHash
implements StackCheck {
    private MyHashEntry[] table;
    private int count = 0;

    public MyHash(int size) {
        this.table = new MyHashEntry[size];
    }

    public void put(byte[] key) {
        MyHashEntry entry = new MyHashEntry(key);
        int hash = StateCodec.hash(key) % this.table.length;
        entry.next = this.table[hash];
        this.table[hash] = entry;
        ++this.count;
    }

    public void put(byte[] key, int value) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                entry.value = value;
                return;
            }
            entry = entry.next;
        }
        entry = new MyHashEntry(key, value);
        entry.next = this.table[hash];
        this.table[hash] = entry;
        ++this.count;
    }

    public void remove(byte[] key) {
        MyHashEntry p;
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashEntry q = p = this.table[hash];
        while (p != null) {
            if (StateCodec.equals(p.key, key)) {
                if (q == this.table[hash]) {
                    this.table[hash] = p.next;
                } else {
                    q = p.next;
                }
                return;
            }
            q = p;
            p = p.next;
        }
    }

    public boolean onStack(byte[] key) {
        return this.containsKey(key);
    }

    public boolean containsKey(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -99999;
    }

    public int size() {
        return this.count;
    }
}

