/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.AutCompactState;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.CompositionExpression;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ProcessSpec;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Value;
import ic.doc.ltsa.lts.ltl.AssertDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class ProcessRef {
    Symbol name;
    Vector actualParams;

    ProcessRef() {
    }

    public void instantiate(CompositionExpression c, Vector machines, LTSOutput output, Hashtable locals) {
        CompositeState cs;
        Vector actuals = this.paramValues(locals, c);
        String refname = actuals == null ? this.name.toString() : String.valueOf(this.name.toString()) + StateMachine.paramString(actuals);
        CompactState mach = (CompactState)c.compiledProcesses.get(refname);
        if (mach != null) {
            machines.addElement(mach.myclone());
            return;
        }
        ProcessSpec p = (ProcessSpec)c.processes.get(this.name.toString());
        if (p != null) {
            if (this.actualParams != null && this.actualParams.size() != p.parameters.size()) {
                Diagnostics.fatal("actuals do not match formal parameters", this.name);
            }
            if (!p.imported()) {
                StateMachine one = new StateMachine(p, actuals);
                mach = one.makeCompactState();
            } else {
                mach = new AutCompactState(p.name, p.importFile);
            }
            machines.addElement(mach.myclone());
            c.compiledProcesses.put(mach.name, mach);
            if (!p.imported()) {
                c.output.outln("Compiled: " + mach.name);
            } else {
                c.output.outln("Imported: " + mach.name);
            }
            return;
        }
        mach = AssertDefinition.compileConstraint(output, this.name, refname, actuals);
        if (mach != null) {
            machines.addElement(mach.myclone());
            c.compiledProcesses.put(mach.name, mach);
            return;
        }
        CompositionExpression ce = (CompositionExpression)c.composites.get(this.name.toString());
        if (ce == null) {
            Diagnostics.fatal("definition not found- " + this.name, this.name);
        }
        if (this.actualParams != null && this.actualParams.size() != ce.parameters.size()) {
            Diagnostics.fatal("actuals do not match formal parameters", this.name);
        }
        if (ce == c) {
            Hashtable save = (Hashtable)c.constants.clone();
            cs = ce.compose(actuals);
            c.constants = save;
        } else {
            cs = ce.compose(actuals);
        }
        if (cs.needNotCreate()) {
            Enumeration e = cs.machines.elements();
            while (e.hasMoreElements()) {
                mach = (CompactState)e.nextElement();
                mach.name = String.valueOf(cs.name) + "." + mach.name;
            }
            machines.addElement(cs);
        } else {
            mach = cs.create(output);
            c.compiledProcesses.put(mach.name, mach);
            c.output.outln("Compiled: " + mach.name);
            machines.addElement(mach.myclone());
        }
    }

    private Vector paramValues(Hashtable locals, CompositionExpression c) {
        if (this.actualParams == null) {
            return null;
        }
        Enumeration e = this.actualParams.elements();
        Vector<Value> v = new Vector<Value>();
        while (e.hasMoreElements()) {
            Stack stk = (Stack)e.nextElement();
            v.addElement(Expression.getValue(stk, locals, c.constants));
        }
        return v;
    }
}

