/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.Declaration;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.RelabelDefn;
import ic.doc.ltsa.lts.StateDefn;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ProcessSpec
extends Declaration {
    Symbol name;
    Hashtable constants;
    Hashtable init_constants = new Hashtable();
    Vector parameters = new Vector();
    Vector stateDefns = new Vector();
    LabelSet alphaAdditions;
    LabelSet alphaHidden;
    Vector alphaRelabel;
    boolean isProperty = false;
    boolean isMinimal = false;
    boolean isDeterministic = false;
    boolean exposeNotHide = false;
    File importFile = null;

    ProcessSpec() {
    }

    public boolean imported() {
        return this.importFile != null;
    }

    public String getname() {
        this.constants = (Hashtable)this.init_constants.clone();
        StateDefn s = (StateDefn)this.stateDefns.firstElement();
        this.name = s.name;
        if (s.range != null) {
            Diagnostics.fatal("process name cannot be indexed", this.name);
        }
        return s.name.toString();
    }

    public void explicitStates(StateMachine m) {
        Enumeration e = this.stateDefns.elements();
        while (e.hasMoreElements()) {
            Declaration d = (Declaration)e.nextElement();
            d.explicitStates(m);
        }
    }

    public void addAlphabet(StateMachine m) {
        if (this.alphaAdditions != null) {
            Vector a = this.alphaAdditions.getActions(this.constants);
            Enumeration e = a.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (m.alphabet.containsKey(s)) continue;
                m.alphabet.put(s, m.eventLabel.label());
            }
        }
    }

    public void hideAlphabet(StateMachine m) {
        if (this.alphaHidden == null) {
            return;
        }
        m.hidden = this.alphaHidden.getActions(this.constants);
    }

    public void relabelAlphabet(StateMachine m) {
        if (this.alphaRelabel == null) {
            return;
        }
        m.relabels = new Relation();
        Enumeration e = this.alphaRelabel.elements();
        while (e.hasMoreElements()) {
            RelabelDefn r = (RelabelDefn)e.nextElement();
            r.makeRelabels(this.constants, m.relabels);
        }
    }

    public void crunch(StateMachine m) {
        Enumeration e = this.stateDefns.elements();
        while (e.hasMoreElements()) {
            Declaration d = (Declaration)e.nextElement();
            d.crunch(m);
        }
    }

    public void transition(StateMachine m) {
        Enumeration e = this.stateDefns.elements();
        while (e.hasMoreElements()) {
            Declaration d = (Declaration)e.nextElement();
            d.transition(m);
        }
    }

    public void doParams(Vector actuals) {
        Enumeration a = actuals.elements();
        Enumeration f = this.parameters.elements();
        while (a.hasMoreElements() && f.hasMoreElements()) {
            this.constants.put(f.nextElement(), a.nextElement());
        }
    }

    public ProcessSpec myclone() {
        ProcessSpec p = new ProcessSpec();
        p.name = this.name;
        p.constants = (Hashtable)this.constants.clone();
        p.init_constants = this.init_constants;
        p.parameters = this.parameters;
        Enumeration e = this.stateDefns.elements();
        while (e.hasMoreElements()) {
            p.stateDefns.addElement(((StateDefn)e.nextElement()).myclone());
        }
        p.alphaAdditions = this.alphaAdditions;
        p.alphaHidden = this.alphaHidden;
        p.alphaRelabel = this.alphaRelabel;
        p.isProperty = this.isProperty;
        p.isMinimal = this.isMinimal;
        p.isDeterministic = this.isDeterministic;
        p.exposeNotHide = this.exposeNotHide;
        p.importFile = this.importFile;
        return p;
    }
}

