/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ChoiceElement;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Declaration;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.SeqProcessRef;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Transition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class StateExpr
extends Declaration {
    Vector processes;
    Symbol name;
    Vector expr;
    Vector choices;
    Stack boolexpr;
    StateExpr thenpart;
    StateExpr elsepart;

    StateExpr() {
    }

    public void addSeqProcessRef(SeqProcessRef sp) {
        if (this.processes == null) {
            this.processes = new Vector();
        }
        this.processes.addElement(sp);
    }

    public CompactState makeInserts(Hashtable locals, StateMachine m) {
        Vector<CompactState> seqs = new Vector<CompactState>();
        Enumeration e = this.processes.elements();
        while (e.hasMoreElements()) {
            SeqProcessRef sp = (SeqProcessRef)e.nextElement();
            CompactState mach = sp.instantiate(locals, m.constants);
            if (mach.isEnd()) continue;
            seqs.addElement(mach);
        }
        if (seqs.size() > 0) {
            return CompactState.sequentialCompose(seqs);
        }
        return null;
    }

    public Integer instantiate(Integer to, Hashtable locals, StateMachine m) {
        if (this.processes == null) {
            return to;
        }
        CompactState seqmach = this.makeInserts(locals, m);
        if (seqmach == null) {
            return to;
        }
        Integer start = m.stateLabel.interval(seqmach.maxStates);
        seqmach.offsetSeq(start, to);
        m.addSequential(start, seqmach);
        return start;
    }

    public void firstTransition(int from, Hashtable locals, StateMachine m) {
        if (this.boolexpr != null) {
            if (Expression.evaluate(this.boolexpr, locals, m.constants) != 0) {
                if (this.thenpart.name == null) {
                    this.thenpart.firstTransition(from, locals, m);
                }
            } else if (this.elsepart.name == null) {
                this.elsepart.firstTransition(from, locals, m);
            }
        } else {
            this.addTransition(from, locals, m);
        }
    }

    public void addTransition(int from, Hashtable locals, StateMachine m) {
        Enumeration e = this.choices.elements();
        while (e.hasMoreElements()) {
            ChoiceElement d = (ChoiceElement)e.nextElement();
            d.addTransition(from, locals, m);
        }
    }

    public void endTransition(int from, Symbol event, Hashtable locals, StateMachine m) {
        if (this.boolexpr != null) {
            if (Expression.evaluate(this.boolexpr, locals, m.constants) != 0) {
                this.thenpart.endTransition(from, event, locals, m);
            } else {
                this.elsepart.endTransition(from, event, locals, m);
            }
        } else if (this.name != null) {
            Integer to = (Integer)m.explicit_states.get(this.evalName(locals, m));
            if (to == null) {
                if (this.evalName(locals, m).equals("STOP")) {
                    to = m.stateLabel.label();
                    m.explicit_states.put("STOP", to);
                } else if (this.evalName(locals, m).equals("ERROR")) {
                    to = new Integer(-1);
                    m.explicit_states.put("ERROR", to);
                } else if (this.evalName(locals, m).equals("END")) {
                    to = m.stateLabel.label();
                    m.explicit_states.put("END", to);
                } else {
                    to = new Integer(-1);
                    m.explicit_states.put(this.evalName(locals, m), to);
                    Diagnostics.warning(String.valueOf(this.evalName(locals, m)) + " defined to be ERROR", "definition not found- " + this.evalName(locals, m), this.name);
                }
            }
            to = this.instantiate(to, locals, m);
            m.transitions.addElement(new Transition(from, event, to));
        } else {
            Integer to = m.stateLabel.label();
            m.transitions.addElement(new Transition(from, event, to));
            this.addTransition(to, locals, m);
        }
    }

    public String evalName(Hashtable locals, StateMachine m) {
        if (this.expr == null) {
            return this.name.toString();
        }
        Enumeration e = this.expr.elements();
        String s = this.name.toString();
        while (e.hasMoreElements()) {
            Stack x = (Stack)e.nextElement();
            s = String.valueOf(s) + "." + Expression.getValue(x, locals, m.constants);
        }
        return s;
    }

    public StateExpr myclone() {
        StateExpr se = new StateExpr();
        se.processes = this.processes;
        se.name = this.name;
        se.expr = this.expr;
        if (this.choices != null) {
            se.choices = new Vector();
            Enumeration e = this.choices.elements();
            while (e.hasMoreElements()) {
                se.choices.addElement(((ChoiceElement)e.nextElement()).myclone());
            }
        }
        se.boolexpr = this.boolexpr;
        if (this.thenpart != null) {
            se.thenpart = this.thenpart.myclone();
        }
        if (this.elsepart != null) {
            se.elsepart = this.elsepart.myclone();
        }
        return se;
    }
}

