/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.And;
import ic.doc.ltsa.lts.ltl.False;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.Next;
import ic.doc.ltsa.lts.ltl.Not;
import ic.doc.ltsa.lts.ltl.NotVisitor;
import ic.doc.ltsa.lts.ltl.Or;
import ic.doc.ltsa.lts.ltl.Proposition;
import ic.doc.ltsa.lts.ltl.Release;
import ic.doc.ltsa.lts.ltl.True;
import ic.doc.ltsa.lts.ltl.Until;
import ic.doc.ltsa.lts.ltl.UntilVisitor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;

public class FormulaFactory {
    NotVisitor nv = new NotVisitor(this);
    int id = 1;
    Map subf = new HashMap();
    SortedSet props = new TreeSet();
    Formula formula;
    Hashtable actionPredicates = null;
    private boolean hasNext = false;

    boolean nextInFormula() {
        return this.hasNext;
    }

    public void setFormula(Formula f) {
        this.formula = this.makeNot(f);
    }

    public Formula getFormula() {
        return this.formula;
    }

    public Formula make(Symbol sym) {
        return this.unique(new Proposition(sym));
    }

    public Formula make(Symbol sym, ActionLabels range, Hashtable locals, Hashtable globals) {
        range.initContext(locals, globals);
        Formula f = null;
        while (range.hasMoreNames()) {
            String s = range.nextName();
            Symbol newSym = new Symbol(sym, sym + "." + s);
            f = f == null ? this.make(newSym) : this.makeOr(f, this.make(newSym));
        }
        range.clearContext();
        return f;
    }

    public Formula make(Stack expr, Hashtable locals, Hashtable globals) {
        if (Expression.evaluate(expr, locals, globals) > 0) {
            return True.make();
        }
        return False.make();
    }

    public Formula make(ActionLabels act, Hashtable locals, Hashtable globals) {
        Vector av;
        String name;
        if (this.actionPredicates == null) {
            this.actionPredicates = new Hashtable();
        }
        if (!this.actionPredicates.containsKey(name = new Alphabet(av = act.getActions(locals, globals)).toString())) {
            this.actionPredicates.put(name, av);
        }
        return this.unique(new Proposition(new Symbol(123, name)));
    }

    public SortedSet getProps() {
        return this.props;
    }

    public Formula make(Formula left, Symbol op, Formula right) {
        switch (op.kind) {
            case 45: {
                return this.makeNot(right);
            }
            case 23: {
                return this.makeNext(right);
            }
            case 74: {
                return this.makeEventually(right);
            }
            case 75: {
                return this.makeAlways(right);
            }
            case 42: {
                return this.makeAnd(left, right);
            }
            case 40: {
                return this.makeOr(left, right);
            }
            case 69: {
                return this.makeImplies(left, right);
            }
            case 20: {
                return this.makeUntil(left, right);
            }
            case 77: {
                return this.makeWeakUntil(left, right);
            }
            case 76: {
                return this.makeEquivalent(left, right);
            }
        }
        Diagnostics.fatal("Unexpected operator in LTL expression: " + op, op);
        return null;
    }

    Formula makeAnd(Formula left, Formula right) {
        if (left == right) {
            return left;
        }
        if (left == False.make() || right == False.make()) {
            return False.make();
        }
        if (left == True.make()) {
            return right;
        }
        if (right == True.make()) {
            return left;
        }
        if (left == this.makeNot(right)) {
            return False.make();
        }
        if (left instanceof Next && right instanceof Next) {
            return this.makeNext(this.makeAnd(((Next)left).getNext(), ((Next)right).getNext()));
        }
        if (left.compareTo(right) < 0) {
            return this.unique(new And(left, right));
        }
        return this.unique(new And(right, left));
    }

    Formula makeOr(Formula left, Formula right) {
        if (left == right) {
            return left;
        }
        if (left == True.make() || right == True.make()) {
            return True.make();
        }
        if (left == False.make()) {
            return right;
        }
        if (right == False.make()) {
            return left;
        }
        if (left == this.makeNot(right)) {
            return True.make();
        }
        if (left.compareTo(right) < 0) {
            return this.unique(new Or(left, right));
        }
        return this.unique(new Or(right, left));
    }

    Formula makeUntil(Formula left, Formula right) {
        if (right == False.make()) {
            return False.make();
        }
        if (left instanceof Next && right instanceof Next) {
            return this.makeNext(this.makeUntil(((Next)left).getNext(), ((Next)right).getNext()));
        }
        return this.unique(new Until(left, right));
    }

    Formula makeWeakUntil(Formula left, Formula right) {
        return this.makeRelease(right, this.makeOr(left, right));
    }

    Formula makeRelease(Formula left, Formula right) {
        return this.unique(new Release(left, right));
    }

    Formula makeImplies(Formula left, Formula right) {
        return this.makeOr(this.makeNot(left), right);
    }

    Formula makeEquivalent(Formula left, Formula right) {
        return this.makeAnd(this.makeImplies(left, right), this.makeImplies(right, left));
    }

    Formula makeEventually(Formula right) {
        return this.makeUntil(True.make(), right);
    }

    Formula makeAlways(Formula right) {
        return this.makeRelease(False.make(), right);
    }

    Formula makeNot(Formula right) {
        return right.accept(this.nv);
    }

    Formula makeNot(Proposition p) {
        return this.unique(new Not(p));
    }

    Formula makeNext(Formula right) {
        this.hasNext = true;
        return this.unique(new Next(right));
    }

    int processUntils(Formula f, List untils) {
        f.accept(new UntilVisitor(this, untils));
        return untils.size();
    }

    boolean specialCaseV(Formula f, Set s) {
        Formula ff = this.makeRelease(False.make(), f);
        return s.contains(ff);
    }

    boolean syntaxImplied(Formula f, SortedSet one, SortedSet two) {
        if (f == null) {
            return true;
        }
        if (f instanceof True) {
            return true;
        }
        if (one.contains(f)) {
            return true;
        }
        if (f.isLiteral()) {
            return false;
        }
        Formula a = f.getSub1();
        Formula b = f.getSub2();
        Formula c = f instanceof Until || f instanceof Release ? f : null;
        boolean bf = this.syntaxImplied(b, one, two);
        boolean af = this.syntaxImplied(a, one, two);
        boolean cf = c != null ? (two != null ? two.contains(c) : false) : true;
        if (f instanceof Until || f instanceof Or) {
            return bf || af && cf;
        }
        if (f instanceof Release) {
            return af && bf || af && cf;
        }
        if (f instanceof And) {
            return af && bf;
        }
        if (f instanceof Next) {
            if (a != null) {
                if (two != null) {
                    return two.contains(a);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private int newId() {
        return ++this.id;
    }

    private Formula unique(Formula f) {
        String s = f.toString();
        if (this.subf.containsKey(s)) {
            return (Formula)this.subf.get(s);
        }
        f.setId(this.newId());
        this.subf.put(s, f);
        if (f instanceof Proposition) {
            this.props.add(f);
        }
        return f;
    }
}

