/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.ws;

import ic.doc.ltsa.ws.bpelaction;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import mscedit.BMSC;
import mscedit.HMSC;
import mscedit.Link;
import mscedit.MSCEditorControl;
import mscedit.Specification;
import mscedit.Transition;

public class Msc2Bpel {
    private String bpel_translation;
    private Specification msc_spec;
    private String msc_xml;
    private boolean isXMLFile;
    private LinkedList scenarioactions;
    private LinkedList FSPProcessList;
    private String instanceFilter = "";

    private void initvars() {
        this.bpel_translation = "";
        this.FSPProcessList = new LinkedList();
    }

    public Specification getSpecification() {
        return this.msc_spec;
    }

    public void setInstanceFilter(String filter) {
        this.instanceFilter = filter;
    }

    public Msc2Bpel(String Msc, boolean isFile) {
        this.initvars();
        this.isXMLFile = isFile;
        if (this.isXMLFile) {
            MSCEditorControl mec = new MSCEditorControl(null);
            this.msc_spec = mec.getSpecificationFromFile(new File(Msc));
        } else {
            this.msc_xml = Msc;
        }
        this.scenarioactions = new LinkedList();
    }

    private void addtoBPEL(String bpel, boolean addline) {
        if (addline) {
            this.bpel_translation = String.valueOf(this.bpel_translation) + "\n";
        }
        this.bpel_translation = String.valueOf(this.bpel_translation) + bpel;
    }

    private void buildBPELHeader() {
        this.bpel_translation = "";
        this.addtoBPEL("<process name=\"myprocess\"", true);
        this.addtoBPEL("\ttargetNamespace=\"http://my.com/mynamespace\"", true);
        this.addtoBPEL("\tsuppressJoinFailure=\"yes\"", true);
        this.addtoBPEL("\txmlns=\"http://schemas.xmlsoap.org/ws/2003/03/business-process\">", true);
        this.addtoBPEL("\txmlns:processdef=\"http://partner.com/services/partnerdef\">", true);
        this.addtoBPEL("\txmlns:slt=\"http://my.com/wsdl/process-wsdl\">", true);
        this.addtoBPEL("\txmlns:ppt=\"http://partner.com/services/partner\">", true);
    }

    private void buildBPELFooter() {
        this.addtoBPEL("</process>", true);
    }

    private void buildBPELVariables() {
        this.addtoBPEL("\t<variables>", true);
        this.addtoBPEL("\t<variable name=\"request\" messageType=\"processdef:requestMessage\" />", true);
        this.addtoBPEL("\t</variables>", true);
    }

    private String buildPartner(String name, String linkType, String role) {
        String partnerstr = "";
        partnerstr = String.valueOf(partnerstr) + "\t<partner";
        partnerstr = String.valueOf(partnerstr) + " name=\"" + name + "\"";
        partnerstr = String.valueOf(partnerstr) + " serviceLinkType=\"" + linkType + "\"";
        partnerstr = String.valueOf(partnerstr) + " myRole=\"" + role + "\"";
        partnerstr = String.valueOf(partnerstr) + "/>";
        return partnerstr;
    }

    private String buildInvoke(String name, String partner, String portType, String operation, String inputVariable, String outputVariable) {
        String invokestr = "";
        invokestr = "<invoke name=\"" + name + "\"";
        invokestr = String.valueOf(invokestr) + " partner=\"" + partner + "\"";
        invokestr = String.valueOf(invokestr) + " portType=\"" + portType + "\"";
        invokestr = String.valueOf(invokestr) + " operation=\"" + operation + "\"";
        invokestr = String.valueOf(invokestr) + " inputVariable=\"" + operation + "\"";
        if (outputVariable.length() > 0) {
            invokestr = String.valueOf(invokestr) + " outputVariable=\"" + operation + "\"";
        }
        invokestr = String.valueOf(invokestr) + ">\n</invoke>";
        return invokestr;
    }

    private String buildReceive(String name, String partner, String portType, String operation, String variable) {
        String bpelstr = "";
        bpelstr = "<receive name=\"" + name + "\"";
        bpelstr = String.valueOf(bpelstr) + " partner=\"" + partner + "\"";
        bpelstr = String.valueOf(bpelstr) + " portType=\"" + portType + "\"";
        bpelstr = String.valueOf(bpelstr) + " operation=\"" + operation + "\"";
        bpelstr = String.valueOf(bpelstr) + " variable=\"" + operation + "\"";
        bpelstr = String.valueOf(bpelstr) + ">\n</receive>";
        return bpelstr;
    }

    private void buildBPELPartners() {
        this.addtoBPEL("<partners>", true);
        this.addtoBPEL(this.buildPartner("customer", "slt:customerLinkType", "myrole"), true);
        this.addtoBPEL("</partners>", true);
    }

    private BMSC getBMScByName(String name) {
        boolean found = false;
        BMSC foundBMSc = null;
        List bMScs = this.msc_spec.getBMSCs();
        Iterator bMScIterator = bMScs.iterator();
        while (bMScIterator.hasNext() && !found) {
            BMSC bMscelem = (BMSC)bMScIterator.next();
            if (!bMscelem.getName().equals(name)) continue;
            found = true;
            foundBMSc = bMscelem;
        }
        return foundBMSc;
    }

    private bpelaction link2BPELAction(Link alink) {
        String actionstring = "";
        int start = alink.getName().lastIndexOf(",");
        int end = alink.getName().lastIndexOf("_");
        if (start < 0 || end < 0) {
            actionstring = String.valueOf(actionstring) + "invoke" + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        } else {
            actionstring = String.valueOf(alink.getName().substring(start + 1, end)) + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        }
        bpelaction bpaction = new bpelaction(actionstring);
        return bpaction;
    }

    private List sortActionListbyTime(List listtosort) {
        LinkedList<Link> sortedList = null;
        sortedList = new LinkedList<Link>();
        int count = 1;
        while (count <= listtosort.size()) {
            ListIterator actions = listtosort.listIterator();
            while (actions.hasNext()) {
                Link nextLink = (Link)actions.next();
                if (nextLink.getTimeIndex() != count) continue;
                sortedList.add(nextLink);
            }
            ++count;
        }
        return sortedList;
    }

    private String GenerateUniqueProcessName(String name) {
        String newName = name;
        int index = 1;
        while (this.FSPProcessList.contains(newName)) {
            newName = String.valueOf(name) + index;
            ++index;
        }
        this.FSPProcessList.add(newName);
        return newName;
    }

    private void translateScenario(String bMSC_name) {
        BMSC scenarioBMSC = this.getBMScByName(bMSC_name);
        bpelaction bpa = null;
        List timedactions = null;
        String strAction = "";
        String strName = "";
        boolean isrepeating = false;
        isrepeating = this.isRepeatingScenario(bMSC_name);
        if (isrepeating) {
            this.addtoBPEL("<while condition=\"bpws:getVariableData('variable','part')\">", true);
            this.addtoBPEL("<sequence>", true);
        }
        timedactions = this.sortActionListbyTime(scenarioBMSC.getLinks());
        ListIterator actions = timedactions.listIterator();
        while (actions.hasNext()) {
            strAction = "";
            Link nextLink = (Link)actions.next();
            bpa = this.link2BPELAction(nextLink);
            if (bpa == null) continue;
            if (this.instanceFilter.length() > 0 && this.instanceFilter.equals(bpa.getPartner1()) || this.instanceFilter.equals("All")) {
                if (bpa.getAction().equals("invoke")) {
                    strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
                    strAction = this.buildInvoke(strName, bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin", "");
                }
                if (bpa.getAction().equals("reply")) {
                    strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
                    strAction = this.buildReceive(strName, bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin");
                }
            }
            this.addtoBPEL(strAction, true);
            this.scenarioactions.add(bpa);
        }
        if (isrepeating) {
            this.addtoBPEL("</sequence>", true);
            this.addtoBPEL("</while>", true);
        }
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (trans.getFrom().equals(bMSC_name) && !trans.getTo().equals(bMSC_name)) {
                this.translateScenario(trans.getTo());
            }
            trans.getOutputs().iterator();
        }
    }

    private boolean isRepeatingScenario(String scenario) {
        boolean result = false;
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (!trans.getFrom().equals(scenario) || !trans.getTo().equals(scenario)) continue;
            result = true;
        }
        return result;
    }

    private void buildBPELBody() {
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        this.addtoBPEL("<sequence>", true);
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (trans.getFrom().equals("init")) {
                this.translateScenario(trans.getTo());
            }
            trans.getOutputs().iterator();
        }
        this.addtoBPEL("</sequence>", true);
    }

    public String toBPEL() {
        if (this.msc_spec != null) {
            this.buildBPELHeader();
            this.buildBPELVariables();
            this.buildBPELPartners();
            this.buildBPELBody();
            this.buildBPELFooter();
            return this.bpel_translation;
        }
        return "";
    }
}

