/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.ws;

import ic.doc.ltsa.ws.wsaction;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import mscedit.BMSC;
import mscedit.HMSC;
import mscedit.Link;
import mscedit.MSCEditorControl;
import mscedit.Specification;
import mscedit.Transition;

public class Msc2WSCDL {
    private String wscdl_translation;
    private Specification msc_spec;
    private String msc_xml;
    private boolean isXMLFile;
    private LinkedList scenarioactions;

    private void initvars() {
        this.wscdl_translation = "";
    }

    public Msc2WSCDL(String Msc, boolean isFile) {
        this.initvars();
        this.isXMLFile = isFile;
        if (this.isXMLFile) {
            MSCEditorControl mec = new MSCEditorControl(null);
            this.msc_spec = mec.getSpecificationFromFile(new File(Msc));
        } else {
            this.msc_xml = Msc;
        }
        this.scenarioactions = new LinkedList();
    }

    private void addtowscdl(String wscdl, boolean addline) {
        if (addline) {
            this.wscdl_translation = String.valueOf(this.wscdl_translation) + "\n";
        }
        this.wscdl_translation = String.valueOf(this.wscdl_translation) + wscdl;
    }

    private void buildwscdlHeader() {
        this.wscdl_translation = "";
        this.addtowscdl("<process name=\"myprocess\"", true);
        this.addtowscdl("\ttargetNamespace=\"http://my.com/mynamespace\"", true);
        this.addtowscdl("\tsuppressJoinFailure=\"yes\"", true);
        this.addtowscdl("\txmlns=\"http://schemas.xmlsoap.org/ws/2003/03/business-process\">", true);
        this.addtowscdl("\txmlns:processdef=\"http://partner.com/services/partnerdef\">", true);
        this.addtowscdl("\txmlns:slt=\"http://my.com/wsdl/process-wsdl\">", true);
        this.addtowscdl("\txmlns:ppt=\"http://partner.com/services/partner\">", true);
    }

    private void buildwscdlFooter() {
        this.addtowscdl("</process>", true);
    }

    private void buildwscdlVariables() {
        this.addtowscdl("\t<variables>", true);
        this.addtowscdl("\t<variable name=\"request\" messageType=\"processdef:requestMessage\" />", true);
        this.addtowscdl("\t</variables>", true);
    }

    private String buildPartner(String name, String linkType, String role) {
        String partnerstr = "";
        partnerstr = String.valueOf(partnerstr) + "\t<partner";
        partnerstr = String.valueOf(partnerstr) + " name=\"" + name + "\"";
        partnerstr = String.valueOf(partnerstr) + " serviceLinkType=\"" + linkType + "\"";
        partnerstr = String.valueOf(partnerstr) + " myRole=\"" + role + "\"";
        partnerstr = String.valueOf(partnerstr) + "/>";
        return partnerstr;
    }

    private String buildInvoke(String name, String partner, String portType, String operation, String inputVariable, String outputVariable) {
        String invokestr = "";
        invokestr = "<invoke name=\"" + name + "\"";
        invokestr = String.valueOf(invokestr) + " partner=\"" + partner + "\"";
        invokestr = String.valueOf(invokestr) + " portType=\"" + portType + "\"";
        invokestr = String.valueOf(invokestr) + " operation=\"" + operation + "\"";
        invokestr = String.valueOf(invokestr) + " inputVariable=\"" + operation + "\"";
        invokestr = String.valueOf(invokestr) + " outputVariable=\"" + operation + "\"";
        invokestr = String.valueOf(invokestr) + "\n></invoke>";
        return invokestr;
    }

    private String buildReceive(String name, String partner, String portType, String operation, String variable) {
        String invokestr = "";
        invokestr = "<receive name=\"" + name + "\"";
        invokestr = String.valueOf(invokestr) + " partner=\"" + partner + "\"";
        invokestr = String.valueOf(invokestr) + " portType=\"" + portType + "\"";
        invokestr = String.valueOf(invokestr) + " operation=\"" + operation + "\"";
        invokestr = String.valueOf(invokestr) + " variable=\"" + operation + "\"";
        invokestr = String.valueOf(invokestr) + "\n></receive>";
        return invokestr;
    }

    private void buildwscdlPartners() {
        this.addtowscdl("<partners>", true);
        this.addtowscdl(this.buildPartner("customer", "slt:customerLinkType", "myrole"), true);
        this.addtowscdl("</partners>", true);
    }

    private BMSC getBMScByName(String name) {
        boolean found = false;
        BMSC foundBMSc = null;
        List bMScs = this.msc_spec.getBMSCs();
        Iterator bMScIterator = bMScs.iterator();
        while (bMScIterator.hasNext() && !found) {
            BMSC bMscelem = (BMSC)bMScIterator.next();
            if (!bMscelem.getName().equals(name)) continue;
            found = true;
            foundBMSc = bMscelem;
        }
        return foundBMSc;
    }

    private wsaction link2wsaction(Link alink) {
        String actionstring = "";
        int start = alink.getName().lastIndexOf(",");
        int end = alink.getName().lastIndexOf("_");
        if (start < 0 || end < 0) {
            actionstring = String.valueOf(actionstring) + "invoke" + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        } else {
            actionstring = String.valueOf(alink.getName().substring(start + 1, end)) + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        }
        wsaction bpaction = new wsaction(actionstring);
        return bpaction;
    }

    private List sortActionListbyTime(List listtosort) {
        LinkedList<Link> sortedList = null;
        sortedList = new LinkedList<Link>();
        int count = 1;
        while (count <= listtosort.size()) {
            ListIterator actions = listtosort.listIterator();
            while (actions.hasNext()) {
                Link nextLink = (Link)actions.next();
                if (nextLink.getTimeIndex() != count) continue;
                sortedList.add(nextLink);
            }
            ++count;
        }
        return sortedList;
    }

    private void translateScenario(String bMSC_name) {
        BMSC scenarioBMSC = this.getBMScByName(bMSC_name);
        wsaction bpa = null;
        List timedactions = null;
        String strAction = "";
        timedactions = this.sortActionListbyTime(scenarioBMSC.getLinks());
        ListIterator actions = timedactions.listIterator();
        while (actions.hasNext()) {
            strAction = "";
            Link nextLink = (Link)actions.next();
            bpa = this.link2wsaction(nextLink);
            if (bpa != null) {
                if (bpa.getAction().equals("invoke")) {
                    strAction = this.buildInvoke(String.valueOf(bpa.getPartner1()) + bpa.getOperation(), bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin", "testout");
                }
                if (bpa.getAction().equals("reply")) {
                    strAction = this.buildReceive(String.valueOf(bpa.getPartner1()) + bpa.getOperation(), bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin");
                }
            }
            this.addtowscdl(strAction, true);
            this.scenarioactions.add(bpa);
        }
    }

    private void buildwscdlBody() {
        HMSC hMsc = this.msc_spec.getHMSC();
        hMsc.getTransitions();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (trans.getFrom().equals("init")) {
                this.addtowscdl("<sequence>", true);
                this.translateScenario(trans.getTo());
                this.addtowscdl("</sequence>", true);
            }
            trans.getOutputs().iterator();
        }
    }

    public String towscdl() {
        if (this.msc_spec != null) {
            this.buildwscdlHeader();
            this.buildwscdlVariables();
            this.buildwscdlPartners();
            this.buildwscdlBody();
            this.buildwscdlFooter();
            return this.wscdl_translation;
        }
        return "";
    }
}

