/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.ws;

import ic.doc.ltsa.ws.bpelaction;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import mscedit.BMSC;
import mscedit.HMSC;
import mscedit.Link;
import mscedit.MSCEditorControl;
import mscedit.Specification;
import mscedit.Transition;

public class MscFSP2Bpel {
    private String bpel_translation;
    private Specification msc_spec;
    private String msc_xml = "";
    private String msc_fsp = "";
    private boolean isXMLFile;
    private boolean isFiltered;
    private MSCEditorControl mec = null;
    private LinkedList scenarioactions;
    private LinkedList FSPProcessList;
    private LinkedList callStack;
    private LinkedList partnerList;
    private LinkedList varList;
    private String instanceFilter = "";
    private String origInstanceFilter = "";

    private void initvars() {
        this.bpel_translation = "";
        this.FSPProcessList = new LinkedList();
        this.callStack = new LinkedList();
        this.partnerList = new LinkedList();
        this.varList = new LinkedList();
        this.isFiltered = false;
    }

    public Specification getSpecification() {
        return this.msc_spec;
    }

    public void setInstanceFilter(String filter) {
        this.origInstanceFilter = filter;
        this.instanceFilter = filter.toLowerCase();
        this.isFiltered = !filter.equals("All");
    }

    private boolean addPartner(String partnername) {
        boolean result = false;
        if (!this.partnerList.contains(partnername)) {
            this.partnerList.add(partnername);
        }
        return result;
    }

    private boolean addVar(String varname) {
        boolean result = false;
        if (!this.varList.contains(varname)) {
            this.varList.add(varname);
        }
        return result;
    }

    private String getFSPfromMSCXML(String filename) {
        String lts = this.mec.doSynthesiseFromFile(new File(filename));
        return lts;
    }

    public String getFSP() {
        return this.msc_fsp;
    }

    public MscFSP2Bpel(String MscFSP, boolean isFile) {
        this.initvars();
        this.mec = new MSCEditorControl(null);
        this.isXMLFile = isFile;
        if (this.isXMLFile) {
            this.msc_spec = this.mec.getSpecificationFromFile(new File(MscFSP));
            this.msc_fsp = this.mec.doSynthesiseFromFile(new File(MscFSP));
        } else {
            this.msc_xml = MscFSP;
        }
        this.scenarioactions = new LinkedList();
    }

    private void addtoBPEL(String bpel, boolean addline) {
        if (addline) {
            this.bpel_translation = String.valueOf(this.bpel_translation) + "\n";
        }
        this.bpel_translation = String.valueOf(this.bpel_translation) + bpel;
    }

    private void createtemplateBPELHeader(String process_name) {
        this.bpel_translation = "";
        this.addtoBPEL("<process name=\"" + process_name + "\"", true);
        this.addtoBPEL("\ttargetNamespace=\"http://my.com/mynamespace\"", true);
        this.addtoBPEL("\tsuppressJoinFailure=\"yes\"", true);
        this.addtoBPEL("\txmlns=\"http://schemas.xmlsoap.org/ws/2003/03/business-process\">", true);
        this.addtoBPEL("\txmlns:processdef=\"http://partner.com/services/partnerdef\">", true);
        this.addtoBPEL("\txmlns:slt=\"http://my.com/wsdl/process-wsdl\">", true);
        this.addtoBPEL("\txmlns:ppt=\"http://partner.com/services/partner\">", true);
    }

    private void createtemplateBPELFooter() {
        this.addtoBPEL("</process>", true);
    }

    private void buildBPELVariables() {
        this.addtoBPEL("\t<variables>", true);
        Iterator var = this.varList.iterator();
        while (var.hasNext()) {
            String varstr = (String)var.next();
            this.addtoBPEL("\t\t<variable name=\"" + varstr + "\" messageType=\"processdef:" + varstr + "MessageType\" />", true);
        }
        this.addtoBPEL("\t</variables>", true);
    }

    private String buildTabs(int tablevel) {
        String tabstr = "";
        int tab = 0;
        while (tab < tablevel) {
            tabstr = String.valueOf(tabstr) + "\t";
            ++tab;
        }
        return tabstr;
    }

    private String createtemplatePartner(int tablevel, String name, String linkType, String role) {
        String partnerstr = "";
        partnerstr = String.valueOf(partnerstr) + this.buildTabs(tablevel) + "<partner";
        partnerstr = String.valueOf(partnerstr) + " name=\"" + name + "\"";
        partnerstr = String.valueOf(partnerstr) + " serviceLinkType=\"" + linkType + "\"";
        partnerstr = String.valueOf(partnerstr) + " myRole=\"" + role + "\"";
        partnerstr = String.valueOf(partnerstr) + "/>";
        return partnerstr;
    }

    private String buildInvoke(int tablevel, String name, String partner, String portType, String operation, String inputVariable, String outputVariable) {
        String invokestr = "";
        invokestr = "\n" + this.buildTabs(tablevel) + "<invoke name=\"" + name + "\"";
        invokestr = String.valueOf(invokestr) + " partner=\"" + partner + "\"";
        invokestr = String.valueOf(invokestr) + " portType=\"" + portType + "\"";
        invokestr = String.valueOf(invokestr) + " operation=\"" + operation + "\"";
        invokestr = String.valueOf(invokestr) + " inputVariable=\"" + operation + "\"";
        if (outputVariable.length() > 0) {
            invokestr = String.valueOf(invokestr) + " outputVariable=\"" + operation + "\"";
        }
        invokestr = String.valueOf(invokestr) + ">\n" + this.buildTabs(tablevel) + "</invoke>";
        return invokestr;
    }

    private String buildReceive(int tablevel, String name, String partner, String portType, String operation, String variable) {
        String bpelstr = "";
        bpelstr = "\n" + this.buildTabs(tablevel) + "<receive name=\"" + name + "\"";
        bpelstr = String.valueOf(bpelstr) + " partner=\"" + partner + "\"";
        bpelstr = String.valueOf(bpelstr) + " portType=\"" + portType + "\"";
        bpelstr = String.valueOf(bpelstr) + " operation=\"" + operation + "\"";
        bpelstr = String.valueOf(bpelstr) + " variable=\"" + operation + "\"";
        bpelstr = String.valueOf(bpelstr) + ">\n" + this.buildTabs(tablevel) + "</receive>";
        return bpelstr;
    }

    private String buildReply(int tablevel, String name, String partner, String portType, String operation, String variable) {
        String bpelstr = "";
        bpelstr = "\n" + this.buildTabs(tablevel) + "<reply name=\"" + name + "\"";
        bpelstr = String.valueOf(bpelstr) + " partner=\"" + partner + "\"";
        bpelstr = String.valueOf(bpelstr) + " portType=\"" + portType + "\"";
        bpelstr = String.valueOf(bpelstr) + " operation=\"" + operation + "\"";
        bpelstr = String.valueOf(bpelstr) + " variable=\"" + operation + "\"";
        bpelstr = String.valueOf(bpelstr) + ">\n" + this.buildTabs(tablevel) + "</reply>";
        return bpelstr;
    }

    private String buildWhile(String variable, String while_body) {
        String while_construct = "";
        while_construct = "\n<while condition=\"bpws:getVariableData('variable','part')\">\n";
        while_construct = String.valueOf(while_construct) + "<sequence>" + "\n";
        while_construct = String.valueOf(while_construct) + while_body + "\n";
        while_construct = String.valueOf(while_construct) + "</sequence>" + "\n";
        while_construct = String.valueOf(while_construct) + "</while>" + "\n";
        return while_construct;
    }

    private String buildSwitch(String variable, String body) {
        String construct = "";
        construct = "\n<switch name=\"" + variable + "\"\n";
        construct = String.valueOf(construct) + "<case condition=\"scenario1condition\">" + "\n";
        construct = String.valueOf(construct) + body + "\n";
        construct = String.valueOf(construct) + "</case>" + "\n";
        construct = String.valueOf(construct) + "</switch>" + "\n";
        return construct;
    }

    private void createtemplateBPELPartners() {
        this.addtoBPEL("\n\t<partners>", true);
        Iterator partner = this.partnerList.iterator();
        while (partner.hasNext()) {
            String partnerstr = (String)partner.next();
            this.addtoBPEL(this.createtemplatePartner(2, partnerstr, "slt:" + partnerstr + "LinkType", "myrole"), true);
        }
        this.addtoBPEL("\t</partners>", true);
    }

    private BMSC getBMScByName(String name) {
        boolean found = false;
        BMSC foundBMSc = null;
        List bMScs = this.msc_spec.getBMSCs();
        Iterator bMScIterator = bMScs.iterator();
        while (bMScIterator.hasNext() && !found) {
            BMSC bMscelem = (BMSC)bMScIterator.next();
            if (!bMscelem.getName().equals(name)) continue;
            found = true;
            foundBMSc = bMscelem;
        }
        return foundBMSc;
    }

    private bpelaction link2BPELAction(Link alink) {
        String actionstring = "";
        int start = alink.getName().lastIndexOf(",");
        int end = alink.getName().lastIndexOf("_");
        if (start < 0 || end < 0) {
            actionstring = String.valueOf(actionstring) + "invoke" + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        } else {
            actionstring = String.valueOf(alink.getName().substring(start + 1, end)) + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        }
        bpelaction bpaction = new bpelaction(actionstring);
        return bpaction;
    }

    private bpelaction fspAction2BPELAction(String fspactionstr) {
        String bpelactionstring = "";
        String from = "";
        String to = "";
        String action = "";
        String method = "";
        int start = 0;
        int end = 0;
        start = 1;
        end = fspactionstr.indexOf(".");
        if (end > 0) {
            from = fspactionstr.substring(0, end);
        }
        if ((end = fspactionstr.indexOf(".", (start = end) + 1)) > 0) {
            to = fspactionstr.substring(start + 1, end);
        }
        if ((end = fspactionstr.indexOf("_", start = end)) > 0) {
            action = fspactionstr.substring(start + 1, end);
        }
        start = end;
        end = fspactionstr.length();
        method = fspactionstr.substring(start + 1, end);
        bpelactionstring = String.valueOf(action) + "_";
        bpelactionstring = String.valueOf(bpelactionstring) + from + "_";
        bpelactionstring = String.valueOf(bpelactionstring) + to + "_";
        bpelactionstring = String.valueOf(bpelactionstring) + method;
        bpelaction bpaction = new bpelaction(bpelactionstring);
        return bpaction;
    }

    private List sortActionListbyTime(List listtosort) {
        LinkedList<Link> sortedList = null;
        sortedList = new LinkedList<Link>();
        int count = 1;
        while (count <= listtosort.size()) {
            ListIterator actions = listtosort.listIterator();
            while (actions.hasNext()) {
                Link nextLink = (Link)actions.next();
                if (nextLink.getTimeIndex() != count) continue;
                sortedList.add(nextLink);
            }
            ++count;
        }
        return sortedList;
    }

    private String GenerateUniqueProcessName(String name) {
        String newName = name;
        int index = 1;
        while (this.FSPProcessList.contains(newName)) {
            newName = String.valueOf(name) + index;
            ++index;
        }
        this.FSPProcessList.add(newName);
        return newName;
    }

    private void translateScenario(int tablevel, String bMSC_name) {
        BMSC scenarioBMSC = this.getBMScByName(bMSC_name);
        bpelaction bpa = null;
        List timedactions = null;
        String strAction = "";
        String strName = "";
        boolean isrepeating = false;
        isrepeating = this.isRepeatingScenario(bMSC_name);
        if (isrepeating) {
            this.addtoBPEL("<while condition=\"bpws:getVariableData('variable','part')\">", true);
            this.addtoBPEL("<sequence>", true);
        }
        timedactions = this.sortActionListbyTime(scenarioBMSC.getLinks());
        ListIterator actions = timedactions.listIterator();
        while (actions.hasNext()) {
            strAction = "";
            Link nextLink = (Link)actions.next();
            bpa = this.link2BPELAction(nextLink);
            if (bpa == null) continue;
            if (this.instanceFilter.length() > 0 && this.instanceFilter.equals(bpa.getPartner1()) || this.instanceFilter.equals("All")) {
                if (bpa.getAction().equals("invoke")) {
                    strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
                    strAction = this.buildInvoke(tablevel, strName, bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin", "");
                }
                if (bpa.getAction().equals("reply")) {
                    strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
                    strAction = this.buildReceive(tablevel, strName, bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin");
                }
            }
            this.addtoBPEL(strAction, true);
            this.scenarioactions.add(bpa);
        }
        if (isrepeating) {
            this.addtoBPEL("</sequence>", true);
            this.addtoBPEL("</while>", true);
        }
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (trans.getFrom().equals(bMSC_name) && !trans.getTo().equals(bMSC_name)) {
                this.translateScenario(tablevel + 1, trans.getTo());
            }
            trans.getOutputs().iterator();
        }
    }

    private boolean isRepeatingScenario(String scenario) {
        boolean result = false;
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (!trans.getFrom().equals(scenario) || !trans.getTo().equals(scenario)) continue;
            result = true;
        }
        return result;
    }

    public String getComponentFSPBody(String component_name) {
        String componentBody = "";
        String componentID = "////Component " + component_name;
        String componentendID = "deterministic";
        if (this.msc_fsp.length() > 0) {
            int start = 0;
            int end = 0;
            start = this.msc_fsp.indexOf(componentID);
            if (start > 0 && (end = this.msc_fsp.indexOf(componentendID, start)) > 0) {
                componentBody = this.msc_fsp.substring(start + componentID.length(), end);
            }
        }
        return componentBody;
    }

    public String getComponentProcessByNo(String component_name, int number) {
        String componentID = String.valueOf(component_name) + "_N" + number + " = ";
        return this.getComponentProcessByLabel(componentID, ",");
    }

    public String getComponentProcessByLabel(String component_label, String component_end) {
        String componentBody = "";
        String componentID = String.valueOf(component_label) + " = ";
        String componentendID = component_end;
        int nlpos = 0;
        if (this.msc_fsp.length() > 0) {
            int start = 0;
            int end = 0;
            start = this.msc_fsp.indexOf(componentID);
            if (start > 0) {
                end = this.msc_fsp.indexOf(componentendID, start);
                nlpos = this.msc_fsp.indexOf("\r", start);
                if (nlpos < end && nlpos > -1) {
                    end = nlpos - 1;
                }
                if (end > 0) {
                    componentBody = this.msc_fsp.substring(start + componentID.length(), end + componentendID.length());
                } else {
                    end = this.msc_fsp.indexOf(",", start);
                    if (end > 0) {
                        componentBody = this.msc_fsp.substring(start + componentID.length(), end + componentendID.length());
                    }
                }
            }
        }
        return componentBody;
    }

    public String getComponentProcessAdjByLabel(String component_name, int number) {
        String componentBody = "";
        String componentID = String.valueOf(component_name) + "_N" + number + "_Adj = ";
        String componentendID = ",";
        if (this.msc_fsp.length() > 0) {
            int start = 0;
            int end = 0;
            start = this.msc_fsp.indexOf(componentID);
            if (start > 0 && (end = this.msc_fsp.indexOf(componentendID, start)) > 0) {
                componentBody = this.msc_fsp.substring(start + componentID.length(), end - componentendID.length());
            }
        }
        return componentBody;
    }

    private String translateBPELAction(int tab, bpelaction bpa) {
        String strName = "";
        String strAction = "";
        if (bpa.getAction().equals("invoke")) {
            if (!this.isFiltered || !bpa.getPartner1().equals(this.instanceFilter) && !bpa.getPartner2().equals(this.instanceFilter)) {
                return "";
            }
            if (this.isFiltered && bpa.getPartner1().equals(this.instanceFilter)) {
                strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
                strAction = this.buildInvoke(tab, strName, bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin", "");
            } else {
                strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner2()) + "receive");
                strAction = this.buildReceive(tab, strName, bpa.getPartner1(), "ppt:" + bpa.getPartner1(), "receive", "testin");
            }
        }
        if (bpa.getAction().equals("reply")) {
            strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
            strAction = this.isFiltered && bpa.getPartner1().equals(this.instanceFilter) ? this.buildReply(tab, strName, bpa.getPartner2(), "ppt:" + bpa.getPartner2(), bpa.getOperation(), "testin") : this.buildReceive(tab, strName, bpa.getPartner1(), "ppt:" + bpa.getPartner1(), bpa.getOperation(), "testin");
        }
        if (strAction.length() > 0) {
            this.addPartner(bpa.getPartner1());
            this.addPartner(bpa.getPartner2());
            this.addVar(bpa.getOperation());
        }
        return strAction;
    }

    private String buildScenarioBPEL(int tablevel, String curr_process_part, String curr_process_label) {
        String scenario_label = "";
        int action_start = 0;
        int action_end = 0;
        String curr_action = "";
        String bpel = "";
        scenario_label = "s_" + curr_process_label + " -> ";
        action_end = action_start = curr_process_part.indexOf(scenario_label) + scenario_label.length();
        while (action_end > 0) {
            action_end = curr_process_part.indexOf(" -> ", action_start);
            if (action_end <= 0) continue;
            curr_action = curr_process_part.substring(action_start, action_end);
            bpelaction curr_bpa = this.fspAction2BPELAction(curr_action);
            bpel = String.valueOf(bpel) + this.translateBPELAction(tablevel, curr_bpa);
            action_start = action_end + 4;
        }
        return bpel;
    }

    private String translateComponentBodytoBPEL(int tablevel, String process_name, String process, String acc_bpel) {
        String bpel = "";
        String curr_bpel = "";
        String temp_bpel = "";
        String curr_process = "";
        String curr_process_part = "";
        String curr_process_label = "";
        String end_marker = "";
        int choice_start = 0;
        int choice_count = 0;
        boolean has_choices = false;
        int process_start = 0;
        int process_part_start = 0;
        curr_process = process;
        if (process.length() < 1) {
            return "";
        }
        choice_start = curr_process.indexOf("|");
        if (choice_start > 0) {
            has_choices = true;
            choice_start = 0;
            choice_count = 0;
            while (choice_start < curr_process.length() - 1) {
                if ((choice_start = curr_process.indexOf("|", choice_start + 1)) == -1) {
                    choice_start = curr_process.length() - 1;
                    continue;
                }
                ++choice_count;
            }
            if (has_choices) {
                bpel = String.valueOf(bpel) + "\n" + this.buildTabs(tablevel) + "<switch name=\"test\">";
                ++tablevel;
            }
            int choice = 0;
            while (choice <= choice_count) {
                int choicemarkcount = 0;
                process_start = 0;
                while (choicemarkcount < choice) {
                    int oldprocess_start = process_start;
                    if ((process_start = curr_process.indexOf("|", process_start + 1) + 1) == 0) {
                        process_start = oldprocess_start;
                    }
                    ++choicemarkcount;
                }
                process_start = curr_process.indexOf("internalAction -> ", process_start);
                if (choice_start > 0) {
                    choice_start = curr_process.indexOf("|", process_start);
                    if (choice_start < 0) {
                        choice_start = curr_process.endsWith("),") ? curr_process.length() - 2 : curr_process.length() - 1;
                    }
                    if (this.callStack.contains(curr_process_label = curr_process.substring((process_start = curr_process.indexOf(end_marker = "internalAction -> ", process_start)) + end_marker.length(), choice_start).trim())) {
                        this.callStack.clear();
                        process_start = process_start + curr_process_label.length() + 1;
                    } else {
                        this.callStack.add(curr_process_label);
                        temp_bpel = this.translateComponentBodytoBPEL(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ","), "");
                        if (temp_bpel.length() > 0) {
                            temp_bpel = "\n" + this.buildTabs(tablevel) + "<case condition=\"bpws:getVariableData('scenario','no')\">\n" + this.buildTabs(tablevel) + "<sequence>" + temp_bpel;
                            temp_bpel = String.valueOf(temp_bpel) + "\n" + this.buildTabs(tablevel) + "</sequence>" + "\n" + this.buildTabs(tablevel) + "</case>";
                            bpel = String.valueOf(bpel) + temp_bpel;
                        }
                    }
                }
                ++choice;
            }
        } else if (process_name.endsWith("Adj")) {
            if (curr_process.indexOf("endAction") <= 0) {
                end_marker = "internalAction -> ";
                choice_start = curr_process.indexOf(";");
                if (choice_start < 1 && (choice_start = curr_process.length() - 1) - 1 == curr_process.indexOf(")")) {
                    choice_start = curr_process.indexOf(")");
                }
                curr_process_label = curr_process.substring(end_marker.length() + 1, choice_start);
                bpel = this.translateComponentBodytoBPEL(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ";"), "");
                String adj_process = this.getComponentProcessByLabel(curr_process_label, ",");
                if (adj_process.length() > 0) {
                    int adj_start = adj_process.indexOf(";");
                    String adj_part = adj_process.substring(adj_start + 1, adj_process.indexOf(","));
                    bpel = String.valueOf(bpel) + this.translateComponentBodytoBPEL(tablevel, adj_part, this.getComponentProcessByLabel(adj_part, ","), curr_bpel);
                }
                bpel = String.valueOf(acc_bpel) + bpel;
            } else {
                bpel = String.valueOf(bpel) + acc_bpel;
            }
        } else if (process.indexOf("endAction") <= 0) {
            process_start = 0;
            process_part_start = curr_process.indexOf(";");
            if (process_part_start < 1) {
                process_start = curr_process.indexOf("internalAction -> ") + 18;
                process_part_start = curr_process.indexOf("),");
            }
            if ((curr_process_part = this.getComponentProcessByLabel(curr_process_label = curr_process.substring(process_start, process_part_start), "END).")).indexOf(";") > 0) {
                curr_process_part = curr_process_part.substring(0, curr_process_part.indexOf(",") + 1);
                curr_bpel = this.translateComponentBodytoBPEL(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ","), curr_bpel);
            } else {
                curr_bpel = this.buildScenarioBPEL(tablevel, curr_process_part, curr_process_label);
            }
            bpel = process_part_start < curr_process.length() - 1 ? ((curr_process_label = curr_process.substring(process_part_start + 1, curr_process.length() - 1).trim()).length() > 0 ? String.valueOf(bpel) + this.translateComponentBodytoBPEL(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ")"), curr_bpel) : (curr_bpel.length() > 0 ? String.valueOf(bpel) + curr_bpel : "")) : (curr_bpel.length() > 0 ? String.valueOf(bpel) + curr_bpel : "");
        }
        if (has_choices) {
            bpel = String.valueOf(bpel) + "\n" + this.buildTabs(--tablevel) + "</switch>";
        }
        return bpel;
    }

    private String createtemplateBPELBody() {
        String hmsc_process = "";
        String hmsc_process_label = "HMSC_" + this.origInstanceFilter;
        String BPELstr = "";
        BPELstr = String.valueOf(BPELstr) + "\n\t<sequence>\n";
        hmsc_process = this.getComponentProcessByLabel(hmsc_process_label, ",");
        this.callStack.clear();
        BPELstr = String.valueOf(BPELstr) + this.translateComponentBodytoBPEL(2, hmsc_process_label, hmsc_process, "") + "\n";
        BPELstr = String.valueOf(BPELstr) + "\t</sequence>\n";
        return BPELstr;
    }

    public String toBPEL() {
        String bpelBody = "";
        if (this.msc_spec != null) {
            if (this.instanceFilter.length() > 0) {
                this.createtemplateBPELHeader(this.instanceFilter);
            }
            bpelBody = this.createtemplateBPELBody();
            this.buildBPELVariables();
            this.createtemplateBPELPartners();
            this.addtoBPEL(bpelBody, true);
            this.createtemplateBPELFooter();
            return this.bpel_translation;
        }
        return "";
    }
}

