/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.ws;

import ic.doc.ltsa.ws.WSInteraction;
import ic.doc.ltsa.ws.bpelaction;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import mscedit.BMSC;
import mscedit.HMSC;
import mscedit.Instance;
import mscedit.Link;
import mscedit.MSCEditorControl;
import mscedit.Specification;
import mscedit.Transition;

public class MscFSP2WSCDL {
    private String wscdl_translation;
    private Specification msc_spec;
    private String msc_xml = "";
    private String msc_fsp = "";
    private boolean isXMLFile;
    private boolean isFiltered;
    private MSCEditorControl mec = null;
    private LinkedList scenarioactions;
    private LinkedList FSPProcessList;
    private LinkedList callStack;
    private LinkedList varList;
    private String instanceFilter = "";
    private String origInstanceFilter = "";

    private void initvars() {
        this.wscdl_translation = "";
        this.FSPProcessList = new LinkedList();
        this.callStack = new LinkedList();
        this.varList = new LinkedList();
        this.isFiltered = false;
    }

    public Specification getSpecification() {
        return this.msc_spec;
    }

    public void setInstanceFilter(String filter) {
        this.origInstanceFilter = filter;
        this.instanceFilter = filter.toLowerCase();
        this.isFiltered = !filter.equals("All");
    }

    private String getFSPfromMSCXML(String filename) {
        String lts = this.mec.doSynthesiseFromFile(new File(filename));
        return lts;
    }

    public String getFSP() {
        return this.msc_fsp;
    }

    public MscFSP2WSCDL(String MscFSP, boolean isFile) {
        this.initvars();
        this.mec = new MSCEditorControl(null);
        this.isXMLFile = isFile;
        if (this.isXMLFile) {
            this.msc_spec = this.mec.getSpecificationFromFile(new File(MscFSP));
            this.msc_fsp = this.mec.doSynthesiseFromFile(new File(MscFSP));
        } else {
            this.msc_xml = MscFSP;
        }
        this.scenarioactions = new LinkedList();
    }

    private boolean addVar(String varname) {
        boolean result = false;
        if (!this.varList.contains(varname)) {
            this.varList.add(varname);
        }
        return result;
    }

    private void addtoWSCDL(String bpel, boolean addline) {
        if (addline) {
            this.wscdl_translation = String.valueOf(this.wscdl_translation) + "\n";
        }
        this.wscdl_translation = String.valueOf(this.wscdl_translation) + bpel;
    }

    private void buildInformationTypes() {
        this.addtoWSCDL("<!-- Information types and tokens used later on -->", true);
        this.addtoWSCDL("\t<informationType name=\"correlationId\" type=\"xsd:string\"/>", true);
    }

    private void buildRoleTypes() {
        String Role = "";
        this.addtoWSCDL("<!-- Role types  -->", true);
        Iterator roles = this.getRoles().iterator();
        while (roles.hasNext()) {
            Role = (String)roles.next();
            this.addtoWSCDL("\t<roleType  name=\"" + Role + "Role\">", true);
            this.addtoWSCDL("\t\t<behavior name=\"" + Role + "Activity\" interface=\"tns:" + Role + ".wsdl\"/>", true);
            this.addtoWSCDL("\t</roleType>", true);
        }
    }

    private void buildRoleRelationships() {
        String Role = "";
        this.addtoWSCDL("<!-- Connecting various roles together           -->", true);
        Iterator roles = this.getRoles().iterator();
        while (roles.hasNext()) {
            Role = (String)roles.next();
            this.addtoWSCDL("\t<relationshipType name=\"" + Role + "Advisor\">", true);
            this.addtoWSCDL("\t\t<role type=\"" + Role + "Role\"/>", true);
            this.addtoWSCDL("\t</relationshipType>", true);
        }
    }

    private void buildChannels() {
        String Role = "";
        this.addtoWSCDL("<!-- Define some channels on a per role basis                                 -->", true);
        Iterator roles = this.getRoles().iterator();
        while (roles.hasNext()) {
            Role = (String)roles.next();
            this.addtoWSCDL("\t<channelType name=\"" + Role + "Channel\" action=\"request\">", true);
        }
    }

    private LinkedList getRoles() {
        BMSC bMscelem = null;
        LinkedList<String> components = new LinkedList<String>();
        Iterator cit = this.msc_spec.getBMSCs().iterator();
        while (cit.hasNext()) {
            bMscelem = (BMSC)cit.next();
            Iterator instances = bMscelem.getInstances().iterator();
            while (instances.hasNext()) {
                Instance inst = (Instance)instances.next();
                if (components.contains(inst.getName())) continue;
                components.add(inst.getName());
            }
        }
        return components;
    }

    private void createtemplateFooter() {
        this.addtoWSCDL("</package>", true);
    }

    private void buildVariables() {
        this.addtoWSCDL("\t<variables>", true);
        this.addtoWSCDL("\t<variable name=\"request\" messageType=\"processdef:requestMessage\" />", true);
        this.addtoWSCDL("\t</variables>", true);
    }

    private void createtemplateHeader(String process_name) {
        this.wscdl_translation = "";
        this.addtoWSCDL("<package name=\"" + process_name + "\"", true);
        this.addtoWSCDL("\tversion=\"1.0\"", true);
        this.addtoWSCDL("\ttargetNamespace=\"http://www.w3.org/2004/04/ws-chor/cdl\"", true);
        this.addtoWSCDL("\tsuppressJoinFailure=\"yes\"", true);
        this.addtoWSCDL("\txmlns=\"http://www.w3.org/2004/12/ws-chor/cdl\">", true);
        this.addtoWSCDL("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">", true);
        this.addtoWSCDL("\txsi:schemaLocation=\"http://www.w3.org/2004/12/ws-chor/cdlws-cdl3.xsd\">", true);
        this.addtoWSCDL("\txmlns:ppt=\"http://partner.com/services/partner\">", true);
    }

    private String createtemplatePartner(String name, String linkType, String role) {
        String partnerstr = "";
        partnerstr = String.valueOf(partnerstr) + "\t<partner";
        partnerstr = String.valueOf(partnerstr) + " name=\"" + name + "\"";
        partnerstr = String.valueOf(partnerstr) + " serviceLinkType=\"" + linkType + "\"";
        partnerstr = String.valueOf(partnerstr) + " myRole=\"" + role + "\"";
        partnerstr = String.valueOf(partnerstr) + "/>";
        return partnerstr;
    }

    private String buildTabs(int tablevel) {
        String tabstr = "";
        int tab = 0;
        while (tab < tablevel) {
            tabstr = String.valueOf(tabstr) + "\t";
            ++tab;
        }
        return tabstr;
    }

    private void createtemplatePartners() {
        this.addtoWSCDL("\n<partners>", true);
        this.addtoWSCDL(this.createtemplatePartner("customer", "slt:customerLinkType", "myrole"), true);
        this.addtoWSCDL("\n</partners>", true);
    }

    private BMSC getBMScByName(String name) {
        boolean found = false;
        BMSC foundBMSc = null;
        List bMScs = this.msc_spec.getBMSCs();
        Iterator bMScIterator = bMScs.iterator();
        while (bMScIterator.hasNext() && !found) {
            BMSC bMscelem = (BMSC)bMScIterator.next();
            if (!bMscelem.getName().equals(name)) continue;
            found = true;
            foundBMSc = bMscelem;
        }
        return foundBMSc;
    }

    private bpelaction link2BPELAction(Link alink) {
        String actionstring = "";
        int start = alink.getName().lastIndexOf(",");
        int end = alink.getName().lastIndexOf("_");
        if (start < 0 || end < 0) {
            actionstring = String.valueOf(actionstring) + "invoke" + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        } else {
            actionstring = String.valueOf(alink.getName().substring(start + 1, end)) + "_";
            actionstring = String.valueOf(actionstring) + alink.getFrom() + "_";
            actionstring = String.valueOf(actionstring) + alink.getTo() + "_";
            actionstring = String.valueOf(actionstring) + alink.getName().substring(end + 1);
        }
        bpelaction bpaction = new bpelaction(actionstring);
        return bpaction;
    }

    private bpelaction fspAction2BPELAction(String fspactionstr) {
        String bpelactionstring = "";
        String from = "";
        String to = "";
        String action = "";
        String method = "";
        int start = 0;
        int end = 0;
        start = 1;
        end = fspactionstr.indexOf(".");
        if (end > 0) {
            from = fspactionstr.substring(0, end);
        }
        if ((end = fspactionstr.indexOf(".", (start = end) + 1)) > 0) {
            to = fspactionstr.substring(start + 1, end);
        }
        if ((end = fspactionstr.indexOf("_", start = end)) > 0) {
            action = fspactionstr.substring(start + 1, end);
        }
        start = end;
        end = fspactionstr.length();
        method = fspactionstr.substring(start + 1, end);
        bpelactionstring = String.valueOf(action) + "_";
        bpelactionstring = String.valueOf(bpelactionstring) + from + "_";
        bpelactionstring = String.valueOf(bpelactionstring) + to + "_";
        bpelactionstring = String.valueOf(bpelactionstring) + method;
        bpelaction bpaction = new bpelaction(bpelactionstring);
        return bpaction;
    }

    private List sortActionListbyTime(List listtosort) {
        LinkedList<Link> sortedList = null;
        sortedList = new LinkedList<Link>();
        int count = 1;
        while (count <= listtosort.size()) {
            ListIterator actions = listtosort.listIterator();
            while (actions.hasNext()) {
                Link nextLink = (Link)actions.next();
                if (nextLink.getTimeIndex() != count) continue;
                sortedList.add(nextLink);
            }
            ++count;
        }
        return sortedList;
    }

    private String GenerateUniqueProcessName(String name) {
        String newName = name;
        int index = 1;
        while (this.FSPProcessList.contains(newName)) {
            newName = String.valueOf(name) + index;
            ++index;
        }
        this.FSPProcessList.add(newName);
        return newName;
    }

    private String translateScenario(String bMSC_name) {
        BMSC scenarioBMSC = this.getBMScByName(bMSC_name);
        bpelaction bpa = null;
        List timedactions = null;
        String translation = "";
        boolean isrepeating = false;
        isrepeating = this.isRepeatingScenario(bMSC_name);
        if (isrepeating) {
            this.addtoWSCDL("<while condition=\"bpws:getVariableData('variable','part')\">", true);
            this.addtoWSCDL("<sequence>", true);
        }
        timedactions = this.sortActionListbyTime(scenarioBMSC.getLinks());
        ListIterator actions = timedactions.listIterator();
        while (actions.hasNext()) {
            Link nextLink = (Link)actions.next();
            bpa = this.link2BPELAction(nextLink);
            if (bpa == null) continue;
            this.scenarioactions.add(bpa);
        }
        ListIterator bpelactions = this.scenarioactions.listIterator();
        while (bpelactions.hasNext()) {
            bpa = (bpelaction)bpelactions.next();
            WSInteraction wsi = new WSInteraction(bpa);
            translation = String.valueOf(translation) + wsi.toWSCDL() + "\n";
        }
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (trans.getFrom().equals(bMSC_name) && !trans.getTo().equals(bMSC_name)) {
                translation = String.valueOf(translation) + this.translateScenario(trans.getTo());
            }
            trans.getOutputs().iterator();
        }
        return translation;
    }

    private boolean isRepeatingScenario(String scenario) {
        boolean result = false;
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (!trans.getFrom().equals(scenario) || !trans.getTo().equals(scenario)) continue;
            result = true;
        }
        return result;
    }

    public String getComponentFSPBody(String component_name) {
        String componentBody = "";
        String componentID = "////Component " + component_name;
        String componentendID = "deterministic";
        if (this.msc_fsp.length() > 0) {
            int start = 0;
            int end = 0;
            start = this.msc_fsp.indexOf(componentID);
            if (start > 0 && (end = this.msc_fsp.indexOf(componentendID, start)) > 0) {
                componentBody = this.msc_fsp.substring(start + componentID.length(), end);
            }
        }
        return componentBody;
    }

    public String getComponentProcessByNo(String component_name, int number) {
        String componentID = String.valueOf(component_name) + "_N" + number + " = ";
        return this.getComponentProcessByLabel(componentID, ",");
    }

    public String getComponentProcessByLabel(String component_label, String component_end) {
        String componentBody = "";
        String componentID = String.valueOf(component_label) + " = ";
        String componentendID = component_end;
        if (this.msc_fsp.length() > 0) {
            int start = 0;
            int end = 0;
            start = this.msc_fsp.indexOf(componentID);
            if (start > 0 && (end = this.msc_fsp.indexOf(componentendID, start)) > 0) {
                componentBody = this.msc_fsp.substring(start + componentID.length(), end + componentendID.length());
            }
        }
        return componentBody;
    }

    public String getComponentProcessAdjByLabel(String component_name, int number) {
        String componentBody = "";
        String componentID = String.valueOf(component_name) + "_N" + number + "_Adj = ";
        String componentendID = ",";
        if (this.msc_fsp.length() > 0) {
            int start = 0;
            int end = 0;
            start = this.msc_fsp.indexOf(componentID);
            if (start > 0 && (end = this.msc_fsp.indexOf(componentendID, start)) > 0) {
                componentBody = this.msc_fsp.substring(start + componentID.length(), end - componentendID.length());
            }
        }
        return componentBody;
    }

    private String translateBPELAction(int tab, bpelaction bpa) {
        String strName = "";
        String strAction = "";
        if (bpa.getAction().equals("invoke")) {
            if (!this.isFiltered || !bpa.getPartner1().equals(this.instanceFilter) && !bpa.getPartner2().equals(this.instanceFilter)) {
                return "";
            }
            if (this.isFiltered && bpa.getPartner1().equals(this.instanceFilter)) {
                strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
                strAction = String.valueOf(this.buildTabs(tab)) + strName + bpa.getPartner2() + "ppt:" + bpa.getPartner2() + bpa.getOperation();
            } else {
                strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner2()) + "receive");
                strAction = String.valueOf(this.buildTabs(tab)) + strName + bpa.getPartner2() + "ppt:" + bpa.getPartner2() + bpa.getOperation();
            }
        }
        if (bpa.getAction().equals("reply")) {
            strName = this.GenerateUniqueProcessName(String.valueOf(bpa.getPartner1()) + bpa.getOperation());
            strAction = this.isFiltered && bpa.getPartner1().equals(this.instanceFilter) ? String.valueOf(this.buildTabs(tab)) + strName + bpa.getPartner2() + "ppt:" + bpa.getPartner2() + bpa.getOperation() : String.valueOf(this.buildTabs(tab)) + strName + bpa.getPartner2() + "ppt:" + bpa.getPartner2() + bpa.getOperation();
        }
        if (strAction.length() > 0) {
            this.addVar(bpa.getOperation());
        }
        return strAction;
    }

    private String buildScenario(int tablevel, String curr_process_part, String curr_process_label) {
        String scenario_label = "";
        int action_start = 0;
        int action_end = 0;
        String curr_action = "";
        String bpel = "";
        scenario_label = "s_" + curr_process_label + " -> ";
        action_end = action_start = curr_process_part.indexOf(scenario_label) + scenario_label.length();
        while (action_end > 0) {
            action_end = curr_process_part.indexOf(" -> ", action_start);
            if (action_end <= 0) continue;
            curr_action = curr_process_part.substring(action_start, action_end);
            bpelaction curr_bpa = this.fspAction2BPELAction(curr_action);
            bpel = String.valueOf(bpel) + this.translateBPELAction(tablevel, curr_bpa);
            action_start = action_end + 4;
        }
        return bpel;
    }

    private String translateComponentBody(int tablevel, String process_name, String process, String acc_body) {
        String bpel = "";
        String curr_bpel = "";
        String temp_bpel = "";
        String curr_process = "";
        String curr_process_part = "";
        String curr_process_label = "";
        String end_marker = "";
        int choice_start = 0;
        int choice_count = 0;
        boolean has_choices = false;
        int process_start = 0;
        int process_part_start = 0;
        curr_process = process;
        if (process.length() < 1) {
            return "";
        }
        choice_start = curr_process.indexOf("|");
        if (choice_start > 0) {
            has_choices = true;
            choice_start = 0;
            choice_count = 0;
            while (choice_start < curr_process.length() - 1) {
                if ((choice_start = curr_process.indexOf("|", choice_start + 1)) == -1) {
                    choice_start = curr_process.length() - 1;
                    continue;
                }
                ++choice_count;
            }
            if (has_choices) {
                bpel = String.valueOf(bpel) + "\n" + this.buildTabs(tablevel) + "<switch name=\"test\">";
                ++tablevel;
            }
            int choice = 0;
            while (choice <= choice_count) {
                int choicemarkcount = 0;
                process_start = 0;
                while (choicemarkcount < choice) {
                    int oldprocess_start = process_start;
                    if ((process_start = curr_process.indexOf("|", process_start + 1) + 1) == 0) {
                        process_start = oldprocess_start;
                    }
                    ++choicemarkcount;
                }
                process_start = curr_process.indexOf("internalAction -> ", process_start);
                if (choice_start > 0) {
                    choice_start = curr_process.indexOf("|", process_start);
                    if (choice_start < 0) {
                        choice_start = curr_process.endsWith("),") ? curr_process.length() - 2 : curr_process.length() - 1;
                    }
                    if (this.callStack.contains(curr_process_label = curr_process.substring((process_start = curr_process.indexOf(end_marker = "internalAction -> ", process_start)) + end_marker.length(), choice_start).trim())) {
                        this.callStack.clear();
                        process_start = process_start + curr_process_label.length() + 1;
                    } else {
                        this.callStack.add(curr_process_label);
                        temp_bpel = this.translateComponentBody(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ","), "");
                        if (temp_bpel.length() > 0) {
                            temp_bpel = "\n" + this.buildTabs(tablevel) + "<case condition=\"bpws:getVariableData('scenario','no')\">\n" + this.buildTabs(tablevel) + "<sequence>" + temp_bpel;
                            temp_bpel = String.valueOf(temp_bpel) + "\n" + this.buildTabs(tablevel) + "</sequence>" + "\n" + this.buildTabs(tablevel) + "</case>";
                            bpel = String.valueOf(bpel) + temp_bpel;
                        }
                    }
                }
                ++choice;
            }
        } else if (process_name.endsWith("Adj")) {
            if (curr_process.indexOf("endAction") <= 0) {
                end_marker = "internalAction -> ";
                choice_start = curr_process.indexOf(";");
                if (choice_start < 1 && (choice_start = curr_process.length() - 1) - 1 == curr_process.indexOf(")")) {
                    choice_start = curr_process.indexOf(")");
                }
                curr_process_label = curr_process.substring(end_marker.length() + 1, choice_start);
                bpel = this.translateComponentBody(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ";"), "");
                String adj_process = this.getComponentProcessByLabel(curr_process_label, ",");
                if (adj_process.length() > 0) {
                    int adj_start = adj_process.indexOf(";");
                    String adj_part = adj_process.substring(adj_start + 1, adj_process.indexOf(","));
                    bpel = String.valueOf(bpel) + this.translateComponentBody(tablevel, adj_part, this.getComponentProcessByLabel(adj_part, ","), curr_bpel);
                }
                bpel = String.valueOf(acc_body) + bpel;
            } else {
                bpel = String.valueOf(bpel) + acc_body;
            }
        } else if (process.indexOf("endAction") <= 0) {
            process_start = 0;
            process_part_start = curr_process.indexOf(";");
            if (process_part_start < 1) {
                process_start = curr_process.indexOf("internalAction -> ") + 18;
                process_part_start = curr_process.indexOf("),");
            }
            if ((curr_process_part = this.getComponentProcessByLabel(curr_process_label = curr_process.substring(process_start, process_part_start), "END).")).indexOf(";") > 0) {
                curr_process_part = curr_process_part.substring(0, curr_process_part.indexOf(",") + 1);
                curr_bpel = this.translateComponentBody(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ","), curr_bpel);
            } else {
                curr_bpel = this.buildScenario(tablevel, curr_process_part, curr_process_label);
            }
            bpel = process_part_start < curr_process.length() - 1 ? ((curr_process_label = curr_process.substring(process_part_start + 1, curr_process.length() - 1).trim()).length() > 0 ? String.valueOf(bpel) + this.translateComponentBody(tablevel, curr_process_label, this.getComponentProcessByLabel(curr_process_label, ")"), curr_bpel) : (curr_bpel.length() > 0 ? String.valueOf(bpel) + curr_bpel : "")) : (curr_bpel.length() > 0 ? String.valueOf(bpel) + curr_bpel : "");
        }
        if (has_choices) {
            bpel = String.valueOf(bpel) + "\n" + this.buildTabs(--tablevel) + "</switch>";
        }
        return bpel;
    }

    private String createtemplateBody() {
        String hmsc_process = "";
        String hmsc_process_label = "HMSC_" + this.origInstanceFilter;
        String body = "";
        body = String.valueOf(body) + "<!-- define the choreography                                                 -->\n";
        body = String.valueOf(body) + "\t<!-- The choreography describes the interaction between the roles on the basis   -->\n";
        body = String.valueOf(body) + "\t<!-- of their behaviors.                                                         -->\n";
        body = String.valueOf(body) + "<choreography name=\"testroot\" root=\"true\">\n";
        body = String.valueOf(body) + "<sequence>\n";
        this.callStack.clear();
        body = String.valueOf(body) + this.translateComponentBody(2, hmsc_process_label, hmsc_process, "");
        HMSC hMsc = this.msc_spec.getHMSC();
        Iterator transitions = hMsc.getTransitions().iterator();
        while (transitions.hasNext()) {
            Transition trans = (Transition)transitions.next();
            if (trans.getFrom().equals("init")) {
                body = String.valueOf(body) + this.translateScenario(trans.getTo());
            }
            trans.getOutputs().iterator();
        }
        body = String.valueOf(body) + "</sequence>\n";
        body = String.valueOf(body) + "</choreography>\n";
        return body;
    }

    public String toWSCDL() {
        String body = "";
        if (this.msc_spec != null) {
            this.createtemplateHeader("test");
            this.buildInformationTypes();
            this.buildRoleTypes();
            this.buildRoleRelationships();
            this.buildVariables();
            body = this.createtemplateBody();
            this.addtoWSCDL(body, true);
            this.createtemplateFooter();
            return this.wscdl_translation;
        }
        return "";
    }
}

