/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.editors;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import ltsaeclipse.editors.AdaptableList;
import ltsaeclipse.editors.MarkElement;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.views.LTSAAnimatorView;
import ltsaeclipse.views.LTSADrawView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class LTSAContentOutlinePage
extends ContentOutlinePage {
    protected IFile input;
    protected String strinput;
    protected String source = "";
    public TreeViewer viewer;
    private AdaptableList al;
    private Action parseAction;
    private Action compileAction;
    private Action composeAction;
    private Action minimiseAction;
    private Action drawAction;
    private Action doubleClickAction;
    private Action safetycheckAction;
    private Action animAction;
    String currentselection = "";
    private MultiPageEditor Editor;

    public void SetEditor(MultiPageEditor parentEditor) {
        this.Editor = parentEditor;
    }

    public LTSAContentOutlinePage(IFile input) {
        this.input = input;
    }

    public LTSAContentOutlinePage(String strinput) {
        this.source = strinput;
        this.input = null;
    }

    public void setPageInput(String newsource) {
        this.source = newsource;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)this.getContentOutline((IAdaptable)this.input));
        this.initDragAndDrop();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        Object domain = iterator.next();
                        String value = ((WorkbenchLabelProvider)LTSAContentOutlinePage.this.viewer.getLabelProvider()).getText(domain);
                        toShow.append(value);
                        toShow.append(", ");
                    }
                    if (toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    LTSAContentOutlinePage.this.currentselection = toShow.toString();
                    if (LTSAContentOutlinePage.this.currentselection.length() > 0) {
                        Iterator i = ((LTSAContentOutlinePage)LTSAContentOutlinePage.this).al.children.iterator();
                        while (i.hasNext()) {
                            MarkElement parent = (MarkElement)i.next();
                            Object[] children = parent.getChildren(parent);
                            if (children == null) continue;
                            int child = 0;
                            while (child < children.length) {
                                MarkElement nextchild = (MarkElement)children[child];
                                if (nextchild.getLabel(nextchild).trim().equals(LTSAContentOutlinePage.this.currentselection)) {
                                    LTSAContentOutlinePage.this.Editor.moveToInEditor(nextchild.getStart(), nextchild.getStart() + 1);
                                }
                                ++child;
                            }
                        }
                    }
                }
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LTSAContentOutlinePage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu("ltsaeclipse.editors.LTSAContentOutlinePage", menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.parseAction);
        manager.add((IAction)this.compileAction);
        manager.add((IAction)this.composeAction);
        manager.add((IAction)this.minimiseAction);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.safetycheckAction);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.drawAction);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.animAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LTSAContentOutlinePage.this.doubleClickAction.run();
            }
        });
    }

    private IAdaptable getContentOutline(IAdaptable input) {
        String filestring = "";
        if (this.source.length() < 1) {
            int k = 0;
            int Buffsize = 0x112333;
            byte[] buff = new byte[Buffsize];
            ByteArrayOutputStream os = new ByteArrayOutputStream(Buffsize);
            try {
                IFile file = (IFile)input;
                InputStream is = file.getContents();
                while ((k = is.read(buff)) != -1) {
                    ((OutputStream)os).write(buff, 0, k);
                }
                filestring = ((Object)os).toString();
            }
            catch (Exception exception) {}
        } else {
            filestring = this.source;
        }
        this.al = new AdaptableList();
        this.AddLines("Constants", "const", true, filestring, this.al);
        this.AddLines("Sets", "set", true, filestring, this.al);
        this.AddLines("Ranges", "range", true, filestring, this.al);
        this.AddCompositionLines("Compositions", ",", filestring, this.al);
        this.AddLines("Processes", "=", false, filestring, this.al);
        this.AddLines("Properties", "property", true, filestring, this.al);
        return this.al;
    }

    private void AddCompositionLines(String header, String linestart, String strFSP, AdaptableList al) {
        MarkElement consthead = new MarkElement(null, header, 0, 0);
        al.add(consthead);
        int pos = 0;
        Hashtable cs = this.Editor.doParse(false);
        if (cs == null) {
            return;
        }
        Enumeration e = cs.keys();
        ArrayList forSort = new ArrayList();
        while (e.hasMoreElements()) {
            forSort.add(e.nextElement());
        }
        Collections.sort(forSort);
        Iterator i = forSort.iterator();
        while (i.hasNext()) {
            String compositionname = i.next().toString();
            pos = strFSP.indexOf("||" + compositionname);
            if (pos < 0) {
                pos = 0;
            }
            new MarkElement(consthead, compositionname, pos, pos + 1);
        }
    }

    private void AddLines(String header, String linestart, boolean iskeyword, String strFSP, AdaptableList al) {
        boolean end = false;
        int pos = 0;
        MarkElement consthead = new MarkElement(null, header, 0, 0);
        al.add(consthead);
        pos = strFSP.indexOf(linestart, pos);
        while (pos > 0 && pos <= strFSP.length() && !end) {
            int endpos;
            int startpos = strFSP.indexOf(linestart, pos);
            if (startpos > 0 && iskeyword) {
                endpos = strFSP.indexOf("\n", startpos) - 1;
                if (endpos > 0) {
                    try {
                        String strconstant = strFSP.substring(startpos + linestart.length(), endpos);
                        if (strconstant.indexOf("=") > 0) {
                            new MarkElement(consthead, strconstant, 0, 0);
                        }
                        pos = endpos;
                    }
                    catch (Exception exception) {
                        end = true;
                    }
                }
                pos = endpos;
                continue;
            }
            if (!iskeyword) {
                endpos = startpos;
                while (endpos >= 0) {
                    boolean addelement = false;
                    if (strFSP.charAt(endpos) == '\n' || endpos == 0) {
                        String element = strFSP.substring(endpos, startpos);
                        if (element.trim().indexOf(" ") < 0 && element.indexOf("||") < 0 && element.indexOf("[") < 0) {
                            if (element.indexOf("(") > 0) {
                                if (element.indexOf(")") > 0) {
                                    addelement = false;
                                }
                            } else {
                                addelement = true;
                            }
                            if (addelement) {
                                new MarkElement(consthead, element.trim(), endpos + 1, startpos);
                            }
                        }
                        endpos = startpos = strFSP.indexOf(linestart, startpos + 1);
                        continue;
                    }
                    if (strFSP.charAt(endpos) == ' ') {
                        int cfr_ignored_0 = endpos + 1;
                    }
                    --endpos;
                }
            }
            pos = startpos;
        }
    }

    private void initDragAndDrop() {
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance(), PluginTransfer.getInstance()};
    }

    public void update() {
        this.getControl().setRedraw(false);
        this.getTreeViewer().setInput((Object)this.getContentOutline((IAdaptable)this.input));
        this.getTreeViewer().expandAll();
        this.getControl().setRedraw(true);
    }

    private void showMessage(String message) {
        MessageDialog.openInformation(null, (String)((Object)((Object)this)).getClass().getName(), (String)message);
    }

    private void makeActions() {
        this.parseAction = new Action(){

            public void run() {
                LTSAContentOutlinePage.this.Editor.doParse(false);
            }
        };
        this.parseAction.setText("&Parse");
        this.parseAction.setToolTipText("Parse FSP");
        this.parseAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.compileAction = new Action(){

            public void run() {
                LTSAContentOutlinePage.this.Editor.doCompile();
            }
        };
        this.compileAction.setText("&Compile");
        this.compileAction.setToolTipText("Compose FSP");
        this.compileAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT"));
        this.composeAction = new Action(){

            public void run() {
                LTSAContentOutlinePage.this.Editor.doCompose();
            }
        };
        this.composeAction.setText("&Compose");
        this.composeAction.setToolTipText("Compose FSP");
        this.composeAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OPEN_MARKER"));
        this.minimiseAction = new Action(){

            public void run() {
                LTSAContentOutlinePage.this.Editor.doMinimise();
            }
        };
        this.minimiseAction.setText("&Minimise");
        this.minimiseAction.setToolTipText("Minimise FSP");
        this.minimiseAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.safetycheckAction = new Action(){

            public void run() {
                LTSAContentOutlinePage.this.Editor.doAnalyse();
            }
        };
        this.safetycheckAction.setText("&Safety");
        this.safetycheckAction.setToolTipText("Perform Safety Check on FSP");
        this.safetycheckAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.safetycheckAction = new Action(){

            public void run() {
                LTSAContentOutlinePage.this.Editor.doProgress();
            }
        };
        this.safetycheckAction.setText("&Progress");
        this.safetycheckAction.setToolTipText("Perform Progress Check on FSP");
        this.safetycheckAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.drawAction = new Action(){

            public void run() {
                LTSADrawView ltsacv = null;
                boolean foundview = false;
                int view = 0;
                IViewPart[] views = LTSAContentOutlinePage.this.getSite().getPage().getViews();
                while (view < views.length && !foundview) {
                    IViewPart viewpart = views[0];
                    if (viewpart != null && viewpart.getTitle().equals("Draw - " + LTSAContentOutlinePage.this.Editor.getTitle())) {
                        ltsacv = (LTSADrawView)viewpart;
                    }
                    ++view;
                }
                if (ltsacv == null) {
                    try {
                        LTSAContentOutlinePage.this.getSite().getPage().showView("ltsaeclipse.views.LTSADrawView");
                        ltsacv = (LTSADrawView)LTSAContentOutlinePage.this.getSite().getPage().findView("ltsaeclipse.views.LTSADrawView");
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.drawAction.setText("&View Process");
        this.drawAction.setToolTipText("View LTS Process");
        this.drawAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.animAction = new Action(){

            public void run() {
                LTSAAnimatorView ltsacv = null;
                boolean foundview = false;
                int view = 0;
                IViewPart[] views = LTSAContentOutlinePage.this.getSite().getPage().getViews();
                while (view < views.length && !foundview) {
                    IViewPart viewpart = views[0];
                    if (viewpart != null && viewpart.getTitle().equals("LTS Animator")) {
                        ltsacv = (LTSAAnimatorView)viewpart;
                    }
                    ++view;
                }
                if (ltsacv == null) {
                    try {
                        LTSAContentOutlinePage.this.getSite().getPage().showView("ltsaeclipse.views.LTSAAnimatorView");
                        ltsacv = (LTSAAnimatorView)LTSAContentOutlinePage.this.getSite().getPage().findView("ltsaeclipse.views.LTSAAnimatorView");
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.animAction.setText("&Animate Process");
        this.animAction.setToolTipText("Animate LTS Process");
        this.animAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = LTSAContentOutlinePage.this.viewer.getSelection();
                ((IStructuredSelection)selection).getFirstElement();
                LTSAContentOutlinePage.this.Editor.doCompile();
            }
        };
    }

    class OutlineAction
    extends Action {
        private Shell shell;

        public OutlineAction(String label) {
            super(label);
            LTSAContentOutlinePage.this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ OutlineAction this$1;
                {
                    this.this$1 = outlineAction;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    this.this$1.setEnabled(!event.getSelection().isEmpty());
                }
            });
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }

        public void run() {
            MessageDialog.openInformation((Shell)this.shell, (String)"Readme_Outline", (String)"ReadmeOutlineActionExecuted");
        }
    }
}

