/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import ic.doc.ltsa.AnimWindow;
import ic.doc.ltsa.lts.Analyser;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.RunMenu;
import java.awt.Frame;
import java.awt.Panel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.views.DrawCanvas;
import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.LTSADrawTable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class LTSAAnimatorView
extends ViewPart
implements ISelectionListener {
    private MultiPageEditor mpe;
    private CTabFolder container;
    private LTSADrawTable tableViewer;
    public DrawCanvas drawCanvas;
    private SashForm sash_form;
    private Composite composite;
    private Composite thisparent;
    List list = new ArrayList();
    private StyledText alphabetText;
    private StyledText transitionsText;
    private Analyser analyser = null;
    LTSAEclipseIO eio = new LTSAEclipseIO();
    JFrame animator = new JFrame();
    EventManager eman = new EventManager();
    Frame frame = null;
    CompactState mach = null;
    CompositeState CState;
    int[] lastEvent;
    int[] prevEvent;
    String lastName;
    int Nmach = 0;
    int hasC = 0;
    CompactState[] sm;
    boolean[] machineHasAction;
    boolean[] machineToDrawSet;
    int currentMachine = 0;
    String[][] labels;

    public void setMPE(MultiPageEditor aMPE) {
        this.mpe = aMPE;
    }

    private CTabFolder createContainer(Composite parent) {
        final CTabFolder newContainer = new CTabFolder(parent, 0x800400);
        newContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = newContainer.indexOf((CTabItem)e.item);
                LTSAAnimatorView.this.pageChange(newPageIndex);
            }
        });
        return newContainer;
    }

    private CTabItem createItem(Control control) {
        CTabItem item = new CTabItem(this.getTabFolder(), 0);
        item.setControl(control);
        return item;
    }

    protected Composite getContainer() {
        return this.container;
    }

    private CTabFolder getTabFolder() {
        return this.container;
    }

    protected int getPageCount() {
        CTabFolder folder = this.getTabFolder();
        if (folder != null && !folder.isDisposed()) {
            return folder.getItemCount();
        }
        return 0;
    }

    private CTabItem getItem(int pageIndex) {
        return this.getTabFolder().getItem(pageIndex);
    }

    protected Control getControl(int pageIndex) {
        return this.sash_form;
    }

    protected int getActivePage() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    protected void pageChange(int newPageIndex) {
        Control control = this.getControl(newPageIndex);
        if (control != null) {
            control.setVisible(true);
        }
        this.setFocus();
        if (this.getActivePage() > 0) {
            if (this.getActivePage() == 1) {
                this.displayAlphabet(this.currentMachine);
            }
            if (this.getActivePage() == 2) {
                this.displayTransitions(this.currentMachine);
            }
        }
    }

    protected void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        this.getTabFolder().setSelection(pageIndex);
    }

    public void createPartControl(Composite parent) {
        this.mpe = (MultiPageEditor)this.getSite().getPage().getActiveEditor();
        new FillLayout();
        this.sash_form = new SashForm(parent, 512);
        this.composite = new Composite((Composite)this.sash_form, 0x1000000);
        this.thisparent = parent;
        this.frame = SWT_AWT.new_Frame((Composite)this.composite);
        new Panel();
        if (this.mpe.getCurrentState() != null) {
            this.analyser = new Analyser(this.mpe.getCurrentState(), this.eio, this.eman);
            if (this.animator != null) {
                this.animator.dispose();
                this.animator = null;
            }
            RunMenu r = null;
            this.animator = new AnimWindow(this.analyser, r, false, false);
            if (this.animator != null) {
                this.frame.add(this.animator.getRootPane());
            }
        }
    }

    void createPage1() {
        this.alphabetText = new StyledText(this.getContainer(), 768);
        this.alphabetText.setEditable(false);
        CTabItem item = this.createItem((Control)this.alphabetText);
        item.setText("Alphabet");
        this.displayAlphabet(0);
    }

    void createPage2() {
        this.transitionsText = new StyledText(this.getContainer(), 768);
        this.transitionsText.setEditable(false);
        CTabItem item = this.createItem((Control)this.transitionsText);
        item.setText("Transitions");
        this.displayTransitions(0);
    }

    void displayAlphabet(int machine) {
        String alphabetstr = "";
        if (this.sm != null) {
            alphabetstr = String.valueOf(alphabetstr) + "Process: \n";
            alphabetstr = String.valueOf(alphabetstr) + "\t" + this.sm[machine].name + "\n";
            alphabetstr = String.valueOf(alphabetstr) + "Alphabet: \n";
            alphabetstr = String.valueOf(alphabetstr) + "\t{";
            int word = 0;
            while (word < this.sm[machine].alphabet.length) {
                alphabetstr = String.valueOf(alphabetstr) + " " + this.sm[machine].alphabet[word];
                if (word < this.sm[machine].alphabet.length) {
                    alphabetstr = String.valueOf(alphabetstr) + ",";
                }
                ++word;
            }
            alphabetstr = String.valueOf(alphabetstr) + " } ";
            this.alphabetText.setText(alphabetstr);
        }
    }

    void displayTransitions(int machine) {
        String alphabetstr = "";
        LTSAEclipseIO MyOutput2 = new LTSAEclipseIO();
        if (this.sm != null) {
            alphabetstr = String.valueOf(alphabetstr) + "Process: \n";
            alphabetstr = String.valueOf(alphabetstr) + "\t" + this.sm[machine].name + "\n";
            alphabetstr = String.valueOf(alphabetstr) + "Transitions: \n";
            alphabetstr = String.valueOf(alphabetstr) + MyOutput2.result;
            this.transitionsText.setText(alphabetstr);
        }
    }

    public void updateView(String machinename) {
        this.frame.removeAll();
        this.frame = SWT_AWT.new_Frame((Composite)this.composite);
        new Panel();
        if (this.mpe.getCurrentState() != null) {
            this.analyser = new Analyser(this.mpe.getCurrentState(), this.eio, this.eman);
            if (this.animator != null) {
                this.animator.dispose();
                this.animator = null;
            }
            RunMenu r = null;
            this.animator = new AnimWindow(this.analyser, r, false, false);
            if (this.animator != null) {
                this.frame.add(this.animator.getRootPane());
            }
        }
        this.sash_form.update();
        this.composite.redraw();
        this.composite.update();
        this.thisparent.redraw();
        this.thisparent.update();
    }

    public int setMachineByName(String machinename) {
        int selmachine = 0;
        boolean machinefound = false;
        int machine = 0;
        while (machine < this.list.size()) {
            if (machinename.equals((String)this.list.get(machine))) {
                this.drawCanvas.mach = this.sm[machine];
                selmachine = machine;
                machinefound = true;
            }
            ++machine;
        }
        if (!machinefound) {
            selmachine = this.list.size() > 0 ? this.list.size() - 1 : 0;
            this.drawCanvas.mach = this.sm[selmachine];
        }
        return selmachine;
    }

    public void addMachine(String machinename, String states) {
        this.tableViewer.getTaskList().addTask(machinename, states);
    }

    public void removeMachines() {
        while (!this.tableViewer.getTaskList().getTasks().isEmpty()) {
            ExampleTask task = (ExampleTask)this.tableViewer.getTaskList().getTasks().get(0);
            this.tableViewer.getTaskList().removeTask(task);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    private void showMessage(String message) {
        MessageDialog.openInformation(null, (String)"Sample View", (String)message);
    }

    public void setFocus() {
    }

    private void SetStatusLine(String msg) {
        IStatusLineManager slm;
        IActionBars actionbars = this.getViewSite().getActionBars();
        if (actionbars != null && (slm = actionbars.getStatusLineManager()) != null) {
            slm.setErrorMessage(msg);
        }
    }

    private void list_new_machines(CompositeState cs) {
        int i;
        int hasC;
        int n = hasC = cs != null && cs.composition != null ? 1 : 0;
        if (cs != null && cs.machines != null && cs.machines.size() > 0) {
            this.sm = new CompactState[cs.machines.size() + hasC];
            Enumeration e = cs.machines.elements();
            i = 0;
            while (e.hasMoreElements()) {
                this.sm[i] = (CompactState)e.nextElement();
                ++i;
            }
            this.Nmach = this.sm.length;
            if (hasC == 1) {
                this.sm[this.Nmach - 1] = cs.composition;
            }
            this.machineHasAction = new boolean[this.Nmach];
            this.machineToDrawSet = new boolean[this.Nmach];
        } else {
            this.Nmach = 0;
            this.machineHasAction = null;
            this.machineToDrawSet = null;
        }
        DefaultListModel<String> lm = new DefaultListModel<String>();
        i = 0;
        while (i < this.Nmach) {
            String stringStates;
            if (hasC == 1 && i == this.Nmach - 1) {
                lm.addElement("||" + this.sm[i].name);
                stringStates = "" + this.sm[i].maxStates;
                this.addMachine("||" + this.sm[i].name, stringStates);
                this.list.add("||" + this.sm[i].name);
            } else {
                lm.addElement(this.sm[i].name);
                stringStates = "" + this.sm[i].maxStates;
                this.addMachine(this.sm[i].name, stringStates);
                this.list.add(this.sm[i].name);
            }
            ++i;
        }
    }

    class LTSAEclipseIO
    implements LTSInput,
    LTSOutput {
        String fSrc = "A = (test -> END). B = (test2 -> END). ||C = (A || B).";
        public int fPos;
        public String result = "";

        LTSAEclipseIO() {
        }

        public void setFPos(int value) {
            this.fPos = value;
        }

        public char backChar() {
            --this.fPos;
            if (this.fPos < 0) {
                this.fPos = 0;
                return '\u0000';
            }
            return this.fSrc.charAt(this.fPos);
        }

        public char nextChar() {
            ++this.fPos;
            if (this.fPos < this.fSrc.length()) {
                return this.fSrc.charAt(this.fPos);
            }
            --this.fPos;
            return '\u0000';
        }

        public void out(String str) {
            this.result = String.valueOf(this.result) + str;
        }

        public void clearOutput() {
            this.result = "";
        }

        public void outln(String str) {
            this.result = String.valueOf(this.result) + str;
        }

        public void showOutput() {
        }

        public int getMarker() {
            return this.fPos;
        }
    }
}

