/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import mscedit.Glyph;

class MessageGraphic
extends Glyph {
    protected int o_from;
    protected int o_to;
    protected int o_vert_position;
    protected int o_y;
    protected String o_display_name;

    public MessageGraphic() {
    }

    public MessageGraphic(String p_name, int p_from, int p_to, int p_vert_position) {
        this.o_name = p_name;
        int x_dot2 = this.o_name.indexOf(",", this.o_name.indexOf(",") + 1);
        this.o_display_name = this.o_name.substring(x_dot2 + 1, this.o_name.length());
        this.o_from = p_from;
        this.o_to = p_to;
        this.o_vert_position = p_vert_position;
        this.o_y = 50 + this.o_vert_position * 25;
        this.constructPolygons();
        this.scale();
    }

    public String getId() {
        return String.valueOf(this.getName()) + this.o_vert_position;
    }

    protected void constructPolygons() {
        this.o_area = new Area();
        int x_length = Math.abs(this.o_from - this.o_to) * 100;
        this.o_area.add(new Area(new Rectangle((this.o_from < this.o_to ? this.o_from : this.o_to) * 100 + 50, this.o_y, x_length, 1)));
        if (this.o_from < this.o_to) {
            this.o_area.add(new Area(new Polygon(new int[]{50 + this.o_to * 100 - 5, 50 + this.o_to * 100, 50 + this.o_to * 100 - 5}, new int[]{this.o_y - 5, this.o_y, this.o_y + 5}, 3)));
        } else {
            this.o_area.add(new Area(new Polygon(new int[]{50 + this.o_to * 100 + 5, 50 + this.o_to * 100, 50 + this.o_to * 100 + 5}, new int[]{this.o_y - 5, this.o_y, this.o_y + 5}, 3)));
        }
    }

    public void draw(Graphics g) {
        ((Graphics2D)g).draw(this.o_area);
        g.setFont(s_current_font);
        g.drawString(this.o_display_name, (int)(s_scale * (double)((this.o_from + this.o_to) / 2 * 100 + 65)), (int)(s_scale * (double)(this.o_y - 5)));
    }

    protected void moveTo(int p_y) {
        this.o_y = p_y;
        this.constructPolygons();
        this.scale();
    }
}

