/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.extra.JPFErrorException;
import gov.nasa.arc.ase.ltl.Formula;
import gov.nasa.arc.ase.ltl.Node;
import gov.nasa.arc.ase.ltl.ParseErrorException;
import gov.nasa.arc.ase.ltl.Pool;
import gov.nasa.arc.ase.ltl.Rewriter;
import gov.nasa.arc.ase.ltl.Translator;
import gov.nasa.arc.ase.util.graph.Degeneralize;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.SCCReduction;
import gov.nasa.arc.ase.util.graph.SFSReduction;
import gov.nasa.arc.ase.util.graph.Simplify;
import gov.nasa.arc.ase.util.graph.SuperSetReduction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class LTL2Buchi {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        System.out.println("\n(c) Dimitra Giannakopoulou & Flavio Lerda, NASA Ames Research Center\n");
        Translator.set_algorithm(1);
        if (stringArray.length != 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-a")) {
                    if (++n >= stringArray.length) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    if (stringArray[n].equals("ltl2buchi")) {
                        Translator.set_algorithm(1);
                    } else {
                        if (!stringArray[n].equals("ltl2aut")) {
                            LTL2Buchi.usage_warning();
                            return;
                        }
                        Translator.set_algorithm(0);
                    }
                } else if (stringArray[n].equals("-norw")) {
                    bl = false;
                } else if (stringArray[n].equals("-nobisim")) {
                    bl2 = false;
                } else if (stringArray[n].equals("-nofsim")) {
                    bl3 = false;
                } else {
                    if (!stringArray[n].equals("-f")) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    if (++n >= stringArray.length) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    string = stringArray[n];
                    if (string.endsWith(".ltl")) {
                        string = LTL2Buchi.loadLTL(string);
                        bl4 = true;
                    } else if (!string.equals("-")) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                }
                ++n;
            }
        }
        if (!bl4) {
            string = LTL2Buchi.readLTL();
        }
        try {
            Graph graph = LTL2Buchi.translate(string, bl, bl2, bl3);
            graph.save(1);
            System.out.println("\n***********************\n");
            return;
        }
        catch (ParseErrorException parseErrorException) {
            System.out.println("Error: " + parseErrorException);
        }
    }

    public static void usage_warning() {
        System.out.println("\n*******  USAGE *******");
        System.out.println("java gov.nasa.arc.ase.ltl.LTL2Buchi <options>");
        System.out.println("\toptions can be (in any order):");
        System.out.println("\t\t \"-f <filename.ltl>\" (read formula from file)");
        System.out.println("\t\t \"-a [ltl2buchi|ltl2aut]\" (set algorithm to be used)");
        System.out.println("\t\t \"-norw\" (no rewriting)");
        System.out.println("\t\t \"-nobisim\" (no bisimulation reduction)");
        System.out.println("\t\t \"-nofsim\" (no fair simulation reduction");
    }

    public static void reset_all_static() {
        Node.reset_static();
        Formula.reset_static();
        Pool.reset_static();
    }

    public static Graph translate(String string, boolean bl, boolean bl2, boolean bl3) throws ParseErrorException {
        boolean bl4 = true;
        boolean bl5 = true;
        if (bl) {
            try {
                string = Rewriter.rewrite(string);
            }
            catch (ParseErrorException parseErrorException) {
                throw new ParseErrorException(parseErrorException.getMessage());
            }
            System.out.println("Rewritten as       : " + string);
            System.out.println();
        }
        if (string == null) {
            System.out.println("Unexpected null formula");
        }
        Graph graph = Translator.translate(string);
        System.out.println("\n***********************");
        System.out.println("\nGeneralized buchi automaton generated");
        System.out.println("\t" + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
        System.out.println();
        graph.save(1);
        if (bl4) {
            graph = SuperSetReduction.reduce(graph);
            System.out.println("Superset reduction");
            System.out.println("\t" + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
            System.out.println();
        }
        Graph graph2 = Degeneralize.degeneralize(graph);
        System.out.println("Degeneralized buchi automaton generated");
        System.out.println("\t" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
        System.out.println();
        if (bl5) {
            graph2 = SCCReduction.reduce(graph2);
            System.out.println("Strongly connected component reduction");
            System.out.println("\t" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
            System.out.println();
        }
        if (bl2) {
            graph2 = Simplify.simplify(graph2);
            System.out.println("Bisimulation applied");
            System.out.println("\t" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
            System.out.println();
        }
        if (bl3) {
            graph2 = SFSReduction.reduce(graph2);
            System.out.println("Fair simulation applied");
            System.out.println("\t" + graph2.getNodeCount() + " states " + graph2.getEdgeCount() + " transitions");
        }
        System.out.println("***********************\n");
        LTL2Buchi.reset_all_static();
        return graph2;
    }

    public static Graph translate(String string) throws ParseErrorException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        if (bl) {
            try {
                string = Rewriter.rewrite(string);
            }
            catch (ParseErrorException parseErrorException) {
                throw new ParseErrorException(parseErrorException.getMessage());
            }
            System.out.println("Rewritten as       : " + string);
            System.out.println();
        }
        Graph graph = Translator.translate(string);
        try {
            graph.save(System.getProperty("user.dir") + File.separator + "gba.sm");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl2) {
            graph = SuperSetReduction.reduce(graph);
            try {
                graph.save(System.getProperty("user.dir") + File.separator + "ssr-gba.sm");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Graph graph2 = Degeneralize.degeneralize(graph);
        try {
            graph2.save(System.getProperty("user.dir") + File.separator + "ba.sm");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl3) {
            graph2 = SCCReduction.reduce(graph2);
            try {
                graph2.save(System.getProperty("user.dir") + File.separator + "scc-ba.sm");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl4) {
            graph2 = Simplify.simplify(graph2);
            try {
                graph2.save(System.getProperty("user.dir") + File.separator + "bisim.sm");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl5) {
            graph2 = SFSReduction.reduce(graph2);
            try {
                graph2.save(System.getProperty("user.dir") + File.separator + "fairSim-ba.sm");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("***********************\n");
        LTL2Buchi.reset_all_static();
        return graph2;
    }

    private static String loadLTL(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            return bufferedReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JPFErrorException("Can't load LTL formula: " + string);
        }
        catch (IOException iOException) {
            throw new JPFErrorException("Error read on LTL formula: " + string);
        }
    }

    private static String readLTL() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("\nInsert LTL formula: ");
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new JPFErrorException("Invalid LTL formula");
        }
    }
}

