/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

import gov.nasa.arc.ase.util.Debug;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;

public class Options {
    private Hashtable parsers;
    private Hashtable printers;
    private Class mainClass;
    private String defaultParam;
    private boolean multipleParam;
    private String[] args;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public Options(Class clazz) {
        this.init(clazz, null, true);
    }

    public Options(Class clazz, String string) {
        this.init(clazz, string, true);
    }

    public Options(Class clazz, String string, boolean bl) {
        this.init(clazz, string, bl);
    }

    public void addPrinter(String string, String string2) {
        Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Options.class$("java.lang.Object")) : class$java$lang$Object};
        try {
            this.printers.put(string, this.getClass().getMethod(string2, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            System.exit(1);
        }
    }

    public void addParser(String string, String string2) {
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Options.class$("java.lang.String")) : class$java$lang$String};
        try {
            this.parsers.put(string, this.getClass().getMethod(string2, classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            System.exit(1);
        }
    }

    public void print(PrintStream printStream) {
        int n;
        Field[] fieldArray = this.getClass().getFields();
        int n2 = 0;
        int n3 = 0;
        while (n3 < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n3].getModifiers()) && n2 < (n = fieldArray[n3].getName().length())) {
                n2 = n;
            }
            ++n3;
        }
        n = 0;
        while (n < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n].getModifiers())) {
                String string = fieldArray[n].getName();
                while (string.length() != n2) {
                    string = string + " ";
                }
                printStream.print(string + ": ");
                try {
                    Object object = fieldArray[n].get(this);
                    String string2 = fieldArray[n].getType().getName();
                    Method method = (Method)this.printers.get(string2);
                    String string3 = object == null ? "null" : object.toString();
                    if (method != null) {
                        Object[] objectArray = new Object[]{object};
                        try {
                            string3 = (String)method.invoke((Object)this, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    printStream.println(string3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    System.exit(1);
                }
            }
            ++n;
        }
    }

    public void print() {
        int n;
        Field[] fieldArray = this.getClass().getFields();
        int n2 = 0;
        int n3 = 0;
        while (n3 < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n3].getModifiers()) && n2 < (n = fieldArray[n3].getName().length())) {
                n2 = n;
            }
            ++n3;
        }
        n = 0;
        while (n < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n].getModifiers())) {
                String string = fieldArray[n].getName();
                while (string.length() != n2) {
                    string = string + " ";
                }
                Debug.print(1, string + ": ");
                try {
                    Object object = fieldArray[n].get(this);
                    String string2 = fieldArray[n].getType().getName();
                    Method method = (Method)this.printers.get(string2);
                    String string3 = object == null ? "null" : object.toString();
                    if (method != null) {
                        Object[] objectArray = new Object[]{object};
                        try {
                            string3 = (String)method.invoke((Object)this, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    Debug.println(1, string3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    System.exit(1);
                }
            }
            ++n;
        }
    }

    public void usage() {
        Debug.println(0, "usage: ");
        Debug.println(0);
        Debug.print(0, this.mainClass.getName() + " ");
        if (this.defaultParam != null) {
            Debug.print(0, "<" + this.defaultParam + ">");
            if (this.multipleParam) {
                Debug.print(0, " ...");
            }
        }
        Debug.println(0);
        Field[] fieldArray = this.getClass().getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (Modifier.isPublic(fieldArray[n].getModifiers())) {
                String string = fieldArray[n].getName().replace('_', '-');
                String string2 = fieldArray[n].getType().getName();
                Debug.print(0, "\t-" + string);
                if (string2.equals("boolean")) {
                    Debug.print(0, " | -no-" + string);
                } else {
                    Debug.print(0, " <" + string + ">");
                }
                Debug.println(0);
            }
            ++n;
        }
        Debug.println(0);
        Debug.println(0, "The default values are:");
        Debug.println(0, "-----------------------");
        this.print();
        System.exit(1);
    }

    public String[] parse(String[] stringArray) {
        int n;
        Object object;
        this.args = stringArray;
        boolean bl = this.defaultParam != null;
        int n2 = 0;
        Vector<Object> vector = new Vector<Object>();
        int n3 = 0;
        while (n3 < stringArray.length) {
            object = stringArray[n3];
            if (((String)object).startsWith("-") && n2 == 0) {
                n = 0;
                Field[] fieldArray = this.getClass().getFields();
                if (((String)object).equals("--")) {
                    n = 1;
                    n2 = 1;
                }
                int n4 = 0;
                while (n4 < fieldArray.length && n == 0) {
                    if (Modifier.isPublic(fieldArray[n4].getModifiers())) {
                        String string = fieldArray[n4].getName().replace('_', '-');
                        String string2 = fieldArray[n4].getType().getName();
                        try {
                            if (string2.equals("boolean")) {
                                if (((String)object).equals("-" + string)) {
                                    fieldArray[n4].setBoolean(this, true);
                                    n = 1;
                                }
                                if (((String)object).equals("-no-" + string)) {
                                    fieldArray[n4].setBoolean(this, false);
                                    n = 1;
                                }
                            } else if (((String)object).equals("-" + string)) {
                                Method method;
                                String string3 = null;
                                n = 1;
                                if (++n3 != stringArray.length) {
                                    string3 = stringArray[n3];
                                }
                                if ((method = (Method)this.parsers.get(string2)) == null) {
                                    Debug.println(0, this.mainClass.getName() + ": invalid type -- " + string2);
                                    System.exit(1);
                                }
                                Object[] objectArray = new Object[]{string3};
                                try {
                                    fieldArray[n4].set(this, method.invoke((Object)this, objectArray));
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    if (string3 == null && invocationTargetException.getTargetException() instanceof IllegalArgumentException) {
                                        Debug.println(0, this.mainClass.getName() + ": option requires an argument -- " + (String)object);
                                        System.exit(1);
                                    }
                                    invocationTargetException.printStackTrace();
                                    System.exit(1);
                                }
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                            System.exit(1);
                        }
                    }
                    ++n4;
                }
                if (n == 0) {
                    Debug.println(0, this.mainClass.getName() + ": invalid option -- " + (String)object);
                    System.exit(1);
                }
            } else if (!bl) {
                Debug.println(0, this.mainClass.getName() + ": invalid parameter -- " + (String)object);
                System.exit(1);
            } else {
                bl = this.multipleParam;
                vector.addElement(object);
            }
            ++n3;
        }
        object = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            object[n] = (String)vector.elementAt(n);
            ++n;
        }
        return object;
    }

    public Object parseString(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public Object parseLong(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return new Long(Long.parseLong(string));
    }

    public Object parseInt(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return new Integer(Integer.parseInt(string));
    }

    public Class getMainClass() {
        return this.mainClass;
    }

    private void init(Class clazz, String string, boolean bl) {
        this.mainClass = clazz;
        this.defaultParam = string;
        this.multipleParam = bl;
        this.parsers = new Hashtable();
        this.printers = new Hashtable();
        this.addParser("java.lang.String", "parseString");
        this.addParser("int", "parseInt");
        this.addParser("long", "parseLong");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].indexOf(" ") != -1) {
                stringBuffer.append('\"');
            }
            stringBuffer.append(this.args[n]);
            if (this.args[n].indexOf(" ") != -1) {
                stringBuffer.append('\"');
            }
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

