/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;

public class Determinizer {
    static final int TAU = 0;
    CompactState machine;
    LTSOutput output;
    Vector newStates;
    Vector stateSets;
    Hashtable map;
    int nextState;
    int currentState;

    public Determinizer(CompactState c, LTSOutput output) {
        this.machine = c;
        this.output = output;
    }

    public CompactState determine() {
        this.output.outln("make DFA(" + this.machine.name + ")");
        this.newStates = new Vector(this.machine.maxStates * 2);
        this.stateSets = new Vector(this.machine.maxStates * 2);
        this.map = new Hashtable(this.machine.maxStates * 2);
        this.nextState = 0;
        this.currentState = 0;
        BitSet st = new BitSet();
        st.set(0);
        this.addState(st);
        while (this.currentState < this.nextState) {
            this.compute(this.currentState);
            ++this.currentState;
        }
        return this.makeNewMachine();
    }

    protected void compute(int n) {
        BitSet state = (BitSet)this.stateSets.elementAt(n);
        EventState tr = null;
        EventState newtr = null;
        int i = 0;
        while (i < state.size()) {
            if (state.get(i)) {
                tr = EventState.union(tr, this.machine.states[i]);
            }
            ++i;
        }
        EventState action = tr;
        while (action != null) {
            boolean errorState = false;
            BitSet newState = new BitSet();
            if (action.next != -1) {
                newState.set(action.next);
            } else {
                errorState = true;
            }
            EventState nd = action.nondet;
            while (nd != null) {
                if (nd.next != -1) {
                    newState.set(nd.next);
                } else {
                    errorState = true;
                }
                nd = nd.nondet;
            }
            int newStateId = errorState ? -1 : this.addState(newState);
            newtr = EventState.add(newtr, new EventState(action.event, newStateId));
            action = action.list;
        }
        this.newStates.addElement(newtr);
    }

    protected int addState(BitSet bs) {
        Integer ii = (Integer)this.map.get(bs);
        if (ii != null) {
            return ii;
        }
        this.map.put(bs, new Integer(this.nextState));
        this.stateSets.addElement(bs);
        ++this.nextState;
        return this.nextState - 1;
    }

    protected CompactState makeNewMachine() {
        CompactState m = new CompactState();
        m.name = this.machine.name;
        m.alphabet = new String[this.machine.alphabet.length];
        int i = 0;
        while (i < this.machine.alphabet.length) {
            m.alphabet[i] = this.machine.alphabet[i];
            ++i;
        }
        m.maxStates = this.nextState;
        m.states = new EventState[m.maxStates];
        i = 0;
        while (i < m.maxStates) {
            m.states[i] = (EventState)this.newStates.elementAt(i);
            ++i;
        }
        if (this.machine.endseq >= 0) {
            BitSet es = new BitSet();
            es.set(this.machine.endseq);
            Integer ii = (Integer)this.map.get(es);
            if (ii != null) {
                m.endseq = ii;
            }
        }
        this.output.outln("DFA(" + this.machine.name + ") has " + m.maxStates + " states.");
        return m;
    }
}

