/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.extension.Relation;
import ic.doc.ltsa.lts.EventStateEnumerator;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.MyIntHash;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EventState {
    public int event;
    public int next;
    public int machine;
    public EventState list;
    public EventState nondet;
    public EventState path;

    public EventState(int e, int i) {
        this.event = e;
        this.next = i;
    }

    public Enumeration elements() {
        return new EventStateEnumerator(this);
    }

    /*
     * Unable to fully structure code
     */
    public static EventState add(EventState head, EventState tr) {
        block4: {
            block3: {
                if (head == null || tr.event < head.event) {
                    tr.list = head;
                    return tr;
                }
                p = head;
                while (p.list != null && p.event != tr.event && tr.event >= p.list.event) {
                    p = p.list;
                }
                if (p.event != tr.event) break block3;
                q = p;
                if (q.next != tr.next) ** GOTO lbl15
                return head;
lbl-1000:
                // 1 sources

                {
                    q = q.nondet;
                    if (q.next != tr.next) continue;
                    return head;
lbl15:
                    // 2 sources

                    ** while (q.nondet != null)
                }
lbl16:
                // 1 sources

                q.nondet = tr;
                break block4;
            }
            tr.list = p.list;
            p.list = tr;
        }
        return head;
    }

    public static EventState remove(EventState head, EventState tr) {
        if (head == null) {
            return head;
        }
        if (head.event == tr.event && head.next == tr.next) {
            if (head.nondet == null) {
                return head.list;
            }
            head.nondet.list = head.list;
            return head.nondet;
        }
        EventState p = head;
        EventState plag = head;
        while (p != null) {
            EventState q = p;
            EventState qlag = p;
            while (q != null) {
                if (q.event == tr.event && q.next == tr.next) {
                    if (p == q) {
                        if (p.nondet == null) {
                            plag.list = p.list;
                            return head;
                        }
                        p.nondet.list = p.list;
                        plag.list = p.nondet;
                        return head;
                    }
                    qlag.nondet = q.nondet;
                    return head;
                }
                qlag = q;
                q = q.nondet;
            }
            plag = p;
            p = p.list;
        }
        return head;
    }

    public static void printAUT(EventState head, int from, String[] alpha, PrintStream output) {
        EventState p = head;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                output.print("(" + from + "," + alpha[q.event] + "," + q.next + ")\n");
                q = q.nondet;
            }
            p = p.list;
        }
    }

    public static int count(EventState head) {
        EventState p = head;
        int n = 0;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                ++n;
                q = q.nondet;
            }
            p = p.list;
        }
        return n;
    }

    public static boolean hasState(EventState head, int next) {
        EventState p = head;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next == next) {
                    return true;
                }
                q = q.nondet;
            }
            p = p.list;
        }
        return false;
    }

    public static void replaceWithError(EventState head, int sinkState) {
        EventState p = head;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next == sinkState) {
                    q.next = -1;
                }
                q = q.nondet;
            }
            p = p.list;
        }
    }

    public static EventState offsetSeq(int off, int seq, int max, EventState head) {
        EventState p = head;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next >= 0) {
                    q.next = q.next == seq ? max : (q.next += off);
                }
                q = q.nondet;
            }
            p = p.list;
        }
        return head;
    }

    public static int toState(EventState head, int next) {
        EventState p = head;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next == next) {
                    return q.event;
                }
                q = q.nondet;
            }
            p = p.list;
        }
        return -1;
    }

    public static int countStates(EventState head, int next) {
        EventState p = head;
        int result = 0;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next == next) {
                    ++result;
                }
                q = q.nondet;
            }
            p = p.list;
        }
        return result;
    }

    public static boolean hasEvent(EventState head, int event) {
        EventState p = head;
        while (p != null) {
            if (p.event == event) {
                return true;
            }
            p = p.list;
        }
        return false;
    }

    public static boolean isAccepting(EventState head, String[] alphabet) {
        EventState p = head;
        while (p != null) {
            if (alphabet[p.event].charAt(0) == '@') {
                return true;
            }
            p = p.list;
        }
        return false;
    }

    public static boolean isTerminal(int state, EventState head) {
        EventState p = head;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next != state) {
                    return false;
                }
                q = q.nondet;
            }
            p = p.list;
        }
        return true;
    }

    public static EventState firstCompState(EventState head, int event, int[] state) {
        EventState p = head;
        while (p != null) {
            if (p.event == event) {
                state[p.machine] = p.next;
                return p.nondet;
            }
            p = p.list;
        }
        return null;
    }

    public static EventState moreCompState(EventState head, int[] state) {
        state[head.machine] = head.next;
        return head.nondet;
    }

    public static boolean hasTau(EventState head) {
        if (head == null) {
            return false;
        }
        return head.event == 0;
    }

    public static boolean hasOnlyTau(EventState head) {
        if (head == null) {
            return false;
        }
        return head.event == 0 && head.list == null;
    }

    public static boolean hasOnlyTauAndAccept(EventState head, String[] alphabet) {
        if (head == null) {
            return false;
        }
        if (head.event != 0) {
            return false;
        }
        if (head.list == null) {
            return true;
        }
        if (alphabet[head.list.event].charAt(0) != '@') {
            return false;
        }
        return head.list.list == null;
    }

    public static EventState removeAccept(EventState head) {
        head.list = null;
        return head;
    }

    public static EventState addNonDetTau(EventState head, EventState[] states, BitSet tauOnly) {
        EventState p = head;
        EventState toAdd = null;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next > 0 && tauOnly.get(q.next)) {
                    int[] nextS = EventState.nextState(states[q.next], 0);
                    q.next = nextS[0];
                    int i = 1;
                    while (i < nextS.length) {
                        toAdd = EventState.add(toAdd, new EventState(q.event, nextS[i]));
                        ++i;
                    }
                }
                q = q.nondet;
            }
            p = p.list;
        }
        if (toAdd == null) {
            return head;
        }
        return EventState.union(head, toAdd);
    }

    public static boolean hasNonDet(EventState head) {
        EventState p = head;
        while (p != null) {
            if (p.nondet != null) {
                return true;
            }
            p = p.list;
        }
        return false;
    }

    public static boolean hasNonDetEvent(EventState head, int event) {
        EventState p = head;
        while (p != null) {
            if (p.event == event && p.nondet != null) {
                return true;
            }
            p = p.list;
        }
        return false;
    }

    public static int[] localEnabled(EventState head) {
        EventState p = head;
        int n = 0;
        while (p != null) {
            ++n;
            p = p.list;
        }
        if (n == 0) {
            return null;
        }
        int[] a = new int[n];
        p = head;
        n = 0;
        while (p != null) {
            a[n++] = p.event;
            p = p.list;
        }
        return a;
    }

    public static void hasEvents(EventState head, BitSet actions) {
        EventState p = head;
        while (p != null) {
            actions.set(p.event);
            p = p.list;
        }
    }

    public static int[] nextState(EventState head, int event) {
        EventState p = head;
        while (p != null) {
            if (p.event == event) {
                EventState q = p;
                int size = 0;
                while (q != null) {
                    q = q.nondet;
                    ++size;
                }
                q = p;
                int[] n = new int[size];
                int i = 0;
                while (i < n.length) {
                    n[i] = q.next;
                    q = q.nondet;
                    ++i;
                }
                return n;
            }
            p = p.list;
        }
        return null;
    }

    public static EventState renumberEvents(EventState head, Hashtable oldtonew) {
        EventState p = head;
        EventState newhead = null;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                int event = (Integer)oldtonew.get(new Integer(q.event));
                newhead = EventState.add(newhead, new EventState(event, q.next));
                q = q.nondet;
            }
            p = p.list;
        }
        return newhead;
    }

    public static EventState newTransitions(EventState head, Relation oldtonew) {
        EventState p = head;
        EventState newhead = null;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                Object o = oldtonew.get(new Integer(q.event));
                if (o != null) {
                    if (o instanceof Integer) {
                        newhead = EventState.add(newhead, new EventState((Integer)o, q.next));
                    } else {
                        Vector v = (Vector)o;
                        Enumeration e = v.elements();
                        while (e.hasMoreElements()) {
                            newhead = EventState.add(newhead, new EventState((Integer)e.nextElement(), q.next));
                        }
                    }
                }
                q = q.nondet;
            }
            p = p.list;
        }
        return newhead;
    }

    public static EventState offsetEvents(EventState head, int offset) {
        EventState p = head;
        EventState newhead = null;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                q.event = q.event == 0 ? 0 : q.event + offset;
                q = q.nondet;
            }
            p = p.list;
        }
        return newhead;
    }

    public static EventState renumberStates(EventState head, Hashtable oldtonew) {
        EventState p = head;
        EventState newhead = null;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                int next = q.next < 0 ? -1 : (Integer)oldtonew.get(new Integer(q.next));
                newhead = EventState.add(newhead, new EventState(q.event, next));
                q = q.nondet;
            }
            p = p.list;
        }
        return newhead;
    }

    public static EventState renumberStates(EventState head, MyIntHash oldtonew) {
        EventState p = head;
        EventState newhead = null;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                int next = q.next < 0 ? -1 : oldtonew.get(q.next);
                newhead = EventState.add(newhead, new EventState(q.event, next));
                q = q.nondet;
            }
            p = p.list;
        }
        return newhead;
    }

    public static EventState addTransToError(EventState head, int last) {
        EventState p = head;
        EventState newhead = null;
        if (p != null && p.event == 0) {
            p = p.list;
        }
        int index = 1;
        while (p != null) {
            if (index < p.event) {
                int i = index;
                while (i < p.event) {
                    newhead = EventState.add(newhead, new EventState(i, -1));
                    ++i;
                }
            }
            index = p.event + 1;
            EventState q = p;
            while (q != null) {
                newhead = EventState.add(newhead, new EventState(q.event, q.next));
                q = q.nondet;
            }
            p = p.list;
        }
        int i = index;
        while (i < last) {
            newhead = EventState.add(newhead, new EventState(i, -1));
            ++i;
        }
        return newhead;
    }

    public static EventState removeTransToError(EventState head) {
        EventState p = head;
        EventState newHead = null;
        while (p != null) {
            if (p.next != -1) {
                newHead = EventState.add(newHead, new EventState(p.event, p.next));
            }
            p = p.list;
        }
        return newHead;
    }

    public static EventState removeTau(EventState head) {
        if (head == null) {
            return head;
        }
        if (head.event != 0) {
            return head;
        }
        return head.list;
    }

    public static EventState tauAdd(EventState head, EventState[] T) {
        EventState p = head;
        EventState added = null;
        if (p != null && p.event == 0) {
            p = p.list;
        }
        while (p != null) {
            EventState q = p;
            while (q != null) {
                if (q.next != -1) {
                    EventState t = T[q.next];
                    while (t != null) {
                        added = EventState.push(added, new EventState(p.event, t.next));
                        t = t.nondet;
                    }
                }
                q = q.nondet;
            }
            p = p.list;
        }
        while (added != null) {
            head = EventState.add(head, added);
            added = EventState.pop(added);
        }
        return head;
    }

    public static void setActions(EventState head, BitSet b) {
        EventState p = head;
        while (p != null) {
            b.set(p.event);
            p = p.list;
        }
    }

    public static EventState actionAdd(EventState head, EventState[] states) {
        if (head == null || head.event != 0) {
            return head;
        }
        EventState tau = head;
        while (tau != null) {
            if (tau.next != -1) {
                head = EventState.union(head, states[tau.next]);
            }
            tau = tau.nondet;
        }
        return head;
    }

    public static EventState union(EventState to, EventState from) {
        EventState res = to;
        EventState p = from;
        while (p != null) {
            EventState q = p;
            while (q != null) {
                res = EventState.add(res, new EventState(q.event, q.next));
                q = q.nondet;
            }
            p = p.list;
        }
        return res;
    }

    public static EventState transpose(EventState from) {
        EventState q;
        EventState res = null;
        EventState p = from;
        while (p != null) {
            q = p;
            while (q != null) {
                res = EventState.add(res, new EventState(q.next, q.event));
                q = q.nondet;
            }
            p = p.list;
        }
        p = res;
        while (p != null) {
            q = p;
            while (q != null) {
                int n = q.next;
                q.next = q.event;
                q.event = n;
                q = q.nondet;
            }
            p = p.list;
        }
        return res;
    }

    public static String[] eventsToNext(EventState from, String[] alphabet) {
        EventState q = from;
        int size = 0;
        while (q != null) {
            q = q.nondet;
            ++size;
        }
        q = from;
        String[] s = new String[size];
        int i = 0;
        while (i < s.length) {
            s[i] = alphabet[q.event];
            q = q.nondet;
            ++i;
        }
        return s;
    }

    public static String[] eventsToNextNoAccept(EventState from, String[] alphabet) {
        EventState q = from;
        int size = 0;
        while (q != null) {
            if (alphabet[q.event].charAt(0) != '@') {
                ++size;
            }
            q = q.nondet;
        }
        q = from;
        String[] s = new String[size];
        int i = 0;
        while (i < s.length) {
            if (alphabet[q.event].charAt(0) != '@') {
                s[i] = alphabet[q.event];
            } else {
                --i;
            }
            q = q.nondet;
            ++i;
        }
        return s;
    }

    private static EventState push(EventState head, EventState es) {
        es.path = head == null ? es : head;
        head = es;
        return head;
    }

    private static boolean inStack(EventState es) {
        return es.path != null;
    }

    private static EventState pop(EventState head) {
        if (head == null) {
            return head;
        }
        EventState es = head;
        head = es.path;
        es.path = null;
        if (head == es) {
            return null;
        }
        return head;
    }

    public static EventState reachableTau(EventState[] states, int k) {
        EventState head = states[k];
        if (head == null || head.event != 0) {
            return null;
        }
        BitSet visited = new BitSet(states.length);
        visited.set(k);
        EventState stack = null;
        while (head != null) {
            stack = EventState.push(stack, head);
            head = head.nondet;
        }
        while (stack != null) {
            int j = stack.next;
            head = EventState.add(head, new EventState(0, j));
            stack = EventState.pop(stack);
            if (j == -1) continue;
            visited.set(j);
            EventState t = states[j];
            if (t == null || t.event != 0) continue;
            while (t != null) {
                if (!(EventState.inStack(t) || t.next >= 0 && visited.get(t.next))) {
                    stack = EventState.push(stack, t);
                }
                t = t.nondet;
            }
        }
        return head;
    }

    private static EventState addtail(EventState tail, EventState es) {
        es.path = null;
        if (tail != null) {
            tail.path = es;
        }
        return es;
    }

    private static EventState removehead(EventState head) {
        if (head == null) {
            return head;
        }
        EventState es = head;
        head = es.path;
        return head;
    }

    public static MyIntHash reachable(EventState[] states) {
        int ns = 0;
        MyIntHash visited = new MyIntHash(states.length);
        EventState stack = null;
        stack = EventState.push(stack, new EventState(0, 0));
        while (stack != null) {
            int v = stack.next;
            stack = EventState.pop(stack);
            if (visited.containsKey(v)) continue;
            visited.put(v, ns++);
            EventState p = states[v];
            while (p != null) {
                EventState q = p;
                while (q != null) {
                    if (q.next >= 0 && !visited.containsKey(q.next)) {
                        stack = EventState.push(stack, q);
                    }
                    q = q.nondet;
                }
                p = p.list;
            }
        }
        return visited;
    }

    public static int search(EventState trace, EventState[] states, int fromState, int findState, int ignoreState) {
        return EventState.search(trace, states, fromState, findState, ignoreState, true);
    }

    /*
     * Unable to fully structure code
     */
    public static int search(EventState trace, EventState[] states, int fromState, int findState, int ignoreState, boolean checkDeadlocks) {
        head = zero = new EventState(0, fromState);
        tail = zero;
        res = 1;
        val = new EventState[states.length + 1];
        while (head != null) {
            k = head.next;
            val[k + 1] = head;
            if (k < 0 || k == findState) {
                res = -1;
                break;
            }
            t = states[k];
            if (!checkDeadlocks || t != null || k == ignoreState) ** GOTO lbl24
            res = 0;
            break;
lbl-1000:
            // 1 sources

            {
                q = t;
                while (q != null) {
                    if (val[q.next + 1] == null) {
                        q.machine = k;
                        tail = EventState.addtail(tail, q);
                        val[q.next + 1] = zero;
                    }
                    q = q.nondet;
                }
                t = t.list;
lbl24:
                // 2 sources

                ** while (t != null)
            }
lbl25:
            // 1 sources

            head = EventState.removehead(head);
        }
        if (head == null) {
            return res;
        }
        stack = null;
        ts = head;
        while (ts.next != fromState) {
            stack = EventState.push(stack, ts);
            ts = val[ts.machine + 1];
        }
        trace.path = stack;
        return res;
    }

    public static void printPath(EventState head, String[] alpha, LTSOutput output) {
        EventState q = head;
        while (q != null) {
            output.outln("\t" + alpha[q.event]);
            q = EventState.pop(q);
        }
    }

    public static Vector getPath(EventState head, String[] alpha) {
        EventState q = head;
        Vector<String> v = new Vector<String>();
        while (q != null) {
            v.addElement(alpha[q.event]);
            q = EventState.pop(q);
        }
        return v;
    }
}

